/* 
 * frankhale@gmail.com
 * http://frankhale.org
 *
 * This code is released under the GPL license www.gnu.org
 */
#ifndef _AEWM_HH_
#define _AEWM_HH_

#define WINDOW_MANAGER_NAME "aewm++"
#define VERSION "1.1.5"
#define RELEASE_DATE "22 May 2005"

#include <stdio.h>
#include <unistd.h>
#include <sys/wait.h>
#include <signal.h>
#include <stdlib.h>
#include <iostream>
#include <string>
#include <list>

#include <X11/cursorfont.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xmd.h>
#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif

using std::list;
using std::string;
using std::cout;
using std::cerr;
using std::endl;

#define DEF_FONT	"Fixed"
#define DEF_FG		"#ffffff"
#define DEF_BG		"#3f5881"
#define DEF_FC		"#dddddd"
#define DEF_BD		"#000000"

#define FOCUSED_BORDER_COLOR "#000000"
#define UNFOCUSED_BORDER_COLOR "#888888"
#define FOCUSED_WINDOW_TITLE_COLOR "#FFFFFF"

#define DEF_NEW1	"xterm -ls -sb -bg black -fg white"
#define DEF_BW		1
#define SPACE		3
#define MINSIZE		15
#define EDGE_SNAP	"true"
#define SNAP		5
#define TEXT_JUSTIFY	"right"
#define WIRE_MOVE	"false"
#define MAX_DESKTOPS	4
#define DEF_FM		"click"
#define DEF_WP          "mouse"

#define TRANSIENT_WINDOW_HEIGHT 8

// MOTIF hints
#define MwmHintsDecorations   		(1l << 1)
#define MwmDecorAll           		(1l << 0)
#define MwmDecorBorder        		(1l << 1)
#define MwmDecorTitle         		(1l << 3)

#define PropMwmHintsElements 3

typedef struct MwmHints {
  unsigned long flags, functions, decorations;
} MwmHints;

enum { LEFT_JUSTIFY, CENTER_JUSTIFY, RIGHT_JUSTIFY };
enum { FOCUS_FOLLOW, FOCUS_SLOPPY, FOCUS_CLICK };
enum { APPLY_GRAVITY=1, REMOVE_GRAVITY=-1 };
enum { PIXELS=0, INCREMENTS=1 };

// Shorthand for wordy function calls
#define setmouse(w, x, y) XWarpPointer(dpy, None, w, 0, 0, 0, 0, x, y)
#define Ungrab() XUngrabPointer(dpy, CurrentTime)
#define Grab(w, mask, curs) (XGrabPointer(dpy, w, False, mask, \
    GrabModeAsync, GrabModeAsync, None, curs, CurrentTime) == GrabSuccess)

// Border width accessor to handle hints/no hints
#define BW (has_border ? wm->getOptBW() : 0)

// defined in main.cc
void forkExec(char *);
int handleXError(Display *, XErrorEvent *);

class Client;

#include "basemenu.hh"
#include "genericmenu.hh"
#include "windowmenu.hh"
#include "iconmenu.hh"
#include "client.hh"
#include "windowmanager.hh"

#endif // _AEWM_HH_ 
