
/*

    cpu.c - cpu load graph for dock applet
    Copyright (C) 2002-2004 Mario Pascucci <ilpettegolo (a) yahoo it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    or
    visit the URL http://www.fsf.org/

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dockhelper.h"
#include "cpu.h"




/* reads cpu status from /proc/stat 
 * if cpu_num == -1 reports total CPUs activities, 
 * else report cpuN (N = cpu_num) activities */
void cpu_update(struct cpu_monitor *cpum)
{
  
  FILE *f;
  char s[255],s1[8];
  int ll;

  cpum->prevu = cpum->user;
  cpum->prevn = cpum->nice;
  cpum->prevs = cpum->sys;
  cpum->previ = cpum->idle;
  if (!(f = fopen ("/proc/stat", "r"))) {
    fprintf(stderr,"Open /proc/stat failed!");
    return;
  }
  /* sets search string for cpuN */
  if (cpum->cpu_num == -1)
  {
    strcpy(s1,"cpu ");
  }
  else
  {
    sprintf(s1,"cpu%d ",cpum->cpu_num);
  }
  /* gets data for cpuN */
  while (!feof (f))
  {
    fgets (s, 254, f);
    if (cpum->cpu_num == -1)
    {
      if (strstr (s, s1)) 
      {
	sscanf (s, "cpu %lu %lu %lu %lu", &cpum->user, &cpum->nice, &cpum->sys, &cpum->idle);
	break;
      }
    }
    else
    {
      if (strstr (s, s1))
      {
	sscanf (s, "cpu%d %lu %lu %lu %lu", &ll, &cpum->user, &cpum->nice, &cpum->sys, &cpum->idle);
	break;
      }
    }
  }
  fclose (f);
}



/* set size for cpu graph */
int cpu_size(struct cpu_monitor *cpum) {

  dh_getsize(cpum->handler,&cpum->xc,&cpum->yc,&cpum->wc,&cpum->hc);
  /* if size is less than 10x10 pixel is unusable */
  if ((cpum->hc < 10) || (cpum->wc < 10)) return -1;
  /* creates pixmap from screen settings */
  dh_newpixmap(&cpum->p,cpum->wc,cpum->hc);
  return 0;
}



/* draw cpu graph */
void cpu_draw(struct cpu_monitor *cpum) {

  int total,uh,nh,sh;

  total = cpum->idle + cpum->sys + cpum->nice + cpum->user - 
    cpum->prevu - cpum->prevn - cpum->prevs - cpum->previ;
  /* under heavy load can be zero */
  if (total == 0) total = 1;
  if (cpum->mode == CPUMON_GRAPH)
  {
    uh = ((cpum->user-cpum->prevu) * cpum->hc) / total;
    nh = ((cpum->nice-cpum->prevn) * cpum->hc) / total;
    sh = ((cpum->sys-cpum->prevs) * cpum->hc) / total;
    dh_scroll(cpum->p,cpum->xc,cpum->yc,cpum->wc-1,cpum->hc);
    dh_color(dh_background());
    dh_line(cpum->xc,cpum->yc,cpum->xc,cpum->yc+cpum->hc-1);
    if (uh) {
      dh_color(cpum->user_color);
      dh_line(cpum->xc,cpum->yc+cpum->hc-1,cpum->xc,cpum->yc+cpum->hc-uh);
    }
    if (nh) {
      dh_color(cpum->nice_color);
      dh_line(cpum->xc,cpum->yc+cpum->hc-uh-1,cpum->xc,cpum->yc+cpum->hc-uh-nh);
    }
    if (sh) {
      dh_color(cpum->sys_color);
      dh_line(cpum->xc,cpum->yc+cpum->hc-uh-nh-1,cpum->xc,cpum->yc+cpum->hc-uh-nh-sh);
    }
  }
  else
  {
    uh = ((cpum->user-cpum->prevu) * cpum->wc) / total;
    nh = ((cpum->nice-cpum->prevn) * cpum->wc) / total;
    sh = ((cpum->sys-cpum->prevs) * cpum->wc) / total;
    dh_color(dh_background());
    dh_fillrect(cpum->xc,cpum->yc,cpum->wc,cpum->hc);
    if (uh) {
      dh_color(cpum->user_color);
      dh_fillrect(cpum->xc,cpum->yc,uh,cpum->hc);
    }
    if (nh) {
      dh_color(cpum->nice_color);
      dh_fillrect(cpum->xc+uh,cpum->yc,nh,cpum->hc);
    }
    if (sh) {
      dh_color(cpum->sys_color);
      dh_fillrect(cpum->xc+uh+nh,cpum->yc,sh,cpum->hc);
    }
  }
}






