
/*

    network.h - Header file for network monitor functions
    Copyright (C) 2002-2004 Mario Pascucci <ilpettegolo (a) yahoo it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    or
    visit the URL http://www.fsf.org/

*/

/* prevent multiple inclusion */
#ifndef _MP_NETWORK


#ifdef __cplusplus
extern "C" {
#endif


/* define header ID */
#define _MP_NETWORK

  
/* header definitions starts here */


/* smooth factor for net gauge */
#define SMOOTH 5

  /* icon index */
#define INTF_ON	    0
#define INTF_OFF    10

  /* icon type */
#define MDM_ICO		0
#define NIC_ICO		1
#define RLED_ICO	2
#define GLED_ICO	3
#define UPDN_ICO	4
#define WLAN_ICO	5
#define ACTIVITY_ICO 0

  /* activity index for activity indicator */
#define ACTIVITY_SIZE	3

/* net interface monitor data struct */  
struct net_monitor
{
  int handler;			/* graphic area handler */
  int icon_handler;		/* icon area handler */
  int enable;			/* enabled flag */
  int update_dly;		/* update delay in 2/10 sec */
  char intf_name[20];		/* interface name, like eth, ppp, lo, ecc */
  int intf_up;			/* interface is present and up */
  long long intf_out, intf_in;		/* interface traffic count */
  long long previntf_in, previntf_out;	/* previous traffic */
  struct timeval tv, tvp;		/* store sample absolute time */
  long	time[SMOOTH],			/* stored values for smoothing */
	in_bytes[SMOOTH], 
	out_bytes[SMOOTH];
  int tindex;				/* smooth index */
  char in_color[30];			/* incoming traffic color */
  char out_color[30];			/* outgoing traffic color */
  int xe,ye,we,he;			/* gauge position */
  int xc,yc,wc,hc;			/* icon position */
  int icon_index;			/* icon selection */
  int speedkb;				/* interface speed in kbit per second */
  int log_scale;			/* logaritmic scale flag */
  int icon_type;			/* icon type: modem, NIC, LED, ... */
  int activity_led;		/* if not zero, show traffic activity with two "leds" in icon */
  int activity_stat;		/* traffic status: 0 no act, 1 in act, 2 out act, 3 both */
};
  
/* reads network status from /proc/net/dev */
void net_update(struct net_monitor *nmon);

/* set histogram size */
int net_size(struct net_monitor *nmon);

/* set size for status icon */
/* size for icon is 10*6 pixels */
int net_icon_size(struct net_monitor *nmon);

/* draw net traffic histogram */
void net_draw(struct net_monitor *nmon);

/* draw up or down icon */
void net_icon_draw(struct net_monitor *nmon);


#ifdef __cplusplus
}
#endif

#endif /* _MP_NETWORK */


