/*******************************************************************************
 *
 * MIT License
 *
 * Copyright (c) 2020 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/
#include <miopen/solver.hpp>
#include <miopen/handle.hpp>
#include <miopen/conv/invokers/impl_gemm_dynamic.hpp>
#include <miopen/generic_search.hpp>
#include <miopen/gcn_asm_utils.hpp>
#include <miopen/solver/implicitgemm_util.hpp>
#include <miopen/conv/asm_implicit_gemm.hpp>

#define WORKAROUND_SWDEV_306318 1

MIOPEN_DECLARE_ENV_VAR(MIOPEN_DEBUG_CONV_IMPLICIT_GEMM_ASM_FWD_GTC_XDLOPS)

namespace miopen {
namespace solver {

static const inline std::vector<TunableImplicitGemmGTCDynamic_t>&
GetImplicitGemmGtcDynamicFwdXdlopsTunablesList()
{
    // list all the dynamic igemm conv-fwd kernels
    // clang-format off
    static const  std::vector<TunableImplicitGemmGTCDynamic_t> kernel_param_list {
        { "fwd", miopenFloat,   4,   0, 128, 256,  16,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1, 128, 256,  16,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0, 128, 256,  16,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1, 128, 256,  16,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0, 128, 256,  16,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1, 128, 256,  16,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0, 128, 256,  16,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1, 128, 256,  16,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0, 128, 256,   8,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   4,   2,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   1, 128, 256,   8,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   4,   2,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   0, 128, 256,   8,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   4,   2,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   1, 128, 256,   8,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   4,   2,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   0, 128, 256,   8,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1, 128, 256,   8,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0, 128, 256,   8,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1, 128, 256,   8,  32,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0, 256, 128,  16,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1, 256, 128,  16,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0, 256, 128,  16,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1, 256, 128,  16,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0, 256, 128,  16,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1, 256, 128,  16,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0, 256, 128,  16,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1, 256, 128,  16,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0, 256, 128,   8,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   1, 256, 128,   8,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   0, 256, 128,   8,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   1, 256, 128,   8,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   0, 256, 128,   8,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1, 256, 128,   8,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0, 256, 128,   8,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1, 256, 128,   8,  64,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,  64, 256,  16,  16,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   4,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1,  64, 256,  16,  16,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   4,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0,  64, 256,  16,  16,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   4,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1,  64, 256,  16,  16,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   4,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0,  64, 256,  16,  16,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  64, 256,  16,  16,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  64, 256,  16,  16,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  64, 256,  16,  16,  64,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  64, 256,   8,  16,  64,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   1,  64, 256,   8,  16,  64,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   0,  64, 256,   8,  16,  64,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   1,  64, 256,   8,  16,  64,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   0,  64, 256,   8,  16,  64,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,  64, 256,   8,  16,  64,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  64, 256,   8,  16,  64,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,  64, 256,   8,  16,  64,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,  64, 256,   4,  16,  64,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenFloat,   4,   1,  64, 256,   4,  16,  64,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenFloat,   1,   0,  64, 256,   4,  16,  64,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenFloat,   1,   1,  64, 256,   4,  16,  64,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenFloat,   4,   0,  64, 256,   4,  16,  64,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1,  64, 256,   4,  16,  64,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0,  64, 256,   4,  16,  64,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1,  64, 256,   4,  16,  64,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0, 128, 128,  16,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1, 128, 128,  16,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0, 128, 128,  16,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1, 128, 128,  16,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0, 128, 128,  16,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1, 128, 128,  16,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0, 128, 128,  16,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1, 128, 128,  16,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0, 128, 128,   8,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   1, 128, 128,   8,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   0, 128, 128,   8,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   1, 128, 128,   8,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   0, 128, 128,   8,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1, 128, 128,   8,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0, 128, 128,   8,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1, 128, 128,   8,  32,  32,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0, 256,  64,  16,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1, 256,  64,  16,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0, 256,  64,  16,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1, 256,  64,  16,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0, 256,  64,  16,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1, 256,  64,  16,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0, 256,  64,  16,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1, 256,  64,  16,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0, 256,  64,   8,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1, 256,  64,   8,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0, 256,  64,   8,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1, 256,  64,   8,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0, 256,  64,   8,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1, 256,  64,   8,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0, 256,  64,   8,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1, 256,  64,   8,  64,  16,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0, 256,  64,   4,  64,  16,   1,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1, 256,  64,   4,  64,  16,   1,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0, 256,  64,   4,  64,  16,   1,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1, 256,  64,   4,  64,  16,   1,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0,  32, 256,  16,   4,  64,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   4,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1,  32, 256,  16,   4,  64,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   4,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0,  32, 256,  16,   4,  64,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   4,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1,  32, 256,  16,   4,  64,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   4,   4,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0,  32, 256,  16,   4,  64,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  32, 256,  16,   4,  64,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  32, 256,  16,   4,  64,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  32, 256,  16,   4,  64,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  32, 256,   8,   4,  64,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   2,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   1,  32, 256,   8,   4,  64,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   2,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   0,  32, 256,   8,   4,  64,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   2,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   1,  32, 256,   8,   4,  64,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   2,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   0,  32, 256,   8,   4,  64,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,  32, 256,   8,   4,  64,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  32, 256,   8,   4,  64,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,  32, 256,   8,   4,  64,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  64, 128,  32,   8,  32,   1,   2,   1,   2,   2,   {1,   4,   1,   2},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   0,  64, 128,  16,   8,  32,   1,   2,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1,  64, 128,  16,   8,  32,   1,   2,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0,  64, 128,  16,   8,  32,   1,   2,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1,  64, 128,  16,   8,  32,   1,   2,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0,  64, 128,  16,   8,  32,   1,   2,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  64, 128,  16,   8,  32,   1,   2,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  64, 128,  16,   8,  32,   1,   2,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  64, 128,  16,   8,  32,   1,   2,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  64, 128,   8,   8,  32,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   1,  64, 128,   8,   8,  32,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   0,  64, 128,   8,   8,  32,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   1,  64, 128,   8,   8,  32,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   0,  64, 128,   8,   8,  32,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,  64, 128,   8,   8,  32,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  64, 128,   8,   8,  32,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,  64, 128,   8,   8,  32,   1,   2,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,  64, 128,   4,   8,  32,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   1,  64, 128,   4,   8,  32,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   0,  64, 128,   4,   8,  32,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   1,  64, 128,   4,   8,  32,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   0,  64, 128,   4,   8,  32,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1,  64, 128,   4,   8,  32,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0,  64, 128,   4,   8,  32,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1,  64, 128,   4,   8,  32,   1,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0, 128,  64,  32,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   1,   4},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1, 128,  64,  32,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   1,   4},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0, 128,  64,  16,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1, 128,  64,  16,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0, 128,  64,  16,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1, 128,  64,  16,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0, 128,  64,  16,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1, 128,  64,  16,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0, 128,  64,  16,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1, 128,  64,  16,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0, 128,  64,   8,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1, 128,  64,   8,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0, 128,  64,   8,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1, 128,  64,   8,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0, 128,  64,   8,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1, 128,  64,   8,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0, 128,  64,   8,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1, 128,  64,   8,  32,   8,   1,   1,   2,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0, 128,  64,   4,  32,   8,   1,   1,   2,   2,   2,   {1,   2,   1,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1, 128,  64,   4,  32,   8,   1,   1,   2,   2,   2,   {1,   2,   1,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0, 128,  64,   4,  32,   8,   1,   1,   2,   2,   2,   {1,   2,   1,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1, 128,  64,   4,  32,   8,   1,   1,   2,   2,   2,   {1,   2,   1,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0, 256,  32,  16,  64,   4,   1,   1,   2,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1, 256,  32,  16,  64,   4,   1,   1,   2,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0, 256,  32,  16,  64,   4,   1,   1,   2,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1, 256,  32,  16,  64,   4,   1,   1,   2,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0, 256,  32,  16,  64,   4,   1,   1,   2,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1, 256,  32,  16,  64,   4,   1,   1,   2,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0, 256,  32,  16,  64,   4,   1,   1,   2,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1, 256,  32,  16,  64,   4,   1,   1,   2,   2,   2,   {1,   4,   4,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0, 256,  32,   8,  64,   4,   1,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1, 256,  32,   8,  64,   4,   1,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0, 256,  32,   8,  64,   4,   1,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1, 256,  32,   8,  64,   4,   1,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  32, 128,  32,   8,  32,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   0,  32, 128,  16,   8,  32,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1,  32, 128,  16,   8,  32,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0,  32, 128,  16,   8,  32,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1,  32, 128,  16,   8,  32,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   4,   2,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0,  32, 128,  16,   8,  32,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  32, 128,  16,   8,  32,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  32, 128,  16,   8,  32,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  32, 128,  16,   8,  32,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  32, 128,   8,   8,  32,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   1,  32, 128,   8,   8,  32,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   0,  32, 128,   8,   8,  32,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   1,   1,  32, 128,   8,   8,  32,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenFloat,   4,   0,  32, 128,   8,   8,  32,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,  32, 128,   8,   8,  32,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  32, 128,   8,   8,  32,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,  32, 128,   8,   8,  32,   1,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  64,  64,  64,  16,  16,   1,   1,   1,   2,   2,   {1,   4,   1,   4},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0,  64,  64,  16,  16,  16,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1,  64,  64,  16,  16,  16,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0,  64,  64,  16,  16,  16,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1,  64,  64,  16,  16,  16,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0,  64,  64,  16,  16,  16,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  64,  64,  16,  16,  16,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  64,  64,  16,  16,  16,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  64,  64,  16,  16,  16,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  64,  64,   8,  16,  16,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1,  64,  64,   8,  16,  16,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0,  64,  64,   8,  16,  16,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1,  64,  64,   8,  16,  16,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0,  64,  64,   8,  16,  16,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,  64,  64,   8,  16,  16,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  64,  64,   8,  16,  16,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,  64,  64,   8,  16,  16,   1,   1,   1,   2,   2,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0, 128,  32,  16,  32,   8,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1, 128,  32,  16,  32,   8,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0, 128,  32,  16,  32,   8,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1, 128,  32,  16,  32,   8,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0, 128,  32,  16,  32,   8,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1, 128,  32,  16,  32,   8,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0, 128,  32,  16,  32,   8,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1, 128,  32,  16,  32,   8,   1,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0, 128,  32,   8,  32,   8,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1, 128,  32,   8,  32,   8,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0, 128,  32,   8,  32,   8,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1, 128,  32,   8,  32,   8,   1,   1,   1,   2,   2,   {1,   4,   1,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,  32,  64,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1,  32,  64,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0,  32,  64,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1,  32,  64,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0,  32,  64,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  32,  64,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  32,  64,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  32,  64,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  32,  64,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1,  32,  64,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0,  32,  64,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1,  32,  64,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0,  32,  64,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,  32,  64,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  32,  64,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,  32,  64,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,  64,  32,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,  64,  32,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  64,  32,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,  64,  32,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,  64,  32,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  64,  32,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  64,  32,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  64,  32,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  64,  32,   8,  32,   8,   1,   1,   2,   1,   1,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,  64,  32,   8,  32,   8,   1,   1,   2,   1,   1,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  64,  32,   8,  32,   8,   1,   1,   2,   1,   1,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,  64,  32,   8,  32,   8,   1,   1,   2,   1,   1,   {1,   2,   1,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,  16,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1,  16,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0,  16,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1,  16,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0,  16,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  16,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  16,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  16,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  16,  64,  16,   4,  64,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  16},   {1,   4,   2,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,  16,  64,  16,   4,  64,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  16},   {1,   4,   2,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  16,  64,  16,   4,  64,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  16},   {1,   4,   2,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,  16,  64,  16,   4,  64,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  16},   {1,   4,   2,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,  16,  64,  16,   4,  64,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   4,   1,  16,  64,  16,   4,  64,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   1,   0,  16,  64,  16,   4,  64,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   1,   1,  16,  64,  16,   4,  64,   1,   2,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   4,   0,  16,  64,   8,   4,  64,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   4,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenFloat,   4,   1,  16,  64,   8,   4,  64,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   4,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenFloat,   1,   0,  16,  64,   8,   4,  64,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   4,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenFloat,   1,   1,  16,  64,   8,   4,  64,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   4,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenFloat,   4,   0,  16,  64,   8,   4,  64,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   4,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  16,  64,   8,   4,  64,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   4,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  16,  64,   8,   4,  64,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   4,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  16,  64,   8,   4,  64,   1,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   4,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  32,  32,  16,  16,  16,   1,   1,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,  32,  32,  16,  16,  16,   1,   1,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  32,  32,  16,  16,  16,   1,   1,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,  32,  32,  16,  16,  16,   1,   1,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,  32,  32,  16,  16,  16,   1,   1,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  32,  32,  16,  16,  16,   1,   1,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  32,  32,  16,  16,  16,   1,   1,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  32,  32,  16,  16,  16,   1,   1,   1,   1,   1,   {1,   2,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  64,  16,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  64,  16,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  64,  16,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  64,  16,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   4,   1,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  64,  16,  16,  64,   4,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  64,  16,  16,  64,   4,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  64,  16,  16,  64,   4,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  64,  16,  16,  64,   4,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  64,  16,  16,  64,   4,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   4,   1,  64,  16,  16,  64,   4,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   1,   0,  64,  16,  16,  64,   4,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   1,   1,  64,  16,  16,  64,   4,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   4,   0,  64,  16,   8,  64,   4,   1,   1,   2,   1,   1,   {1,   4,   1,   1},   {1,   2,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  64,  16,   8,  64,   4,   1,   1,   2,   1,   1,   {1,   4,   1,   1},   {1,   2,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  64,  16,   8,  64,   4,   1,   1,   2,   1,   1,   {1,   4,   1,   1},   {1,   2,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  64,  16,   8,  64,   4,   1,   1,   2,   1,   1,   {1,   4,   1,   1},   {1,   2,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,   8,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   4,   2,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,   8,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   4,   2,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,   8,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   4,   2,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,   8,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   4,   2,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,   8,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   4,   1,   8,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   1,   0,   8,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   1,   1,   8,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   4,   0,  16,  32,  16,   8,  32,   1,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,  16,  32,  16,   8,  32,   1,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  16,  32,  16,   8,  32,   1,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,  16,  32,  16,   8,  32,   1,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,  16,  32,  16,   8,  32,   1,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,   4,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   4,   1,  16,  32,  16,   8,  32,   1,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,   4,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   1,   0,  16,  32,  16,   8,  32,   1,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,   4,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   1,   1,  16,  32,  16,   8,  32,   1,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,   4,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   4,   0,  16,  32,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   4,   2,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  16,  32,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   4,   2,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  16,  32,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   4,   2,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  16,  32,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   4,   2,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  16,  32,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   4,   1,  16,  32,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   1,   0,  16,  32,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   1,   1,  16,  32,  16,   8,  32,   1,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   4,   0,  16,  32,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenFloat,   4,   1,  16,  32,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenFloat,   1,   0,  16,  32,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenFloat,   1,   1,  16,  32,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,  16,  32,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   1,   4,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenFloat,   4,   1,  16,  32,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   1,   4,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenFloat,   1,   0,  16,  32,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   1,   4,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenFloat,   1,   1,  16,  32,   8,   8,  32,   1,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   1,   4,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenFloat,   4,   0,  32,  16,  16,  32,   8,   1,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  32,  16,  16,  32,   8,   1,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  32,  16,  16,  32,   8,   1,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  32,  16,  16,  32,   8,   1,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  32,  16,  16,  32,   8,   1,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   4,   1,  32,  16,  16,  32,   8,   1,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   1,   0,  32,  16,  16,  32,   8,   1,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   1,   1,  32,  16,  16,  32,   8,   1,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   4,   0,  32,  16,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  32,  16,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  32,  16,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  32,  16,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  32,  16,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   4,   1,  32,  16,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   1,   0,  32,  16,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   1,   1,  32,  16,  16,  32,   8,   1,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   4,   0,  32,  16,   8,  32,   8,   1,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,  32,  16,   8,  32,   8,   1,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,  32,  16,   8,  32,   8,   1,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,  32,  16,   8,  32,   8,   1,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  32,  16,   8,  32,   8,   1,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenFloat,   4,   1,  32,  16,   8,  32,   8,   1,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenFloat,   1,   0,  32,  16,   8,  32,   8,   1,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenFloat,   1,   1,  32,  16,   8,  32,   8,   1,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenFloat,   4,   0,  64,   8,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   1,   8,   1},   {1,  16,   1,   8},   {1,   1,   1,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   4,   1,  64,   8,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   1,   8,   1},   {1,  16,   1,   8},   {1,   1,   1,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   1,   0,  64,   8,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   1,   8,   1},   {1,  16,   1,   8},   {1,   1,   1,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   1,   1,  64,   8,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   1,   8,   1},   {1,  16,   1,   8},   {1,   1,   1,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,   8,   1,  64,   8,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   1,   8,   1},   {1,  16,   1,   8},   {1,   1,   1,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenFloat,  64,   0,   4,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,  16,   1,   1},   {1,   1,   1,  64},   0},
        { "fwd", miopenFloat,  32,   0,   4,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   8,   2,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenFloat,   4,   0,   4,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   4,   4,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   4,   1,   4,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   4,   4,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   1,   0,   4,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   4,   4,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   1,   1,   4,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   4,   4,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,   4,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   1,  16,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   4,   1,   4,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   1,  16,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   1,   0,   4,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   1,  16,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   1,   1,   4,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   1,  16,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,  64,   1,   4,  64,  16,   4,  64,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,  16,   1,   1},   {1,   1,   1,  64},   0},
        { "fwd", miopenFloat,  16,   0,  16,  16,   4,  16,  16,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   4,   1,  16},   {1,   1,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,  16,   1,  16,  16,   4,  16,  16,   1,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   4,   1,  16},   {1,   1,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenFloat,   4,   0,  64,   4,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   1,  16,   1},   {1,  16,   1,   4},   {1,   1,   1,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   4,   1,  64,   4,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   1,  16,   1},   {1,  16,   1,   4},   {1,   1,   1,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   1,   0,  64,   4,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   1,  16,   1},   {1,  16,   1,   4},   {1,   1,   1,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenFloat,   1,   1,  64,   4,  16,  64,   4,   1,   1,   1,   1,   1,   {1,   1,  16,   1},   {1,  16,   1,   4},   {1,   1,   1,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,  16,   0, 256, 128,  32,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 256, 128,  32,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0, 256, 128,  32,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1, 256, 128,  32,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1, 256, 128,  32,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1, 256, 128,  32,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 256, 128,  32,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0, 256, 128,  32,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1, 256, 128,  32,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1, 256, 128,  32,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0, 256, 128,  16,  64,  32,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0, 256, 128,  16,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 256, 128,  16,  64,  32,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 256, 128,  16,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0, 256, 128,  16,  64,  32,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0, 256, 128,  16,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1, 256, 128,  16,  64,  32,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1, 256, 128,  16,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1, 256, 128,  16,  64,  32,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1, 256, 128,  16,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1, 256, 128,  16,  64,  32,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1, 256, 128,  16,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0, 256, 128,  16,  64,  32,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0, 256, 128,  16,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 256, 128,  16,  64,  32,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 256, 128,  16,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 256, 128,  16,  64,  32,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 256, 128,  16,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 256, 128,  16,  64,  32,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 256, 128,  16,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 256, 128,  16,  64,  32,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 256, 128,  16,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 256, 128,  16,  64,  32,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 256, 128,  16,  32,  32,   8,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0, 256, 128,   8,  64,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 256, 128,   8,  64,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0, 256, 128,   8,  64,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1, 256, 128,   8,  64,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1, 256, 128,   8,  64,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1, 256, 128,   8,  64,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0, 256, 128,   8,  64,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0, 256, 128,   8,  64,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0, 256, 128,   8,  64,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1, 256, 128,   8,  64,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1, 256, 128,   8,  64,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1, 256, 128,   8,  64,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0, 128, 256,  32,  32,  32,   8,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  32,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0, 128, 256,  32,  32,  32,   8,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  32,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0, 128, 256,  32,  32,  32,   8,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  32,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   1, 128, 256,  32,  32,  32,   8,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  32,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   1, 128, 256,  32,  32,  32,   8,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  32,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   1, 128, 256,  32,  32,  32,   8,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  32,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0, 128, 256,  32,  32,  32,   8,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,  32,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0, 128, 256,  32,  32,  32,   8,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,  32,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1, 128, 256,  32,  32,  32,   8,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,  32,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1, 128, 256,  32,  32,  32,   8,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,  32,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0, 128, 256,  16,  32,  64,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   0, 128, 256,  16,  32,  32,   8,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0, 128, 256,  16,  32,  64,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0, 128, 256,  16,  32,  32,   8,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0, 128, 256,  16,  32,  64,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0, 128, 256,  16,  32,  32,   8,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   1, 128, 256,  16,  32,  64,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   1, 128, 256,  16,  32,  32,   8,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   1, 128, 256,  16,  32,  64,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   1, 128, 256,  16,  32,  32,   8,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   1, 128, 256,  16,  32,  64,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   1, 128, 256,  16,  32,  32,   8,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   0, 128, 256,  16,  32,  64,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0, 128, 256,  16,  32,  32,   8,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 128, 256,  16,  32,  64,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 128, 256,  16,  32,  32,   8,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 128, 256,  16,  32,  64,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 128, 256,  16,  32,  32,   8,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 128, 256,  16,  32,  64,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 128, 256,  16,  32,  32,   8,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 128, 256,  16,  32,  64,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 128, 256,  16,  32,  32,   8,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 128, 256,  16,  32,  64,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 128, 256,  16,  32,  32,   8,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0, 128, 256,   8,  32,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0, 128, 256,   8,  32,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0, 128, 256,   8,  32,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   1, 128, 256,   8,  32,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   1, 128, 256,   8,  32,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   1, 128, 256,   8,  32,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   0, 128, 256,   8,  32,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0, 128, 256,   8,  32,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0, 128, 256,   8,  32,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1, 128, 256,   8,  32,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1, 128, 256,   8,  32,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1, 128, 256,   8,  32,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  64, 256,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,  32,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0,  64, 256,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,  32,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0,  64, 256,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,  32,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,  16,   1,  64, 256,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,  32,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,   4,   1,  64, 256,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,  32,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,   1,   1,  64, 256,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,  32,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0,  64, 256,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,  32,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  64, 256,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,  32,   1},   {1,  32,   1,   8},   0},
        //{ "fwd", miopenHalf,   4,   1,  64, 256,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,  32,   1},   {1,  32,   1,   8},   0},
        //{ "fwd", miopenHalf,   1,   1,  64, 256,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,  32,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0,  64, 256,  16,  32,  64,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   0,  64, 256,  16,  16,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   0,  64, 256,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0,  64, 256,  16,  32,  64,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0,  64, 256,  16,  16,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0,  64, 256,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0,  64, 256,  16,  32,  64,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0,  64, 256,  16,  16,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0,  64, 256,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,  16,   1,  64, 256,  16,  16,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,  16,   1,  64, 256,  16,  32,  64,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,  16,   1,  64, 256,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,   4,   1,  64, 256,  16,  16,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,   4,   1,  64, 256,  16,  32,  64,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,   4,   1,  64, 256,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,   1,   1,  64, 256,  16,  16,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,   1,   1,  64, 256,  16,  32,  64,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,   1,   1,  64, 256,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   0,  64, 256,  16,  32,  64,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  64, 256,  16,  16,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  64, 256,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64, 256,  16,  32,  64,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64, 256,  16,  16,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64, 256,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  64, 256,  16,  16,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  64, 256,  16,  32,  64,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  64, 256,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        //{ "fwd", miopenHalf,  16,   1,  64, 256,  16,  32,  64,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        //{ "fwd", miopenHalf,  16,   1,  64, 256,  16,  16,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        //{ "fwd", miopenHalf,  16,   1,  64, 256,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        //{ "fwd", miopenHalf,   4,   1,  64, 256,  16,  32,  64,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        //{ "fwd", miopenHalf,   4,   1,  64, 256,  16,  16,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        //{ "fwd", miopenHalf,   4,   1,  64, 256,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        //{ "fwd", miopenHalf,   1,   1,  64, 256,  16,  32,  64,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        //{ "fwd", miopenHalf,   1,   1,  64, 256,  16,  16,  64,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        //{ "fwd", miopenHalf,   1,   1,  64, 256,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  64, 256,   8,  16,  64,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   0,  64, 256,   8,  32,  64,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0,  64, 256,   8,  16,  64,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0,  64, 256,   8,  32,  64,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0,  64, 256,   8,  16,  64,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0,  64, 256,   8,  32,  64,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,  16,   1,  64, 256,   8,  16,  64,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,  16,   1,  64, 256,   8,  32,  64,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        //{ "fwd", miopenHalf,   4,   1,  64, 256,   8,  16,  64,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   1,  64, 256,   8,  32,  64,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   1,  64, 256,   8,  16,  64,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   1,  64, 256,   8,  32,  64,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   0,  64, 256,   8,  32,  64,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  64, 256,   8,  16,  64,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  64, 256,   8,  32,  64,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  64, 256,   8,  16,  64,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  64, 256,   8,  16,  64,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  64, 256,   8,  32,  64,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  64, 256,   8,  32,  64,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  64, 256,   8,  16,  64,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  64, 256,   8,  32,  64,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  64, 256,   8,  16,  64,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  64, 256,   8,  32,  64,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  64, 256,   8,  16,  64,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,  64,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,  32,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,  64,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,  32,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,  64,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,  32,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,  64,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,  32,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,  64,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,  32,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,  64,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,  32,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,  64,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,   1,  32,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,  64,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,   1,  32,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,  64,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,   1,  32,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,  64,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,   1,  32,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,  32,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,  32,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,  32,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,  32,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,  32,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,  32,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,  32,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,  32,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,  32,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,  32,  32,  32,   8,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,  32,  16,  16,  16,   2,   2,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,  16,  32,  64,   4,   2,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,  16,  32,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,  16,  32,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,  16,  32,  64,   4,   2,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,  16,  32,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,  16,  32,  64,   4,   2,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,  16,  32,  64,   4,   2,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,  16,  32,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,  16,  32,  64,   4,   2,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,  16,  32,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,  16,  32,  64,   4,   2,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,  16,  32,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,  16,  32,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,  16,  32,  64,   4,   2,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,  16,  32,  64,   4,   2,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,  16,  32,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,  16,  32,  64,   4,   2,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,  16,  32,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,  16,  32,  64,   4,   2,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,  16,  32,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,  16,  32,  64,   4,   2,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,  16,  32,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,  16,  32,  64,   4,   2,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,  16,  32,  32,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,  16,  32,  32,   8,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,   8,  32,  64,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,   8,  32,  32,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,   8,  32,  64,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,   8,  32,  32,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,   8,  32,  32,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,   8,  32,  64,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,   8,  32,  64,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,   8,  32,  32,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,   8,  32,  32,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,   8,  32,  64,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,   8,  32,  32,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,   8,  32,  64,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,   8,  32,  64,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0, 128, 128,   8,  32,  32,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,   8,  32,  64,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0, 128, 128,   8,  32,  32,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,   8,  32,  64,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0, 128, 128,   8,  32,  32,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,   8,  32,  32,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1, 128, 128,   8,  32,  64,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,   8,  32,  64,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1, 128, 128,   8,  32,  32,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,   8,  32,  64,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1, 128, 128,   8,  32,  32,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0, 256,  64,  16,  64,  16,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0, 256,  64,  16,  64,  16,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0, 256,  64,  16,  64,  16,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1, 256,  64,  16,  64,  16,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1, 256,  64,  16,  64,  16,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1, 256,  64,  16,  64,  16,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   0, 256,  64,  16,  64,  16,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 256,  64,  16,  64,  16,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 256,  64,  16,  64,  16,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 256,  64,  16,  64,  16,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 256,  64,  16,  64,  16,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 256,  64,  16,  64,  16,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0, 256,  64,   8,  64,  16,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0, 256,  64,   8,  64,  16,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0, 256,  64,   8,  64,  16,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1, 256,  64,   8,  64,  16,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1, 256,  64,   8,  64,  16,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1, 256,  64,   8,  64,  16,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   0, 256,  64,   8,  64,  16,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0, 256,  64,   8,  64,  16,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0, 256,  64,   8,  64,  16,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1, 256,  64,   8,  64,  16,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1, 256,  64,   8,  64,  16,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1, 256,  64,   8,  64,  16,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  32, 256,  16,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0,  32, 256,  16,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0,  32, 256,  16,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   1,  32, 256,  16,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   1,  32, 256,  16,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   1,  32, 256,  16,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   0,  32, 256,  16,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  32, 256,  16,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  32, 256,  16,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  32, 256,  16,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  32, 256,  16,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  32, 256,  16,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  32, 256,   8,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0,  32, 256,   8,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0,  32, 256,   8,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   1,  32, 256,   8,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   1,  32, 256,   8,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   1,  32, 256,   8,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   0,  32, 256,   8,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  32, 256,   8,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  32, 256,   8,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  32, 256,   8,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  32, 256,   8,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  32, 256,   8,   4,  64,   4,   2,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,  32,  32,  32,   8,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,  32,  32,  32,   8,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,  32,  32,  32,   8,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,  32,  32,  32,   8,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,  32,  32,  32,   8,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,  32,  32,  32,   8,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,  32,  32,  32,   8,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,  32,  32,  32,   8,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,  32,  32,  32,   8,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,  32,  32,  32,   8,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,  16,  32,  64,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,  16,  64,  32,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,  16,   8,  32,   4,   2,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,  16,  32,  32,   8,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,  16,   8,  32,   4,   2,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,  16,  32,  64,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,  16,  64,  32,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,  16,  32,  32,   8,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,  16,  64,  32,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,  16,  32,  64,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,  16,   8,  32,   4,   2,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,  16,  32,  32,   8,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,  16,  64,  32,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,  16,   8,  32,   4,   2,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,  16,  32,  64,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,  16,  32,  32,   8,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,  16,   8,  32,   4,   2,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,  16,  64,  32,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,  16,  32,  64,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,  16,  32,  32,   8,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,  16,  64,  32,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,  16,  32,  64,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,  16,   8,  32,   4,   2,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,  16,  32,  32,   8,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,  16,  64,  32,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,  16,   8,  32,   4,   2,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,  16,  32,  64,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,  16,  32,  32,   8,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,  16,  32,  64,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,  16,   8,  32,   4,   2,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,  16,  64,  32,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,  16,  32,  32,   8,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,  16,   8,  32,   4,   2,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,  16,  32,  64,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,  16,  64,  32,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,  16,  32,  32,   8,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,  16,  64,  32,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,  16,  32,  64,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,  16,   8,  32,   4,   2,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,  16,  32,  32,   8,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,  16,   8,  32,   4,   2,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,  16,  32,  64,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,  16,  64,  32,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,  16,  32,  32,   8,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,  16,   8,  32,   4,   2,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,  16,  64,  32,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,  16,  32,  64,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,  16,  32,  32,   8,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,   8,   8,  32,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,   8,  32,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,   8,  64,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,   8,  32,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,   8,   8,  32,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,   8,  64,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,   8,  32,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,   8,  64,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,   8,   8,  32,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,   8,  64,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,   8,   8,  32,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,   8,  32,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,   8,  32,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,   8,   8,  32,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,   8,  64,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,   8,  64,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,   8,   8,  32,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,   8,  32,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,   8,  64,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,   8,  32,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  64, 128,   8,   8,  32,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,   8,  32,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,   8,  64,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  64, 128,   8,   8,  32,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,   8,   8,  32,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,   8,  32,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  64, 128,   8,  64,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,   8,   8,  32,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,   8,  64,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  64, 128,   8,  32,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,   8,   8,  32,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,   8,  64,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  64, 128,   8,  32,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,   8,   8,  32,   4,   2,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,   8,  32,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  64, 128,   8,  64,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0, 128,  64,  64,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0, 128,  64,  64,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0, 128,  64,  64,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1, 128,  64,  64,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1, 128,  64,  64,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1, 128,  64,  64,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0, 128,  64,  64,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   1,   0, 128,  64,  64,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   4,   1, 128,  64,  64,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   1,   1, 128,  64,  64,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   4,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,  16,   0, 128,  64,  32,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0, 128,  64,  32,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0, 128,  64,  32,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1, 128,  64,  32,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1, 128,  64,  32,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1, 128,  64,  32,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0, 128,  64,  32,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0, 128,  64,  32,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1, 128,  64,  32,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1, 128,  64,  32,  16,  16,  16,   2,   1,   2,   2,   {1,   8,   2,   1},   {1,   4,   1,  64},   {1,   1,   8,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0, 128,  64,  16,  32,   8,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0, 128,  64,  16,  32,   8,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0, 128,  64,  16,  32,   8,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1, 128,  64,  16,  32,   8,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1, 128,  64,  16,  32,   8,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1, 128,  64,  16,  32,   8,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   0, 128,  64,  16,  32,   8,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 128,  64,  16,  32,   8,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 128,  64,  16,  32,   8,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 128,  64,  16,  32,   8,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 128,  64,  16,  32,   8,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 128,  64,  16,  32,   8,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0, 128,  64,   8,  32,   8,   4,   1,   2,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0, 128,  64,   8,  32,   8,   4,   1,   2,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0, 128,  64,   8,  32,   8,   4,   1,   2,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1, 128,  64,   8,  32,   8,   4,   1,   2,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1, 128,  64,   8,  32,   8,   4,   1,   2,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1, 128,  64,   8,  32,   8,   4,   1,   2,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   0, 128,  64,   8,  32,   8,   4,   1,   2,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0, 128,  64,   8,  32,   8,   4,   1,   2,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0, 128,  64,   8,  32,   8,   4,   1,   2,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1, 128,  64,   8,  32,   8,   4,   1,   2,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1, 128,  64,   8,  32,   8,   4,   1,   2,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1, 128,  64,   8,  32,   8,   4,   1,   2,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0, 256,  32,  16,  64,   4,   4,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0, 256,  32,  16,  64,   4,   4,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0, 256,  32,  16,  64,   4,   4,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1, 256,  32,  16,  64,   4,   4,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1, 256,  32,  16,  64,   4,   4,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1, 256,  32,  16,  64,   4,   4,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0, 256,  32,  16,  64,   4,   4,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 256,  32,  16,  64,   4,   4,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 256,  32,  16,  64,   4,   4,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 256,  32,  16,  64,   4,   4,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 256,  32,  16,  64,   4,   4,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 256,  32,  16,  64,   4,   4,   1,   2,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0, 256,  32,   8,  64,   4,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0, 256,  32,   8,  64,   4,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0, 256,  32,   8,  64,   4,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1, 256,  32,   8,  64,   4,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1, 256,  32,   8,  64,   4,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1, 256,  32,   8,  64,   4,   4,   1,   2,   2,   2,   {1,   4,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  16, 256,  16,   4,  64,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   0,  16, 256,  16,   4,  64,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   0,  16, 256,  16,   4,  64,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   1,  16, 256,  16,   4,  64,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   4,   1,  16, 256,  16,   4,  64,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,   1,   1,  16, 256,  16,   4,  64,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,  16,   1,   1},   {1,   1,   1, 256},   0},
        { "fwd", miopenHalf,  16,   0,  16, 256,  16,   4,  64,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  16, 256,  16,   4,  64,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  16, 256,  16,   4,  64,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  16, 256,  16,   4,  64,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  16, 256,  16,   4,  64,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  16, 256,  16,   4,  64,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,  16,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  32, 128,  16,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0,  32, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  32, 128,  16,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  32, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  32, 128,  16,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  32, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  32, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  32, 128,  16,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  32, 128,  16,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  32, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  32, 128,  16,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  32, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0,  32, 128,  16,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  32, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  32, 128,  16,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  32, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  32, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  32, 128,  16,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  32, 128,  16,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  32, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  32, 128,  16,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  32, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  32, 128,  16,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  32, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  32, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0,  32, 128,   8,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  32, 128,   8,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  32, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  32, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  32, 128,   8,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  32, 128,   8,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  32, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  32, 128,   8,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  32, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  32, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  32, 128,   8,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   2,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0,  32, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  32, 128,   8,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  32, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  32, 128,   8,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  32, 128,   8,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  32, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  32, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  32, 128,   8,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  32, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  32, 128,   8,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  32, 128,   8,   8,  32,   4,   1,   1,   2,   2,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  32, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  64,  64,  64,  16,  16,  16,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   0,  64,  64,  64,  16,  16,  16,   2,   2,   1,   1,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  64,  64,  64,  16,  16,  16,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  64,  64,  64,  16,  16,  16,   2,   2,   1,   1,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,  64,  64,  64,  16,  16,  16,   2,   2,   1,   1,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,  64,  64,  64,  16,  16,  16,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,  64,  64,  64,  16,  16,  16,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,  64,  64,  64,  16,  16,  16,   2,   2,   1,   1,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,  64,  64,  64,  16,  16,  16,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,  64,  64,  64,  16,  16,  16,   2,   2,   1,   1,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,  64,  64,  64,  16,  16,  16,   2,   2,   1,   1,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,  64,  64,  64,  16,  16,  16,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,  16,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  64,  64,  64,  16,  16,  16,   2,   2,   1,   1,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   4,   0,  64,  64,  64,  16,  16,  16,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   1,   0,  64,  64,  64,  16,  16,  16,   2,   2,   1,   1,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   1,   0,  64,  64,  64,  16,  16,  16,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   4,   1,  64,  64,  64,  16,  16,  16,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   4,   1,  64,  64,  64,  16,  16,  16,   2,   2,   1,   1,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   1,   1,  64,  64,  64,  16,  16,  16,   2,   2,   1,   1,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   1,   1,  64,  64,  64,  16,  16,  16,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   8,   1,  32},   {1,   1,  16,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,  16,   0,  64,  64,  32,  16,  16,  16,   2,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   0,  64,  64,  32,  16,  16,  16,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  64,  64,  32,  16,  16,  16,   2,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  64,  64,  32,  16,  16,  16,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,  64,  64,  32,  16,  16,  16,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,  64,  64,  32,  16,  16,  16,   2,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,  64,  64,  32,  16,  16,  16,   2,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,  64,  64,  32,  16,  16,  16,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,  64,  64,  32,  16,  16,  16,   2,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,  64,  64,  32,  16,  16,  16,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,  64,  64,  32,  16,  16,  16,   2,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,  64,  64,  32,  16,  16,  16,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   8,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  64,  64,  32,  16,  16,  16,   2,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   4,   0,  64,  64,  32,  16,  16,  16,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  64,  64,  32,  16,  16,  16,   2,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  64,  64,  32,  16,  16,  16,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  64,  64,  32,  16,  16,  16,   2,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  64,  64,  32,  16,  16,  16,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  64,  64,  32,  16,  16,  16,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  64,  64,  32,  16,  16,  16,   2,   2,   1,   1,   {1,   4,   2,   1},   {1,   8,   1,  32},   {1,   1,   8,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0,  64,  64,  16,  16,  16,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  64,  64,  16,  16,  16,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,  64,  64,  16,  16,  16,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,  64,  64,  16,  16,  16,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,  64,  64,  16,  16,  16,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,  64,  64,  16,  16,  16,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   0,  64,  64,  16,  16,  16,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64,  64,  16,  16,  16,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  64,  64,  16,  16,  16,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  64,  64,  16,  16,  16,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  64,  64,  16,  16,  16,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  64,  64,  16,  16,  16,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  64,  64,   8,  16,  16,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  64,  64,   8,  16,  16,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,  64,  64,   8,  16,  16,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,  64,  64,   8,  16,  16,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,  64,  64,   8,  16,  16,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,  64,  64,   8,  16,  16,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   0,  64,  64,   8,  16,  16,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  64,  64,   8,  16,  16,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  64,  64,   8,  16,  16,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  64,  64,   8,  16,  16,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  64,  64,   8,  16,  16,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  64,  64,   8,  16,  16,   4,   1,   1,   2,   2,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0, 128,  32,  16,  32,   8,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0, 128,  32,  16,  32,   8,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0, 128,  32,  16,  32,   8,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1, 128,  32,  16,  32,   8,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1, 128,  32,  16,  32,   8,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1, 128,  32,  16,  32,   8,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0, 128,  32,  16,  32,   8,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 128,  32,  16,  32,   8,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 128,  32,  16,  32,   8,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 128,  32,  16,  32,   8,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 128,  32,  16,  32,   8,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 128,  32,  16,  32,   8,   4,   1,   1,   2,   2,   {1,   4,   2,   1},   {1,   4,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0, 128,  32,   8,  32,   8,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0, 128,  32,   8,  32,   8,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0, 128,  32,   8,  32,   8,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1, 128,  32,   8,  32,   8,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1, 128,  32,   8,  32,   8,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1, 128,  32,   8,  32,   8,   4,   1,   1,   2,   2,   {1,   2,   2,   1},   {1,   4,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0, 256,  16,  16,  64,   4,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 256,  16,  16,  64,   4,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 256,  16,  16,  64,   4,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 256,  16,  16,  64,   4,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 256,  16,  16,  64,   4,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 256,  16,  16,  64,   4,   4,   1,   1,   2,   2,   {1,   8,   2,   1},   {1,   2,   1, 128},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  16, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,  16,   1,   1},   {1,   1,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  16, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,  16,   1,   1},   {1,   1,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  16, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,  16,   1,   1},   {1,   1,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  16, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,  16,   1,   1},   {1,   1,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  16, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,  16,   1,   1},   {1,   1,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  16, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,  16,   1,   1},   {1,   1,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  16, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,  16,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  16, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,  16,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  16, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,  16,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  16, 128,  16,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,  16,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0,  16, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   8,   1,   1},   {1,   1,   1, 128},   0},
        { "fwd", miopenHalf,   4,   0,  16, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   8,   1,   1},   {1,   1,   1, 128},   0},
        { "fwd", miopenHalf,   1,   0,  16, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   8,   1,   1},   {1,   1,   1, 128},   0},
        { "fwd", miopenHalf,  16,   1,  16, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   8,   1,   1},   {1,   1,   1, 128},   0},
        { "fwd", miopenHalf,   4,   1,  16, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   8,   1,   1},   {1,   1,   1, 128},   0},
        { "fwd", miopenHalf,   1,   1,  16, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   8,   1,   1},   {1,   1,   1, 128},   0},
        { "fwd", miopenHalf,  16,   0,  16, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   8,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  16, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   8,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  16, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   8,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  16, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   8,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  16, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   8,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  16, 128,   8,  16,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   8,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  32,  64,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  32,  64,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,  32,  64,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,  32,  64,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,  32,  64,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,  32,  64,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   0,  32,  64,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  32,  64,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  32,  64,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  32,  64,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  32,  64,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  32,  64,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  32,  64,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  32,  64,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,  32,  64,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,  32,  64,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,  32,  64,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,  32,  64,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   0,  32,  64,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  32,  64,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  32,  64,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  32,  64,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  32,  64,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  32,  64,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  64,  32,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  64,  32,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  64,  32,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  64,  32,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  64,  32,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  64,  32,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  64,  32,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64,  32,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  64,  32,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  64,  32,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  64,  32,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  64,  32,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  64,  32,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  64,  32,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  64,  32,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  64,  32,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  64,  32,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  64,  32,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0, 128,  16,  16,  64,  16,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 128,  16,  16,  64,  16,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 128,  16,  16,  64,  16,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 128,  16,  16,  64,  16,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 128,  16,  16,  64,  16,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 128,  16,  16,  64,  16,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  64},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 128,  16,  16,  64,  16,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0, 128,  16,  16,  64,  16,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1, 128,  16,  16,  64,  16,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1, 128,  16,  16,  64,  16,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  64},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0, 128,  16,   8,  64,  16,   4,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,   2,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0, 128,  16,   8,  64,  16,   4,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,   2,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0, 128,  16,   8,  64,  16,   4,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,   2,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1, 128,  16,   8,  64,  16,   4,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,   2,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1, 128,  16,   8,  64,  16,   4,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,   2,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1, 128,  16,   8,  64,  16,   4,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,   2,   1,  64},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  16,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  16,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,  16,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,  16,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,  16,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,  16,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  64},   0},
        { "fwd", miopenHalf,  16,   0,  16,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  16,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  16,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  16,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  16,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  16,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  16,  64,  16,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  16,  64,  16,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,  16,  64,  16,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,  16,  64,  16,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,  16,  64,  16,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,  16,  64,  16,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  16,  64,  16,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  16,  64,  16,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  16,  64,  16,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  16,  64,  16,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0,  16,  64,   8,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   4,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,  16,  64,   8,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   4,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,  16,  64,   8,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   4,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,  16,  64,   8,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   4,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,  16,  64,   8,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   4,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,  16,  64,   8,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   4,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,  16,   0,  16,  64,   8,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   4,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  16,  64,   8,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   4,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  16,  64,   8,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   4,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  16,  64,   8,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   4,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  16,  64,   8,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   4,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  16,  64,   8,   4,  64,   4,   2,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   4,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  32,  32,  64,  16,  16,  16,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  32,  32,  64,  16,  16,  16,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  32,  32,  64,  16,  16,  16,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  32,  32,  64,  16,  16,  16,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  32,  32,  64,  16,  16,  16,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  32,  32,  64,  16,  16,  16,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,  16,   1,  16},   {1,   8,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  32,  32,  64,  16,  16,  16,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   1,   0,  32,  32,  64,  16,  16,  16,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   4,   1,  32,  32,  64,  16,  16,  16,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,   1,   1,  32,  32,  64,  16,  16,  16,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,  16,   1,  16},   {1,   1,   8,   1},   {1,  64,   1,   4},   0},
        { "fwd", miopenHalf,  16,   0,  32,  32,  32,  16,  16,  16,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  32,  32,  32,  16,  16,  16,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  32,  32,  32,  16,  16,  16,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  32,  32,  32,  16,  16,  16,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  32,  32,  32,  16,  16,  16,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  32,  32,  32,  16,  16,  16,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,  16,   1,  16},   {1,   4,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  32,  32,  32,  16,  16,  16,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  32,  32,  32,  16,  16,  16,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  32,  32,  32,  16,  16,  16,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  32,  32,  32,  16,  16,  16,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,  16,   1,  16},   {1,   1,   4,   1},   {1,  32,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0,  32,  32,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  32,  32,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  32,  32,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  32,  32,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  32,  32,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  32,  32,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  32,  32,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  32,  32,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  32,  32,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  32,  32,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  32,  32,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  32,  32,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  32,  32,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  32,  32,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  32,  32,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  32,  32,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  32,  32,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  32,  32,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  64,  16,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64,  16,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  64,  16,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  64,  16,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  64,  16,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  64,  16,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  64,  16,  16,  64,   4,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64,  16,  16,  64,   4,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  64,  16,  16,  64,   4,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  64,  16,  16,  64,   4,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  64,  16,  16,  64,   4,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  64,  16,  16,  64,   4,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64,  16,  16,  64,   4,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  64,  16,  16,  64,   4,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  64,  16,  16,  64,   4,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  64,  16,  16,  64,   4,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0,  64,  16,   8,  64,   4,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  64,  16,   8,  64,   4,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  64,  16,   8,  64,   4,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  64,  16,   8,  64,   4,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  64,  16,   8,  64,   4,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  64,  16,   8,  64,   4,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  32},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,   8,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,   8,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,   8,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,   8,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,   8,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,   8,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,   8,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,   8,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,   8,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,   8,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0,  16,  32,  16,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  16,  32,  16,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  16,  32,  16,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  16,  32,  16,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  16,  32,  16,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  16,  32,  16,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  16,  32,  16,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,   4,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  16,  32,  16,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,   4,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  16,  32,  16,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,   4,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  16,  32,  16,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,  16,   1,   8},   {1,   1,   4,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0,  16,  32,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  16,  32,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  16,  32,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  16,  32,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  16,  32,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  16,  32,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   8,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  16,  32,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   1,   0,  16,  32,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   4,   1,  16,  32,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   1,   1,  16,  32,  16,   8,  32,   4,   2,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   1,   8,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,  16,   0,  16,  32,   8,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  16,  32,   8,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  16,  32,   8,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  16,  32,   8,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  16,  32,   8,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  16,  32,   8,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  32},   0},
        { "fwd", miopenHalf,  16,   0,  16,  32,   8,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  16,  32,   8,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  16,  32,   8,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  16,  32,   8,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  16,  32,   8,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  16,  32,   8,   8,  32,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  16,  32,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  16,  32,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenHalf,   1,   0,  16,  32,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenHalf,  16,   1,  16,  32,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenHalf,   4,   1,  16,  32,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenHalf,   1,   1,  16,  32,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   2,   1,  32},   0},
        { "fwd", miopenHalf,   4,   0,  16,  32,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   1,   4,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  16,  32,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   1,   4,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  16,  32,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   1,   4,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  16,  32,   8,   8,  32,   4,   2,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   1,   4,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0,  32,  16,  16,  32,   8,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  32,  16,  16,  32,   8,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  32,  16,  16,  32,   8,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  32,  16,  16,  32,   8,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  32,  16,  16,  32,   8,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  32,  16,  16,  32,   8,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   2,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  32,  16,  16,  32,   8,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  32,  16,  16,  32,   8,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  32,  16,  16,  32,   8,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  32,  16,  16,  32,   8,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,  16},   {1,   1,   2,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0,  32,  16,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  32,  16,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  32,  16,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  32,  16,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  32,  16,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  32,  16,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  32,  16,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   1,   0,  32,  16,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   4,   1,  32,  16,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   1,   1,  32,  16,  16,  32,   8,   4,   1,   2,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  16},   {1,   1,   4,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,  16,   0,  32,  16,   8,  32,   8,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  16},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  32,  16,   8,  32,   8,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  16},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  32,  16,   8,  32,   8,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  16},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  32,  16,   8,  32,   8,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  16},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  32,  16,   8,  32,   8,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  16},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  32,  16,   8,  32,   8,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,  16},   {1,   1,   1,   1},   {1,   8,   1,  16},   0},
        { "fwd", miopenHalf,  16,   0,  32,  16,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  32,  16,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  32,  16,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  32,  16,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  32,  16,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  32,  16,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  32,  16,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  32,  16,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  32,  16,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  32,  16,   8,  32,   8,   4,   1,   2,   1,   1,   {1,   2,   2,   1},   {1,   4,   1,  16},   {1,   1,   2,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenHalf,   4,   0,  64,   8,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  64,   8,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  64,   8,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  64,   8,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   4,   2,   1},   {1,   4,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,   8},   0},
        { "fwd", miopenHalf,  16,   0,   4,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,  16,   1,   1},   {1,   1,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,   4,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,  16,   1,   1},   {1,   1,   1,  64},   0},
        { "fwd", miopenHalf,   1,   0,   4,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,  16,   1,   1},   {1,   1,   1,  64},   0},
        { "fwd", miopenHalf,  16,   1,   4,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,  16,   1,   1},   {1,   1,   1,  64},   0},
        { "fwd", miopenHalf,   4,   1,   4,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,  16,   1,   1},   {1,   1,   1,  64},   0},
        { "fwd", miopenHalf,   1,   1,   4,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,  16,   1,   1},   {1,   1,   1,  64},   0},
        { "fwd", miopenHalf,   4,   0,   4,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   1,  16,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   1,   0,   4,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   1,  16,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   4,   1,   4,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   1,  16,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   1,   1,   4,  64,  16,   4,  64,   4,   1,   1,   1,   1,   {1,   1,   1,   1},   {1,  16,   1,   4},   {1,   1,  16,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,  16,   0,  16,  16,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  16,  16,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  16,  16,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  16,  16,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  16,  16,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  16,  16,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   4,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  16,  16,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   1,   4,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   1,   0,  16,  16,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   1,   4,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   4,   1,  16,  16,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   1,   4,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   1,   1,  16,  16,  16,  16,  16,   4,   1,   1,   1,   1,   {1,   2,   2,   1},   {1,   8,   1,   8},   {1,   1,   4,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,  16,   0,  16,  16,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  16,  16,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   1,   0,  16,  16,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,  16,   1,  16,  16,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   4,   1,  16,  16,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   1,   1,  16,  16,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   2,   1,   1},   {1,   4,   1,  16},   0},
        { "fwd", miopenHalf,   4,   0,  16,  16,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   1,   2,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenHalf,   1,   0,  16,  16,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   1,   2,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenHalf,   4,   1,  16,  16,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   1,   2,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenHalf,   1,   1,  16,  16,   8,  16,  16,   4,   1,   1,   1,   1,   {1,   1,   2,   1},   {1,   8,   1,   8},   {1,   1,   2,   1},   {1,   8,   1,   8},   0},
        { "fwd", miopenHalf,   4,   0,  64,   4,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   1,   0,  64,   4,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   4,   1,  64,   4,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,   4},   0},
        { "fwd", miopenHalf,   1,   1,  64,   4,  16,  64,   4,   4,   1,   1,   1,   1,   {1,   8,   2,   1},   {1,   2,   1,  32},   {1,   1,   1,   1},   {1,  16,   1,   4},   0},
    };
    // clang-format on

    return kernel_param_list;
}

// This is a helper function for selecting better performing config
bool mayHaveBiggerN1bClusterSize(int gemm_m,
                                 int gemm_n,
                                 const TunableImplicitGemmGTCDynamic_t& tunable)
{
    float n_times_m = static_cast<float>(gemm_n) / static_cast<float>(gemm_m);

    if(n_times_m > 100.0f)
    {
        if(tunable.gemm_k_per_block <= 2 * tunable.wave_tile_k)
            return (false);

        // N1bClusterSize can be expanded by using half gemm_k_per_block
        if((tunable.tensor_a_thread_lengths[1] > 1 ||
            tunable.tensor_a_cluster_lengths[3] * 2 <= tunable.gemm_m_per_block) &&
           (tunable.tensor_b_cluster_lengths[3] * 2 <= tunable.gemm_n_per_block))
            return (true);
    };

    return (false);
}

static std::tuple<bool, // is suitable kernel found
                  TunableImplicitGemmGTCDynamic_t,
                  std::string, // kernel_name
                  int,         // block_size
                  int>         // grid_size
FindImplicitGemmGtcDynamicFwdKernel(const ProblemDescription& problem)
{
    auto tunables         = GetImplicitGemmGtcDynamicFwdXdlopsTunablesList();
    const auto n          = problem.GetBatchSize();
    const auto c          = problem.GetInChannels();
    const auto k          = problem.GetOutChannels();
    const auto ho         = problem.GetOutHeight();
    const auto wo         = problem.GetOutWidth();
    const auto stride_h   = problem.GetInHeight() > 1 ? problem.GetKernelStrideH() : 1;
    const auto stride_w   = problem.GetInWidth() > 1 ? problem.GetKernelStrideW() : 1;
    const auto dilation_h = problem.GetWeightsHeight() > 1 ? problem.GetDilationH() : 1;
    const auto dilation_w = problem.GetWeightsWidth() > 1 ? problem.GetDilationW() : 1;
    const auto pad_h      = problem.GetPadH();
    const auto pad_w      = problem.GetPadW();
    const auto y          = problem.GetWeightsHeight();
    const auto x          = problem.GetWeightsWidth();

    const auto& gemm_m = k;
    const auto gemm_n  = n * ho * wo;
    const auto gemm_k  = c * y * x;

    const auto& precision = problem.IsFp16() ? miopenHalf : miopenFloat;

    for(const auto& cfg : tunables)
    {
        if(precision != cfg.precision)
            continue;
        if(cfg.nxe == 0)
        {
            if((x != 1) || (y != 1) || (stride_h != 1) || (stride_w != 1) || (dilation_h != 1) ||
               (dilation_w != 1) || (pad_h != 0) || (pad_w != 0))
            {
                continue;
            }
        };
        if(precision == miopenFloat)
        {
            if((gemm_n % cfg.gemm_n_per_block != 0) || (gemm_m % cfg.gemm_m_per_block != 0) ||
               (gemm_k % cfg.gemm_k_per_block != 0))
            {
                continue;
            };
        }
        else
        {
            if((gemm_n % cfg.gemm_n_per_block != 0) || (gemm_m % cfg.gemm_m_per_block != 0))
            {
                continue;
            };
            if((gemm_k % cfg.gemm_k_per_block != 0) && (cfg.tensor_a_thread_lengths[1] > 1))
            {
                continue;
            };
        }
        // Don't have to check, assuming the tunable itself is already valid
        if(cfg.gemm_n_per_block % cfg.nxb != 0)
        {
            continue;
        };

        if(n % (cfg.gemm_n_per_block / cfg.nxb) != 0)
        {
            continue;
        };

        if((ho * wo) % cfg.nxb != 0)
        {
            continue;
        };

        // tensor_b_thread_lengths[c1e] > 1 can only be used with x=y=1
        if(cfg.tensor_b_thread_lengths[1] > 1 && (x != 1 || y != 1))
        {
            continue;
        };

        // try find another config whose n1b cluster is larger
        if(mayHaveBiggerN1bClusterSize(gemm_m, gemm_n, cfg))
            continue;

        return std::make_tuple(true,
                               cfg,
                               cfg.GetKernelName(),
                               cfg.GetBlockSize(),
                               integer_divide_ceil(gemm_m, cfg.gemm_m_per_block) *
                                   integer_divide_ceil(gemm_n, cfg.gemm_n_per_block));
    };

    // second try, try find if packed image size match
    for(const auto& cfg : tunables)
    {
        const auto b             = cfg.nxe == 0 ? (ho * wo)
                                                : ((ho * wo + cfg.nxb - 1) / cfg.nxb) *
                                          cfg.nxb; // pad to nxb modulo when nxe != 0
        const auto gemm_n_packed = n * b;
        if(precision != cfg.precision)
            continue;
        if(cfg.nxe == 0)
        {
            if((x != 1) || (y != 1) || (stride_h != 1) || (stride_w != 1) || (dilation_h != 1) ||
               (dilation_w != 1) || (pad_h != 0) || (pad_w != 0))
            {
                continue;
            }
        };
        if(precision == miopenFloat)
        {
            if((gemm_n_packed % cfg.gemm_n_per_block != 0) ||
               (gemm_m % cfg.gemm_m_per_block != 0) || (gemm_k % cfg.gemm_k_per_block != 0))
            {
                continue;
            };
        }
        else
        {
            if((gemm_n_packed % cfg.gemm_n_per_block != 0))
            {
                continue;
            };
            if((gemm_k % cfg.gemm_k_per_block != 0) && (cfg.tensor_a_thread_lengths[1] > 1))
            {
                continue;
            };
        }
        // Don't have to check, assuming the tunable itself is already valid
        if(cfg.gemm_n_per_block % cfg.nxb != 0)
        {
            continue;
        };

        if(n % (cfg.gemm_n_per_block / cfg.nxb) != 0)
        {
            continue;
        };

        // tensor_b_thread_lengths[c1e] > 1 can only be used with x=y=1
        if(cfg.tensor_b_thread_lengths[1] > 1 && (x != 1 || y != 1))
        {
            continue;
        };

        return std::make_tuple(true,
                               cfg,
                               cfg.GetKernelName(),
                               cfg.GetBlockSize(),
                               integer_divide_ceil(gemm_m, cfg.gemm_m_per_block) *
                                   integer_divide_ceil(gemm_n_packed, cfg.gemm_n_per_block));
    };
    return std::make_tuple(false, tunables[0], "", -1, -1);
}

bool ConvAsmImplicitGemmGTCDynamicFwdXdlops::IsApplicable(const ExecutionContext& ctx,
                                                          const ProblemDescription& problem) const
{
    if(miopen::IsDisabled(MIOPEN_DEBUG_CONV_IMPLICIT_GEMM_ASM_FWD_GTC_XDLOPS{}))
        return false;

    const auto device_name = ctx.GetStream().GetDeviceName();
    if(device_name != "gfx908")
        return false;

    if(!ctx.use_asm_kernels)
        return false;

    if(!problem.direction.IsForward())
        return false;

    if(!problem.Is2d())
        return false;

    if(!problem.IsFp32() && !problem.IsFp16())
        return false;

    if(!ctx.rmv.IsV3())
        return false;

    if(problem.GetGroupCount() != 1)
        return false;

    if(!problem.IsLayoutDefault())
    {
        return false;
    }

#if WORKAROUND_SWDEV_306318
    if((problem.GetWeightsHeight() == 1) && (problem.GetWeightsWidth() == 1) &&
       (problem.GetInChannels() % 8 != 0))
        if(!miopen::IsEnabled(MIOPEN_DEBUG_CONV_IMPLICIT_GEMM_ASM_FWD_GTC_XDLOPS{}))
            return false;
#endif

    const auto target = ctx.GetStream().GetTargetProperties();
    if(target.Xnack() && *target.Xnack())
        return false;

    bool isValid;
    std::tie(isValid, std::ignore, std::ignore, std::ignore, std::ignore) =
        FindImplicitGemmGtcDynamicFwdKernel(problem);

    return isValid;
}

ConvSolution
ConvAsmImplicitGemmGTCDynamicFwdXdlops::GetSolution(const ExecutionContext& ctx,
                                                    const ProblemDescription& problem) const
{
    ConvSolution result;
    KernelInfo kernel;
    std::ostringstream options;

    std::string kernel_name;
    int block_size;
    int grid_size;
    TunableImplicitGemmGTCDynamic_t cfg;
    std::tie(std::ignore, cfg, kernel_name, block_size, grid_size) =
        FindImplicitGemmGtcDynamicFwdKernel(problem);

    std::ostringstream kernel_file_name;
    kernel_file_name << kernel_name << ".s";
    kernel.kernel_file = kernel_file_name.str();

    kernel.kernel_name = kernel_name;
    kernel.g_wk.clear();
    kernel.g_wk.push_back(static_cast<std::size_t>(grid_size) * block_size);
    kernel.g_wk.push_back(1);
    kernel.g_wk.push_back(1);
    kernel.l_wk.clear();
    kernel.l_wk.push_back(block_size);
    kernel.l_wk.push_back(1);
    kernel.l_wk.push_back(1);

    GenerateClangDefsym(options, "ROCM_METADATA_VERSION", ctx.rmv.UseV3() ? 5 : 4);

    kernel.comp_options = options.str();

    MIOPEN_LOG_I2(kernel.kernel_file + ":" + kernel.kernel_name);

    result.invoker_factory =
        conv::MakeImplGemmDynamicForwardInvokerFactory<TunableImplicitGemmGTCDynamic_t>(problem,
                                                                                        cfg);
    result.construction_params.push_back(kernel);
    return result;
}

} // namespace solver
} // namespace miopen
