/******************************************************************************
*******************************************************************************
**
**    Copyright 1997 Kenneth W. Preslan <kpreslan@lcse.umn.edu>
**              1998-1999 Grant M. Erickson <gerickson@brocade.com>
**
**    University of Minnesota
**    Department of Electrical and Computer Engineering
**
**    Brocade Communications Systems, Inc.
** 
**    Module name: fwdl.h
**    Date:        1998/09/30
**
**    Description:
**      This modules implements device generic data structures and function
**      prototypes for the firmware dowload tool.
**
*******************************************************************************
******************************************************************************/

/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *  
 *    This program is distributed in the hope that it will be useful,  
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __FWDL_H__
#define __FWDL_H__

#ifdef __cplusplus
extern "C" {
#endif

// Preprocessor Defines

#define SCSI_CMD_TIMEOUT	2000


// Type Defintions

typedef struct {
  unsigned char	errorCode;
  unsigned char	segment;
  unsigned char	senseKey;
  unsigned char	info[4];
  unsigned char	addLength;
  unsigned char	csinfo[4];
  unsigned char	asc;
  unsigned char	ascq;
  unsigned char	fruc;
  unsigned char	specific[3];
  unsigned char data[30];
} senseData_t;

typedef struct {
  unsigned char deviceType;
  unsigned char rmbDtm;
  unsigned char version;
  unsigned char rdf;
  unsigned char addLength;
  unsigned char reserved0;
  unsigned char reserved1;
  unsigned char optionBits;
  unsigned char vendorID[8];
  unsigned char productID[16];
  unsigned char prodRevLevel[4];
  unsigned char vendorSpecific[20];
} inquiryData_t;

typedef struct scsi_ops_s {
  int	(*scsiOpen)(const char *, int);
  int	(*scsiClose)(int);
  int	(*scsiTstUnitRdy)(int);
  int	(*scsiInquiry)(int, void *);
  int	(*scsiWriteFW)(int, void *, unsigned int);
} scsi_ops_t;


// External Global Variables

#ifdef DEBUG
extern int		 debug;
#endif
extern senseData_t	 global_sdata;


#ifdef __cplusplus
}
#endif

#endif /* __FWDL_H__ */
