/*
    Falling Block Game
    Copyright (C) 1999-2002 Jared Krinke <http://derajdezine.vze.com/>


    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    This application is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this distribution; if not, write to:
    Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA02111-1307  USA

    Jared Krinke

    Deraj DeZine
    http://derajdezine.vze.com/
*/

#include "fbg.h"
#include <mikmod.h>
#include <SDL/SDL.h>
#include <physfs.h>
#define FBGGAMESOUND_DELAY 10

// PhysicsFS-MREADER wrapper

typedef struct physfsMREADER {
	MREADER core;
	PHYSFS_file* file;
} physfsMREADER;

static long PhysfsMREADER_tell(MREADER* context) {
	return (long)(PHYSFS_tell(((physfsMREADER*)(context))->file));
}
static BOOL PhysfsMREADER_seek(MREADER* context, long offset, int whence) {
	PHYSFS_uint64 start;
	switch (whence) {
	case SEEK_CUR:
		start = (PHYSFS_uint64)(PHYSFS_tell(((physfsMREADER*)(context))->file));
	break;
	case SEEK_END:
		start = (PHYSFS_uint64)(PHYSFS_fileLength(((physfsMREADER*)(context))->file));
	break;
	default:
		start = 0;
	}
	return PHYSFS_seek(((physfsMREADER*)(context))->file, start+offset);
}
static BOOL PhysfsMREADER_read(MREADER* context, void *ptr, size_t size) {
	return PHYSFS_read(((physfsMREADER*)(context))->file, ptr, 1, size);
}
static int PhysfsMREADER_get(MREADER* context) {
	PHYSFS_sint8 byte;
	PhysfsMREADER_read(context, &byte, 1);
	return byte;
}
static BOOL PhysfsMREADER_eof(MREADER* context) {
	return PHYSFS_eof(((physfsMREADER*)(context))->file);
}
physfsMREADER* getPhysfsMREADER(const string& theFile) {
	physfsMREADER* reader = new physfsMREADER;
	reader->file = PHYSFS_openRead(theFile.c_str());
	reader->core.Seek = PhysfsMREADER_seek;
	reader->core.Tell = PhysfsMREADER_tell;
	reader->core.Read = PhysfsMREADER_read;
	reader->core.Get = PhysfsMREADER_get;
	reader->core.Eof = PhysfsMREADER_eof;

	return reader;
}
void freePhysfsMREADER(physfsMREADER* context) {
	delete context;
}

// Main Music functions
int fbgGame::musicThread(void* param) {
	while (((fbgGame*)(param))->getState() != QUIT) {
		SDL_Delay(FBGGAMESOUND_DELAY);
		if (Player_Active()) {
			// Locking shouldn't really be necessary for now
			MikMod_Update();
		}
	}
	return 0;
}
void fbgGame::initSound() {
	MikMod_RegisterAllDrivers();
	MikMod_RegisterAllLoaders();
	MikMod_Init("");
}
void fbgGame::initMusic(const string& musicFile) {
//	if (!MikMod_InitThreads()) return;	// Don't need threads, will use SDL when needed

	physfsMREADER* reader = getPhysfsMREADER(musicFile);
	music = Player_LoadGeneric(((MREADER*)(reader)), 16, 0);
	readerAddress = ((void*)(reader));

	Player_Start(music);
	musicID = SDL_CreateThread(fbgGame::musicThread, this);
}
void fbgGame::stopMusic() {
	if (musicID) SDL_WaitThread(musicID, NULL);

	if (music != NULL) {
		Player_Stop();
		Player_Free(music);
		freePhysfsMREADER(((physfsMREADER*)(readerAddress)));
	}
}
void fbgGame::stopSound() {
	MikMod_Exit();
}
