/*********************************************************************
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ===================================================================
 * Revision History ::
 * YYYY.MM.DD   Change ID       Developer
 *              Description
 * -------------------------------------------------------------------
 * 2002.04.25                   Vlad Skarzhevskyy
 *              Initial implementation.
 *
 * ===================================================================
 *
 ********************************************************************/

#include "pure-sfv.h"

#define BUFFERSIZE 16384   /* (16k) buffer size for reading from the file */

int getFileCRC(char *filename, pure_sfv_params* params, unsigned long *crc_val)
{

    int           file;
    unsigned long crc_value = 0xffffffff;
    unsigned char buffer[BUFFERSIZE];
    unsigned long total_len = 0;
    int           read_len;

    DBUG_PRINT("getFileCRC", ("%s", filename));

    /* open the file */
    file = open(filename, O_RDONLY | O_BINARY, 0);

    /* if the file could not be opened */
    if (file < 0)
    {
       fprintf(stderr, "sfv: Fatal error, cannot read file %s: %s\n", filename, strerror(errno));
       return ERROR_FILE_ACCESS;
    }

    while ((read_len = read(file, buffer, sizeof(buffer))) > 0) {
        crc_value = crc32(crc_value, buffer, read_len);
        total_len += read_len;
    }
    if (read_len == -1)
    {
        fprintf(stderr, "sfv: Fatal error, cannot calcualte sfv file %s: %s\n", filename, strerror(errno));
        close(file);
        return ERROR_FILE_ACCESS;
    }

    DBUG_PRINT("crc32.len", ("%ld", total_len));
    *crc_val = crc_value ^ 0xffffffff;
    close(file);
    return 0;
}

/* EOF */

