/*********************************************************************
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ===================================================================
 * Revision History ::
 * YYYY.MM.DD   Change ID       Developer
 *              Description
 * -------------------------------------------------------------------
 * 2002.04.25                   Vlad Skarzhevskyy
 *              Initial implementation.
 *
 * ===================================================================
 *
 ********************************************************************/

#include "pure-sfv.h"

char* getFilePath(char* filename)
{
    static string      tmp_name;
    char* end;
    strncpy(tmp_name, filename, MAX_STRING_LEN);
    /* Unix function dirname
       dir = dirname(tmp_name);
       Begin DIY
    */
    end = strrchr(tmp_name, DIR_SEP_PLATFORM);
    if (end == NULL) {
        return NULL;
    } else {
        *end = '\0';
    }
    /* End DIY */
    DBUG_PRINT("dirname", ("%s", tmp_name));
    if (strcmp(tmp_name, ".") == 0) {
        return NULL;
    }
    return tmp_name;
}

char* getBaseName(char* filename)
{
    char *ret;
    /* Unix function basename */
    for (ret = filename; *filename; filename++) {
        if (*filename == DIR_SEP_PLATFORM) {
            ret = filename + 1;
        }
    }
    DBUG_PRINT("basename", ("%s", ret));
    return ret;
}

char* getBaseNameWinUnix(char* filename)
{
    char* unix_end;
    char* win_end;
    unix_end = strrchr(filename, DIR_SEP_UNIX);
    if (unix_end == NULL) {
        unix_end = filename;
    } else {
        unix_end ++;
    }
    win_end = strrchr(unix_end, DIR_SEP_DOS);
    if (win_end == NULL) {
        win_end = unix_end;
    } else {
        win_end ++;
    }
    DBUG_PRINT("basename", ("%s", win_end));
    return win_end;
}

void makeCleanName(char* src, char* dst)
{
    int i, k, len;
    char c;

    len = strlen(src);
    k = 0;
    for (i = 0; i < len; i++)
    {
        c = src[i];
        if ((c == '_') || (c == ' ') || (c == '-')) {
            continue;
        }
        c = tolower(c);
        dst[k] = c;
        k++;
    }
    dst[k] = '\0';
}

void getFileExtension(char* filename, char* dst)
{
    int i, len;
    char* end;
    dst[0] = '\0';
    end = strrchr(filename, '.');
    if (end == NULL) {
        return;
    }
    end ++;
    len = strlen(end);
    if ((len == 0) || (len > MAX_FILE_EXTENSION)) {
        return;
    }
    for(i = 0; i < len; i++) {
        dst[i] = tolower(end[i]);
    }
    dst[i] = '\0';
    return;
}

int hasWildcard(const char * name)
{
    if (strchr(name, '*') != NULL) {
        return 1;
    }
    if (strchr(name, '?') != NULL) {
        return 1;
    }
    return 0;
}

/* http://sourceforge.net/snippet/detail.php?type=snippet&id=100891 */
/* eg. match("a*b","AXYZB", 1) .. true */
/* eg. match("a?","a:", 1) .. true */

/*  Problem in mathc "*.txt" "w.txt any.txt" */

int match( const char * p, const char * s, int ignore_case)
{
    switch( *p ){
    case '\0' : return ! *s ;
    case '*'  : return (match(p+1, s, ignore_case)) || (( *s ) && match(p, s+1 , ignore_case));
    case '?'  : return *s && match(p+1, s+1, ignore_case);
    default   :
         return ( (*p == *s) ||
                  (ignore_case && (toupper(*p) == toupper(*s)))
                ) &&  match(p+1, s+1, ignore_case);
         /* *p == *s && match( p+1, s+1 ); */
    }
}

#ifdef _MSC_VER
/* Read directory list under MS Visual C++ */

DIR *opendir(const char *dirname) {
    DIR *d = malloc(sizeof(DIR)); 
    d->dirp = 0;
    strncpy(d->name, dirname, PATH_MAX);
    return d;
}

int closedir(DIR *dirp) {
    free(dirp);
    return 0;
}

struct dirent *readdir(DIR *d) {
    static struct dirent  udirinfo;
    static string  tmp_name;
    struct _finddata_t dirinfo;
    int rc;

    if (d->dirp <= 0) {
        /* Find first file in current directory */
        if (d->name[0] == 0) {
            strncpy(tmp_name, ".%c*.*", DIR_SEP_PLATFORM);
        } else {
            sprintf(tmp_name, "%s%c*.*", d->name, DIR_SEP_PLATFORM);
        }
        d->dirp = _findfirst(tmp_name, &dirinfo);
        if (d->dirp == -1) {
            return NULL;
        }
    } else {
        rc = _findnext(d->dirp,  &dirinfo);
        if (errno == ENOENT) {
            errno = 0;
        }
        if (rc == -1) {
            return NULL;
        }
    }

    strncpy(udirinfo.d_name, dirinfo.name, PATH_MAX);

    return &udirinfo;

}

#endif


/* #ifdef __unix */

/* Read directory list under unix */

int dirRead(char* dir_name, crc_info_type* dir_info)
{
    DIR *dirp;
    struct dirent *dirinfo;
    crc_info_item_type item;
    char* use_dir_name;

    if ((dir_name == NULL) || (dir_name[0] == '\0')) {
        use_dir_name = ".";
    } else {
        use_dir_name = dir_name;
    }

    strncpy(dir_info->name, use_dir_name, MAX_STRING_LEN);

    dirp = opendir(use_dir_name);
    if (dirp == NULL) {
        fprintf(stderr, "sfv: %s: %s\n", use_dir_name, strerror(errno));
        return ERROR_DIR_ACCESS;
    }

    errno = 0;

    while ((dirinfo = readdir(dirp)) != NULL) {
         if ((strcmp(dirinfo->d_name, ".") == 0) ||
             (strcmp(dirinfo->d_name, "..") == 0)) {
             continue;
         }
         sfvInfoItemNULL(&item);
         strncpy(item.file_name, dirinfo->d_name, MAX_STRING_LEN);
         item.crc = 0;
         if (sfvInfoAdd(dir_info, &item)) {
             return ERROR_MEMORY;
         }

    }
    if (errno) {
        fprintf(stderr, "sfv: %s: %s\n", use_dir_name, strerror(errno));
        return ERROR_DIR_ACCESS;
    }
    closedir(dirp);

    return 0;
}

/* #endif */

/* #ifdef _MSC_VER */

/* Read directory list under MS Visual C++ */

/*
int dirRead(char* dir_name, crc_info_type* dir_info)
{
    long               dirp;
    int                rc;
    struct _finddata_t dirinfo;
    crc_info_item_type item;
    char               *use_dir_name;
    static string      tmp_name;

    if ((dir_name == NULL) || (dir_name[0] == '\0')) {
        use_dir_name = ".";
    } else {
        use_dir_name = dir_name;
    }

    strncpy(dir_info->name, use_dir_name, MAX_STRING_LEN);
    sprintf(tmp_name, "%s%c*.*", use_dir_name, DIR_SEP_PLATFORM);

    dirp = _findfirst(tmp_name, &dirinfo);
    if (dirp == -1) {
        fprintf(stderr, "sfv: %s: %s\n", use_dir_name, strerror(errno));
        return ERROR_DIR_ACCESS;
    }

    do {
         if ((strcmp(dirinfo.name, ".") == 0) ||
             (strcmp(dirinfo.name, "..") == 0)) {
             ;
         } else {
            sfvInfoItemNULL(&item);
            strncpy(item.file_name, dirinfo.name, MAX_STRING_LEN);
            item.crc = 0;
            if (sfvInfoAdd(dir_info, &item)) {
                return ERROR_MEMORY;
            }
         }

    } while ((rc = _findnext(dirp,  &dirinfo)) == 0);

    if ((rc == -1) && (errno != ENOENT)) {
        fprintf(stderr, "sfv: %s: %s\n", use_dir_name, strerror(errno));
        return ERROR_DIR_ACCESS;
    }

    _findclose(dirp);

    return 0;
}
#endif

*/

#ifdef _MSC_VER 

int chdir(const char *path)
{
    /* TODO */
    return _chdir(path);
}

char *getcwd(char *buf, int size)
{
    return _getcwd(buf, size);
}

#endif


int isFile(char* dir_name, char* file_name)
{
    return 1;
}

int fileReadAttributes(crc_info_item_type* file_info)
{
    int rc = 0;
    struct stat fileinfo;
    rc = stat(file_info->file_name, &fileinfo);
    if (rc) {
        fprintf(stderr, "sfv: Error reading file attributs [%s]: %s\n", file_info->file_name, strerror(errno));
        return rc;
    }
    file_info->size = fileinfo.st_size;
    file_info->time = *localtime(&fileinfo.st_mtime);
    file_info->is_dir = S_ISDIR(fileinfo.st_mode);
    DBUG_PRINT("file", ("%20s, %ld, %i", file_info->file_name, file_info->size, file_info->is_dir));
    return rc;
}

int dirReadAttributes(char* dir_name, crc_info_type* dir_info)
{
    int rc = 0;
    int i;

    for(i = 0; i < dir_info->len; i++)
    {
        rc = fileReadAttributes(&(dir_info->items[i]));
        if (rc) return rc;
    }
    return rc;
}

int dirFindFile(char* file_name, crc_info_type* dir_info)
{
    int i;
    for(i = 0; i < dir_info->len; i++)
    {
        if (strcmp(file_name, dir_info->items[i].file_name) == 0) {
            return (i + 1);
        }
    }
    return 0;
}

int dirFindFileLike(char* file_name_clean, crc_info_type* dir_info)
{
    int i;
    for(i = 0; i < dir_info->len; i++)
    {
        if (strcmp(file_name_clean, dir_info->items[i].file_name_clean) == 0) {
            return (i + 1);
        }
    }
    return 0;
}

/* EOF */

