/*********************************************************************
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ===================================================================
 * Revision History ::
 * YYYY.MM.DD   Change ID       Developer
 *              Description
 * -------------------------------------------------------------------
 * 2002.04.25                   Vlad Skarzhevskyy
 *              Initial implementation.
 *
 * ===================================================================
 *
 ********************************************************************/

#ifndef pure_sfv_h_defined
#define pure_sfv_h_defined

#ifndef VERSION
  #define VERSION "0.3"
#endif

#define PURE_SFV_VERSION VERSION

/* All includes are in one place for Windows port */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <fcntl.h>
#include <ctype.h>
#include <locale.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "platform.h"

typedef enum
{
    EXIT_NO_PROBLEMS    = 0,
    ERROR_FILE_ACCESS   = 1,
    ERROR_DIR_ACCESS    = 2,
    ERROR_FILE_FORMAT   = 3,
    ERROR_MEMORY        = 4,
	ERROR_CREATING_PAR  = 5,

    /* File from command line has not been found */
    EXIT_FILE_NOT_FOUND           = 8,

    /* Exit codes for test mode */

    /* SFV file has not been found to verify at least one of specified files */
    EXIT_SFV_NOT_FOUND            = 9,

    /* Tere are at least one file with different CRC and at least one missing file*/
    EXIT_TESTED_DIFFERENT_MISSING = 10,

    /* Tere are at least one file with different CRC no  missing files*/
    EXIT_TESTED_DIFFERENT         = 11,

    /* Tested file have the same SRC as expected but in there are at least one missing file */
    EXIT_TESTED_OK_MISSING        = 12,

    /* Files tested ok and its CRC has been found in database */
    EXIT_TESTED_OK_DUPLICATE      = 20,
    /* File has not been tested no SFV found, But it's CRC has been found in database */
    EXIT_DUPLICATE                = 21

}  return_error_codes;


typedef enum
{
    MODE_DEFAULT     = 0,
	MODE_TEST        = 1,
    MODE_CREATE      = 2,
	MODE_TEST_CREATE = 3,
    MODE_COUNT       = 4,
    MODE_FTPD        = 5
}  mode_type;

#define MAX_STRING_LEN 256

typedef char string[MAX_STRING_LEN];

#define MAX_STRING_ARRAY_LEN 50
#define MAX_FILE_EXTENSION 5

typedef enum
{
    PARAM_NAME         = 1,
    PARAM_MASK_INCLUDE = 2,
    PARAM_MASK_EXCLUDE = 3,
    PARAM_NAME_FOUND   = 16
} param_attribute;

#define PARAM_NAME_MASK 7

extern int attr_base(int attr);
extern void attr_set(int *pattr, int attr_flag);
extern int attr_is_set(int attr, int attr_flag);

typedef struct
{
    string          strs[MAX_STRING_ARRAY_LEN]; /* Just take the memory not much */
    int             attr[MAX_STRING_ARRAY_LEN];
	int             names_cnt;
    int             len;
} string_array;

extern void init_string_array(string_array *ar);
extern void add_string_array(string_array *ar, char* str, param_attribute attr);
extern void debug_string_array(char* name, string_array *ar);

typedef struct
{
    int                 sfv_tested,
		                sfv_created,
						directories_scaned,
						files_tested,
						files_ignored,
		                files_ok,
                        files_not_found,
						files_found,
                        files_broken,
						files_error,
						files_added;
} pure_sfv_counters;

typedef struct
{
    mode_type mode;

    int           cd_sfv_file_location;
    string        sfv_dir;

    string_array  sfv_files;
    string_array  files;

    int           quiet;
    int           create_recurse_subdirectories;
	int           create_m3u;
	int           force_create;
	char          name_place_holder;
    int           win_sfv;
	int           windows_pause;
    int           recurse_subdirectories;
    int           ignore_case;
    int           ignore_dir_name;
    int           ignore_nofiles_sfv;
	char          list_files;
    int           tested_db_use;
    string        tested_db_filename;

	int           par_create;
	int           par_recovery_ratio;

	pure_sfv_counters  cnt;
} pure_sfv_params;

typedef struct
{
    unsigned long   crc;
	unsigned long   new_crc;
    long            size;
    struct tm       time;
    int             is_dir;
    string          file_name;
    char            ext[MAX_FILE_EXTENSION + 1];
    /* File name lower case. spaces _  - removed. */
    string          file_name_clean;
	/* Test result */
	int             ignored;
    int             found;
    int             tested;
} crc_info_item_type;


typedef struct
{
    crc_info_item_type* items;
    int                 len;
    int                 allocated_len;

    /* Directory or SFV file name */
    string              name;
    pure_sfv_counters   cnt;
} crc_info_type;

#define  SFV_INFO_MEMORY_CHUNKS  300
#define  SFV_INFO_SORT            1

#define sfv_extension "sfv"
#define par_extension "par"
#define mp3_extension "mp3"

extern pure_sfv_params*  g_prams;

extern int   initParams(pure_sfv_params* params);
extern int   debugParams(pure_sfv_params* params);
extern int   initCnt(pure_sfv_counters* cnt);
extern int   addCnt(pure_sfv_counters* cnt, pure_sfv_counters* to_add);
extern void  ifNeedDirectory(pure_sfv_params* params, char* filename);
extern char* stripExtraPath(pure_sfv_params* params, char* filename);
extern char* getFilePath(char* filename);
extern char* getBaseName(char* filename);
extern char* getBaseNameWinUnix(char* filename);
extern void  makeCleanName(char* src, char* dst);
extern void  getFileExtension(char* filename, char* dst);
extern int   isSfvFile(char* extension);
extern int   isFile(char* dir_name, char* file_name);

/* http://sourceforge.net/snippet/detail.php?type=snippet&id=100891 */
extern int match(const char * wildcard, const char * name, int ignore_case);
extern int hasWildcard(const char * name);
/* Exclude or include files in command line Wildcard */
extern int includeFile(char* filename, pure_sfv_params* params);
extern int includeFileSFV(char* filename, pure_sfv_params* params);

extern int  sfvProcess(pure_sfv_params* params);
extern unsigned long crc32(unsigned long crc, unsigned char *buf, int len);

extern int getFileCRC(char *filename, pure_sfv_params* params, unsigned long *crc_val);

extern int sfvInfoInit(crc_info_type* sfv_info);
extern int sfvInfoFree(crc_info_type* sfv_info);
extern int sfvInfoAdd(crc_info_type* sfv_info, crc_info_item_type* item);
extern int sfvInfoItemNULL(crc_info_item_type* item);

extern int dirRead(char* dir_name, crc_info_type* dir_info);
extern int dirReadAttributes(char* dir_name, crc_info_type* dir_info);
extern int fileReadAttributes(crc_info_item_type* file_info);
extern int dirFindFile(char* file_name, crc_info_type* dir_info);
extern int dirFindFileLike(char* file_name, crc_info_type* dir_info);

extern int sfvReadFile(pure_sfv_params* params, char* sfvname, crc_info_type* sfv_info);

extern int sfvCreate(pure_sfv_params* params, char* sfv_dir, crc_info_type* sfv_info);
extern int sfvCreateFile(pure_sfv_params* params, char* sfv_file_name, char* sfv_dir);
extern int sfvCreateRecursive(pure_sfv_params* params, char* sfv_dir);

extern int pparCreate(pure_sfv_params* params, crc_info_type* sfv_info);
extern int pparCreateN(pure_sfv_params* params, crc_info_type* sfv_info, char* par_name, int from, int to);
extern int par_main(int argc, char *argv[]);

extern int sfvTestFile(pure_sfv_params* params, char* sfv_file, char* sfv_dir);
extern int sfvTestInDir(pure_sfv_params* params, char* sfv_dir);
extern int sfvTestInDirRecursive(pure_sfv_params* params, char* sfv_dir);

extern int _debug_on_;

#define DBUG_ENABLED _debug_on_

#ifndef DBUG_ENABLED
#define DBUG_PRINT(keyword, arglist)
#else
#define DBUG_PRINT(keyword, arglist) \
        { if (DBUG_ENABLED) { printf("%17s(%03i)%15s:", __FILE__, __LINE__, keyword); printf arglist; printf("\n"); fflush(stdout); } }
#endif


#endif
/* EOF */
