/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.ui;

import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.intellij.images.ui.ImageComponent;
import org.intellij.images.ui.ThumbnailComponentUI;
import org.jetbrains.annotations.NonNls;

public class ThumbnailComponent
extends JComponent {
    @NonNls
    private static final String FORMAT_PROP = "format";
    @NonNls
    private static final String FILE_SIZE_PROP = "fileSize";
    @NonNls
    private static final String FILE_NAME_PROP = "fileName";
    @NonNls
    private static final String DIRECTORY_PROP = "directory";
    @NonNls
    private static final String IMAGES_COUNT_PROP = "imagesCount";
    @NonNls
    private static final String uiClassID = "ThumbnailComponentUI";
    private final ImageComponent imageComponent = new ImageComponent();
    private String format;
    private long fileSize;
    private String fileName;
    private boolean directory;
    private int imagesCount;

    public ThumbnailComponent() {
        this.updateUI();
    }

    public ImageComponent getImageComponent() {
        return this.imageComponent;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format2) {
        String oldValue = this.format;
        if (oldValue != null && !oldValue.equals(format2) || oldValue == null && format2 != null) {
            this.format = format2;
            this.firePropertyChange(FORMAT_PROP, oldValue, this.format);
        }
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        long oldValue = this.fileSize;
        if (oldValue != fileSize) {
            this.fileSize = fileSize;
            this.firePropertyChange(FILE_SIZE_PROP, (Object)oldValue, (Object)this.fileSize);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        String oldValue = this.fileName;
        if (oldValue != null && !oldValue.equals(fileName) || oldValue == null && fileName != null) {
            this.fileName = fileName;
            this.firePropertyChange(FILE_NAME_PROP, oldValue, this.fileName);
        }
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        boolean oldValue = this.directory;
        if (oldValue != directory) {
            this.directory = directory;
            this.firePropertyChange(DIRECTORY_PROP, oldValue, this.directory);
        }
    }

    public int getImagesCount() {
        return this.imagesCount;
    }

    public void setImagesCount(int imagesCount) {
        int oldValue = this.imagesCount;
        if (oldValue != imagesCount) {
            this.imagesCount = imagesCount;
            this.firePropertyChange(IMAGES_COUNT_PROP, oldValue, this.imagesCount);
        }
    }

    public String getFileSizeText() {
        return StringUtil.formatFileSize((long)this.fileSize);
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    static {
        UIManager.getDefaults().put(uiClassID, ThumbnailComponentUI.class.getName());
    }
}

