/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class UseEllipsisInPropertyInspection
extends PropertiesInspectionBase {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Charset charset;
        if (holder == null) {
            UseEllipsisInPropertyInspection.$$$reportNull$$$0(0);
        }
        if ((charset = EncodingProjectManager.getInstance((Project)holder.getProject()).getDefaultCharsetForPropertiesFiles(null)) != StandardCharsets.UTF_8) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                UseEllipsisInPropertyInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof PropertyValueImpl)) {
                    return;
                }
                boolean found = UseEllipsisInPropertyInspection.getThreeDots(((PropertyValueImpl)element).getChars());
                if (found) {
                    int length = element.getTextLength();
                    holder.registerProblem(element, TextRange.create((int)(length - 3), (int)length), PropertiesBundle.message((String)"inspection.use.ellipsis.in.property.description", (Object[])new Object[0]), new LocalQuickFix[]{ReplaceThreeDotsWithEllipsisFix.getInstance()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/codeInspection/UseEllipsisInPropertyInspection$1", "visitElement"));
            }
        };
    }

    private static boolean getThreeDots(@NotNull CharSequence element) {
        int textLength;
        if (element == null) {
            UseEllipsisInPropertyInspection.$$$reportNull$$$0(2);
        }
        if ((textLength = element.length()) <= 4) {
            return false;
        }
        if (element.charAt(textLength - 3) != '.') {
            return false;
        }
        if (element.charAt(textLength - 2) != '.') {
            return false;
        }
        if (element.charAt(textLength - 1) != '.') {
            return false;
        }
        return element.charAt(textLength - 4) != '.';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/codeInspection/UseEllipsisInPropertyInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/codeInspection/UseEllipsisInPropertyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThreeDots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class ReplaceThreeDotsWithEllipsisFix
    implements LocalQuickFix {
        private static volatile ReplaceThreeDotsWithEllipsisFix instance;

        private ReplaceThreeDotsWithEllipsisFix() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ReplaceThreeDotsWithEllipsisFix getInstance() {
            if (instance != null) return instance;
            Class<ReplaceThreeDotsWithEllipsisFix> clazz = ReplaceThreeDotsWithEllipsisFix.class;
            synchronized (ReplaceThreeDotsWithEllipsisFix.class) {
                if (instance != null) return instance;
                instance = new ReplaceThreeDotsWithEllipsisFix();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message((String)"use.ellipsis.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceThreeDotsWithEllipsisFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                ReplaceThreeDotsWithEllipsisFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceThreeDotsWithEllipsisFix.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor.getPsiElement()) instanceof PropertyValueImpl)) {
                return;
            }
            boolean found = UseEllipsisInPropertyInspection.getThreeDots(((PropertyValueImpl)element).getChars());
            if (found) {
                int length = element.getTextLength();
                StringBuilder newText = new StringBuilder(((PropertyValueImpl)element).getChars());
                newText.replace(length - 3, length, "\u2026");
                ((PropertyValueImpl)element).replaceWithText(newText.toString());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/codeInspection/UseEllipsisInPropertyInspection$ReplaceThreeDotsWithEllipsisFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/codeInspection/UseEllipsisInPropertyInspection$ReplaceThreeDotsWithEllipsisFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

