/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.go;

import com.goide.inspections.core.GoInspectionBase;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoVisitor;
import com.goide.quickfix.GoNavigateToQuickFix;
import com.goide.util.GoUtil;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.go.GoBuildFileProvider;
import com.intellij.packageChecker.go.UtilsKt;
import com.intellij.packageChecker.inspection.problemDescriptor.LocalProblemDescriptor;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.RemoteConfigService;
import com.intellij.packageChecker.model.Vulnerability;
import com.intellij.packageChecker.model.VulnerablePackage;
import com.intellij.packageChecker.service.PackageChecker;
import com.intellij.packageChecker.service.PackageStatus;
import com.intellij.packageChecker.service.Vulnerable;
import com.intellij.packageChecker.toolwindow.preview.PackageHtmlRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/packageChecker/go/GoVulnerablePackageImportInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.packageChecker.go"})
@SourceDebugExtension(value={"SMAP\nGoVulnerablePackageImportInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoVulnerablePackageImportInspection.kt\ncom/intellij/packageChecker/go/GoVulnerablePackageImportInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,111:1\n1#2:112\n19#3:113\n*S KotlinDebug\n*F\n+ 1 GoVulnerablePackageImportInspection.kt\ncom/intellij/packageChecker/go/GoVulnerablePackageImportInspection\n*L\n35#1:113\n*E\n"})
public final class GoVulnerablePackageImportInspection
extends LocalInspectionTool {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        GoFile file;
        void $this$asSafely$iv;
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile it = psiFile = holder.getFile();
        boolean bl = false;
        psiFile = UtilsKt.ifClassesLoaded((Function0<Boolean>)((Function0)() -> GoVulnerablePackageImportInspection.buildVisitor$lambda$1$lambda$0(it))) ? psiFile : null;
        boolean $i$f$asSafely = false;
        Object v0 = $this$asSafely$iv;
        if (!(v0 instanceof GoFile)) {
            v0 = null;
        }
        if ((file = (GoFile)v0) == null || !GoInspectionBase.shouldProcessFile((GoFile)file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new GoVisitor(file, holder){
            private final Module module;
            final /* synthetic */ GoFile $file;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$file = $file;
                this.$holder = $holder;
                this.module = GoUtil.module((PsiElement)((PsiElement)$file));
            }

            /*
             * WARNING - void declaration
             */
            public void visitImportSpec(GoImportSpec importSpec) {
                LocalQuickFix[] localQuickFixArray;
                Intrinsics.checkNotNullParameter((Object)importSpec, (String)"importSpec");
                super.visitImportSpec(importSpec);
                if (this.module == null) {
                    return;
                }
                String string = importSpec.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                PackageStatus packageStatus = this.inspect(string);
                if (!(packageStatus instanceof Vulnerable)) {
                    return;
                }
                VulnerablePackage vulnerablePackage = ((Vulnerable)packageStatus).getVulnerablePackage();
                ProblemsHolder problemsHolder = this.$holder;
                PsiElement psiElement = (PsiElement)importSpec;
                String string2 = this.getDescription(vulnerablePackage);
                String string3 = this.getInspectionTooltip(vulnerablePackage);
                boolean bl = false;
                TextRange textRange = null;
                String string4 = importSpec.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                LocalQuickFix localQuickFix = this.getNavigateToQuickFix(string4);
                if (localQuickFix != null) {
                    void it;
                    LocalQuickFix localQuickFix2 = localQuickFix;
                    TextRange textRange2 = textRange;
                    boolean bl2 = bl;
                    String string5 = string3;
                    String string6 = string2;
                    PsiElement psiElement2 = psiElement;
                    ProblemsHolder problemsHolder2 = problemsHolder;
                    boolean bl3 = false;
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[]{it};
                    LocalQuickFix[] localQuickFixArray3 = localQuickFixArray2;
                    problemsHolder = problemsHolder2;
                    psiElement = psiElement2;
                    string2 = string6;
                    string3 = string5;
                    bl = bl2;
                    textRange = textRange2;
                    localQuickFixArray = localQuickFixArray3;
                } else {
                    localQuickFixArray = new LocalQuickFix[]{};
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 24;
                ProblemHighlightType problemHighlightType = ProblemHighlightType.WEAK_WARNING;
                LocalQuickFix[] localQuickFixArray4 = localQuickFixArray;
                TextRange textRange3 = textRange;
                boolean bl4 = bl;
                String string7 = string3;
                String string8 = string2;
                PsiElement psiElement3 = psiElement;
                problemsHolder.registerProblem((ProblemDescriptor)new LocalProblemDescriptor(psiElement3, string8, string7, bl4, textRange3, localQuickFixArray4, problemHighlightType, n, defaultConstructorMarker));
            }

            private final PackageStatus inspect(String importPath) {
                Object v0;
                block2: {
                    Iterable iterable = this.getBuildFileProvider().importedPackages((PsiFile)this.$file);
                    for (T t : iterable) {
                        Package it = (Package)t;
                        boolean bl = false;
                        if (!this.includesGoPackage(it, importPath)) continue;
                        v0 = t;
                        break block2;
                    }
                    v0 = null;
                }
                Package package_ = v0;
                if (package_ == null) {
                    return null;
                }
                Package importedPackage = package_;
                return this.getPackageChecker().packageStatus(importedPackage);
            }

            @NlsContexts.Tooltip
            private final String getInspectionTooltip(VulnerablePackage vulnerablePackage) {
                return PackageHtmlRenderer.INSTANCE.getLocalInspectionPopup(vulnerablePackage, null, "GoVulnerablePackageImport", null);
            }

            @InspectionMessage
            private final String getDescription(VulnerablePackage vulnerablePackage) {
                String vulnerabilityList = PackageHtmlRenderer.INSTANCE.getVulnerabilityList((Collection<Vulnerability>)vulnerablePackage.getVulnerabilities());
                String copyright = RemoteConfigService.Companion.getInstance().getCopyrightOrEmpty();
                Object[] objectArray = new Object[]{vulnerabilityList, copyright};
                String string = PackageCheckerBundle.message("inspection.message.vulnerable.dependency.usage", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            private final LocalQuickFix getNavigateToQuickFix(String importPath) {
                GoNavigateToQuickFix goNavigateToQuickFix;
                PsiElement psiElement;
                Object v0;
                block3: {
                    Iterable iterable = this.getCurrentModuleDependencies();
                    for (T t : iterable) {
                        VgoModuleSpec it = (VgoModuleSpec)t;
                        boolean bl = false;
                        if (!this.includesGoPackage(it, importPath)) continue;
                        v0 = t;
                        break block3;
                    }
                    v0 = null;
                }
                VgoModuleSpec vgoModuleSpec = v0;
                if (vgoModuleSpec != null && (psiElement = vgoModuleSpec.getModuleVersion()) != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    goNavigateToQuickFix = new GoNavigateToQuickFix(it, PackageCheckerBundle.message("inspection.navigate.to.dependency.declaration", new Object[0]));
                } else {
                    goNavigateToQuickFix = null;
                }
                return (LocalQuickFix)goNavigateToQuickFix;
            }

            private final List<VgoModuleSpec> getCurrentModuleDependencies() {
                VirtualFile virtualFile;
                block6: {
                    block5: {
                        if (this.module == null) {
                            return CollectionsKt.emptyList();
                        }
                        VgoModule vgoModule = this.getVgoModulesRegistry().findVgoModule(this.module, this.$file.getVirtualFile());
                        if (vgoModule == null) {
                            return CollectionsKt.emptyList();
                        }
                        VgoModule vgoModule2 = vgoModule;
                        VirtualFile goModFile = vgoModule2.getRoot().findChild("go.mod");
                        virtualFile = goModFile;
                        if (virtualFile == null) break block5;
                        VirtualFile virtualFile2 = virtualFile;
                        GoFile goFile = this.$file;
                        VirtualFile it = virtualFile2;
                        boolean bl = false;
                        PsiFile psiFile = goFile.getManager().findFile(it);
                        VgoFile vgoFile = psiFile instanceof VgoFile ? (VgoFile)psiFile : null;
                        virtualFile = vgoFile;
                        if (vgoFile != null) break block6;
                    }
                    return CollectionsKt.emptyList();
                }
                VirtualFile goModPsiFile = virtualFile;
                return UtilsKt.getDependencies((PsiFile)goModPsiFile);
            }

            private final GoBuildFileProvider getBuildFileProvider() {
                Project project = this.$file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return new GoBuildFileProvider(project);
            }

            private final PackageChecker getPackageChecker() {
                Project project = this.$file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return PackageChecker.Companion.getInstance(project);
            }

            private final VgoModulesRegistry getVgoModulesRegistry() {
                return VgoModulesRegistry.getInstance((Project)this.$file.getProject());
            }

            private final boolean includesGoPackage(VgoModuleSpec $this$includesGoPackage, String goPackagePath) {
                String string = $this$includesGoPackage.getIdentifier().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return this.includesPath(string, goPackagePath);
            }

            private final boolean includesGoPackage(Package $this$includesGoPackage, String path) {
                return this.includesPath($this$includesGoPackage.getName(), path);
            }

            private final boolean includesPath(String $this$includesPath, String path) {
                return Intrinsics.areEqual((Object)$this$includesPath, (Object)path) || this.isSubPathOf(path, $this$includesPath);
            }

            private final boolean isSubPathOf(String $this$isSubPathOf, String path) {
                return $this$isSubPathOf.length() > path.length() && StringsKt.startsWith$default((String)$this$isSubPathOf, (String)path, (boolean)false, (int)2, null) && $this$isSubPathOf.charAt(path.length()) == '/';
            }
        };
    }

    private static final boolean buildVisitor$lambda$1$lambda$0(PsiFile $it) {
        return $it instanceof GoFile;
    }
}

