/*
 * Decompiled with CFR 0.152.
 */
package git4idea.applyChanges;

import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.GitApplyChangesNotification;
import git4idea.GitDisposable;
import git4idea.applyChanges.GitApplyChangesCanRestoreNotification;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryStateChangeListener;
import git4idea.stash.GitChangesSaver;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ%\u0010\u000b\u001a\u00020\n2\u000b\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\bJ\u001d\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\b2\u000b\u0010\u0012\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/applyChanges/GitApplyChangesNotificationsHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "changesSaver", "Ljava/util/concurrent/atomic/AtomicReference;", "Lgit4idea/stash/GitChangesSaver;", "beforeApply", "", "operationFailed", "operationName", "", "Lorg/jetbrains/annotations/Nls;", "repository", "Lgit4idea/repo/GitRepository;", "showRestoreChangesNotification", "operation", "isCherryPickingOrReverting", "", "state", "Lcom/intellij/dvcs/repo/Repository$State;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitApplyChangesNotificationsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitApplyChangesNotificationsHandler.kt\ngit4idea/applyChanges/GitApplyChangesNotificationsHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,82:1\n24#2:83\n*S KotlinDebug\n*F\n+ 1 GitApplyChangesNotificationsHandler.kt\ngit4idea/applyChanges/GitApplyChangesNotificationsHandler\n*L\n77#1:83\n*E\n"})
public final class GitApplyChangesNotificationsHandler {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private AtomicReference<GitChangesSaver> changesSaver;
    @NotNull
    private static final Logger LOG;

    public GitApplyChangesNotificationsHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.changesSaver = new AtomicReference();
        MessageBusConnection messageBusConnection2 = this.project.getMessageBus().connect((Disposable)GitDisposable.Companion.getInstance(this.project));
        Topic<GitRepositoryStateChangeListener> topic = GitRepository.GIT_REPO_STATE_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GIT_REPO_STATE_CHANGE");
        messageBusConnection2.subscribe(topic, (Object)new GitRepositoryStateChangeListener(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void repositoryChanged(GitRepository repository2, GitRepoInfo previousInfo, GitRepoInfo info) {
                block6: {
                    void $this$forEach$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
                    Intrinsics.checkNotNullParameter((Object)previousInfo, (String)"previousInfo");
                    Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                    if (!this.wasCherryPickingOrReverting(previousInfo, info)) break block6;
                    LOG.debug("Hiding notifications");
                    GitApplyChangesNotification.Companion companion = GitApplyChangesNotification.Companion;
                    Project project$iv = project;
                    boolean $i$f$expireAll = false;
                    Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(GitApplyChangesNotification.class, project$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
                    Object[] objectArray = notificationArray;
                    boolean $i$f$forEach = false;
                    for (void element$iv$iv : $this$forEach$iv$iv) {
                        GitApplyChangesNotification it$iv = (GitApplyChangesNotification)element$iv$iv;
                        boolean bl = false;
                        if (!(it$iv instanceof GitApplyChangesNotification.ExpireAfterRepoStateChanged)) continue;
                        ((Notification)it$iv).expire();
                    }
                    GitChangesSaver gitChangesSaver = changesSaver.getAndSet(null);
                    if (gitChangesSaver != null) {
                        GitChangesSaver gitChangesSaver2 = gitChangesSaver;
                        GitApplyChangesNotificationsHandler gitApplyChangesNotificationsHandler = this;
                        GitChangesSaver changesSaver = gitChangesSaver2;
                        boolean bl = false;
                        String string = switch (WhenMappings.$EnumSwitchMapping$0[previousInfo.getState().ordinal()]) {
                            case 1 -> GitBundle.message((String)"cherry.pick.name", (Object[])new Object[0]);
                            case 2 -> GitBundle.message((String)"revert.operation.name", (Object[])new Object[0]);
                            default -> throw new IllegalStateException(("Unexpected state: " + previousInfo.getState()).toString());
                        };
                        Intrinsics.checkNotNull((Object)string);
                        String operation = string;
                        LOG.debug("Suggesting to restore saved changes after " + operation);
                        gitApplyChangesNotificationsHandler.showRestoreChangesNotification(changesSaver, operation);
                    }
                }
            }

            private final boolean wasCherryPickingOrReverting(GitRepoInfo previousInfo, GitRepoInfo info) {
                return this.isCherryPickingOrReverting(previousInfo.getState()) && !this.isCherryPickingOrReverting(info.getState());
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[Repository.State.values().length];
                    try {
                        nArray[Repository.State.GRAFTING.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Repository.State.REVERTING.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
    }

    public final void beforeApply() {
        this.changesSaver.set(null);
    }

    public final void operationFailed(@NotNull String operationName, @NotNull GitRepository repository2, @Nullable GitChangesSaver changesSaver) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        if (changesSaver != null) {
            if (this.isCherryPickingOrReverting(repository2.getInfo().getState())) {
                this.changesSaver.set(changesSaver);
            } else {
                this.showRestoreChangesNotification(changesSaver, operationName);
            }
        }
    }

    private final void showRestoreChangesNotification(GitChangesSaver changesSaver, String operation) {
        VcsNotifier.getInstance((Project)this.project).notify((Notification)new GitApplyChangesCanRestoreNotification(this.project, changesSaver, operation));
    }

    private final boolean isCherryPickingOrReverting(Repository.State state2) {
        return state2 == Repository.State.GRAFTING || state2 == Repository.State.REVERTING;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/applyChanges/GitApplyChangesNotificationsHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lgit4idea/applyChanges/GitApplyChangesNotificationsHandler;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitApplyChangesNotificationsHandler getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(GitApplyChangesNotificationsHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (GitApplyChangesNotificationsHandler)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

