/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.pathValidation;

import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.pathValidation.ValidationRequest;
import com.jetbrains.python.sdk.WinAppxToolsKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a&\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"validateExecutableFile", "Lcom/intellij/openapi/ui/ValidationInfo;", "request", "Lcom/jetbrains/python/pathValidation/ValidationRequest;", "validateEmptyDir", "notADirectory", "", "directoryNotEmpty", "intellij.python.sdk"})
public final class PathValidatorKt {
    @RequiresBackgroundThread
    @Nullable
    public static final ValidationInfo validateExecutableFile(@NotNull ValidationRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return request.validate$intellij_python_sdk((Function1<? super Path, String>)((Function1)PathValidatorKt::validateExecutableFile$lambda$0));
    }

    @RequiresBackgroundThread
    @Nullable
    public static final ValidationInfo validateEmptyDir(@NotNull ValidationRequest request, @Nls @NotNull String notADirectory, @Nls @NotNull String directoryNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)notADirectory, (String)"notADirectory");
        Intrinsics.checkNotNullParameter((Object)directoryNotEmpty, (String)"directoryNotEmpty");
        return request.validate$intellij_python_sdk((Function1<? super Path, String>)((Function1)arg_0 -> PathValidatorKt.validateEmptyDir$lambda$1(directoryNotEmpty, notADirectory, arg_0)));
    }

    private static final String validateExecutableFile$lambda$0(Path it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (WinAppxToolsKt.getAppxProduct(it) != null) {
            return null;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            if (Files.isExecutable(it)) {
                string = null;
            } else {
                Object[] objectArray = new Object[]{it};
                string = PySdkBundle.message("path.validation.cannot.execute", objectArray);
            }
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Object[] objectArray = new Object[]{it};
                string = PySdkBundle.message("path.validation.cannot.execute", objectArray);
            } else {
                Object[] objectArray = new Object[]{it};
                string = PySdkBundle.message("path.validation.file.not.found", objectArray);
            }
        }
        return string;
    }

    private static final String validateEmptyDir$lambda$1(String $directoryNotEmpty, String $notADirectory, Path it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            string = PathsKt.listDirectoryEntries$default((Path)it, null, (int)1, null).isEmpty() ? null : $directoryNotEmpty;
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            string = Files.isRegularFile(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) || WinAppxToolsKt.getAppxProduct(it) != null ? $notADirectory : null;
        }
        return string;
    }
}

