/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references.hasattr;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/psi/impl/references/hasattr/PyHasAttrVisitor;", "Lcom/jetbrains/python/psi/PyRecursiveElementVisitor;", "resolvedQualifier", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "result", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getResult", "()Ljava/util/HashSet;", "myPositive", "", "visitPyPrefixExpression", "", "node", "Lcom/jetbrains/python/psi/PyPrefixExpression;", "visitPyBinaryExpression", "Lcom/jetbrains/python/psi/PyBinaryExpression;", "visitPyCallExpression", "Lcom/jetbrains/python/psi/PyCallExpression;", "intellij.python.psi.impl"})
public final class PyHasAttrVisitor
extends PyRecursiveElementVisitor {
    @NotNull
    private final PsiElement resolvedQualifier;
    @NotNull
    private final HashSet<String> result;
    private boolean myPositive;

    public PyHasAttrVisitor(@NotNull PsiElement resolvedQualifier) {
        Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
        this.resolvedQualifier = resolvedQualifier;
        this.result = new HashSet();
        this.myPositive = true;
    }

    @NotNull
    public final HashSet<String> getResult() {
        return this.result;
    }

    @Override
    public void visitPyPrefixExpression(@NotNull PyPrefixExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getOperator() == PyTokenTypes.NOT_KEYWORD) {
            this.myPositive = !this.myPositive;
            super.visitPyPrefixExpression(node);
            this.myPositive = !this.myPositive;
        } else {
            super.visitPyPrefixExpression(node);
        }
    }

    @Override
    public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!node.isOperator("and") && !node.isOperator("or")) {
            return;
        }
        super.visitPyBinaryExpression(node);
    }

    @Override
    public void visitPyCallExpression(@NotNull PyCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!this.myPositive) {
            return;
        }
        String[] stringArray = new String[]{"hasattr"};
        if (!node.isCalleeText(stringArray)) {
            return;
        }
        if (node.getArguments().length != 2) {
            return;
        }
        PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)node.getArgument(0, PyReferenceExpression.class);
        if (pyReferenceExpression == null) {
            return;
        }
        PyReferenceExpression firstArg = pyReferenceExpression;
        PyStringLiteralExpression pyStringLiteralExpression = (PyStringLiteralExpression)node.getArgument(1, PyStringLiteralExpression.class);
        if (pyStringLiteralExpression == null) {
            return;
        }
        PyStringLiteralExpression attrName = pyStringLiteralExpression;
        if (firstArg.getReference().isReferenceTo(this.resolvedQualifier)) {
            String string = attrName.getStringValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
            String variant = string;
            if (StringUtil.isJavaIdentifier((String)variant)) {
                this.result.add(variant);
            }
        }
    }
}

