/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.editor.GotoRowAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TableGoToRowHelper
implements GotoRowAction.GoToRowHelper {
    private final TableResultView myTable;
    private final DataGrid myDataGrid;

    TableGoToRowHelper(@NotNull TableResultView table2, @NotNull DataGrid grid) {
        if (table2 == null) {
            TableGoToRowHelper.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            TableGoToRowHelper.$$$reportNull$$$0(1);
        }
        this.myTable = table2;
        this.myDataGrid = grid;
        table2.putClientProperty("GoToRowExecutor", this);
    }

    @Override
    public void goToRow(@NotNull String rowStr, @NotNull String columnStr) {
        if (rowStr == null) {
            TableGoToRowHelper.$$$reportNull$$$0(2);
        }
        if (columnStr == null) {
            TableGoToRowHelper.$$$reportNull$$$0(3);
        }
        Couple<Integer> coordinates = this.coordinates(rowStr, columnStr);
        Counter counter = Counter.get(this.myTable);
        int column = counter.horizontalUnit(coordinates);
        int row = counter.verticalUnit(coordinates);
        ModelIndex<GridColumn> columnIdx = this.myTable.uiColumn(column);
        int absoluteRowIdx = this.myTable.fromRealRowIdx(row);
        if (columnIdx.isValid((CoreGrid)this.myDataGrid) && absoluteRowIdx != -1) {
            this.myDataGrid.showCell(absoluteRowIdx, columnIdx);
        }
    }

    @NotNull
    private Couple<Integer> coordinates(String row, String column) {
        Counter counter = Counter.get(this.myTable);
        int rowIdx = counter.rowIndex(this.myDataGrid, row);
        int columnIdx = counter.columnIndex(this.myDataGrid, column);
        Couple couple = Couple.of((Object)rowIdx, (Object)columnIdx);
        if (couple == null) {
            TableGoToRowHelper.$$$reportNull$$$0(4);
        }
        return couple;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowStr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnStr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/table/TableGoToRowHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/table/TableGoToRowHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "coordinates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "goToRow";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Counter {
        REGULAR{

            @Override
            public int verticalUnit(@NotNull DataGrid grid) {
                if (grid == null) {
                    1.$$$reportNull$$$0(0);
                }
                return GridUtil.min(grid.getSelectionModel().getSelectedRows().toView((CoreGrid)grid));
            }

            @Override
            public int horizontalUnit(@NotNull DataGrid grid) {
                if (grid == null) {
                    1.$$$reportNull$$$0(1);
                }
                return GridUtil.min(grid.getSelectionModel().getSelectedColumns().toView((CoreGrid)grid));
            }

            @Override
            public int verticalUnit(@NotNull Couple<Integer> coordinates) {
                if (coordinates == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (Integer)coordinates.first;
            }

            @Override
            public int horizontalUnit(@NotNull Couple<Integer> coordinates) {
                if (coordinates == null) {
                    1.$$$reportNull$$$0(3);
                }
                return (Integer)coordinates.second;
            }

            @Override
            public int rowIndex(@NotNull DataGrid grid, @NotNull String s) {
                if (grid == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (s == null) {
                    1.$$$reportNull$$$0(5);
                }
                return StringUtil.isEmpty((String)s) ? Counter.defaultRow(grid) : StringUtil.parseInt((String)s, (int)-1);
            }

            @Override
            public int columnIndex(@NotNull DataGrid grid, @NotNull String s) {
                if (grid == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (s == null) {
                    1.$$$reportNull$$$0(7);
                }
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    GridModel model2;
                    if (StringUtil.isEmpty((String)s)) {
                        return Counter.defaultColumn(grid);
                    }
                    List indexList = grid.getVisibleColumns().asList();
                    ModelIndex idx = (ModelIndex)ContainerUtil.find((Iterable)indexList, arg_0 -> 1.lambda$columnIndex$0(model2 = grid.getDataModel(DataAccessType.DATABASE_DATA), s, arg_0));
                    return idx == null ? Counter.defaultColumn(grid) : idx.toView((CoreGrid)grid).asInteger() + 1;
                }
            }

            private static /* synthetic */ boolean lambda$columnIndex$0(GridModel model2, String s, ModelIndex c2) {
                GridColumn column = (GridColumn)model2.getColumn(c2);
                return column != null && StringUtil.equalsIgnoreCase((CharSequence)column.getName(), (CharSequence)s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "grid";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "coordinates";
                        break;
                    }
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/ui/table/TableGoToRowHelper$Counter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "verticalUnit";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "horizontalUnit";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "rowIndex";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "columnIndex";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        TRANSPOSED{

            @Override
            public int verticalUnit(@NotNull DataGrid grid) {
                if (grid == null) {
                    2.$$$reportNull$$$0(0);
                }
                return REGULAR.horizontalUnit(grid);
            }

            @Override
            public int horizontalUnit(@NotNull DataGrid grid) {
                if (grid == null) {
                    2.$$$reportNull$$$0(1);
                }
                return REGULAR.verticalUnit(grid);
            }

            @Override
            public int verticalUnit(@NotNull Couple<Integer> coordinates) {
                if (coordinates == null) {
                    2.$$$reportNull$$$0(2);
                }
                return REGULAR.horizontalUnit(coordinates);
            }

            @Override
            public int horizontalUnit(@NotNull Couple<Integer> coordinates) {
                if (coordinates == null) {
                    2.$$$reportNull$$$0(3);
                }
                return REGULAR.verticalUnit(coordinates);
            }

            @Override
            public int rowIndex(@NotNull DataGrid grid, @NotNull String s) {
                if (grid == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (s == null) {
                    2.$$$reportNull$$$0(5);
                }
                return REGULAR.columnIndex(grid, s);
            }

            @Override
            public int columnIndex(@NotNull DataGrid grid, @NotNull String s) {
                if (grid == null) {
                    2.$$$reportNull$$$0(6);
                }
                if (s == null) {
                    2.$$$reportNull$$$0(7);
                }
                return REGULAR.rowIndex(grid, s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "grid";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "coordinates";
                        break;
                    }
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/ui/table/TableGoToRowHelper$Counter$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "verticalUnit";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "horizontalUnit";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "rowIndex";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "columnIndex";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        public abstract int horizontalUnit(@NotNull DataGrid var1);

        public abstract int horizontalUnit(@NotNull Couple<Integer> var1);

        public abstract int verticalUnit(@NotNull DataGrid var1);

        public abstract int verticalUnit(@NotNull Couple<Integer> var1);

        public abstract int rowIndex(@NotNull DataGrid var1, @NotNull String var2);

        public abstract int columnIndex(@NotNull DataGrid var1, @NotNull String var2);

        private static int defaultColumn(@NotNull DataGrid dataGrid) {
            int min;
            if (dataGrid == null) {
                Counter.$$$reportNull$$$0(0);
            }
            int result = (min = GridUtil.min(dataGrid.getSelectionModel().getSelectedColumns().toView((CoreGrid)dataGrid))) == -1 ? GridUtil.min(dataGrid.getVisibleColumns().toView((CoreGrid)dataGrid)) : min;
            return result == -1 ? -1 : result + 1;
        }

        private static int defaultRow(@NotNull DataGrid dataGrid) {
            int min;
            if (dataGrid == null) {
                Counter.$$$reportNull$$$0(1);
            }
            int result = (min = GridUtil.min(dataGrid.getSelectionModel().getSelectedRows().toView((CoreGrid)dataGrid))) == -1 ? GridUtil.min(dataGrid.getVisibleRows().toView((CoreGrid)dataGrid)) : min;
            return result == -1 ? -1 : result + 1;
        }

        @NotNull
        public static Counter get(@NotNull TableResultView table2) {
            if (table2 == null) {
                Counter.$$$reportNull$$$0(2);
            }
            Counter counter = table2.isTransposed() ? TRANSPOSED : REGULAR;
            if (counter == null) {
                Counter.$$$reportNull$$$0(3);
            }
            return counter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataGrid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/table/TableGoToRowHelper$Counter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/table/TableGoToRowHelper$Counter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "defaultColumn";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "defaultRow";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

