/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.DataGridBundle;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J(\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/run/ui/table/UnparsedValueHoverListener;", "Lcom/intellij/ui/hover/TableHoverListener;", "place", "Lcom/intellij/database/run/ui/table/UnparsedValueHoverListener$Companion$Place;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/database/run/ui/table/UnparsedValueHoverListener$Companion$Place;Lcom/intellij/openapi/Disposable;)V", "alarm", "Lcom/intellij/util/Alarm;", "balloonRow", "", "Ljava/lang/Integer;", "balloonColumn", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "onHover", "", "table", "Ljavax/swing/JTable;", "row", "column", "showTooltip", "value", "Lcom/intellij/database/run/ui/grid/editors/UnparsedValue;", "hideTooltip", "Companion", "intellij.grid.impl"})
public final class UnparsedValueHoverListener
extends TableHoverListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Companion.Place place;
    @NotNull
    private final Alarm alarm;
    @Nullable
    private Integer balloonRow;
    @Nullable
    private Integer balloonColumn;
    @Nullable
    private Balloon balloon;

    public UnparsedValueHoverListener(@NotNull Companion.Place place, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.place = place;
        this.alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, disposable);
    }

    public void onHover(@NotNull JTable table2, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        if (row == -1 || column == -1) {
            return;
        }
        Object value = table2.getValueAt(row, column);
        this.alarm.cancelAllRequests();
        if (!(value instanceof UnparsedValue)) {
            this.hideTooltip();
        } else {
            this.showTooltip(table2, row, column, (UnparsedValue)value);
        }
    }

    private final void showTooltip(JTable table2, int row, int column, UnparsedValue value) {
        Integer n = this.balloonRow;
        int n2 = row;
        if (n != null && n == n2) {
            Integer n3 = this.balloonColumn;
            n2 = column;
            if (n3 != null && n3 == n2) {
                return;
            }
        }
        this.hideTooltip();
        this.alarm.addRequest(() -> UnparsedValueHoverListener.showTooltip$lambda$1(value, this, row, column, table2), 300);
    }

    private final void hideTooltip() {
        Balloon balloon = this.balloon;
        if (balloon != null) {
            balloon.hide();
        }
        this.balloon = null;
        this.balloonRow = null;
        this.balloonColumn = null;
    }

    private static final void showTooltip$lambda$1(UnparsedValue $value, UnparsedValueHoverListener this$0, int $row, int $column, JTable $table) {
        block5: {
            Point point;
            Object object = $value.getError();
            if (object == null || (object = object.message()) == null) {
                String string = DataGridBundle.message((String)"popup.content.unparsed.value", (Object[])new Object[0]);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            }
            Object message = object;
            this$0.balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder((String)message, MessageType.ERROR, null).setHideOnAction(true).setHideOnClickOutside(true).setHideOnLinkClick(true).createBalloon();
            this$0.balloonRow = $row;
            this$0.balloonColumn = $column;
            Rectangle cellRect = $table.getCellRect($row, $column, true);
            JScrollPane scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)$table);
            Point $this$showTooltip_u24lambda_u241_u24lambda_u240 = point = cellRect.getLocation();
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this$0.place.ordinal()]) {
                case 1: {
                    $this$showTooltip_u24lambda_u241_u24lambda_u240.translate(cellRect.width / 2, cellRect.height);
                    break;
                }
                case 2: {
                    $this$showTooltip_u24lambda_u241_u24lambda_u240.translate(0, cellRect.height);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int n = $this$showTooltip_u24lambda_u241_u24lambda_u240.x;
            JComponent jComponent = scrollPane;
            int n2 = jComponent != null && (jComponent = ((JScrollPane)jComponent).getHorizontalScrollBar()) != null ? ((JScrollBar)jComponent).getValue() : 0;
            $this$showTooltip_u24lambda_u241_u24lambda_u240.move(Math.max(n, n2), $this$showTooltip_u24lambda_u241_u24lambda_u240.y);
            Point point2 = point;
            Balloon balloon = this$0.balloon;
            if (balloon == null) break block5;
            balloon.show(new RelativePoint((Component)$table, point2), Balloon.Position.below);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/run/ui/table/UnparsedValueHoverListener$Companion;", "", "<init>", "()V", "Place", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/run/ui/table/UnparsedValueHoverListener$Companion$Place;", "", "<init>", "(Ljava/lang/String;I)V", "LEFT", "CENTER", "intellij.grid.impl"})
        public static final class Place
        extends Enum<Place> {
            public static final /* enum */ Place LEFT = new Place();
            public static final /* enum */ Place CENTER = new Place();
            private static final /* synthetic */ Place[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Place[] values() {
                return (Place[])$VALUES.clone();
            }

            public static Place valueOf(String value) {
                return Enum.valueOf(Place.class, value);
            }

            @NotNull
            public static EnumEntries<Place> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = placeArray = new Place[]{Place.LEFT, Place.CENTER};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Companion.Place.values().length];
            try {
                nArray[Companion.Place.CENTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.Place.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

