/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.textMatching.SimilarityScorer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/completion/ml/common/ContextSimilarityUtil;", "", "<init>", "()V", "LINE_SIMILARITY_SCORER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/textMatching/SimilarityScorer;", "getLINE_SIMILARITY_SCORER_KEY", "()Lcom/intellij/openapi/util/Key;", "PARENT_SIMILARITY_SCORER_KEY", "getPARENT_SIMILARITY_SCORER_KEY", "createLineSimilarityScorer", "line", "", "createParentSimilarityScorer", "element", "Lcom/intellij/psi/PsiElement;", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nContextSimilarityUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextSimilarityUtil.kt\ncom/intellij/completion/ml/common/ContextSimilarityUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,29:1\n1#2:30\n*E\n"})
public final class ContextSimilarityUtil {
    @NotNull
    public static final ContextSimilarityUtil INSTANCE = new ContextSimilarityUtil();
    @NotNull
    private static final Key<SimilarityScorer> LINE_SIMILARITY_SCORER_KEY;
    @NotNull
    private static final Key<SimilarityScorer> PARENT_SIMILARITY_SCORER_KEY;

    private ContextSimilarityUtil() {
    }

    @NotNull
    public final Key<SimilarityScorer> getLINE_SIMILARITY_SCORER_KEY() {
        return LINE_SIMILARITY_SCORER_KEY;
    }

    @NotNull
    public final Key<SimilarityScorer> getPARENT_SIMILARITY_SCORER_KEY() {
        return PARENT_SIMILARITY_SCORER_KEY;
    }

    @NotNull
    public final SimilarityScorer createLineSimilarityScorer(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        List list = StringUtil.getWordsIn((String)line);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getWordsIn(...)");
        return new SimilarityScorer(list, null, 2, null);
    }

    @NotNull
    public final SimilarityScorer createParentSimilarityScorer(@Nullable PsiElement element) {
        List parents = new ArrayList();
        for (PsiElement curElement = element; curElement != null && !(curElement instanceof PsiFile); curElement = curElement.getParent()) {
            String it;
            if (!(curElement instanceof PsiNamedElement)) continue;
            if (((PsiNamedElement)curElement).getName() == null) continue;
            boolean bl = false;
            parents.add(it);
        }
        return new SimilarityScorer(parents, null, 2, null);
    }

    static {
        Key key = Key.create((String)"LINE_SIMILARITY_SCORER");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LINE_SIMILARITY_SCORER_KEY = key;
        Key key2 = Key.create((String)"PARENT_SIMILARITY_SCORER");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        PARENT_SIMILARITY_SCORER_KEY = key2;
    }
}

