/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.providers.execution;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.utils.JupyterEditorCellExtensionsKt;
import com.intellij.jupyter.core.jupyter.actions.CellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterInlayProgressStatusManager;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListeners;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookVisualizationCoroutine;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.time.ZonedDateTime;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/providers/execution/NotebookEditorCellExecutionDetector;", "Lcom/intellij/openapi/Disposable$Default;", "manager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;)V", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "recalculateStatus", "", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "updateInterval", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "Companion", "intellij.jupyter.core"})
public final class NotebookEditorCellExecutionDetector
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotebookCellInlayManager manager;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<NotebookEditorCellExecutionDetector> KEY = new Key(NotebookEditorCellExecutionDetector.class.getName());

    public NotebookEditorCellExecutionDetector(@NotNull NotebookCellInlayManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.editor = this.manager.getEditor();
        Project project = this.editor.getProject();
        Intrinsics.checkNotNull((Object)project);
        this.project = project;
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)this.editor);
        Intrinsics.checkNotNull((Object)jupyterNotebook);
        JupyterListeners listeners = jupyterNotebook.getListeners();
        CellExecutionListener listener2 = new CellExecutionListener(this){
            final /* synthetic */ NotebookEditorCellExecutionDetector this$0;
            {
                this.this$0 = $receiver;
            }

            public void cellExecuted(JupyterNotebook notebook, NotebookIntervalPointer cell) {
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
                NotebookEditorCellExecutionDetector.access$updateInterval(this.this$0, cell);
            }

            public void executionSubmitted(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook) {
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                NotebookEditorCellExecutionDetector.access$updateInterval(this.this$0, cellPointer);
            }

            public void executionStarted(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook, ZonedDateTime startTime) {
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
                NotebookEditorCellExecutionDetector.access$updateInterval(this.this$0, cellPointer);
            }

            public void executionStopped(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook, JupyterExecutionStatus jupyterStatus, ZonedDateTime endTime) {
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)((Object)jupyterStatus), (String)"jupyterStatus");
                Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
                NotebookEditorCellExecutionDetector.access$updateInterval(this.this$0, cellPointer);
            }

            public void executionStatusReset(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook) {
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                NotebookEditorCellExecutionDetector.access$updateInterval(this.this$0, cellPointer);
            }

            public void debugFinished() {
                NotebookVisualizationCoroutine.Utils.INSTANCE.launchEdt((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                    int label;
                    final /* synthetic */ NotebookEditorCellExecutionDetector this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$forEach$iv;
                                ResultKt.throwOnFailure((Object)$result);
                                Iterable iterable = NotebookEditorCellExecutionDetector.access$getManager$p(this.this$0).getCells();
                                NotebookEditorCellExecutionDetector notebookEditorCellExecutionDetector = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    EditorCell it = (EditorCell)element$iv;
                                    boolean bl = false;
                                    notebookEditorCellExecutionDetector.recalculateStatus(it);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                });
            }
        };
        listeners.getCellExecutionListeners().addListener((EventListener)listener2, (Disposable)this);
    }

    public final void recalculateStatus(@NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        JupyterCell jupyterCell = JupyterEditorCellExtensionsKt.getJupyterCell(cell);
        if (jupyterCell == null) {
            return;
        }
        JupyterCell jupyterCell2 = jupyterCell;
        ProgressStatus progressStatus = JupyterInlayProgressStatusManager.Companion.getInstance(this.project).getProgressStatus(cell.getIntervalPointer());
        ZonedDateTime executionStartTime = jupyterCell2.getExecutionStartTime();
        ZonedDateTime executionEndTime = jupyterCell2.getExecutionEndTime();
        Integer n = jupyterCell2.getExecutionCount();
        EditorCell.ExecutionStatus status = new EditorCell.ExecutionStatus(progressStatus, n, executionStartTime, executionEndTime);
        cell.getExecutionStatus().set((Object)status);
    }

    private final void updateInterval(NotebookIntervalPointer cellPointer) {
        EditorCell editorCell = this.manager.getCell(cellPointer);
        this.recalculateStatus(editorCell);
    }

    public static final /* synthetic */ void access$updateInterval(NotebookEditorCellExecutionDetector $this, NotebookIntervalPointer cellPointer) {
        $this.updateInterval(cellPointer);
    }

    public static final /* synthetic */ NotebookCellInlayManager access$getManager$p(NotebookEditorCellExecutionDetector $this) {
        return $this.manager;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/providers/execution/NotebookEditorCellExecutionDetector$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/jupyter/editor/providers/execution/NotebookEditorCellExecutionDetector;", "install", "", "manager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "getFor", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull NotebookCellInlayManager manager) {
            NotebookEditorCellExecutionDetector notebookEditorCellExecutionDetector;
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            NotebookEditorCellExecutionDetector it = notebookEditorCellExecutionDetector = new NotebookEditorCellExecutionDetector(manager);
            boolean bl = false;
            Disposer.register((Disposable)((Disposable)manager), (Disposable)((Disposable)it));
            NotebookEditorCellExecutionDetector detector = notebookEditorCellExecutionDetector;
            manager.getEditor().putUserData(KEY, (Object)detector);
        }

        @Nullable
        public final NotebookEditorCellExecutionDetector getFor(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (NotebookEditorCellExecutionDetector)editor.getUserData(KEY);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

