/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.xml;

import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.impl.xml.XmlTagTreeElement;
import com.intellij.ide.structureView.xml.XmlStructureViewElementProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractXmlTagTreeElement<T extends XmlElement>
extends PsiTreeElementBase<T> {
    protected AbstractXmlTagTreeElement(T psiElement) {
        super(psiElement);
    }

    protected static @Unmodifiable Collection<StructureViewTreeElement> getStructureViewTreeElements(XmlTag[] subTags) {
        return ContainerUtil.map((Object[])subTags, xmlTag -> {
            for (XmlStructureViewElementProvider provider : XmlStructureViewElementProvider.EP_NAME.getExtensionList()) {
                StructureViewTreeElement element = provider.createCustomXmlTagTreeElement((XmlTag)xmlTag);
                if (element == null) continue;
                return element;
            }
            return new XmlTagTreeElement((XmlTag)xmlTag);
        });
    }

    static {
        XmlStructureViewElementProvider.EP_NAME.addChangeListener(() -> ((Runnable)ApplicationManager.getApplication().getMessageBus().syncPublisher(StructureViewWrapperImpl.STRUCTURE_CHANGED)).run(), null);
    }
}

