/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomAttributeXmlDescriptor
implements NamespaceAwareXmlAttributeDescriptor {
    private final DomAttributeChildDescription<?> myDescription;
    private final Project myProject;

    public DomAttributeXmlDescriptor(DomAttributeChildDescription<?> description, Project project) {
        this.myDescription = description;
        this.myProject = project;
    }

    public boolean isRequired() {
        Required required = this.myDescription.getAnnotation(Required.class);
        return required != null && required.value();
    }

    public boolean isFixed() {
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public boolean isEnumerated() {
        return false;
    }

    public String @Nullable [] getEnumeratedValues() {
        return null;
    }

    @Nullable
    public String validateValue(XmlElement context, String value) {
        return null;
    }

    @Nullable
    public PsiElement getDeclaration() {
        return this.myDescription.getDeclaration(this.myProject);
    }

    @NonNls
    public String getName(PsiElement context) {
        return DomAttributeXmlDescriptor.getQualifiedAttributeName(context, this.myDescription.getXmlName());
    }

    static String getQualifiedAttributeName(PsiElement context, XmlName xmlName) {
        String localName = xmlName.getLocalName();
        if (context instanceof XmlTag) {
            String prefix;
            String ns;
            XmlTag tag = (XmlTag)context;
            DomInvocationHandler handler = DomManagerImpl.getDomManager(context.getProject()).getDomHandler((XmlElement)tag);
            if (handler != null && !(ns = handler.createEvaluatedXmlName(xmlName).getNamespace((XmlElement)tag, handler.getFile())).equals("") && !ns.equals(tag.getNamespace()) && StringUtil.isNotEmpty((String)(prefix = tag.getPrefixByNamespace(ns)))) {
                return prefix + ":" + localName;
            }
        }
        return localName;
    }

    @NonNls
    public String getName() {
        return this.getLocalName();
    }

    private String getLocalName() {
        return this.myDescription.getXmlName().getLocalName();
    }

    @Override
    @Nullable
    public String getNamespace(@NotNull XmlTag context) {
        DomInvocationHandler handler;
        if (context == null) {
            DomAttributeXmlDescriptor.$$$reportNull$$$0(0);
        }
        if ((handler = DomManagerImpl.getDomManager(this.myProject).getDomHandler((XmlElement)context)) == null) {
            return null;
        }
        return handler.createEvaluatedXmlName(this.myDescription.getXmlName()).getNamespace((XmlElement)context, handler.getFile());
    }

    public void init(PsiElement element) {
        throw new UnsupportedOperationException("Method init not implemented in " + String.valueOf(this.getClass()));
    }

    public Object @NotNull [] getDependencies() {
        throw new UnsupportedOperationException("Method getDependencies not implemented in " + String.valueOf(this.getClass()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/xml/impl/dom/DomAttributeXmlDescriptor", "getNamespace"));
    }
}

