/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.XmlRefCountHolder;
import org.jetbrains.annotations.NotNull;

public class XmlDuplicatedIdInspection
extends XmlSuppressableInspectionTool
implements UnfairLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XmlDuplicatedIdInspection.$$$reportNull$$$0(0);
        }
        if (holder.getFile().getLanguage() != XMLLanguage.INSTANCE && holder.getFile().getLanguage() != HTMLLanguage.INSTANCE) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                XmlDuplicatedIdInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new XmlElementVisitor(){

            public void visitXmlAttributeValue(@NotNull XmlAttributeValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value.getTextRange().isEmpty()) {
                    return;
                }
                PsiFile file = value.getContainingFile();
                PsiFile baseFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)file);
                if (baseFile != file && !(baseFile instanceof XmlFile)) {
                    return;
                }
                XmlRefCountHolder refHolder = XmlRefCountHolder.getRefCountHolder((XmlFile)file);
                if (refHolder == null) {
                    return;
                }
                PsiElement parent = value.getParent();
                if (!(parent instanceof XmlAttribute)) {
                    return;
                }
                XmlTag tag = (XmlTag)parent.getParent();
                if (tag == null) {
                    return;
                }
                XmlDuplicatedIdInspection.this.checkValue(value, (XmlFile)file, refHolder, tag, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xml/util/XmlDuplicatedIdInspection$1", "visitXmlAttributeValue"));
            }
        };
    }

    protected void checkValue(XmlAttributeValue value, XmlFile file, XmlRefCountHolder refHolder, XmlTag tag, ProblemsHolder holder) {
        if (refHolder.isValidatable(tag.getParent()) && refHolder.isDuplicateIdAttributeValue(value)) {
            holder.registerProblem((PsiElement)value, XmlAnalysisBundle.message("xml.inspections.duplicate.id.reference", new Object[0]), ProblemHighlightType.GENERIC_ERROR, ElementManipulators.getValueTextRange((PsiElement)value), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/XmlDuplicatedIdInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/XmlDuplicatedIdInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

