/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jsonProtocol;

import com.google.gson.stream.JsonToken;
import com.intellij.util.ArrayUtilRt;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.MapFactory;
import org.jetbrains.jsonProtocol.ObjectFactory;
import org.jetbrains.jsonProtocol.StringIntPair;

@ApiStatus.Internal
public final class JsonReaders {
    public static final ObjectFactory<String> STRING_OBJECT_FACTORY = new ObjectFactory<String>(){

        @Override
        public String read(JsonReaderEx reader) {
            return reader.nextString();
        }
    };

    public static <T extends Enum<T>> List<T> readEnumArray(@NotNull JsonReaderEx reader, @NotNull Class<T> enumClass) {
        if (reader == null) {
            JsonReaders.$$$reportNull$$$0(0);
        }
        if (enumClass == null) {
            JsonReaders.$$$reportNull$$$0(1);
        }
        return JsonReaders.readObjectArray(reader, new EnumFactory<T>(enumClass));
    }

    public static double[] readDoubleArray(JsonReaderEx reader) {
        JsonReaders.checkIsNull(reader);
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return new double[0];
        }
        DoubleArrayList result = new DoubleArrayList();
        do {
            result.add(reader.nextDouble());
        } while (reader.hasNext());
        reader.endArray();
        return result.toDoubleArray();
    }

    private JsonReaders() {
    }

    public static <T> ObjectFactory<Map<String, T>> mapFactory(@NotNull ObjectFactory<? extends T> valueFactory) {
        if (valueFactory == null) {
            JsonReaders.$$$reportNull$$$0(2);
        }
        return new MapFactory<T>(valueFactory);
    }

    private static void checkIsNull(JsonReaderEx reader) {
        if (reader.peek() == JsonToken.NULL) {
            throw new RuntimeException("Field is not nullable");
        }
    }

    public static boolean readsNull(JsonReaderEx reader) {
        if (reader.peek() == JsonToken.NULL) {
            reader.skipValue();
            return true;
        }
        return false;
    }

    public static String readRawString(JsonReaderEx reader) {
        return reader.nextString(true);
    }

    public static Object readRawStringOrMap(JsonReaderEx reader) {
        if (reader.peek() == JsonToken.BEGIN_OBJECT) {
            return JsonReaders.readMap(reader, null);
        }
        return reader.nextString(true);
    }

    public static String convertRawEnumName(@NotNull String enumValue) {
        if (enumValue == null) {
            JsonReaders.$$$reportNull$$$0(3);
        }
        int n = enumValue.length();
        StringBuilder builder2 = new StringBuilder(n + 4);
        boolean prevIsLowerCase = false;
        for (int i = 0; i < n; ++i) {
            char c = enumValue.charAt(i);
            if (c == '-' || c == ' ') {
                builder2.append('_');
                continue;
            }
            if (Character.isUpperCase(c)) {
                if (prevIsLowerCase || i != 0 && i + 1 < n && Character.isLowerCase(enumValue.charAt(i + 1))) {
                    builder2.append('_');
                }
                builder2.append(c);
                prevIsLowerCase = false;
                continue;
            }
            builder2.append(Character.toUpperCase(c));
            prevIsLowerCase = true;
        }
        return builder2.toString();
    }

    public static <T extends Enum<T>> T readEnum(@NotNull JsonReaderEx reader, @NotNull Class<T> enumClass) {
        if (reader == null) {
            JsonReaders.$$$reportNull$$$0(4);
        }
        if (enumClass == null) {
            JsonReaders.$$$reportNull$$$0(5);
        }
        if (reader.peek() == JsonToken.NULL) {
            reader.skipValue();
            return null;
        }
        try {
            return Enum.valueOf(enumClass, JsonReaders.convertRawEnumName(reader.nextString()));
        }
        catch (IllegalArgumentException ignored) {
            return Enum.valueOf(enumClass, "NO_ENUM_CONST");
        }
    }

    public static <T> List<T> readObjectArrayOrSingleObject(@NotNull JsonReaderEx reader, @NotNull ObjectFactory<? extends T> factory) {
        if (reader == null) {
            JsonReaders.$$$reportNull$$$0(6);
        }
        if (factory == null) {
            JsonReaders.$$$reportNull$$$0(7);
        }
        if (reader.peek() == JsonToken.BEGIN_OBJECT) {
            return Collections.singletonList(factory.read(reader));
        }
        return JsonReaders.readObjectArray(reader, factory);
    }

    public static <T> List<T> readObjectArray(@NotNull JsonReaderEx reader, @NotNull ObjectFactory<? extends T> factory) {
        if (reader == null) {
            JsonReaders.$$$reportNull$$$0(8);
        }
        if (factory == null) {
            JsonReaders.$$$reportNull$$$0(9);
        }
        if (reader.peek() == JsonToken.NULL) {
            reader.skipValue();
            return null;
        }
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        do {
            result.add(factory.read(reader));
        } while (reader.hasNext());
        reader.endArray();
        return result;
    }

    public static <T> Map<String, T> readMap(@NotNull JsonReaderEx reader, @Nullable ObjectFactory<? extends T> factory) {
        if (reader == null) {
            JsonReaders.$$$reportNull$$$0(10);
        }
        if (reader.peek() == JsonToken.NULL) {
            reader.skipValue();
            return null;
        }
        reader.beginObject();
        if (!reader.hasNext()) {
            reader.endObject();
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (reader.hasNext()) {
            if (factory == null) {
                map.put(reader.nextName(), JsonReaders.read(reader));
                continue;
            }
            map.put(reader.nextName(), factory.read(reader));
        }
        reader.endObject();
        return map;
    }

    public static Object read(JsonReaderEx reader) {
        return switch (reader.peek()) {
            case JsonToken.BEGIN_ARRAY -> JsonReaders.nextList(reader);
            case JsonToken.BEGIN_OBJECT -> {
                reader.beginObject();
                yield JsonReaders.nextObject(reader);
            }
            case JsonToken.STRING -> reader.nextString();
            case JsonToken.NUMBER -> reader.nextDouble();
            case JsonToken.BOOLEAN -> reader.nextBoolean();
            case JsonToken.NULL -> {
                reader.nextNull();
                yield null;
            }
            default -> throw new IllegalStateException();
        };
    }

    public static Map<String, Object> nextObject(JsonReaderEx reader) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (reader.hasNext()) {
            map.put(reader.nextName(), JsonReaders.read(reader));
        }
        reader.endObject();
        return map;
    }

    public static <T> List<T> nextList(JsonReaderEx reader) {
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        do {
            list.add(JsonReaders.read(reader));
        } while (reader.hasNext());
        reader.endArray();
        return list;
    }

    public static List<String> readRawStringArray(JsonReaderEx reader) {
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        do {
            list.add(reader.nextString(true));
        } while (reader.hasNext());
        reader.endArray();
        return list;
    }

    public static long[] readLongArray(JsonReaderEx reader) {
        JsonReaders.checkIsNull(reader);
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return ArrayUtilRt.EMPTY_LONG_ARRAY;
        }
        LongArrayList result = new LongArrayList();
        do {
            result.add(reader.nextLong());
        } while (reader.hasNext());
        reader.endArray();
        return result.toLongArray();
    }

    public static int[] readIntArray(JsonReaderEx reader) {
        JsonReaders.checkIsNull(reader);
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        IntArrayList result = new IntArrayList();
        do {
            result.add(reader.nextInt());
        } while (reader.hasNext());
        reader.endArray();
        return result.toIntArray();
    }

    public static List<StringIntPair> readIntStringPairs(JsonReaderEx reader) {
        JsonReaders.checkIsNull(reader);
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return Collections.emptyList();
        }
        ArrayList<StringIntPair> result = new ArrayList<StringIntPair>();
        do {
            reader.beginArray();
            result.add(new StringIntPair(reader.nextInt(), reader.nextString()));
            reader.endArray();
        } while (reader.hasNext());
        reader.endArray();
        return result;
    }

    public static boolean findBooleanField(String name, JsonReaderEx reader) {
        reader.beginObject();
        while (reader.hasNext()) {
            if (reader.nextName().equals(name)) {
                return reader.nextBoolean();
            }
            reader.skipValue();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumValue";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jsonProtocol/JsonReaders";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readEnumArray";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mapFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "convertRawEnumName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "readEnum";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "readObjectArrayOrSingleObject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "readObjectArray";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "readMap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class EnumFactory<T extends Enum<T>>
    extends ObjectFactory<T> {
        private final Class<T> enumClass;

        public EnumFactory(Class<T> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        public T read(JsonReaderEx reader) {
            return JsonReaders.readEnum(reader, this.enumClass);
        }
    }

    public static final class WrapperFactory<T>
    extends ObjectFactory<T> {
        private final Function1<? super JsonReaderEx, ? extends T> innerReader;

        public WrapperFactory(Function1<? super JsonReaderEx, ? extends T> reader) {
            this.innerReader = reader;
        }

        @Override
        public T read(JsonReaderEx reader) {
            return (T)this.innerReader.invoke((Object)reader);
        }
    }
}

