/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.SplitLineAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstDocStringOwner;
import com.jetbrains.python.ast.PyAstFile;
import com.jetbrains.python.ast.PyAstFromImportStatement;
import com.jetbrains.python.ast.PyAstGeneratorExpression;
import com.jetbrains.python.ast.PyAstParenthesizedExpression;
import com.jetbrains.python.ast.PyAstStringElement;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.ast.PyAstWithStatement;
import com.jetbrains.python.ast.docstring.DocStringUtilCore;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocString;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.editor.PyEditorHandlerConfig;
import com.jetbrains.python.formatter.PyWhiteSpaceFormattingStrategy;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonEnterHandler
implements EnterHandlerDelegate {
    private int myPostprocessShift = 0;

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            PythonEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PythonEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            PythonEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            PythonEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            PythonEnterHandler.$$$reportNull$$$0(4);
        }
        int offset = (Integer)caretOffset.get();
        if (editor instanceof EditorWindow) {
            file = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
            editor = InjectedLanguageUtil.getTopLevelEditor((Editor)editor);
            offset = editor.getCaretModel().getOffset();
        }
        if (!(file instanceof PyAstFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Boolean isSplitLine = (Boolean)DataManager.getInstance().loadFromDataContext(dataContext, SplitLineAction.SPLIT_LINE_KEY);
        if (isSplitLine != null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document doc = editor.getDocument();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(doc);
        PsiElement element = file.findElementAt(offset);
        PsiElement prevElement = offset > 0 ? file.findElementAt(offset - 1) : null;
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        if (codeInsightSettings.JAVADOC_STUB_ON_ENTER) {
            DocstringState state2;
            PsiElement comment = element;
            if (comment == null && offset != 0) {
                comment = prevElement;
            }
            int expectedStringStart = editor.getCaretModel().getOffset() - 3;
            if (comment != null && (state2 = PythonEnterHandler.canGenerateDocstring(comment, expectedStringStart, doc)) != DocstringState.NONE) {
                PythonEnterHandler.insertDocStringStub(editor, comment, state2);
                return EnterHandlerDelegate.Result.Continue;
            }
        }
        if (element == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        ASTNode node = element.getNode();
        PsiElement elementParent = element.getParent();
        IElementType nodeType = node.getElementType();
        if (nodeType == PyTokenTypes.LPAR) {
            elementParent = elementParent.getParent();
        }
        if (elementParent instanceof PyAstParenthesizedExpression || elementParent instanceof PyAstGeneratorExpression) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PyAstStringElement stringElement = (PyAstStringElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAstStringElement.class, (boolean)false);
        if (stringElement == null && prevElement == element) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!(stringElement == null || stringElement.isFormatted() && nodeType != PyTokenTypes.FSTRING_TEXT && nodeType != PyTokenTypes.FSTRING_FRAGMENT_START && nodeType != PyTokenTypes.FSTRING_END)) {
            if (stringElement.isTripleQuoted() || nodeType == PyTokenTypes.DOCSTRING) {
                return EnterHandlerDelegate.Result.Continue;
            }
            if (prevElement != null && PsiTreeUtil.isAncestor((PsiElement)stringElement, (PsiElement)prevElement, (boolean)false)) {
                String delimiter;
                boolean isEscapedBackslash;
                if (stringElement.getTextOffset() + stringElement.getPrefixLength() >= offset) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                String pref = stringElement.getPrefix();
                String quote = stringElement.getQuote();
                boolean afterBackslash = "\\".equals(doc.getText(TextRange.from((int)(offset - 1), (int)1)));
                boolean isEscapedQuote = quote.equals(doc.getText(TextRange.from((int)offset, (int)1))) && afterBackslash;
                boolean bl = isEscapedBackslash = "\\".equals(doc.getText(TextRange.from((int)(offset - 2), (int)1))) && afterBackslash;
                if (afterBackslash && !isEscapedQuote && !isEscapedBackslash) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                this.myPostprocessShift = pref.length() + quote.length();
                boolean parenthesiseOnEnter = PyCodeInsightSettings.getInstance().PARENTHESISE_ON_ENTER;
                String string = delimiter = parenthesiseOnEnter ? "" : " \\";
                if (PsiTreeUtil.getParentOfType((PsiElement)stringElement, (Class[])PyEditorHandlerConfig.IMPLICIT_WRAP_CLASSES) != null) {
                    doc.insertString(offset, (CharSequence)(quote + pref + quote));
                    caretOffset.set((Object)((Integer)caretOffset.get() + 1));
                } else {
                    int insertionOffset = offset;
                    if (isEscapedQuote) {
                        caretOffset.set((Object)((Integer)caretOffset.get() + 1));
                        ++insertionOffset;
                    }
                    if (parenthesiseOnEnter) {
                        PythonEnterHandler.parenthesise(stringElement, doc);
                        caretOffset.set((Object)((Integer)caretOffset.get() + 1));
                        ++insertionOffset;
                    }
                    doc.insertString(insertionOffset, (CharSequence)(quote + delimiter + pref + quote));
                    caretOffset.set((Object)((Integer)caretOffset.get() + delimiter.length() + 1));
                }
                return EnterHandlerDelegate.Result.Continue;
            }
        }
        return PythonEnterHandler.checkInsertBackslash(file, caretOffset, dataContext, offset, doc);
    }

    private static EnterHandlerDelegate.Result checkInsertBackslash(PsiFile file, Ref<Integer> caretOffset, DataContext dataContext, int offset, Document doc) {
        PsiElement atCaret;
        boolean autoWrapInProgress;
        boolean bl = autoWrapInProgress = DataManager.getInstance().loadFromDataContext(dataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY) != null;
        if (PyWhiteSpaceFormattingStrategy.needInsertBackslash(file, offset, autoWrapInProgress) && (atCaret = file.findElementAt(offset)) != null) {
            PsiElement elementToWrap;
            if (PyCodeInsightSettings.getInstance().PARENTHESISE_ON_ENTER && (elementToWrap = PythonEnterHandler.findElementToParenthesise(atCaret)) != null) {
                PythonEnterHandler.parenthesise(elementToWrap, doc);
                caretOffset.set((Object)((Integer)caretOffset.get() + 1));
                return EnterHandlerDelegate.Result.Continue;
            }
            doc.insertString(offset, (CharSequence)"\\");
            caretOffset.set((Object)((Integer)caretOffset.get() + 1));
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    @Nullable
    private static PsiElement findElementToParenthesise(@NotNull PsiElement nodeAtCaret) {
        PsiElement next;
        if (nodeAtCaret == null) {
            PythonEnterHandler.$$$reportNull$$$0(5);
        }
        PsiElement wrappable = nodeAtCaret;
        while ((next = PsiTreeUtil.getParentOfType((PsiElement)wrappable, (Class[])PyEditorHandlerConfig.CLASSES_TO_PARENTHESISE_ON_ENTER)) != null) {
            wrappable = next;
        }
        return wrappable != nodeAtCaret ? wrappable : null;
    }

    private static void parenthesise(@NotNull PsiElement wrappable, @NotNull Document doc) {
        TextRange rangeToParenthesise;
        if (wrappable == null) {
            PythonEnterHandler.$$$reportNull$$$0(6);
        }
        if (doc == null) {
            PythonEnterHandler.$$$reportNull$$$0(7);
        }
        if (wrappable instanceof PyAstFromImportStatement) {
            PyAstFromImportStatement fromImportStatement = (PyAstFromImportStatement)wrappable;
            rangeToParenthesise = PythonEnterHandler.getRangeForPsiElementArray((PsiElement[])fromImportStatement.getImportElements());
        } else if (wrappable instanceof PyAstWithStatement) {
            PyAstWithStatement withStatement = (PyAstWithStatement)wrappable;
            rangeToParenthesise = PythonEnterHandler.getRangeForPsiElementArray((PsiElement[])withStatement.getWithItems());
        } else {
            rangeToParenthesise = wrappable.getTextRange();
        }
        if (rangeToParenthesise != null) {
            doc.insertString(rangeToParenthesise.getEndOffset(), (CharSequence)")");
            doc.insertString(rangeToParenthesise.getStartOffset(), (CharSequence)"(");
        }
    }

    @Nullable
    private static TextRange getRangeForPsiElementArray(PsiElement[] items) {
        if (!ArrayUtil.isEmpty((Object[])items)) {
            PsiElement first = (PsiElement)ArrayUtil.getFirstElement((Object[])items);
            PsiElement last = (PsiElement)ArrayUtil.getLastElement((Object[])items);
            if (first != null && last != null) {
                return first.getTextRange().union(last.getTextRange());
            }
        }
        return null;
    }

    private static void insertDocStringStub(Editor editor, PsiElement element, DocstringState state2) {
        PyAstDocStringOwner docOwner = (PyAstDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PyAstDocStringOwner.class);
        if (docOwner != null) {
            int caretOffset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            String quotes = document.getText(TextRange.from((int)(caretOffset - 3), (int)3));
            String docString = PyDocstringGenerator.forDocStringOwner(docOwner).withInferredParameters(true).withQuotes(quotes).forceNewMode().buildDocString();
            if (state2 == DocstringState.INCOMPLETE) {
                document.insertString(caretOffset, (CharSequence)docString.substring(3));
            } else if (state2 == DocstringState.EMPTY) {
                document.replaceString(caretOffset, caretOffset + 3, (CharSequence)docString.substring(3));
            }
        }
    }

    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (file == null) {
            PythonEnterHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            PythonEnterHandler.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            PythonEnterHandler.$$$reportNull$$$0(10);
        }
        if (!(file instanceof PyAstFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (this.myPostprocessShift > 0) {
            editor.getCaretModel().moveCaretRelatively(this.myPostprocessShift, 0, false, false, false);
            this.myPostprocessShift = 0;
            return EnterHandlerDelegate.Result.Continue;
        }
        PythonEnterHandler.addGoogleDocStringSectionIndent(file, editor, editor.getCaretModel().getOffset());
        return super.postProcessEnter(file, editor, dataContext);
    }

    private static void addGoogleDocStringSectionIndent(@NotNull PsiFile file, @NotNull Editor editor, int offset) {
        int lineNum;
        TextRange lineRange;
        Matcher matcher;
        String docStringText;
        DocStringFormat format;
        PyAstStringLiteralExpression pyString;
        if (file == null) {
            PythonEnterHandler.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            PythonEnterHandler.$$$reportNull$$$0(12);
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        PsiElement element = file.findElementAt(offset);
        if (element != null && (pyString = DocStringUtilCore.getParentDefinitionDocString(element)) != null && (format = DocStringParser.guessDocStringFormat(docStringText = pyString.getText(), pyString)) == DocStringFormat.GOOGLE && offset + 1 < document.getTextLength() && (matcher = GoogleCodeStyleDocString.SECTION_HEADER.matcher(document.getText(lineRange = TextRange.create((int)document.getLineStartOffset((lineNum = document.getLineNumber(offset)) - 1), (int)document.getLineEndOffset(lineNum - 1))))).matches() && SectionBasedDocString.isValidSectionTitle(matcher.group(1))) {
            document.insertString(offset, (CharSequence)GoogleCodeStyleDocStringBuilder.getDefaultSectionIndent(file));
            editor.getCaretModel().moveCaretRelatively(2, 0, false, false, false);
        }
    }

    @NotNull
    public static DocstringState canGenerateDocstring(@NotNull PsiElement element, int firstQuoteOffset, @NotNull Document document) {
        if (element == null) {
            PythonEnterHandler.$$$reportNull$$$0(13);
        }
        if (document == null) {
            PythonEnterHandler.$$$reportNull$$$0(14);
        }
        if (firstQuoteOffset < 0 || firstQuoteOffset > document.getTextLength() - 3) {
            DocstringState docstringState = DocstringState.NONE;
            if (docstringState == null) {
                PythonEnterHandler.$$$reportNull$$$0(15);
            }
            return docstringState;
        }
        String quotes = document.getText(TextRange.from((int)firstQuoteOffset, (int)3));
        if (!quotes.equals("\"\"\"") && !quotes.equals("'''")) {
            DocstringState docstringState = DocstringState.NONE;
            if (docstringState == null) {
                PythonEnterHandler.$$$reportNull$$$0(16);
            }
            return docstringState;
        }
        PyAstStringLiteralExpression pyString = DocStringUtilCore.getParentDefinitionDocString(element);
        if (pyString != null) {
            String nodeText = element.getText();
            int prefixLength = PyStringLiteralUtil.getPrefixLength(nodeText);
            nodeText = nodeText.substring(prefixLength);
            String literalText = pyString.getText();
            if (literalText.endsWith(nodeText) && nodeText.startsWith(quotes) && firstQuoteOffset == pyString.getTextOffset() + prefixLength) {
                PsiErrorElement error = (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)pyString, PsiErrorElement.class);
                if (error == null) {
                    error = (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)pyString.getParent(), PsiErrorElement.class);
                }
                if (error != null) {
                    DocstringState docstringState = DocstringState.INCOMPLETE;
                    if (docstringState == null) {
                        PythonEnterHandler.$$$reportNull$$$0(17);
                    }
                    return docstringState;
                }
                if (nodeText.equals(quotes + quotes)) {
                    DocstringState docstringState = DocstringState.EMPTY;
                    if (docstringState == null) {
                        PythonEnterHandler.$$$reportNull$$$0(18);
                    }
                    return docstringState;
                }
                if (nodeText.length() < 6 || !nodeText.endsWith(quotes)) {
                    DocstringState docstringState = DocstringState.INCOMPLETE;
                    if (docstringState == null) {
                        PythonEnterHandler.$$$reportNull$$$0(19);
                    }
                    return docstringState;
                }
                String docstringIndent = PyIndentUtil.getLineIndent(document, document.getLineNumber(firstQuoteOffset));
                for (String line : LineTokenizer.tokenizeIntoList((CharSequence)nodeText, (boolean)false)) {
                    String lineIndent;
                    String lineContent = line.substring((lineIndent = PyIndentUtil.getLineIndent(line)).length());
                    if (!lineContent.startsWith("def ") && !lineContent.startsWith("class ") || docstringIndent.length() <= lineIndent.length() || !docstringIndent.startsWith(lineIndent)) continue;
                    DocstringState docstringState = DocstringState.INCOMPLETE;
                    if (docstringState == null) {
                        PythonEnterHandler.$$$reportNull$$$0(20);
                    }
                    return docstringState;
                }
            }
        }
        DocstringState docstringState = DocstringState.NONE;
        if (docstringState == null) {
            PythonEnterHandler.$$$reportNull$$$0(21);
        }
        return docstringState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 17, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeAtCaret";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/editor/PythonEnterHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/editor/PythonEnterHandler";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "canGenerateDocstring";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findElementToParenthesise";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parenthesise";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "postProcessEnter";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addGoogleDocStringSectionIndent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canGenerateDocstring";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 17, 18, 19, 20, 21 -> new IllegalStateException(string);
        };
    }

    static enum DocstringState {
        NONE,
        INCOMPLETE,
        EMPTY;

    }
}

