/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.CachedImageIconKt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconModelRegistry;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0003\u001b\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000bJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\t2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J(\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\t2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0016H\u0002J$\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00062\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0016H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR3\u0010\u0004\u001a'\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\n\u001a'\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistryService;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "<init>", "()V", "imageIconCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Ljavax/swing/Icon;", "imageIconModelCache", "Lcom/jetbrains/rd/ide/model/IconModel;", "imageIconCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "createIcon", "model", "createModel", "icon", "forceLightModel", "", "cacheModel", "function", "Lkotlin/Function1;", "cacheIcon", "identity", "dropCache", "", "Companion", "DefaultIconRegistry", "DefaultIconModelRegistry", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nProtocolIconRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolIconRegistry.kt\ncom/jetbrains/rd/ui/icons/ProtocolIconRegistryService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n14#2:90\n*S KotlinDebug\n*F\n+ 1 ProtocolIconRegistry.kt\ncom/jetbrains/rd/ui/icons/ProtocolIconRegistryService\n*L\n18#1:90\n*E\n"})
public final class ProtocolIconRegistryService
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<Long, Icon> imageIconCache;
    @NotNull
    private final ConcurrentMap<Icon, IconModel> imageIconModelCache;
    @NotNull
    private final AtomicLong imageIconCounter;
    @NotNull
    private static final Logger logger;

    public ProtocolIconRegistryService() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        this.imageIconCache = concurrentMap;
        ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentSoftKeySoftValueMap(...)");
        this.imageIconModelCache = concurrentMap2;
        this.imageIconCounter = new AtomicLong();
    }

    @NotNull
    public final Icon createIcon(@NotNull IconModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Icon icon = (Icon)ProtocolIconConverter.Companion.getEP_NAME().computeSafeIfAny(arg_0 -> ProtocolIconRegistryService.createIcon$lambda$0(model, this, arg_0));
        if (icon == null) {
            logger.error("Failed to deserialize an icon for model " + model);
            return CachedImageIconKt.getEMPTY_ICON();
        }
        return icon;
    }

    @Nullable
    public final IconModel createModel(@NotNull Icon icon, boolean forceLightModel) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        IconModel model = (IconModel)ProtocolIconConverter.Companion.getEP_NAME().computeSafeIfAny(arg_0 -> ProtocolIconRegistryService.createModel$lambda$1(icon, this, forceLightModel, arg_0));
        if (model == null) {
            logger.warn("Failed to serialize a model for icon " + icon);
        }
        return model;
    }

    public static /* synthetic */ IconModel createModel$default(ProtocolIconRegistryService protocolIconRegistryService, Icon icon, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return protocolIconRegistryService.createModel(icon, bl);
    }

    private final IconModel cacheModel(Icon icon, Function1<? super Long, ? extends IconModel> function) {
        return this.imageIconModelCache.computeIfAbsent(icon, arg_0 -> ProtocolIconRegistryService.cacheModel$lambda$3(arg_0 -> ProtocolIconRegistryService.cacheModel$lambda$2(function, this, arg_0), arg_0));
    }

    private final Icon cacheIcon(long identity, Function1<? super Long, ? extends Icon> function) {
        Icon icon = this.imageIconCache.computeIfAbsent(identity, arg_0 -> ProtocolIconRegistryService.cacheIcon$lambda$4(function, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"computeIfAbsent(...)");
        return icon;
    }

    public final void dropCache() {
        this.imageIconCache.clear();
        this.imageIconModelCache.clear();
    }

    private static final Icon createIcon$lambda$0(IconModel $model, ProtocolIconRegistryService this$0, ProtocolIconConverter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.createIcon($model, this$0.new DefaultIconRegistry());
    }

    private static final IconModel createModel$lambda$1(Icon $icon, ProtocolIconRegistryService this$0, boolean $forceLightModel, ProtocolIconConverter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.createModel($icon, this$0.new DefaultIconModelRegistry($forceLightModel));
    }

    private static final IconModel cacheModel$lambda$2(Function1 $function, ProtocolIconRegistryService this$0, Icon it) {
        return (IconModel)$function.invoke((Object)this$0.imageIconCounter.incrementAndGet());
    }

    private static final IconModel cacheModel$lambda$3(Function1 $tmp0, Object p0) {
        return (IconModel)$tmp0.invoke(p0);
    }

    private static final Icon cacheIcon$lambda$4(Function1 $tmp0, Object p0) {
        return (Icon)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProtocolIconRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProtocolIconRegistryService.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistryService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistryService;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nProtocolIconRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolIconRegistry.kt\ncom/jetbrains/rd/ui/icons/ProtocolIconRegistryService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,89:1\n40#2,3:90\n*S KotlinDebug\n*F\n+ 1 ProtocolIconRegistry.kt\ncom/jetbrains/rd/ui/icons/ProtocolIconRegistryService$Companion\n*L\n16#1:90,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProtocolIconRegistryService getInstance() {
            boolean $i$f$service = false;
            Class<ProtocolIconRegistryService> serviceClass$iv = ProtocolIconRegistryService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ProtocolIconRegistryService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistryService$DefaultIconModelRegistry;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconModelRegistry;", "forceLightModel", "", "<init>", "(Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistryService;Z)V", "getForceLightModel", "()Z", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "Ljavax/swing/Icon;", "cacheModel", "function", "Lkotlin/Function1;", "", "intellij.rd.platform"})
    private final class DefaultIconModelRegistry
    implements ProtocolIconModelRegistry {
        private final boolean forceLightModel;

        public DefaultIconModelRegistry(boolean forceLightModel) {
            this.forceLightModel = forceLightModel;
        }

        @Override
        public boolean getForceLightModel() {
            return this.forceLightModel;
        }

        @Override
        @Nullable
        public IconModel createModel(@NotNull Icon icon) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            return ProtocolIconRegistryService.this.createModel(icon, this.getForceLightModel());
        }

        @Override
        @Nullable
        public IconModel cacheModel(@NotNull Icon icon, @NotNull Function1<? super Long, ? extends IconModel> function) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter(function, (String)"function");
            return ProtocolIconRegistryService.this.cacheModel(icon, (Function1<? super Long, ? extends IconModel>)function);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistryService$DefaultIconRegistry;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "<init>", "(Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistryService;)V", "createIcon", "Ljavax/swing/Icon;", "model", "Lcom/jetbrains/rd/ide/model/IconModel;", "cacheIcon", "identity", "", "function", "Lkotlin/Function1;", "intellij.rd.platform"})
    private final class DefaultIconRegistry
    implements ProtocolIconRegistry {
        @Override
        @NotNull
        public Icon createIcon(@NotNull IconModel model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return ProtocolIconRegistryService.this.createIcon(model);
        }

        @Override
        @NotNull
        public Icon cacheIcon(long identity, @NotNull Function1<? super Long, ? extends Icon> function) {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            return ProtocolIconRegistryService.this.cacheIcon(identity, (Function1<? super Long, ? extends Icon>)function);
        }
    }
}

