/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.collapsing.DottedFilterEdgesGenerator;
import com.intellij.vcs.log.graph.collapsing.EdgeStorageWrapper;
import com.intellij.vcs.log.graph.impl.facade.FilteredController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphWrapper;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutBuilder;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bJ.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0007J6\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/graph/impl/facade/FirstParentController;", "", "<init>", "()V", "create", "Lcom/intellij/vcs/log/graph/impl/facade/FilteredController;", "delegateController", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;", "permanentGraphInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "matchedIds", "", "", "visibleHeadsIds", "buildCollapsedGraph", "Lcom/intellij/vcs/log/graph/collapsing/CollapsedGraph;", "linearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "startNodes", "matchedNodes", "getVisibleNodesAndHiddenEdges", "Lkotlin/Pair;", "Lcom/intellij/vcs/log/graph/utils/UnsignedBitSet;", "Lcom/intellij/vcs/log/graph/collapsing/EdgeStorageWrapper;", "intellij.platform.vcs.log.graph.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFirstParentController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirstParentController.kt\ncom/intellij/vcs/log/graph/impl/facade/FirstParentController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1869#2,2:62\n*S KotlinDebug\n*F\n+ 1 FirstParentController.kt\ncom/intellij/vcs/log/graph/impl/facade/FirstParentController\n*L\n55#1:62,2\n*E\n"})
public final class FirstParentController {
    @NotNull
    public static final FirstParentController INSTANCE = new FirstParentController();

    private FirstParentController() {
    }

    @NotNull
    public final FilteredController create(@NotNull LinearGraphController delegateController, @NotNull PermanentGraphInfo<?> permanentGraphInfo, @Nullable Set<Integer> matchedIds, @Nullable Set<Integer> visibleHeadsIds) {
        Intrinsics.checkNotNullParameter((Object)delegateController, (String)"delegateController");
        Intrinsics.checkNotNullParameter(permanentGraphInfo, (String)"permanentGraphInfo");
        LinearGraph linearGraph = permanentGraphInfo.getLinearGraph();
        Intrinsics.checkNotNullExpressionValue((Object)linearGraph, (String)"getLinearGraph(...)");
        LinearGraph linearGraph2 = linearGraph;
        Set set = visibleHeadsIds;
        if (set == null) {
            Set<Integer> set2 = permanentGraphInfo.getBranchNodeIds();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"getBranchNodeIds(...)");
            set = SetsKt.plus(set2, (Iterable)((Iterable)GraphLayoutBuilder.INSTANCE.getHeads$intellij_platform_vcs_log_graph_impl(linearGraph2)));
        }
        Set startNodes = set;
        return new FilteredController(delegateController, permanentGraphInfo, (Function0<CollapsedGraph>)((Function0)() -> FirstParentController.create$lambda$0(linearGraph2, startNodes, matchedIds)));
    }

    public static /* synthetic */ FilteredController create$default(FirstParentController firstParentController, LinearGraphController linearGraphController, PermanentGraphInfo permanentGraphInfo, Set set, Set set2, int n, Object object) {
        if ((n & 8) != 0) {
            set2 = null;
        }
        return firstParentController.create(linearGraphController, permanentGraphInfo, set, set2);
    }

    @VisibleForTesting
    @NotNull
    public final CollapsedGraph buildCollapsedGraph(@NotNull LinearGraph linearGraph, @NotNull Set<Integer> startNodes, @Nullable Set<Integer> matchedNodes) {
        Intrinsics.checkNotNullParameter((Object)linearGraph, (String)"linearGraph");
        Intrinsics.checkNotNullParameter(startNodes, (String)"startNodes");
        Pair<UnsignedBitSet, EdgeStorageWrapper> pair = this.getVisibleNodesAndHiddenEdges(linearGraph, startNodes, matchedNodes);
        UnsignedBitSet visibleNodes = (UnsignedBitSet)pair.component1();
        EdgeStorageWrapper hiddenEdges = (EdgeStorageWrapper)pair.component2();
        CollapsedGraph collapsedGraph = CollapsedGraph.newInstance(new LinearGraphWrapper(linearGraph, hiddenEdges, null, 4, null), visibleNodes);
        if (matchedNodes != null) {
            Intrinsics.checkNotNull((Object)collapsedGraph);
            DottedFilterEdgesGenerator.Companion.update(collapsedGraph, 0, collapsedGraph.getDelegatedGraph().nodesCount() - 1);
        }
        Intrinsics.checkNotNull((Object)collapsedGraph);
        return collapsedGraph;
    }

    private final Pair<UnsignedBitSet, EdgeStorageWrapper> getVisibleNodesAndHiddenEdges(LinearGraph $this$getVisibleNodesAndHiddenEdges, Set<Integer> startNodes, Set<Integer> matchedNodes) {
        UnsignedBitSet visibleNodes = new UnsignedBitSet();
        EdgeStorageWrapper hiddenEdges = EdgeStorageWrapper.createSimpleEdgeStorage();
        BitSetFlags visited = new BitSetFlags($this$getVisibleNodesAndHiddenEdges.nodesCount());
        Iterator<Integer> iterator = startNodes.iterator();
        while (iterator.hasNext()) {
            int start2 = ((Number)iterator.next()).intValue();
            if (start2 < 0) continue;
            int node = start2;
            while (node != -1 && !visited.get(node)) {
                visited.set(node, true);
                if (matchedNodes == null || matchedNodes.contains(node)) {
                    visibleNodes.set(node, true);
                }
                List<GraphEdge> downEdges = $this$getVisibleNodesAndHiddenEdges.getAdjacentEdges(node, EdgeFilter.NORMAL_DOWN);
                Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)downEdges, (int)1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GraphEdge it = (GraphEdge)element$iv;
                    boolean bl = false;
                    hiddenEdges.createEdge(it);
                }
                Object object = (GraphEdge)CollectionsKt.firstOrNull(downEdges);
                node = object != null && (object = ((GraphEdge)object).getDownNodeIndex()) != null ? (Integer)object : -1;
            }
        }
        return new Pair((Object)visibleNodes, (Object)hiddenEdges);
    }

    private static final CollapsedGraph create$lambda$0(LinearGraph $linearGraph, Set $startNodes, Set $matchedIds) {
        return INSTANCE.buildCollapsedGraph($linearGraph, $startNodes, $matchedIds);
    }
}

