/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.visualization.ui.NotebookEditorKt;
import com.intellij.notebooks.visualization.ui.providers.bounds.JupyterBoundsChangeHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.plaf.LayerUI;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0013J\b\u0010\u001c\u001a\u00020\u0015H\u0014J\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorComponentWrapper;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "overlayLines", "", "Lkotlin/Pair;", "Ljava/awt/geom/Line2D;", "Ljava/awt/Color;", "layeredPane", "Ljavax/swing/JLayer;", "Ljava/awt/Component;", "editorMouseListener", "Ljava/awt/event/MouseListener;", "editorMouseMotionListener", "Ljava/awt/event/MouseMotionListener;", "editorMouseWheelListener", "Ljava/awt/event/MouseWheelListener;", "setupGutterWrapper", "", "addEditorMouseEventListener", "l", "removeEditorMouseEventListener", "addEditorMouseMotionEvent", "removeEditorMouseMotionEvent", "addEditorMouseWheelEvent", "validateTree", "addOverlayLine", "line", "color", "removeOverlayLine", "EditorComponentWrapperLayerUI", "Companion", "intellij.notebooks.visualization"})
public final class EditorComponentWrapper
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final List<Pair<Line2D, Color>> overlayLines;
    @NotNull
    private final JLayer<Component> layeredPane;
    @Nullable
    private MouseListener editorMouseListener;
    @Nullable
    private MouseMotionListener editorMouseMotionListener;
    @Nullable
    private MouseWheelListener editorMouseWheelListener;
    @NotNull
    private static final Key<EditorComponentWrapper> EDITOR_COMPONENT_WRAPPER = new Key("EDITOR_COMPONENT_WRAPPER");

    private EditorComponentWrapper(EditorImpl editor) {
        super(new BorderLayout());
        JPanel jPanel;
        this.editor = editor;
        this.overlayLines = new ArrayList();
        this.setOpaque(false);
        JPanel $this$_init__u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$_init__u24lambda_u240.setOpaque(false);
        JViewport viewportWrapper2 = new JViewport(this){
            final /* synthetic */ EditorComponentWrapper this$0;
            {
                this.this$0 = $receiver;
            }

            public Rectangle getViewRect() {
                return EditorComponentWrapper.access$getEditor$p(this.this$0).getScrollPane().getViewport().getViewRect();
            }
        };
        viewportWrapper2.setView((Component)this.editor.getContentComponent());
        $this$_init__u24lambda_u240.add((Component)viewportWrapper2, "Center");
        JPanel editorPanel2 = jPanel;
        this.layeredPane = new JLayer<Component>(editorPanel2, new EditorComponentWrapperLayerUI());
        this.add((Component)this.layeredPane, "Center");
        this.setupGutterWrapper();
    }

    private final void setupGutterWrapper() {
        this.editor.getScrollPane().getRowHeader().setView(new JLayer<Component>(this.editor.getScrollPane().getRowHeader().getView(), new EditorComponentWrapperLayerUI()));
    }

    public final void addEditorMouseEventListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.editorMouseListener = AWTEventMulticaster.add(this.editorMouseListener, l);
    }

    public final void removeEditorMouseEventListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.editorMouseListener = AWTEventMulticaster.remove(this.editorMouseListener, l);
    }

    public final void addEditorMouseMotionEvent(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.editorMouseMotionListener = AWTEventMulticaster.add(this.editorMouseMotionListener, l);
    }

    public final void removeEditorMouseMotionEvent(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.editorMouseMotionListener = AWTEventMulticaster.remove(this.editorMouseMotionListener, l);
    }

    public final void addEditorMouseWheelEvent(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.editorMouseWheelListener = AWTEventMulticaster.add(this.editorMouseWheelListener, l);
    }

    @Override
    protected void validateTree() {
        NotebookEditorKt.getNotebookEditor((Editor)this.editor).getEditorPositionKeeper().keepScrollingPositionWhile(() -> EditorComponentWrapper.validateTree$lambda$1(this));
    }

    public final void addOverlayLine(@NotNull Line2D line, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.overlayLines.add((Pair<Line2D, Color>)TuplesKt.to((Object)line, (Object)color));
        this.layeredPane.repaint();
    }

    public final void removeOverlayLine(@NotNull Line2D line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.overlayLines.removeIf(arg_0 -> EditorComponentWrapper.removeOverlayLine$lambda$3(arg_0 -> EditorComponentWrapper.removeOverlayLine$lambda$2(line, arg_0), arg_0));
        this.layeredPane.repaint();
    }

    private static final Unit validateTree$lambda$1(EditorComponentWrapper this$0) {
        JupyterBoundsChangeHandler.Companion.get((Editor)this$0.editor).postponeUpdates();
        super.validateTree();
        JupyterBoundsChangeHandler.Companion.get((Editor)this$0.editor).schedulePerformPostponed();
        return Unit.INSTANCE;
    }

    private static final boolean removeOverlayLine$lambda$2(Line2D $line, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getFirst(), (Object)$line);
    }

    private static final boolean removeOverlayLine$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public /* synthetic */ EditorComponentWrapper(EditorImpl editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    public static final /* synthetic */ EditorImpl access$getEditor$p(EditorComponentWrapper $this) {
        return $this.editor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorComponentWrapper$Companion;", "", "<init>", "()V", "EDITOR_COMPONENT_WRAPPER", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/notebooks/visualization/ui/EditorComponentWrapper;", "install", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "get", "Lcom/intellij/openapi/editor/Editor;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditorComponentWrapper install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            EditorComponentWrapper wrapper = new EditorComponentWrapper(editor, null);
            editor.getScrollPane().getViewport().setView(wrapper);
            editor.putUserData(EDITOR_COMPONENT_WRAPPER, (Object)wrapper);
            return wrapper;
        }

        @NotNull
        public final EditorComponentWrapper get(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Object object = editor.getUserData(EDITOR_COMPONENT_WRAPPER);
            Intrinsics.checkNotNull((Object)object);
            return (EditorComponentWrapper)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0011H\u0014J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0011H\u0014J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00142\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0011H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorComponentWrapper$EditorComponentWrapperLayerUI;", "Ljavax/swing/plaf/LayerUI;", "Ljava/awt/Component;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorComponentWrapper;)V", "installUI", "", "c", "Ljavax/swing/JComponent;", "uninstallUI", "paint", "g", "Ljava/awt/Graphics;", "processMouseEvent", "e", "Ljava/awt/event/MouseEvent;", "layer", "Ljavax/swing/JLayer;", "processMouseMotionEvent", "processMouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "intellij.notebooks.visualization"})
    @SourceDebugExtension(value={"SMAP\nEditorComponentWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorComponentWrapper.kt\ncom/intellij/notebooks/visualization/ui/EditorComponentWrapper$EditorComponentWrapperLayerUI\n+ 2 NotebookVisualizationUiUtil.kt\ncom/intellij/notebooks/visualization/NotebookVisualizationUiUtilKt\n*L\n1#1,155:1\n22#2,8:156\n*S KotlinDebug\n*F\n+ 1 EditorComponentWrapper.kt\ncom/intellij/notebooks/visualization/ui/EditorComponentWrapper$EditorComponentWrapperLayerUI\n*L\n74#1:156,8\n*E\n"})
    public final class EditorComponentWrapperLayerUI
    extends LayerUI<Component> {
        @Override
        public void installUI(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            super.installUI(c);
            JLayer layer = (JLayer)c;
            layer.setLayerEventMask(131120L);
        }

        @Override
        public void uninstallUI(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            super.uninstallUI(c);
            JLayer layer = (JLayer)c;
            layer.setLayerEventMask(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent c) {
            void $this$useG2D$iv;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            super.paint(g, c);
            Graphics graphics = g;
            EditorComponentWrapper editorComponentWrapper = EditorComponentWrapper.this;
            boolean $i$f$useG2D = false;
            Graphics graphics2 = $this$useG2D$iv.create();
            Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d$iv = (Graphics2D)graphics2;
            try {
                Graphics2D g2d = g2d$iv;
                boolean bl = false;
                for (Pair pair : editorComponentWrapper.overlayLines) {
                    Line2D line = (Line2D)pair.component1();
                    Color color = (Color)pair.component2();
                    g2d.setColor(color);
                    g2d.draw(line);
                }
            }
            finally {
                g2d$iv.dispose();
            }
        }

        @Override
        protected void processMouseEvent(@NotNull MouseEvent e, @NotNull JLayer<? extends Component> layer) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter(layer, (String)"layer");
            switch (e.getID()) {
                case 501: {
                    MouseListener mouseListener2 = EditorComponentWrapper.this.editorMouseListener;
                    if (mouseListener2 != null) {
                        mouseListener2.mousePressed(e);
                    }
                    break;
                }
                case 502: {
                    MouseListener mouseListener3 = EditorComponentWrapper.this.editorMouseListener;
                    if (mouseListener3 != null) {
                        mouseListener3.mouseReleased(e);
                    }
                    break;
                }
                case 500: {
                    MouseListener mouseListener4 = EditorComponentWrapper.this.editorMouseListener;
                    if (mouseListener4 != null) {
                        mouseListener4.mouseClicked(e);
                    }
                    break;
                }
                case 504: {
                    MouseListener mouseListener5 = EditorComponentWrapper.this.editorMouseListener;
                    if (mouseListener5 != null) {
                        mouseListener5.mouseEntered(e);
                    }
                    break;
                }
                case 505: {
                    MouseListener mouseListener6 = EditorComponentWrapper.this.editorMouseListener;
                    if (mouseListener6 == null) break;
                    mouseListener6.mouseExited(e);
                    break;
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(@NotNull MouseEvent e, @NotNull JLayer<? extends Component> layer) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter(layer, (String)"layer");
            switch (e.getID()) {
                case 503: {
                    MouseMotionListener mouseMotionListener = EditorComponentWrapper.this.editorMouseMotionListener;
                    if (mouseMotionListener != null) {
                        mouseMotionListener.mouseMoved(e);
                    }
                    break;
                }
                case 506: {
                    MouseMotionListener mouseMotionListener = EditorComponentWrapper.this.editorMouseMotionListener;
                    if (mouseMotionListener == null) break;
                    mouseMotionListener.mouseDragged(e);
                    break;
                }
            }
        }

        @Override
        protected void processMouseWheelEvent(@NotNull MouseWheelEvent e, @NotNull JLayer<? extends Component> layer) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter(layer, (String)"layer");
                MouseWheelListener mouseWheelListener = EditorComponentWrapper.this.editorMouseWheelListener;
                if (mouseWheelListener == null) break block0;
                mouseWheelListener.mouseWheelMoved(e);
            }
        }
    }
}

