/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui.providers.bounds;

import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesEvent;
import com.intellij.notebooks.visualization.NotebookVisualizationCoroutine;
import com.intellij.notebooks.visualization.ui.providers.bounds.JupyterBoundsChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.Topic;
import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\rJ\u0006\u0010\u0019\u001a\u00020\u0012J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\u0006\u0010\u001b\u001a\u00020\u0012J\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0012J\u0016\u0010\u001e\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/intellij/notebooks/visualization/ui/providers/bounds/JupyterBoundsChangeHandler;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "isDelayed", "", "isShouldBeRecalculated", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/notebooks/visualization/ui/providers/bounds/JupyterBoundsChangeListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "eventFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "getEventFlow", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "dispose", "subscribe", "parentDisposable", "listener", "boundsChanged", "notifyBoundsChanged", "postponeUpdates", "performPostponed", "schedulePerformPostponed", "finishDelayAndDoIfShouldBeRecalculated", "block", "Lkotlin/Function0;", "Companion", "intellij.notebooks.visualization"})
public final class JupyterBoundsChangeHandler
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    private boolean isDelayed;
    private boolean isShouldBeRecalculated;
    @NotNull
    private final EventDispatcher<JupyterBoundsChangeListener> dispatcher;
    @NotNull
    private final MutableSharedFlow<Unit> eventFlow;
    @NotNull
    private static final Key<JupyterBoundsChangeHandler> INSTANCE_KEY = new Key("INLAYS_CHANGE_HANDLER");

    public JupyterBoundsChangeHandler(@NotNull EditorImpl editor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            EventDispatcher eventDispatcher = EventDispatcher.create(JupyterBoundsChangeListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
            this.dispatcher = eventDispatcher;
            this.eventFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
            this.editor.addPropertyChangeListener(arg_0 -> JupyterBoundsChangeHandler._init_$lambda$0(this, arg_0), (Disposable)this);
            this.editor.getSoftWrapModel().addSoftWrapChangeListener(new SoftWrapChangeListener(){

                public void softWrapsChanged() {
                }

                public void recalculationEnds() {
                    if (this.getEditor().getDocument().isInEventsHandling()) {
                        return;
                    }
                    if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                        this.boundsChanged();
                    } else {
                        this.schedulePerformPostponed();
                    }
                }
            });
            this.editor.getFoldingModel().addListener(new FoldingListener(){

                public void onFoldRegionStateChange(FoldRegion region) {
                    Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                    this.boundsChanged();
                }

                public void onFoldProcessingEnd() {
                    this.boundsChanged();
                }

                public void onCustomFoldRegionPropertiesChange(CustomFoldRegion region, int flags) {
                    Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                    this.boundsChanged();
                }
            }, (Disposable)this);
            NotebookCellLines.Companion.get((Editor)this.editor).getIntervalListeners().addListener((EventListener)new NotebookCellLines.IntervalListener(){

                @Override
                public void documentChanged(NotebookCellLinesEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (event.isIntervalsChanged()) {
                        this.boundsChanged();
                    }
                }
            }, this.editor.getDisposable());
            this.editor.getInlayModel().addListener(new InlayModel.Listener(){

                public void onBatchModeFinish(Editor editor) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    this.boundsChanged();
                }

                public void onAdded(Inlay<?> inlay) {
                    Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                    if (inlay.getHeightInPixels() == 0) {
                        return;
                    }
                    this.recalculateIfNotBatch();
                }

                public void onUpdated(Inlay<?> inlay, int changeFlags) {
                    Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                    if ((changeFlags & 2) != 0) {
                        this.recalculateIfNotBatch();
                    }
                }

                public void onRemoved(Inlay<?> inlay) {
                    Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                    this.recalculateIfNotBatch();
                }

                private final void recalculateIfNotBatch() {
                    if (this.getEditor().getInlayModel().isInBatchMode()) {
                        return;
                    }
                    if (this.getEditor().getDocument().isInEventsHandling()) {
                        return;
                    }
                    this.boundsChanged();
                }
            }, (Disposable)this);
            Project project = this.editor.getProject();
            if (project == null || (project = project.getMessageBus()) == null || (project = project.connect((Disposable)this)) == null) break block0;
            Topic topic = ToolWindowManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            project.subscribe(topic, (Object)new ToolWindowManagerListener(){

                public void stateChanged() {
                    this.boundsChanged();
                }
            });
        }
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final MutableSharedFlow<Unit> getEventFlow() {
        return this.eventFlow;
    }

    public void dispose() {
    }

    public final void subscribe(@NotNull Disposable parentDisposable, @NotNull JupyterBoundsChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.dispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public final void boundsChanged() {
        if (this.isDelayed) {
            this.isShouldBeRecalculated = true;
            return;
        }
        this.notifyBoundsChanged();
    }

    private final void notifyBoundsChanged() {
        if (this.editor.isDisposed()) {
            return;
        }
        ((JupyterBoundsChangeListener)this.dispatcher.getMulticaster()).boundsChanged();
        NotebookVisualizationCoroutine.Utils.INSTANCE.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JupyterBoundsChangeHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getEventFlow().emit((Object)Unit.INSTANCE, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void postponeUpdates() {
        this.isDelayed = true;
        this.isShouldBeRecalculated = false;
    }

    public final void performPostponed() {
        this.finishDelayAndDoIfShouldBeRecalculated((Function0<Unit>)((Function0)() -> JupyterBoundsChangeHandler.performPostponed$lambda$1(this)));
    }

    public final void schedulePerformPostponed() {
        this.finishDelayAndDoIfShouldBeRecalculated((Function0<Unit>)((Function0)() -> JupyterBoundsChangeHandler.schedulePerformPostponed$lambda$3(this)));
    }

    private final void finishDelayAndDoIfShouldBeRecalculated(Function0<Unit> block) {
        this.isDelayed = false;
        if (this.isShouldBeRecalculated) {
            this.isShouldBeRecalculated = false;
            block.invoke();
        }
    }

    private static final void _init_$lambda$0(JupyterBoundsChangeHandler this$0, PropertyChangeEvent propertyChangeEvent) {
        this$0.boundsChanged();
    }

    private static final Unit performPostponed$lambda$1(JupyterBoundsChangeHandler this$0) {
        this$0.notifyBoundsChanged();
        return Unit.INSTANCE;
    }

    private static final void schedulePerformPostponed$lambda$3$lambda$2(JupyterBoundsChangeHandler this$0) {
        this$0.notifyBoundsChanged();
    }

    private static final Unit schedulePerformPostponed$lambda$3(JupyterBoundsChangeHandler this$0) {
        SwingUtilities.invokeLater(() -> JupyterBoundsChangeHandler.schedulePerformPostponed$lambda$3$lambda$2(this$0));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/notebooks/visualization/ui/providers/bounds/JupyterBoundsChangeHandler$Companion;", "", "<init>", "()V", "INSTANCE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/notebooks/visualization/ui/providers/bounds/JupyterBoundsChangeHandler;", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "get", "Lcom/intellij/openapi/editor/Editor;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            JupyterBoundsChangeHandler updater = new JupyterBoundsChangeHandler(editor);
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)updater);
            editor.putUserData(INSTANCE_KEY, (Object)updater);
        }

        @NotNull
        public final JupyterBoundsChangeHandler get(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Object object = INSTANCE_KEY.get((UserDataHolder)editor);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (JupyterBoundsChangeHandler)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

