/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.impl.DiffEditorTitleDetails;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffNotificationProvider;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.DiffTitleWithDetailsCustomizers;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DiffShelvedChangesActionProvider
implements AnActionExtensionProvider {
    private static final Logger LOG = Logger.getInstance(DiffShelvedChangesActionProvider.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(1);
        }
        return e.getData(ShelvedChangesViewManager.SHELVED_CHANGES_TREE) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(2);
        }
        DiffShelvedChangesActionProvider.updateAvailability(e);
    }

    public static void updateAvailability(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(3);
        }
        e.getPresentation().setEnabled(DiffShelvedChangesActionProvider.isEnabled(e.getDataContext()));
        boolean shouldBeHidden = ExperimentalUI.isNewUI() && e.isFromActionToolbar();
        e.getPresentation().setVisible(!shouldBeHidden);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(4);
        }
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(e.getDataContext());
    }

    public static boolean isEnabled(DataContext dc) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return false;
        }
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dc);
        return changeLists.size() == 1;
    }

    public static void showShelvedChangesDiff(DataContext dc) {
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(dc, false);
    }

    @Nullable
    public static ListSelection<? extends ChangeDiffRequestChain.Producer> createDiffProducers(@NotNull Project project, boolean withLocal, ListSelection<ShelvedWrapper> selection) {
        if (project == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(5);
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return null;
        }
        String base = project.getBasePath();
        if (base == null) {
            LOG.error("No base path for project " + String.valueOf(project));
            return null;
        }
        ApplyPatchContext patchContext = new ApplyPatchContext(project.getBaseDir(), 0, false, false);
        return selection.map(s -> DiffShelvedChangesActionProvider.createDiffProducer(project, base, patchContext, s, withLocal));
    }

    @Nullable
    public static ChangeDiffRequestChain.Producer createDiffProducer(@NotNull Project project, @NotNull ShelvedWrapper shelvedWrapper, boolean withLocal) {
        if (project == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(6);
        }
        if (shelvedWrapper == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(7);
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return null;
        }
        String base = project.getBasePath();
        if (base == null) {
            LOG.error("No base path for project " + String.valueOf(project));
            return null;
        }
        ApplyPatchContext patchContext = new ApplyPatchContext(project.getBaseDir(), 0, false, false);
        return DiffShelvedChangesActionProvider.createDiffProducer(project, base, patchContext, shelvedWrapper, withLocal);
    }

    @Nullable
    private static ChangeDiffRequestChain.Producer createDiffProducer(@NotNull Project project, @NotNull String base, @NotNull ApplyPatchContext patchContext, @NotNull ShelvedWrapper shelvedWrapper, boolean withLocal) {
        ShelvedChange textChange;
        if (project == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(8);
        }
        if (base == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(9);
        }
        if (patchContext == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(10);
        }
        if (shelvedWrapper == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(11);
        }
        if ((textChange = shelvedWrapper.getShelvedChange()) != null) {
            return DiffShelvedChangesActionProvider.processTextChange(project, base, patchContext, textChange, withLocal);
        }
        ShelvedBinaryFile binaryChange = shelvedWrapper.getBinaryFile();
        if (binaryChange != null) {
            return DiffShelvedChangesActionProvider.processBinaryChange(project, base, binaryChange);
        }
        return null;
    }

    public static void showShelvedChangesDiff(@NotNull DataContext dc, boolean withLocal) {
        Project project;
        if (dc == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(12);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dc)) == null) {
            return;
        }
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(project, withLocal, ShelvedChangesViewManager.getSelectedChangesOrAll(dc));
    }

    public static void showShelvedChangesDiff(@NotNull Project project, boolean withLocal, ListSelection<ShelvedWrapper> selection) {
        ListSelection<? extends ChangeDiffRequestChain.Producer> diffRequestProducers;
        if (project == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(13);
        }
        if ((diffRequestProducers = DiffShelvedChangesActionProvider.createDiffProducers(project, withLocal, selection)) == null || diffRequestProducers.isEmpty()) {
            return;
        }
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(diffRequestProducers);
        chain.putUserData(PatchesPreloader.SHELF_PRELOADER, new PatchesPreloader(project));
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.FRAME);
    }

    private static ShelveDiffRequestProducer processBinaryChange(@NotNull Project project, @NotNull String base, @NotNull ShelvedBinaryFile shelvedChange) {
        if (project == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(14);
        }
        if (base == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(15);
        }
        if (shelvedChange == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(16);
        }
        File file = new File(base, shelvedChange.AFTER_PATH == null ? shelvedChange.BEFORE_PATH : shelvedChange.AFTER_PATH);
        FilePath filePath = VcsUtil.getFilePath((File)file, (boolean)false);
        return new BinaryShelveDiffRequestProducer(project, shelvedChange, filePath);
    }

    private static ShelveDiffRequestProducer processTextChange(@NotNull Project project, @NotNull String base, @NotNull ApplyPatchContext patchContext, @NotNull ShelvedChange shelvedChange, boolean withLocal) {
        if (project == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(17);
        }
        if (base == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(18);
        }
        if (patchContext == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(19);
        }
        if (shelvedChange == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(20);
        }
        String beforePath = shelvedChange.getBeforePath();
        String afterPath = shelvedChange.getAfterPath();
        FilePath filePath = VcsUtil.getFilePath((File)new File(base, afterPath), (boolean)false);
        try {
            if (FileStatus.ADDED.equals(shelvedChange.getFileStatus())) {
                return new NewFileTextShelveDiffRequestProducer(project, shelvedChange, filePath, withLocal);
            }
            VirtualFile file = ApplyFilePatchBase.findPatchTarget(patchContext, beforePath, afterPath);
            if (file == null || !file.exists()) {
                throw new FileNotFoundException(beforePath);
            }
            return new TextShelveDiffRequestProducer(project, shelvedChange, filePath, file, patchContext, withLocal);
        }
        catch (IOException e) {
            return new PatchShelveDiffRequestProducer(project, shelvedChange, filePath);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedWrapper";
                break;
            }
            case 9: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dc";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateAvailability";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDiffProducers";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDiffProducer";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showShelvedChangesDiff";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processBinaryChange";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processTextChange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }

    private static abstract class ShelveDiffRequestProducer
    implements ChangeDiffRequestChain.Producer {
        @NotNull
        protected final FilePath myFilePath;

        ShelveDiffRequestProducer(@NotNull FilePath filePath) {
            if (filePath == null) {
                ShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            this.myFilePath = filePath;
        }

        @Nullable
        public ShelvedChange getTextChange() {
            return null;
        }

        @Nullable
        public ShelvedBinaryFile getBinaryChange() {
            return null;
        }

        @NotNull
        public String getName() {
            String string = FileUtil.toSystemDependentName((String)this.getFilePath().getPath());
            if (string == null) {
                ShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NlsContexts.DialogTitle
        @NotNull
        public String getRequestTitle() {
            ShelvedChange textChange = this.getTextChange();
            Change change = textChange != null ? textChange.getChange() : null;
            String string = change != null ? ChangeDiffRequestProducer.getRequestTitle(change) : this.getName();
            if (string == null) {
                ShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                ShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            return filePath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$ShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$ShelveDiffRequestProducer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequestTitle";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static final class PatchesPreloader {
        public static final Key<PatchesPreloader> SHELF_PRELOADER = Key.create((String)"DiffShelvedChangesActionProvider.PatchesPreloader");
        private final Project myProject;
        private final SoftHardCacheMap<Path, PatchInfo> myFilePatchesMap = new SoftHardCacheMap(5, 5);
        private final ReadWriteLock myLock = new ReentrantReadWriteLock(true);

        public PatchesPreloader(Project project) {
            this.myProject = project;
        }

        @NotNull
        public static PatchesPreloader getPatchesPreloader(@NotNull Project project, @NotNull UserDataHolder context) {
            PatchesPreloader preloader;
            if (project == null) {
                PatchesPreloader.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PatchesPreloader.$$$reportNull$$$0(1);
            }
            if ((preloader = (PatchesPreloader)context.getUserData(SHELF_PRELOADER)) != null) {
                PatchesPreloader patchesPreloader = preloader;
                if (patchesPreloader == null) {
                    PatchesPreloader.$$$reportNull$$$0(2);
                }
                return patchesPreloader;
            }
            return new PatchesPreloader(project);
        }

        @RequiresBackgroundThread
        @NotNull
        public TextFilePatch getPatch(@NotNull ShelvedChange shelvedChange) throws VcsException {
            if (shelvedChange == null) {
                PatchesPreloader.$$$reportNull$$$0(3);
            }
            ThreadingAssertions.assertBackgroundThread();
            TextFilePatch textFilePatch = (TextFilePatch)this.getPatchWithContext((ShelvedChange)shelvedChange).first;
            if (textFilePatch == null) {
                PatchesPreloader.$$$reportNull$$$0(4);
            }
            return textFilePatch;
        }

        @RequiresBackgroundThread
        @NotNull
        public Pair<TextFilePatch, CommitContext> getPatchWithContext(@NotNull ShelvedChange shelvedChange) throws VcsException {
            PatchInfo patchInfo;
            if (shelvedChange == null) {
                PatchesPreloader.$$$reportNull$$$0(5);
            }
            ThreadingAssertions.assertBackgroundThread();
            Path patchPath = shelvedChange.getPatchPath();
            if (this.getInfoFromCache(patchPath) == null || this.isPatchFileChanged(patchPath)) {
                this.readFilePatchAndUpdateCaches(patchPath);
            }
            if ((patchInfo = this.getInfoFromCache(patchPath)) != null) {
                for (TextFilePatch textFilePatch : patchInfo.myTextFilePatches) {
                    if (!shelvedChange.getBeforePath().equals(textFilePatch.getBeforeName())) continue;
                    Pair pair = Pair.create((Object)textFilePatch, (Object)patchInfo.myCommitContext);
                    if (pair == null) {
                        PatchesPreloader.$$$reportNull$$$0(6);
                    }
                    return pair;
                }
            }
            throw new VcsException(VcsBundle.message((String)"changes.can.not.find.patch.for.path.in.patch.file", (Object[])new Object[]{shelvedChange.getBeforePath()}));
        }

        private PatchInfo getInfoFromCache(@NotNull Path patchPath) {
            if (patchPath == null) {
                PatchesPreloader.$$$reportNull$$$0(7);
            }
            try {
                this.myLock.readLock().lock();
                PatchInfo patchInfo = (PatchInfo)this.myFilePatchesMap.get((Object)patchPath);
                return patchInfo;
            }
            finally {
                this.myLock.readLock().unlock();
            }
        }

        private void readFilePatchAndUpdateCaches(@NotNull Path patchPath) throws VcsException {
            if (patchPath == null) {
                PatchesPreloader.$$$reportNull$$$0(8);
            }
            try {
                this.myLock.writeLock().lock();
                CommitContext commitContext = new CommitContext();
                List<TextFilePatch> patches = ShelveChangesManager.loadPatches(this.myProject, patchPath, commitContext);
                long timestamp = Files.getLastModifiedTime(patchPath, new LinkOption[0]).toMillis();
                this.myFilePatchesMap.put((Object)patchPath, (Object)new PatchInfo(patches, commitContext, timestamp));
            }
            catch (PatchSyntaxException | IOException e) {
                throw new VcsException((Throwable)e);
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }

        public boolean isPatchFileChanged(@NotNull Path patchPath) {
            PatchInfo patchInfo;
            if (patchPath == null) {
                PatchesPreloader.$$$reportNull$$$0(9);
            }
            if ((patchInfo = this.getInfoFromCache(patchPath)) == null) {
                return false;
            }
            try {
                return Files.getLastModifiedTime(patchPath, new LinkOption[0]).toMillis() != patchInfo.myLoadedTimeStamp;
            }
            catch (IOException e) {
                return false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedChange";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatchesPreloader";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatch";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatchWithContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPatchesPreloader";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPatch";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getPatchWithContext";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getInfoFromCache";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "readFilePatchAndUpdateCaches";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isPatchFileChanged";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 6 -> new IllegalStateException(string);
            };
        }

        private static final class PatchInfo {
            private final long myLoadedTimeStamp;
            @NotNull
            private final List<TextFilePatch> myTextFilePatches;
            @NotNull
            private final CommitContext myCommitContext;

            PatchInfo(@NotNull List<TextFilePatch> patches, @NotNull CommitContext commitContext, long loadedTimeStamp) {
                if (patches == null) {
                    PatchInfo.$$$reportNull$$$0(0);
                }
                if (commitContext == null) {
                    PatchInfo.$$$reportNull$$$0(1);
                }
                this.myTextFilePatches = patches;
                this.myCommitContext = commitContext;
                this.myLoadedTimeStamp = loadedTimeStamp;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "patches";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "commitContext";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader$PatchInfo";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class BinaryShelveDiffRequestProducer
    extends ShelveDiffRequestProducer {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ShelvedBinaryFile myBinaryChange;

        BinaryShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedBinaryFile change, @NotNull FilePath filePath) {
            if (project == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            super(filePath);
            this.myBinaryChange = change;
            this.myProject = project;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (context == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            Change change = this.myBinaryChange.createChange(this.myProject);
            DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(this.myProject, change, this.getName(), context, indicator);
            if (diffRequest == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(5);
            }
            return diffRequest;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.myBinaryChange.getFileStatus();
            if (fileStatus == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(6);
            }
            return fileStatus;
        }

        @Override
        @NotNull
        public ShelvedBinaryFile getBinaryChange() {
            ShelvedBinaryFile shelvedBinaryFile = this.myBinaryChange;
            if (shelvedBinaryFile == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(7);
            }
            return shelvedBinaryFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$BinaryShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$BinaryShelveDiffRequestProducer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBinaryChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class NewFileTextShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        private final boolean myWithLocal;

        NewFileTextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, boolean withLocal) {
            if (project == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            super(project, change, filePath);
            this.myWithLocal = withLocal;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (context == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            VirtualFile file = this.myFilePath.getVirtualFile();
            if (this.myWithLocal && file != null) {
                DiffRequest diffRequest;
                try {
                    PatchesPreloader preloader = PatchesPreloader.getPatchesPreloader(this.myProject, context);
                    TextFilePatch patch = preloader.getPatch(this.myChange);
                    DiffContentFactory contentFactory = DiffContentFactory.getInstance();
                    DiffContent leftContent = contentFactory.create(this.myProject, file);
                    DocumentContent rightContent = contentFactory.create(this.myProject, patch.getSingleHunkPatchText(), file);
                    String leftTitle = DiffBundle.message((String)"merge.version.title.current", (Object[])new Object[0]);
                    String rightTitle = VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]);
                    SimpleDiffRequest request = new SimpleDiffRequest(this.getRequestTitle(), leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
                    List<DiffEditorTitleCustomizer> titleCustomizers = DiffTitleWithDetailsCustomizers.getTitleCustomizers(this.myProject, this.myChange.getChange(), leftTitle, rightTitle);
                    diffRequest = DiffUtil.addTitleCustomizers((DiffRequest)request, titleCustomizers);
                }
                catch (VcsException e) {
                    throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.can.t.show.diff.for", (Object[])new Object[]{this.getFilePath()}), (Throwable)e);
                }
                if (diffRequest == null) {
                    NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(5);
                }
                return diffRequest;
            }
            DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(this.myProject, this.myChange.getChange(), this.getName(), context, indicator);
            if (diffRequest == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(6);
            }
            return diffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$NewFileTextShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$NewFileTextShelveDiffRequestProducer";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class TextShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final ApplyPatchContext myPatchContext;
        private final boolean myWithLocal;

        TextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull VirtualFile file, @NotNull ApplyPatchContext patchContext, boolean withLocal) {
            if (project == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            if (file == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            if (patchContext == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            super(project, change, filePath);
            this.myFile = file;
            this.myPatchContext = patchContext;
            this.myWithLocal = withLocal;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            DiffRequest diffRequest;
            if (context == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(5);
            }
            if (indicator == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(6);
            }
            if (FileTypeRegistry.getInstance().isFileOfType(this.myFile, UnknownFileType.INSTANCE)) {
                return new UnknownFileTypeDiffRequest(this.myFile, this.getName());
            }
            try {
                PatchesPreloader preloader = PatchesPreloader.getPatchesPreloader(this.myProject, context);
                Pair<TextFilePatch, CommitContext> pair = preloader.getPatchWithContext(this.myChange);
                TextFilePatch patch = (TextFilePatch)pair.first;
                CommitContext commitContext = (CommitContext)pair.second;
                if (patch.isDeletedFile()) {
                    return this.createDiffRequestForDeleted(patch);
                }
                String path = (String)ObjectUtils.chooseNotNull((Object)patch.getAfterName(), (Object)patch.getBeforeName());
                String baseContents = BaseRevisionTextPatchEP.getBaseContent(this.myProject, path, commitContext);
                ApplyPatchForBaseRevisionTexts texts = ApplyPatchForBaseRevisionTexts.create(this.myProject, this.myFile, this.myPatchContext.getPathBeforeRename(this.myFile), patch, baseContents);
                if (texts.isBaseRevisionLoaded()) {
                    assert (!texts.isAppliedSomehow());
                    return this.createDiffRequestUsingBase(texts);
                }
                diffRequest = this.createDiffRequestUsingLocal(texts, patch, context, indicator);
            }
            catch (VcsException e) {
                throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.can.t.show.diff.for", (Object[])new Object[]{this.getFilePath()}), (Throwable)e);
            }
            if (diffRequest == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(7);
            }
            return diffRequest;
        }

        @NotNull
        private DiffRequest createDiffRequestForDeleted(@NotNull TextFilePatch patch) {
            String leftTitle;
            DiffContent leftContent;
            if (patch == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(8);
            }
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            if (this.myWithLocal) {
                leftContent = contentFactory.create(this.myProject, this.myFile);
                leftTitle = DiffBundle.message((String)"merge.version.title.current", (Object[])new Object[0]);
            } else {
                leftContent = contentFactory.create(this.myProject, patch.getSingleHunkPatchText(), this.myFile);
                leftTitle = VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]);
            }
            EmptyContent rightContent = contentFactory.createEmpty();
            String rightTitle = null;
            SimpleDiffRequest request = new SimpleDiffRequest(this.getRequestTitle(), leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
            DiffRequest diffRequest = DiffUtil.addTitleCustomizers((DiffRequest)request, (DiffEditorTitleCustomizer[])new DiffEditorTitleCustomizer[]{DiffEditorTitleDetails.create((Project)this.myProject, (FilePath)VcsUtil.getFilePath((VirtualFile)this.myFile), (String)leftTitle).getCustomizer(), DiffEditorTitleCustomizer.EMPTY});
            if (diffRequest == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(9);
            }
            return diffRequest;
        }

        @NotNull
        private DiffRequest createDiffRequestUsingBase(@NotNull ApplyPatchForBaseRevisionTexts texts) {
            String leftTitle;
            DiffContent leftContent;
            if (texts == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(10);
            }
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            if (this.myWithLocal) {
                leftContent = contentFactory.create(this.myProject, this.myFile);
                leftTitle = DiffBundle.message((String)"merge.version.title.current", (Object[])new Object[0]);
            } else {
                leftContent = contentFactory.create(this.myProject, Objects.requireNonNull(texts.getBase()), this.myFile);
                leftTitle = DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
            }
            DocumentContent rightContent = contentFactory.create(this.myProject, texts.getPatched(), this.myFile);
            SimpleDiffRequest request = new SimpleDiffRequest(this.getRequestTitle(), leftContent, (DiffContent)rightContent, leftTitle, VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]));
            DiffRequest diffRequest = DiffUtil.addTitleCustomizers((DiffRequest)request, (DiffEditorTitleCustomizer[])new DiffEditorTitleCustomizer[]{DiffEditorTitleDetails.create((Project)this.myProject, (FilePath)VcsUtil.getFilePath((VirtualFile)this.myFile), (String)leftTitle).getCustomizer(), DiffEditorTitleCustomizer.EMPTY});
            if (diffRequest == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(11);
            }
            return diffRequest;
        }

        private DiffRequest createDiffRequestUsingLocal(@NotNull ApplyPatchForBaseRevisionTexts texts, @NotNull TextFilePatch patch, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
            DiffRequest diffRequest;
            if (texts == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(12);
            }
            if (patch == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(13);
            }
            if (context == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(14);
            }
            if (indicator == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(15);
            }
            DiffRequest diffRequest2 = diffRequest = this.myChange.isConflictingChange() ? PatchDiffRequestFactory.createConflictDiffRequest(this.myProject, this.myFile, patch, VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]), texts, this.getName()) : PatchDiffRequestFactory.createDiffRequest(this.myProject, this.myChange.getChange(), this.getName(), context, indicator);
            if (!this.myWithLocal) {
                DiffUtil.addNotification((DiffNotificationProvider)DiffNotifications.createNotificationProvider((String)VcsBundle.message((String)"shelve.base.content.not.found.or.not.applicable.error", (Object[])new Object[0])), (UserDataHolder)diffRequest);
            }
            return diffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 9, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchContext";
                    break;
                }
                case 5: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 7: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$TextShelveDiffRequestProducer";
                    break;
                }
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patch";
                    break;
                }
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "texts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$TextShelveDiffRequestProducer";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDiffRequestForDeleted";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDiffRequestUsingBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 7: 
                case 9: 
                case 11: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createDiffRequestForDeleted";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createDiffRequestUsingBase";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createDiffRequestUsingLocal";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 9, 11 -> new IllegalStateException(string);
            };
        }
    }

    private static class PatchShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        PatchShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath) {
            if (project == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            super(project, change, filePath);
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
            PatchDiffRequest patchDiffRequest;
            if (context == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            try {
                PatchesPreloader preloader = PatchesPreloader.getPatchesPreloader(this.myProject, context);
                TextFilePatch patch = preloader.getPatch(this.myChange);
                String leftTitle = DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
                String rightTitle = VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]);
                PatchDiffRequest request = new PatchDiffRequest(patch, this.getRequestTitle(), leftTitle, rightTitle);
                DiffUtil.addNotification((DiffNotificationProvider)DiffNotifications.createNotificationProvider((String)DiffBundle.message((String)"cannot.find.file.error", (Object[])new Object[]{this.getFilePath()})), (UserDataHolder)request);
                patchDiffRequest = request;
            }
            catch (VcsException e) {
                throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.can.t.show.diff.for", (Object[])new Object[]{this.getFilePath()}), (Throwable)e);
            }
            if (patchDiffRequest == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(5);
            }
            return patchDiffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchShelveDiffRequestProducer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class BaseTextShelveDiffRequestProducer
    extends ShelveDiffRequestProducer {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final ShelvedChange myChange;

        BaseTextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath) {
            if (project == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            super(filePath);
            this.myChange = change;
            this.myProject = project;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.myChange.getFileStatus();
            if (fileStatus == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            return fileStatus;
        }

        @Override
        @NotNull
        public ShelvedChange getTextChange() {
            ShelvedChange shelvedChange = this.myChange;
            if (shelvedChange == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            return shelvedChange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$BaseTextShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$BaseTextShelveDiffRequestProducer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

