/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.xml;

import com.intellij.application.options.CodeStyle;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.HtmlUtilsKt;
import com.intellij.lang.Language;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class XmlTextExtractor
extends TextExtractor {
    private static final TextContentBuilder builder = TextContentBuilder.FromPsi.removingIndents(" \t").removingLineSuffixes(" \t");
    private final Set<Class<? extends Language>> myEnabledDialects;

    protected XmlTextExtractor(Class<? extends Language> ... enabledDialects) {
        this.myEnabledDialects = Set.of(enabledDialects);
    }

    protected Function<XmlTag, TagKind> tagClassifier(@NotNull PsiElement context) {
        if (context == null) {
            XmlTextExtractor.$$$reportNull$$$0(0);
        }
        return __ -> TagKind.Unknown;
    }

    @Override
    @NotNull
    protected List<TextContent> buildTextContents(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        TextContent content;
        IElementType type;
        if (element == null) {
            XmlTextExtractor.$$$reportNull$$$0(1);
        }
        if (allowedDomains == null) {
            XmlTextExtractor.$$$reportNull$$$0(2);
        }
        if (XmlTextExtractor.isText(element) && this.hasSuitableDialect(element)) {
            Function<XmlTag, TagKind> classifier = this.tagClassifier(element);
            PsiElement container = (PsiElement)SyntaxTraverser.psiApi().parents((Object)element).find(e -> e instanceof XmlDocument || e instanceof XmlTag && classifier.apply((XmlTag)e) != TagKind.Inline);
            if (container != null) {
                Map contentsInside = (Map)CachedValuesManager.getCachedValue((PsiElement)container, () -> CachedValueProvider.Result.create(this.calcContents(container), (Object[])new Object[]{container}));
                List<TextContent> list = contentsInside.getOrDefault(element, List.of());
                if (list == null) {
                    XmlTextExtractor.$$$reportNull$$$0(3);
                }
                return list;
            }
        }
        if ((type = PsiUtilCore.getElementType((PsiElement)element)) == XmlTokenType.XML_COMMENT_CHARACTERS && allowedDomains.contains((Object)TextContent.TextDomain.COMMENTS) && this.hasSuitableDialect(element)) {
            List list = ContainerUtil.createMaybeSingletonList((Object)builder.build(element, TextContent.TextDomain.COMMENTS));
            if (list == null) {
                XmlTextExtractor.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && allowedDomains.contains((Object)TextContent.TextDomain.LITERALS) && this.hasSuitableDialect(element) && (content = builder.build(element, TextContent.TextDomain.LITERALS)) != null && XmlTextExtractor.seemsNatural(content)) {
            List<TextContent> list = List.of(content);
            if (list == null) {
                XmlTextExtractor.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<TextContent> list = List.of();
        if (list == null) {
            XmlTextExtractor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private Map<PsiElement, List<TextContent>> calcContents(final PsiElement container) {
        if (container instanceof XmlTag && XmlTextExtractor.isNonText((XmlTag)container)) {
            Map<PsiElement, List<TextContent>> map = Collections.emptyMap();
            if (map == null) {
                XmlTextExtractor.$$$reportNull$$$0(7);
            }
            return map;
        }
        final Function<XmlTag, TagKind> classifier = this.tagClassifier(container);
        final boolean unknownContainer = container instanceof XmlTag && classifier.apply((XmlTag)container) == TagKind.Unknown;
        final NotNullLazyValue fullContent = NotNullLazyValue.lazy(() -> TextContent.psiFragment(TextContent.TextDomain.PLAIN_TEXT, container));
        var visitor = new PsiRecursiveElementWalkingVisitor(){
            final Map<PsiElement, List<TextContent>> result = new HashMap<PsiElement, List<TextContent>>();
            final List<PsiElement> group = new ArrayList<PsiElement>();
            final Set<Integer> markupIndices = new HashSet<Integer>();
            final Set<Integer> unknownIndices = new HashSet<Integer>();
            final Set<XmlTag> inlineTags = new HashSet<XmlTag>();
            boolean unknownBefore = unknownContainer;

            public void visitElement(@NotNull PsiElement each) {
                if (each == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (each instanceof XmlTag) {
                    XmlTag tag = (XmlTag)each;
                    TagKind kind = (TagKind)((Object)classifier.apply(tag));
                    if (kind != TagKind.Inline) {
                        boolean unknown = kind == TagKind.Unknown;
                        this.flushGroup(unknown);
                        this.unknownBefore = unknown;
                        return;
                    }
                    if (XmlTextExtractor.isInlineNonTextTag(tag.getName())) {
                        this.unknownIndices.add(this.group.size());
                        return;
                    }
                    this.inlineTags.add(tag);
                    this.markupIndices.add(this.group.size());
                }
                if (each instanceof OuterLanguageElement || each instanceof XmlEntityRef) {
                    this.flushGroup(true);
                    this.unknownBefore = true;
                }
                if (XmlTextExtractor.isText(each)) {
                    if (XmlTextExtractor.isCdata(each.getParent())) {
                        List<TextContent> contents = HtmlUtilsKt.excludeHtml(this.extractRange(each.getTextRange().shiftLeft(container.getTextRange().getStartOffset())));
                        if (!contents.isEmpty()) {
                            this.flushGroup(false);
                            this.result.put(each, contents);
                            this.unknownBefore = false;
                        }
                    } else {
                        this.group.add(each);
                    }
                } else if (PsiUtilCore.getElementType((PsiElement)each) == XmlTokenType.XML_CHAR_ENTITY_REF) {
                    if (HtmlUtilsKt.isSpaceEntity(each.getText())) {
                        this.group.add(each);
                    } else {
                        this.unknownIndices.add(this.group.size());
                    }
                }
                super.visitElement(each);
            }

            private TextContent extractRange(TextRange range) {
                TextContent full = (TextContent)fullContent.getValue();
                return full.excludeRange(new TextRange(range.getEndOffset(), full.length())).excludeRange(new TextRange(0, range.getStartOffset()));
            }

            protected void elementFinished(PsiElement element) {
                super.elementFinished(element);
                if (this.inlineTags.contains(element)) {
                    this.markupIndices.add(this.group.size());
                }
            }

            private void flushGroup(boolean unknownAfter) {
                int containerStart = container.getTextRange().getStartOffset();
                ArrayList<TextContent> components = new ArrayList<TextContent>(this.group.size());
                for (int i = 0; i < this.group.size(); ++i) {
                    PsiElement e = this.group.get(i);
                    TextContent component = this.extractRange(e.getTextRange().shiftLeft(containerStart));
                    component = 1.applyExclusions(i, component, this.markupIndices, TextContent.ExclusionKind.markup);
                    component = 1.applyExclusions(i, component, this.unknownIndices, TextContent.ExclusionKind.unknown);
                    components.add(component);
                }
                this.unknownIndices.clear();
                this.markupIndices.clear();
                this.inlineTags.clear();
                TextContent content = TextContent.join(components);
                if (content != null) {
                    if (this.unknownBefore) {
                        content = content.markUnknown(TextRange.from((int)0, (int)0));
                    }
                    if (unknownAfter) {
                        content = content.markUnknown(TextRange.from((int)content.length(), (int)0));
                    }
                    if ((content = HtmlUtilsKt.inlineSpaceEntities(content.removeIndents(Set.of(Character.valueOf(' '), Character.valueOf('\t'))))) != null) {
                        for (PsiElement e : this.group) {
                            this.result.put(e, List.of(content));
                        }
                    }
                }
                this.group.clear();
            }

            private static TextContent applyExclusions(int index, TextContent component, Set<Integer> indices, TextContent.ExclusionKind kind) {
                if (indices.contains(index)) {
                    component = component.excludeRanges(List.of(new TextContent.Exclusion(0, 0, kind)));
                }
                if (indices.contains(index + 1)) {
                    component = component.excludeRanges(List.of(new TextContent.Exclusion(component.length(), component.length(), kind)));
                }
                return component;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/grazie/ide/language/xml/XmlTextExtractor$1", "visitElement"));
            }
        };
        container.acceptChildren((PsiElementVisitor)visitor);
        visitor.flushGroup(unknownContainer);
        Map<PsiElement, List<TextContent>> map = visitor.result;
        if (map == null) {
            XmlTextExtractor.$$$reportNull$$$0(8);
        }
        return map;
    }

    private static boolean seemsNatural(TextContent content) {
        return content.toString().contains(" ");
    }

    private static boolean isText(PsiElement leaf) {
        PsiElement parent = leaf.getParent();
        if (!(parent instanceof XmlText || XmlTextExtractor.isCdata(parent) || parent instanceof XmlDocument)) {
            return false;
        }
        IElementType type = PsiUtilCore.getElementType((PsiElement)leaf);
        return type == XmlTokenType.XML_WHITE_SPACE || type == TokenType.WHITE_SPACE || type == XmlTokenType.XML_DATA_CHARACTERS;
    }

    private static boolean isCdata(PsiElement element) {
        return PsiUtilCore.getElementType((PsiElement)element) == XmlElementType.XML_CDATA;
    }

    private boolean hasSuitableDialect(@NotNull PsiElement element) {
        if (element == null) {
            XmlTextExtractor.$$$reportNull$$$0(9);
        }
        return this.myEnabledDialects.contains(element.getContainingFile().getLanguage().getClass());
    }

    private static boolean isNonText(XmlTag tag) {
        return tag instanceof HtmlTag && (XmlTextExtractor.isInlineNonTextTag(tag.getName()) || XmlTextExtractor.isBlockNonTextTag(tag.getName()));
    }

    private static boolean isBlockNonTextTag(String name) {
        return "pre".equals(name);
    }

    private static boolean isInlineNonTextTag(String name) {
        return "code".equals(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedDomains";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/ide/language/xml/XmlTextExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/ide/language/xml/XmlTextExtractor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTextContents";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tagClassifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContents";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasSuitableDialect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    protected static enum TagKind {
        Block,
        Inline,
        Unknown;

    }

    public static class Html
    extends XmlTextExtractor {
        public Html() {
            super(HTMLLanguage.class);
        }

        @Override
        @NotNull
        protected List<TextContent> buildTextContents(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
            XmlAttribute attr;
            XmlAttributeValue value;
            PsiElement psiElement;
            if (element == null) {
                Html.$$$reportNull$$$0(0);
            }
            if (allowedDomains == null) {
                Html.$$$reportNull$$$0(1);
            }
            if (PsiUtilCore.getElementType((PsiElement)element) == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && (psiElement = element.getParent()) instanceof XmlAttributeValue && (psiElement = (value = (XmlAttributeValue)psiElement).getParent()) instanceof XmlAttribute && "class".equalsIgnoreCase((attr = (XmlAttribute)psiElement).getName())) {
                List<TextContent> list = List.of();
                if (list == null) {
                    Html.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<TextContent> list = super.buildTextContents(element, allowedDomains);
            if (list == null) {
                Html.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        protected Function<XmlTag, TagKind> tagClassifier(@NotNull PsiElement context) {
            if (context == null) {
                Html.$$$reportNull$$$0(4);
            }
            if (!Registry.is((String)"grazie.html.concatenate.inline.tag.contents")) {
                return super.tagClassifier(context);
            }
            HtmlCodeStyleSettings settings = (HtmlCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getContainingFile(), HtmlCodeStyleSettings.class);
            HashSet inlineTags = ContainerUtil.newHashSet((Object[])settings.HTML_INLINE_ELEMENTS.split(","));
            return tag -> {
                String name = tag.getName();
                if (HtmlUtilsKt.commonBlockElements.contains(name) || XmlTextExtractor.isBlockNonTextTag(name)) {
                    return TagKind.Block;
                }
                if (inlineTags.contains(name) || XmlTextExtractor.isInlineNonTextTag(name)) {
                    return TagKind.Inline;
                }
                return TagKind.Unknown;
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allowedDomains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/grazie/ide/language/xml/XmlTextExtractor$Html";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/grazie/ide/language/xml/XmlTextExtractor$Html";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTextContents";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTextContents";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "tagClassifier";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class Xml
    extends XmlTextExtractor {
        public Xml() {
            super(XMLLanguage.class, XHTMLLanguage.class, DTDLanguage.class);
        }
    }
}

