/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import com.intellij.grazie.utils.PsiUtilsKt;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000h\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a8\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u0006*\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\t0\bH\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010\n\u001a\u00020\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a#\u0010\u000e\u001a\u00020\t*\u00020\u000b2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0012\u001a\u0018\u0010\u000e\u001a\u00020\t*\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013\u001a.\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u0002H\u00050\u0002j\b\u0012\u0004\u0012\u0002H\u0005`\u0015\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u0006*\u0002H\u0005H\u0086\b\u00a2\u0006\u0002\u0010\u0016\u001a\u0010\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018*\u00020\u0006\u001a\u001c\u0010\u0019\u001a\u00020\u001a*\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0006\u001a\u001c\u0010\u001d\u001a\u00020\t*\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\u001f\u001a\u00020\t\u001a\u001c\u0010 \u001a\u00020\t*\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\u001f\u001a\u00020\t\u001a(\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u001c\u001a\u00020\u00062\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u001a0\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\r2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u001a\u0010\u0010'\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002\"\u0016\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\u001e\b\u0000\u0010\u0000\u001a\u0004\b\u0000\u0010\u0001\"\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0002\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"PsiPointer", "E", "Lcom/intellij/psi/SmartPsiElementPointer;", "filterFor", "", "T", "Lcom/intellij/psi/PsiElement;", "filter", "Lkotlin/Function1;", "", "noParentOfTypes", "Lcom/intellij/lang/ASTNode;", "tokenSet", "Lcom/intellij/psi/tree/TokenSet;", "hasType", "tokens", "", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/lang/ASTNode;[Lcom/intellij/psi/tree/IElementType;)Z", "", "toPointer", "Lcom/intellij/grazie/utils/PsiPointer;", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/SmartPsiElementPointer;", "parents", "Lkotlin/sequences/Sequence;", "processElements", "", "Lcom/intellij/psi/search/PsiElementProcessor;", "element", "isAtStart", "Lkotlin/ranges/IntRange;", "skipWhitespace", "isAtEnd", "getNotSoDistantSimilarSiblings", "checkSibling", "whitespaceTokens", "SUPPRESSION", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "isSuppressionComment", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nPsiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiUtils.kt\ncom/intellij/grazie/utils/PsiUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,137:1\n774#2:138\n865#2,2:139\n1104#3,3:141\n*S KotlinDebug\n*F\n+ 1 PsiUtils.kt\ncom/intellij/grazie/utils/PsiUtilsKt\n*L\n19#1:138\n19#1:139,2\n112#1:141,3\n*E\n"})
public final class PsiUtilsKt {
    private static final Pattern SUPPRESSION = Pattern.compile("\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T extends PsiElement> List<T> filterFor(PsiElement $this$filterFor, Function1<? super T, Boolean> filter) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$filterFor, (String)"<this>");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        boolean $i$f$filterFor = false;
        Class[] classArray = new Class[1];
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        classArray[0] = PsiElement.class;
        Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)$this$filterFor, (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectElementsOfType(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filter.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ List filterFor$default(PsiElement $this$filterFor_u24default, Function1 filter, int n, Object object) {
        void $this$filterTo$iv$iv;
        if ((n & 1) != 0) {
            Intrinsics.needClassReification();
            filter = filterFor.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)$this$filterFor_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        boolean $i$f$filterFor = false;
        Class[] classArray = new Class[1];
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        classArray[0] = PsiElement.class;
        Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)$this$filterFor_u24default, (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectElementsOfType(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filter.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    public static final boolean noParentOfTypes(@NotNull ASTNode $this$noParentOfTypes, @NotNull TokenSet tokenSet) {
        Intrinsics.checkNotNullParameter((Object)$this$noParentOfTypes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tokenSet, (String)"tokenSet");
        return TreeUtil.findParent((ASTNode)$this$noParentOfTypes, (TokenSet)tokenSet) == null;
    }

    public static final boolean hasType(@NotNull ASTNode $this$hasType, IElementType ... tokens) {
        Intrinsics.checkNotNullParameter((Object)$this$hasType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        return PsiUtilsKt.hasType($this$hasType, ArraysKt.toSet((Object[])tokens));
    }

    public static final boolean hasType(@NotNull ASTNode $this$hasType, @NotNull Set<? extends IElementType> tokens) {
        Intrinsics.checkNotNullParameter((Object)$this$hasType, (String)"<this>");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        return tokens.contains($this$hasType.getElementType());
    }

    public static final /* synthetic */ <T extends PsiElement> SmartPsiElementPointer<T> toPointer(T $this$toPointer) {
        Intrinsics.checkNotNullParameter($this$toPointer, (String)"<this>");
        boolean $i$f$toPointer = false;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer($this$toPointer);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        return smartPsiElementPointer;
    }

    @NotNull
    public static final Sequence<PsiElement> parents(@NotNull PsiElement $this$parents) {
        Intrinsics.checkNotNullParameter((Object)$this$parents, (String)"<this>");
        return SequencesKt.generateSequence((Object)$this$parents, PsiUtilsKt::parents$lambda$0);
    }

    public static final void processElements(@NotNull PsiElementProcessor<? super PsiElement> $this$processElements, @Nullable PsiElement element) {
        Intrinsics.checkNotNullParameter($this$processElements, (String)"<this>");
        ProgressManager.checkCanceled();
        if (element == null) {
            return;
        }
        if (element instanceof PsiCompiledElement || !element.isPhysical()) {
            if (!$this$processElements.execute(element)) {
                return;
            }
            for (PsiElement child : element.getChildren()) {
                PsiUtilsKt.processElements($this$processElements, child);
            }
        } else {
            element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor($this$processElements){
                final /* synthetic */ PsiElementProcessor<? super PsiElement> $this_processElements;
                {
                    this.$this_processElements = $receiver;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (this.$this_processElements.execute(element)) {
                        super.visitElement(element);
                    }
                }
            });
        }
    }

    public static final boolean isAtStart(@NotNull IntRange $this$isAtStart, @NotNull PsiElement element, boolean skipWhitespace) {
        int n;
        int start;
        Intrinsics.checkNotNullParameter((Object)$this$isAtStart, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        for (start = 0; start < element.getText().length(); ++start) {
            n = $this$isAtStart.getFirst();
            if ((start <= $this$isAtStart.getLast() ? n <= start : false) || !skipWhitespace || !CharsKt.isWhitespace((char)element.getText().charAt(start))) break;
        }
        n = $this$isAtStart.getFirst();
        return start <= $this$isAtStart.getLast() ? n <= start : false;
    }

    public static /* synthetic */ boolean isAtStart$default(IntRange intRange, PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PsiUtilsKt.isAtStart(intRange, psiElement, bl);
    }

    public static final boolean isAtEnd(@NotNull IntRange $this$isAtEnd, @NotNull PsiElement element, boolean skipWhitespace) {
        int n;
        int end;
        Intrinsics.checkNotNullParameter((Object)$this$isAtEnd, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        for (end = element.getText().length() - 1; end >= 0; --end) {
            n = $this$isAtEnd.getFirst();
            if ((end <= $this$isAtEnd.getLast() ? n <= end : false) || !skipWhitespace || !CharsKt.isWhitespace((char)element.getText().charAt(end))) break;
        }
        n = $this$isAtEnd.getFirst();
        return end <= $this$isAtEnd.getLast() ? n <= end : false;
    }

    public static /* synthetic */ boolean isAtEnd$default(IntRange intRange, PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PsiUtilsKt.isAtEnd(intRange, psiElement, bl);
    }

    @NotNull
    public static final List<PsiElement> getNotSoDistantSimilarSiblings(@NotNull PsiElement element, @NotNull Function1<? super PsiElement, Boolean> checkSibling) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(checkSibling, (String)"checkSibling");
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        return PsiUtilsKt.getNotSoDistantSimilarSiblings(element, tokenSet, checkSibling);
    }

    @NotNull
    public static final List<PsiElement> getNotSoDistantSimilarSiblings(@NotNull PsiElement element, @NotNull TokenSet whitespaceTokens, @NotNull Function1<? super PsiElement, Boolean> checkSibling) {
        List list;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)whitespaceTokens, (String)"whitespaceTokens");
        Intrinsics.checkNotNullParameter(checkSibling, (String)"checkSibling");
        if (!((Boolean)checkSibling.invoke((Object)element)).booleanValue()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List $this$getNotSoDistantSimilarSiblings_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getNotSoDistantSimilarSiblings_u24lambda_u242.addAll(CollectionsKt.reversed((Iterable)PsiUtilsKt.getNotSoDistantSimilarSiblings$process(element, checkSibling, whitespaceTokens, false)));
        if (!PsiUtilsKt.isSuppressionComment(element)) {
            $this$getNotSoDistantSimilarSiblings_u24lambda_u242.add(element);
        }
        $this$getNotSoDistantSimilarSiblings_u24lambda_u242.addAll((Collection)PsiUtilsKt.getNotSoDistantSimilarSiblings$process(element, checkSibling, whitespaceTokens, true));
        return CollectionsKt.build((List)list);
    }

    private static final boolean isSuppressionComment(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        ElementManipulator elementManipulator = ElementManipulators.getManipulator((PsiElement)element);
        if (elementManipulator == null) {
            return false;
        }
        ElementManipulator manipulator = elementManipulator;
        TextRange textRange = manipulator.getRangeInElement(element);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
        TextRange valueRange = textRange;
        String string = ((PsiComment)element).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = valueRange.getStartOffset();
        int n2 = valueRange.getEndOffset();
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String commentText = string3;
        return SUPPRESSION.matcher(commentText).matches();
    }

    private static final PsiElement parents$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final List<PsiElement> getNotSoDistantSimilarSiblings$process(PsiElement $this$getNotSoDistantSimilarSiblings_u24process, Function1<? super PsiElement, Boolean> $checkSibling, TokenSet $whitespaceTokens, boolean next) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        int newLinesBetweenSiblingsCount = 0;
        PsiElement sibling = $this$getNotSoDistantSimilarSiblings_u24process;
        while (true) {
            void $this$count$iv;
            PsiElement psiElement = next ? sibling.getNextSibling() : sibling.getPrevSibling();
            if (psiElement == null) return result;
            sibling = psiElement;
            if (((Boolean)$checkSibling.invoke((Object)sibling)).booleanValue()) {
                if (PsiUtilsKt.isSuppressionComment(sibling)) return result;
                newLinesBetweenSiblingsCount = 0;
                result.add(sibling);
                continue;
            }
            if (!(sibling instanceof PsiWhiteSpace) && !$whitespaceTokens.contains(PsiTreeUtilKt.getElementType((PsiElement)sibling))) return result;
            String string = sibling.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence charSequence = string;
            int n = newLinesBetweenSiblingsCount;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char c = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(c == '\n')) continue;
                ++count$iv;
            }
            int n2 = count$iv;
            newLinesBetweenSiblingsCount = n + n2;
            if (newLinesBetweenSiblingsCount > 1) return result;
        }
    }
}

