/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.settings.SpellCheckerSettingsPane;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpellCheckerSettingsManager
implements SearchableConfigurable,
Configurable.NoScroll,
Configurable.WithEpDependencies {
    private SpellCheckerSettingsPane settingsPane;
    private final SpellCheckerSettings settings;
    private final Project project;

    public SpellCheckerSettingsManager(Project project) {
        this.project = project;
        this.settings = SpellCheckerSettings.getInstance(project);
    }

    @Nls
    public String getDisplayName() {
        return SpellCheckerBundle.message("spelling", new Object[0]);
    }

    @NonNls
    @NotNull
    public String getHelpTopic() {
        return "reference.settings.ide.settings.spelling";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            SpellCheckerSettingsManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createComponent() {
        if (this.settingsPane == null) {
            this.settingsPane = new SpellCheckerSettingsPane(this.settings, this.project);
        }
        return this.settingsPane.getPane();
    }

    public boolean isModified() {
        return this.settingsPane == null || this.settingsPane.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.settingsPane != null) {
            this.settingsPane.apply();
        }
    }

    public void reset() {
        if (this.settingsPane != null) {
            this.settingsPane.reset();
        }
    }

    public void disposeUIResources() {
        this.settingsPane = null;
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        Set<ExtensionPointName<CustomDictionaryProvider>> set = Collections.singleton(CustomDictionaryProvider.EP_NAME);
        if (set == null) {
            SpellCheckerSettingsManager.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spellchecker/settings/SpellCheckerSettingsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

