/*
 * Decompiled with CFR 0.152.
 */
package training.onboarding;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.onboarding.AbstractOnboardingTipsDocumentationProviderKt;
import training.onboarding.NewProjectOnboardingTipsImplKt;
import training.onboarding.OnboardingTipComment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H$J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0015H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Ltraining/onboarding/AbstractOnboardingTipsDocumentationProvider;", "Lcom/intellij/lang/documentation/DocumentationProvider;", "commentTokenType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "tipPrefix", "", "getTipPrefix", "()Ljava/lang/String;", "enabled", "", "getEnabled", "()Z", "isLanguageFile", "file", "Lcom/intellij/psi/PsiFile;", "isEnabledForFile", "collectDocComments", "", "sink", "Ljava/util/function/Consumer;", "Lcom/intellij/psi/PsiDocCommentBase;", "findDocComment", "range", "Lcom/intellij/openapi/util/TextRange;", "generateRenderedDoc", "comment", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nAbstractOnboardingTipsDocumentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractOnboardingTipsDocumentationProvider.kt\ntraining/onboarding/AbstractOnboardingTipsDocumentationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1563#2:99\n1634#2,3:100\n1563#2:103\n1634#2,3:104\n1563#2:107\n1634#2,3:108\n*S KotlinDebug\n*F\n+ 1 AbstractOnboardingTipsDocumentationProvider.kt\ntraining/onboarding/AbstractOnboardingTipsDocumentationProvider\n*L\n63#1:99\n63#1:100,3\n64#1:103\n64#1:104,3\n65#1:107\n65#1:108,3\n*E\n"})
public abstract class AbstractOnboardingTipsDocumentationProvider
implements DocumentationProvider {
    @NotNull
    private final IElementType commentTokenType;
    @NotNull
    private final String tipPrefix;

    public AbstractOnboardingTipsDocumentationProvider(@NotNull IElementType commentTokenType) {
        Intrinsics.checkNotNullParameter((Object)commentTokenType, (String)"commentTokenType");
        this.commentTokenType = commentTokenType;
        this.tipPrefix = "//TIP";
    }

    @NotNull
    protected String getTipPrefix() {
        return this.tipPrefix;
    }

    protected final boolean getEnabled() {
        return NewProjectOnboardingTipsImplKt.getRenderedOnboardingTipsEnabled();
    }

    protected abstract boolean isLanguageFile(@NotNull PsiFile var1);

    private final boolean isEnabledForFile(PsiFile file) {
        return this.getEnabled() && this.isLanguageFile(file);
    }

    public void collectDocComments(@NotNull PsiFile file, @NotNull Consumer<? super PsiDocCommentBase> sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        if (!this.isEnabledForFile(file)) {
            return;
        }
        Object object = file.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            return;
        }
        Object filePath = object;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String onboardingTipsDebugPath = NewProjectOnboardingTipsImplKt.getFilePathWithOnboardingTips(project);
        if (!Intrinsics.areEqual((Object)filePath, (Object)onboardingTipsDebugPath)) {
            return;
        }
        Set visitedComments = new LinkedHashSet();
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(visitedComments, this, sink){
            final /* synthetic */ Set<PsiElement> $visitedComments;
            final /* synthetic */ AbstractOnboardingTipsDocumentationProvider this$0;
            final /* synthetic */ Consumer<? super PsiDocCommentBase> $sink;
            {
                this.$visitedComments = $visitedComments;
                this.this$0 = $receiver;
                this.$sink = $sink;
            }

            public void visitComment(PsiComment comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                if (this.$visitedComments.contains(comment)) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)comment.getNode().getElementType(), (Object)AbstractOnboardingTipsDocumentationProvider.access$getCommentTokenType$p(this.this$0))) {
                    return;
                }
                String string = comment.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.startsWith$default((String)string, (String)this.this$0.getTipPrefix(), (boolean)false, (int)2, null)) {
                    OnboardingTipComment wrapper = AbstractOnboardingTipsDocumentationProviderKt.access$createOnboardingTipComment(comment, this.$visitedComments, AbstractOnboardingTipsDocumentationProvider.access$getCommentTokenType$p(this.this$0));
                    this.$sink.accept(wrapper);
                }
            }
        });
    }

    @Nullable
    public PsiDocCommentBase findDocComment(@NotNull PsiFile file, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (this.isEnabledForFile(file)) {
            return null;
        }
        Ref.ObjectRef result = new Ref.ObjectRef();
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(range, (Ref.ObjectRef<PsiDocCommentBase>)result, this){
            final /* synthetic */ TextRange $range;
            final /* synthetic */ Ref.ObjectRef<PsiDocCommentBase> $result;
            final /* synthetic */ AbstractOnboardingTipsDocumentationProvider this$0;
            {
                this.$range = $range;
                this.$result = $result;
                this.this$0 = $receiver;
            }

            public void visitComment(PsiComment comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                if (comment.getTextRange().getStartOffset() != this.$range.getStartOffset()) {
                    return;
                }
                PsiElement psiElement = comment.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
                this.$result.element = new OnboardingTipComment(psiElement, this.$range, AbstractOnboardingTipsDocumentationProvider.access$getCommentTokenType$p(this.this$0));
            }
        });
        return (PsiDocCommentBase)result.element;
    }

    @Nullable
    public String generateRenderedDoc(@NotNull PsiDocCommentBase comment) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        if (!this.getEnabled() || !(comment instanceof OnboardingTipComment)) {
            return null;
        }
        String[] stringArray = new String[]{"\n"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)((OnboardingTipComment)comment).getText(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it, (String)this.getTipPrefix(), (boolean)false, (int)2, null)) {
                String string2 = it.substring(this.getTipPrefix().length(), it.length());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = it;
            }
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it, (String)"//", (boolean)false, (int)2, null)) {
                String string3 = it.substring(2, it.length());
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = it;
            }
            collection.add(string);
        }
        String result = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null))).toString();
        return "<p>" + result;
    }

    public static final /* synthetic */ IElementType access$getCommentTokenType$p(AbstractOnboardingTipsDocumentationProvider $this) {
        return $this.commentTokenType;
    }
}

