/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.indentGuides.currentScope;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.currentScope.FrontendCurrentScopeHighlightingManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/currentScope/FrontendCurrentScopeHighlightingManagerImpl;", "Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/currentScope/FrontendCurrentScopeHighlightingManager;", "<init>", "()V", "myCodeInsightSettings", "Lcom/intellij/codeInsight/CodeInsightSettings;", "updateCurrentScopeHighlighting", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "tryCalculateCurrentScopeRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/openapi/editor/ex/EditorEx;", "Companion", "intellij.rd.client"})
public final class FrontendCurrentScopeHighlightingManagerImpl
implements FrontendCurrentScopeHighlightingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeInsightSettings myCodeInsightSettings;
    @NotNull
    private static final Key<RangeHighlighter> SCOPE_MARKER_IN_EDITOR_KEY;

    public FrontendCurrentScopeHighlightingManagerImpl() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)codeInsightSettings, (String)"getInstance(...)");
        this.myCodeInsightSettings = codeInsightSettings;
    }

    @Override
    public void updateCurrentScopeHighlighting(@NotNull Editor editor) {
        RangeHighlighter existingHighlighter;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(editor instanceof EditorEx)) {
            return;
        }
        TextRange calculatedRange = this.tryCalculateCurrentScopeRange((EditorEx)editor);
        RangeHighlighter rangeHighlighter = existingHighlighter = (RangeHighlighter)editor.getUserData(SCOPE_MARKER_IN_EDITOR_KEY);
        if (Intrinsics.areEqual((Object)calculatedRange, (Object)(rangeHighlighter != null ? RangeMarkersKt.getAsTextRange((RangeMarker)((RangeMarker)rangeHighlighter)) : null))) {
            return;
        }
        RangeHighlighter rangeHighlighter2 = existingHighlighter;
        if (rangeHighlighter2 != null) {
            rangeHighlighter2.dispose();
        }
        editor.putUserData(SCOPE_MARKER_IN_EDITOR_KEY, null);
        if (calculatedRange == null) {
            return;
        }
        RangeHighlighterEx rangeHighlighterEx = ((EditorEx)editor).getMarkupModel().addRangeHighlighterAndChangeAttributes(null, calculatedRange.getStartOffset(), calculatedRange.getEndOffset(), 0, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> FrontendCurrentScopeHighlightingManagerImpl.updateCurrentScopeHighlighting$lambda$1(FrontendCurrentScopeHighlightingManagerImpl::updateCurrentScopeHighlighting$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        RangeHighlighter highlighter = (RangeHighlighter)rangeHighlighterEx;
        editor.putUserData(SCOPE_MARKER_IN_EDITOR_KEY, (Object)highlighter);
    }

    private final TextRange tryCalculateCurrentScopeRange(EditorEx editor) {
        if (!this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
            return null;
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)((Document)editor.getDocument()), (Project)editor.getProject(), (boolean)false);
        MarkupModelEx markupModelEx = markupModel instanceof MarkupModelEx ? (MarkupModelEx)markupModel : null;
        if (markupModelEx == null) {
            return null;
        }
        MarkupModelEx model2 = markupModelEx;
        int caretOffset = editor.getCaretModel().getCurrentCaret().getOffset();
        Ref.ObjectRef currentMaxIndentLevel = new Ref.ObjectRef();
        Ref.ObjectRef rangeOfCurrentMaxIndentLevel = new Ref.ObjectRef();
        model2.processRangeHighlightersOverlappingWith(caretOffset, caretOffset, arg_0 -> FrontendCurrentScopeHighlightingManagerImpl.tryCalculateCurrentScopeRange$lambda$3(arg_0 -> FrontendCurrentScopeHighlightingManagerImpl.tryCalculateCurrentScopeRange$lambda$2(currentMaxIndentLevel, rangeOfCurrentMaxIndentLevel, arg_0), arg_0));
        return (TextRange)rangeOfCurrentMaxIndentLevel.element;
    }

    private static final Unit updateCurrentScopeHighlighting$lambda$0(RangeHighlighterEx h) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        h.setLineMarkerRenderer(BraceHighlightingHandler.Companion.createLineMarkerRenderer(true));
        return Unit.INSTANCE;
    }

    private static final void updateCurrentScopeHighlighting$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean tryCalculateCurrentScopeRange$lambda$2(Ref.ObjectRef $currentMaxIndentLevel, Ref.ObjectRef $rangeOfCurrentMaxIndentLevel, RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNull((Object)highlighter);
        Integer n = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel((RangeHighlighter)highlighter);
        if (n == null) {
            return true;
        }
        int indentLevel = n;
        Integer cachedMaxIndentLevel = (Integer)$currentMaxIndentLevel.element;
        if (cachedMaxIndentLevel == null || cachedMaxIndentLevel < indentLevel) {
            $currentMaxIndentLevel.element = indentLevel;
            $rangeOfCurrentMaxIndentLevel.element = RangeMarkersKt.getAsTextRange((RangeMarker)((RangeMarker)highlighter));
        }
        return true;
    }

    private static final boolean tryCalculateCurrentScopeRange$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"FrontendCurrentScopeHighlightingManagerImpl.SCOPE_MARKER_IN_EDITOR_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SCOPE_MARKER_IN_EDITOR_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/currentScope/FrontendCurrentScopeHighlightingManagerImpl$Companion;", "", "<init>", "()V", "SCOPE_MARKER_IN_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

