/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.telephony;

import com.intellij.cwm.plugin.common.telephony.JitsiEvent;
import com.intellij.cwm.plugin.common.telephony.JitsiEventParameters;
import com.intellij.cwm.plugin.common.telephony.TelephonyLogger;
import com.intellij.cwm.plugin.common.telephony.TelephonySession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.NettyKt;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;
import org.jetbrains.io.webSocket.WebSocketHandshakeHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f\u0018\u00010\nH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0002H\u0014J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/cwm/plugin/common/telephony/TelephonyRequestsHandler;", "Lorg/jetbrains/io/webSocket/WebSocketHandshakeHandler;", "Lorg/jetbrains/io/jsonRpc/MessageServer;", "<init>", "()V", "connected", "", "client", "Lorg/jetbrains/io/jsonRpc/Client;", "parameters", "", "", "", "disconnected", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "isOriginAllowed", "Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "Lio/netty/handler/codec/http/HttpRequest;", "isRequestUrlHostAllowed", "requestOriginURI", "Ljava/net/URI;", "getMessageServer", "messageReceived", "message", "", "Companion", "intellij.cwm.plugin.common"})
@SourceDebugExtension(value={"SMAP\nTelephonyRequestsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelephonyRequestsHandler.kt\ncom/intellij/cwm/plugin/common/telephony/TelephonyRequestsHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,165:1\n24#2:166\n*S KotlinDebug\n*F\n+ 1 TelephonyRequestsHandler.kt\ncom/intellij/cwm/plugin/common/telephony/TelephonyRequestsHandler\n*L\n89#1:166\n*E\n"})
public final class TelephonyRequestsHandler
extends WebSocketHandshakeHandler
implements MessageServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final TelephonyLogger telephonyLogger;
    @NotNull
    private static final String PREFIX = "/codeWithMe";
    @NotNull
    private static final String TELEPHONY_PREFIX = "/codeWithMe/telephony";
    @NotNull
    private static final Json jsonSettings;
    @NotNull
    private static final KSerializer<JitsiEvent> jitsiEventDeserializer;
    @Nullable
    private static WebSocketClient webSocketClient;
    @Nullable
    private static TelephonySession telephonySession;

    public void connected(@NotNull Client client, @Nullable Map<String, List<String>> parameters) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (!(client instanceof WebSocketClient)) {
            telephonyLogger.warning("Connecting client is not websocket.");
            return;
        }
        if (webSocketClient != null) {
            TelephonyRequestsHandler $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TelephonyRequestsHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Websocket client is not null. A new connection will override the old one");
        }
        webSocketClient = (WebSocketClient)client;
        super.connected(client, parameters);
    }

    public void disconnected(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        webSocketClient = null;
        telephonyLogger.info("Telephony session disconnected. '" + client + "'");
    }

    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        return StringsKt.startsWith$default((String)string, (String)TELEPHONY_PREFIX, (boolean)false, (int)2, null);
    }

    @NotNull
    protected HttpRequestHandler.OriginCheckResult isOriginAllowed(@NotNull HttpRequest request) {
        URI uRI;
        String requestOriginRaw;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = NettyKt.getOrigin((HttpRequest)request);
        if (string == null) {
            string = NettyKt.getReferrer((HttpRequest)request);
        }
        if ((requestOriginRaw = string) == null) {
            telephonyLogger.warning("Request origin is null");
            return HttpRequestHandler.OriginCheckResult.FORBID;
        }
        char[] cArray = new char[]{'/'};
        String requestOrigin = StringsKt.trimEnd((String)requestOriginRaw, (char[])cArray) + "/";
        telephonyLogger.info("isOriginAllowed: HOST:" + NettyKt.getHost((HttpRequest)request) + " ORIGIN:" + requestOrigin);
        try {
            uRI = new URI(requestOrigin);
        }
        catch (Throwable t) {
            telephonyLogger.warning("Unable to parse telephony origin from the browser: " + requestOrigin);
            return HttpRequestHandler.OriginCheckResult.FORBID;
        }
        URI requestOriginUri = uRI;
        if (!Intrinsics.areEqual((Object)requestOriginUri.getScheme(), (Object)"https")) {
            telephonyLogger.warning("Scheme " + requestOriginUri.getScheme() + " of " + requestOriginUri + " is not trusted.");
            return HttpRequestHandler.OriginCheckResult.FORBID;
        }
        if (!this.isRequestUrlHostAllowed(requestOriginUri)) {
            return HttpRequestHandler.OriginCheckResult.FORBID;
        }
        telephonyLogger.info("isOriginAllowed: allowing request from " + requestOrigin);
        return HttpRequestHandler.OriginCheckResult.ALLOW;
    }

    private final boolean isRequestUrlHostAllowed(URI requestOriginURI) {
        TelephonySession telephonySession = TelephonyRequestsHandler.telephonySession;
        URI jitsiUrl = telephonySession != null ? telephonySession.getJitsiRoomUrl() : null;
        URI uRI = jitsiUrl;
        return Intrinsics.areEqual((Object)requestOriginURI.getHost(), (Object)(uRI != null ? uRI.getHost() : null));
    }

    @NotNull
    protected MessageServer getMessageServer() {
        return this;
    }

    public void messageReceived(@NotNull Client client, @NotNull CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        telephonyLogger.info("Message from client: " + message);
        JitsiEvent parsedJitsiEvent = (JitsiEvent)jsonSettings.decodeFromString((DeserializationStrategy)jitsiEventDeserializer, ((Object)message).toString());
        switch (parsedJitsiEvent.getType()) {
            case "track": {
                TelephonySession telephonySession = TelephonyRequestsHandler.telephonySession;
                if (telephonySession != null) {
                    telephonySession.trackTypeHandler(parsedJitsiEvent.getParameters());
                }
                break;
            }
            case "messageReceived": {
                TelephonySession telephonySession = TelephonyRequestsHandler.telephonySession;
                if (telephonySession != null) {
                    String string = parsedJitsiEvent.getParameters().getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    telephonySession.onMessageReceivedNotificationHandler(string);
                }
                break;
            }
            case "conferenceJoined": {
                TelephonySession telephonySession = TelephonyRequestsHandler.telephonySession;
                if (telephonySession != null) {
                    telephonySession.onConferenceJoinedHandler(parsedJitsiEvent);
                }
                break;
            }
            case "conferenceLeft": {
                TelephonySession telephonySession = TelephonyRequestsHandler.telephonySession;
                if (telephonySession != null) {
                    telephonySession.onConferenceLeaveHandler();
                }
                break;
            }
            case "conferenceUnloaded": {
                TelephonySession telephonySession = TelephonyRequestsHandler.telephonySession;
                if (telephonySession != null) {
                    telephonySession.onConferenceUnloadedHandler();
                }
                break;
            }
            case "permissionsPrompt": {
                TelephonySession telephonySession = TelephonyRequestsHandler.telephonySession;
                if (telephonySession != null) {
                    telephonySession.onPermissionsPromptHandler(parsedJitsiEvent.getParameters());
                }
                break;
            }
            default: {
                telephonyLogger.warning("Unexpected jitsi event type received: " + parsedJitsiEvent.getType());
            }
        }
    }

    private static final Unit jsonSettings$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        return Unit.INSTANCE;
    }

    static {
        String string = TelephonyRequestsHandler.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        telephonyLogger = new TelephonyLogger(string);
        jsonSettings = JsonKt.Json$default(null, TelephonyRequestsHandler::jsonSettings$lambda$0, (int)1, null);
        jitsiEventDeserializer = JitsiEvent.Companion.serializer();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u0017J\u0006\u0010\u001d\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/intellij/cwm/plugin/common/telephony/TelephonyRequestsHandler$Companion;", "", "<init>", "()V", "telephonyLogger", "Lcom/intellij/cwm/plugin/common/telephony/TelephonyLogger;", "PREFIX", "", "TELEPHONY_PREFIX", "jsonSettings", "Lkotlinx/serialization/json/Json;", "jitsiEventDeserializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/cwm/plugin/common/telephony/JitsiEvent;", "webSocketClient", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "telephonySession", "Lcom/intellij/cwm/plugin/common/telephony/TelephonySession;", "getTelephonySession", "()Lcom/intellij/cwm/plugin/common/telephony/TelephonySession;", "setTelephonySession", "(Lcom/intellij/cwm/plugin/common/telephony/TelephonySession;)V", "sendMessage", "", "jitsiEvent", "sendEndSessionEvent", "sendToggleMicrophoneEvent", "sendToggleCameraEvent", "sendToggleScreenSharingEvent", "sendHangupEvent", "intellij.cwm.plugin.common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final TelephonySession getTelephonySession() {
            return telephonySession;
        }

        public final void setTelephonySession(@Nullable TelephonySession telephonySession) {
            TelephonyRequestsHandler.telephonySession = telephonySession;
        }

        private final void sendMessage(JitsiEvent jitsiEvent) {
            block0: {
                String message = jsonSettings.encodeToString((SerializationStrategy)jitsiEventDeserializer, (Object)jitsiEvent);
                WebSocketClient webSocketClient = webSocketClient;
                if (webSocketClient == null) break block0;
                String string = message;
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                webSocketClient.sendFrame(Unpooled.wrappedBuffer((byte[])byArray), false);
            }
        }

        public final void sendEndSessionEvent() {
            JitsiEvent endSessionEvent = new JitsiEvent("endCWMSession", new JitsiEventParameters(null, null, null, 7, null));
            this.sendMessage(endSessionEvent);
        }

        public final void sendToggleMicrophoneEvent() {
            JitsiEvent microphoneEvent = new JitsiEvent("track", new JitsiEventParameters("microphone", null, "toggle", 2, null));
            this.sendMessage(microphoneEvent);
        }

        public final void sendToggleCameraEvent() {
            JitsiEvent cameraEvent = new JitsiEvent("track", new JitsiEventParameters("camera", null, "toggle", 2, null));
            this.sendMessage(cameraEvent);
        }

        public final void sendToggleScreenSharingEvent() {
            JitsiEvent screenSharingEvent = new JitsiEvent("track", new JitsiEventParameters("desktop", null, "toggle", 2, null));
            this.sendMessage(screenSharingEvent);
        }

        public final void sendHangupEvent() {
            JitsiEvent hangupEvent = new JitsiEvent("hangup", new JitsiEventParameters(null, null, null, 7, null));
            this.sendMessage(hangupEvent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

