/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.TerminalUiSettingsManager;
import com.intellij.util.PlatformUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalEngine;
import org.jetbrains.plugins.terminal.TerminalNewUserTracker;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.settings.TerminalLocalOptions;

@com.intellij.openapi.components.State(name="TerminalOptionsProvider", storages={@Storage(value="terminal.xml")}, presentableName=PresentableNameGetter.class, category=SettingsCategory.TOOLS, exportable=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 U2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003TUVB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\u001c\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u000fJ\b\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010P\u001a\u00020\nH\u0002J\b\u0010Q\u001a\u00020\nH\u0002J\b\u0010R\u001a\u00020\nH\u0002J\b\u0010S\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR.\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001c8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R0\u0010$\u001a\u00070\u001c\u00a2\u0006\u0002\b%2\r\b\u0001\u0010$\u001a\u00070\u001c\u00a2\u0006\u0002\b%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010!\"\u0004\b'\u0010#R$\u0010)\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010.\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R$\u00101\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010+\"\u0004\b3\u0010-R$\u00104\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010+\"\u0004\b6\u0010-R$\u00107\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010+\"\u0004\b9\u0010-R$\u0010:\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010+\"\u0004\b<\u0010-R$\u0010=\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010+\"\u0004\b?\u0010-R$\u0010@\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010+\"\u0004\bB\u0010-R$\u0010C\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bD\u0010+\"\u0004\bE\u0010-R*\u0010F\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\bG\u0010\u001f\u001a\u0004\bH\u0010+\"\u0004\bI\u0010-R$\u0010K\u001a\u00020J2\u0006\u0010\u0015\u001a\u00020J8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bL\u0010M\"\u0004\bN\u0010O\u00a8\u0006W"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider$State;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "state", "getState", "loadState", "", "newState", "noStateLoaded", "listeners", "", "Lkotlin/Function0;", "addListener", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "fireSettingsChanged", "value", "Lorg/jetbrains/plugins/terminal/TerminalEngine;", "terminalEngine", "getTerminalEngine", "()Lorg/jetbrains/plugins/terminal/TerminalEngine;", "setTerminalEngine", "(Lorg/jetbrains/plugins/terminal/TerminalEngine;)V", "", "shellPath", "getShellPath$annotations", "()V", "getShellPath", "()Ljava/lang/String;", "setShellPath", "(Ljava/lang/String;)V", "tabName", "Lorg/jetbrains/annotations/Nls;", "getTabName", "setTabName", "", "closeSessionOnLogout", "getCloseSessionOnLogout", "()Z", "setCloseSessionOnLogout", "(Z)V", "mouseReporting", "getMouseReporting", "setMouseReporting", "audibleBell", "getAudibleBell", "setAudibleBell", "copyOnSelection", "getCopyOnSelection", "setCopyOnSelection", "pasteOnMiddleMouseButton", "getPasteOnMiddleMouseButton", "setPasteOnMiddleMouseButton", "overrideIdeShortcuts", "getOverrideIdeShortcuts", "setOverrideIdeShortcuts", "shellIntegration", "getShellIntegration", "setShellIntegration", "highlightHyperlinks", "getHighlightHyperlinks", "setHighlightHyperlinks", "useOptionAsMetaKey", "getUseOptionAsMetaKey", "setUseOptionAsMetaKey", "useShellPrompt", "getUseShellPrompt$annotations", "getUseShellPrompt", "setUseShellPrompt", "Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "cursorShape", "getCursorShape", "()Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "setCursorShape", "(Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;)V", "performSettingsInitializationOnce", "migrateCursorShape", "initializeTerminalEngine", "migrateTerminalEngineFromRegistry", "State", "Companion", "PresentableNameGetter", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOptionsProvider.kt\norg/jetbrains/plugins/terminal/TerminalOptionsProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,294:1\n14#2:295\n*S KotlinDebug\n*F\n+ 1 TerminalOptionsProvider.kt\norg/jetbrains/plugins/terminal/TerminalOptionsProvider\n*L\n285#1:295\n*E\n"})
public final class TerminalOptionsProvider
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private State state;
    @NotNull
    private final List<Function0<Unit>> listeners;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String COMPONENT_NAME = "TerminalOptionsProvider";

    public TerminalOptionsProvider(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.state = new State();
        this.listeners = new CopyOnWriteArrayList();
    }

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.state = newState;
        this.performSettingsInitializationOnce();
        this.fireSettingsChanged();
    }

    public void noStateLoaded() {
        this.loadState(new State());
    }

    public final void addListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        TerminalUtil.addItem(this.listeners, listener2, disposable);
    }

    private final void fireSettingsChanged() {
        for (Function0<Unit> listener2 : this.listeners) {
            listener2.invoke();
        }
    }

    @NotNull
    public final TerminalEngine getTerminalEngine() {
        return AppMode.isRemoteDevHost() || PlatformUtils.isJetBrainsClient() ? this.state.getTerminalEngineInRemDev() : this.state.getTerminalEngine();
    }

    public final void setTerminalEngine(@NotNull TerminalEngine value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.state.getTerminalEngine() != value || this.state.getTerminalEngineInRemDev() != value) {
            this.state.setTerminalEngine(value);
            this.state.setTerminalEngineInRemDev(value);
            this.fireSettingsChanged();
        }
    }

    @Nullable
    public final String getShellPath() {
        return TerminalLocalOptions.Companion.getInstance().getShellPath();
    }

    public final void setShellPath(@Nullable String value) {
        TerminalLocalOptions options = TerminalLocalOptions.Companion.getInstance();
        if (!Intrinsics.areEqual((Object)options.getShellPath(), (Object)value)) {
            options.setShellPath(value);
            this.fireSettingsChanged();
        }
    }

    @Deprecated(message="Use TerminalLocalOptions#shellPath instead", replaceWith=@ReplaceWith(expression="TerminalLocalOptions.getInstance().shellPath", imports={}))
    public static /* synthetic */ void getShellPath$annotations() {
    }

    @NotNull
    public final String getTabName() {
        return this.state.getMyTabName();
    }

    public final void setTabName(@Nls @NotNull String tabName) {
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        if (!Intrinsics.areEqual((Object)this.state.getMyTabName(), (Object)tabName)) {
            this.state.setMyTabName(tabName);
            this.fireSettingsChanged();
        }
    }

    public final boolean getCloseSessionOnLogout() {
        return this.state.getMyCloseSessionOnLogout();
    }

    public final void setCloseSessionOnLogout(boolean value) {
        if (this.state.getMyCloseSessionOnLogout() != value) {
            this.state.setMyCloseSessionOnLogout(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getMouseReporting() {
        return this.state.getMyReportMouse();
    }

    public final void setMouseReporting(boolean value) {
        if (this.state.getMyReportMouse() != value) {
            this.state.setMyReportMouse(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getAudibleBell() {
        return this.state.getMySoundBell();
    }

    public final void setAudibleBell(boolean value) {
        if (this.state.getMySoundBell() != value) {
            this.state.setMySoundBell(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getCopyOnSelection() {
        return this.state.getMyCopyOnSelection();
    }

    public final void setCopyOnSelection(boolean value) {
        if (this.state.getMyCopyOnSelection() != value) {
            this.state.setMyCopyOnSelection(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getPasteOnMiddleMouseButton() {
        return this.state.getMyPasteOnMiddleMouseButton();
    }

    public final void setPasteOnMiddleMouseButton(boolean value) {
        if (this.state.getMyPasteOnMiddleMouseButton() != value) {
            this.state.setMyPasteOnMiddleMouseButton(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getOverrideIdeShortcuts() {
        return this.state.getMyOverrideIdeShortcuts();
    }

    public final void setOverrideIdeShortcuts(boolean value) {
        if (this.state.getMyOverrideIdeShortcuts() != value) {
            this.state.setMyOverrideIdeShortcuts(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getShellIntegration() {
        return this.state.getMyShellIntegration();
    }

    public final void setShellIntegration(boolean value) {
        if (this.state.getMyShellIntegration() != value) {
            this.state.setMyShellIntegration(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getHighlightHyperlinks() {
        return this.state.getMyHighlightHyperlinks();
    }

    public final void setHighlightHyperlinks(boolean value) {
        if (this.state.getMyHighlightHyperlinks() != value) {
            this.state.setMyHighlightHyperlinks(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getUseOptionAsMetaKey() {
        return this.state.getUseOptionAsMetaKey();
    }

    public final void setUseOptionAsMetaKey(boolean value) {
        if (this.state.getUseOptionAsMetaKey() != value) {
            this.state.setUseOptionAsMetaKey(value);
            this.fireSettingsChanged();
        }
    }

    public final boolean getUseShellPrompt() {
        return this.state.getUseShellPrompt();
    }

    public final void setUseShellPrompt(boolean value) {
        if (this.state.getUseShellPrompt() != value) {
            this.state.setUseShellPrompt(value);
            this.fireSettingsChanged();
        }
    }

    @Deprecated(message="Use BlockTerminalOptions#promptStyle instead")
    public static /* synthetic */ void getUseShellPrompt$annotations() {
    }

    @NotNull
    public final TerminalUiSettingsManager.CursorShape getCursorShape() {
        return this.state.getCursorShape();
    }

    public final void setCursorShape(@NotNull TerminalUiSettingsManager.CursorShape value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.state.getCursorShape() != value) {
            this.state.setCursorShape(value);
            TerminalUiSettingsManager.Companion.getInstance().setCursorShape(value);
            this.fireSettingsChanged();
        }
    }

    private final void performSettingsInitializationOnce() {
        RunOnceUtil.runOnceForApp((String)"TerminalOptionsProvider.migration.2025.1.1", () -> TerminalOptionsProvider.performSettingsInitializationOnce$lambda$1(this));
    }

    private final void migrateCursorShape() {
        TerminalUiSettingsManager.CursorShape previousCursorShape = TerminalUiSettingsManager.Companion.getInstance().getCursorShape();
        this.state.setCursorShape(previousCursorShape);
        LOG.info("Initialized TerminalOptionsProvider.cursorShape value to " + this.state.getCursorShape());
    }

    private final void initializeTerminalEngine() {
        if (TerminalNewUserTracker.Companion.isNewUser()) {
            this.state.setTerminalEngine(TerminalEngine.REWORKED);
            TerminalNewUserTracker.Companion.clearNewUserValue();
            LOG.info("Initialized TerminalOptionsProvider.terminalEngine to " + this.state.getTerminalEngine() + " (new user).");
        } else {
            this.migrateTerminalEngineFromRegistry();
        }
    }

    private final void migrateTerminalEngineFromRegistry() {
        boolean isReworkedValue = Registry.Companion.is("terminal.new.ui.reworked");
        boolean isNewTerminalValue = Registry.Companion.is("terminal.new.ui");
        this.state.setTerminalEngine(isNewTerminalValue ? TerminalEngine.NEW_TERMINAL : (isReworkedValue ? TerminalEngine.REWORKED : TerminalEngine.CLASSIC));
        LOG.info("Initialized TerminalOptionsProvider.terminalEngine value from registry to " + this.state.getTerminalEngine());
    }

    private static final Unit performSettingsInitializationOnce$lambda$1$lambda$0(TerminalOptionsProvider this$0) {
        this$0.migrateCursorShape();
        return Unit.INSTANCE;
    }

    private static final void performSettingsInitializationOnce$lambda$1(TerminalOptionsProvider this$0) {
        TerminalUiUtilsKt.updateFrontendSettingsAndSync(this$0.coroutineScope, (Function0<Unit>)((Function0)() -> TerminalOptionsProvider.performSettingsInitializationOnce$lambda$1$lambda$0(this$0)));
    }

    @JvmStatic
    @NotNull
    public static final TerminalOptionsProvider getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalOptionsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider$Companion;", "", "<init>", "()V", "instance", "Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider;", "getInstance", "()Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "COMPONENT_NAME", "", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOptionsProvider.kt\norg/jetbrains/plugins/terminal/TerminalOptionsProvider$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,294:1\n40#2,3:295\n*S KotlinDebug\n*F\n+ 1 TerminalOptionsProvider.kt\norg/jetbrains/plugins/terminal/TerminalOptionsProvider$Companion\n*L\n283#1:295,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalOptionsProvider getInstance() {
            boolean $i$f$service = false;
            Class<TerminalOptionsProvider> serviceClass$iv = TerminalOptionsProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TerminalOptionsProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider$PresentableNameGetter;", "Lcom/intellij/openapi/components/State$NameGetter;", "<init>", "()V", "get", "", "intellij.terminal"})
    public static final class PresentableNameGetter
    extends State.NameGetter {
        @NotNull
        public String get() {
            String string = TerminalBundle.message("toolwindow.stripe.Terminal", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001f\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019R\u001a\u0010#\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0017\"\u0004\b%\u0010\u0019R\u001a\u0010&\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0017\"\u0004\b(\u0010\u0019R\u001a\u0010)\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0017\"\u0004\b+\u0010\u0019R\u001a\u0010,\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0017\"\u0004\b.\u0010\u0019R\u001a\u0010/\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0017\"\u0004\b1\u0010\u0019R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R$\u00108\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b9\u0010\u0003\u001a\u0004\b:\u0010\u0017\"\u0004\b;\u0010\u0019R&\u0010<\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b=\u0010\u0003\u001a\u0004\b>\u0010\u0011\"\u0004\b?\u0010\u0013\u00a8\u0006@"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalOptionsProvider$State;", "", "<init>", "()V", "terminalEngine", "Lorg/jetbrains/plugins/terminal/TerminalEngine;", "getTerminalEngine", "()Lorg/jetbrains/plugins/terminal/TerminalEngine;", "setTerminalEngine", "(Lorg/jetbrains/plugins/terminal/TerminalEngine;)V", "terminalEngineInRemDev", "getTerminalEngineInRemDev", "setTerminalEngineInRemDev", "myTabName", "", "Lorg/jetbrains/annotations/Nls;", "getMyTabName", "()Ljava/lang/String;", "setMyTabName", "(Ljava/lang/String;)V", "myCloseSessionOnLogout", "", "getMyCloseSessionOnLogout", "()Z", "setMyCloseSessionOnLogout", "(Z)V", "myReportMouse", "getMyReportMouse", "setMyReportMouse", "mySoundBell", "getMySoundBell", "setMySoundBell", "myCopyOnSelection", "getMyCopyOnSelection", "setMyCopyOnSelection", "myPasteOnMiddleMouseButton", "getMyPasteOnMiddleMouseButton", "setMyPasteOnMiddleMouseButton", "myOverrideIdeShortcuts", "getMyOverrideIdeShortcuts", "setMyOverrideIdeShortcuts", "myShellIntegration", "getMyShellIntegration", "setMyShellIntegration", "myHighlightHyperlinks", "getMyHighlightHyperlinks", "setMyHighlightHyperlinks", "useOptionAsMetaKey", "getUseOptionAsMetaKey", "setUseOptionAsMetaKey", "cursorShape", "Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "getCursorShape", "()Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;", "setCursorShape", "(Lcom/intellij/terminal/TerminalUiSettingsManager$CursorShape;)V", "useShellPrompt", "getUseShellPrompt$annotations", "getUseShellPrompt", "setUseShellPrompt", "myShellPath", "getMyShellPath$annotations", "getMyShellPath", "setMyShellPath", "intellij.terminal"})
    public static final class State {
        @ApiStatus.Internal
        @NotNull
        private TerminalEngine terminalEngine = TerminalEngine.REWORKED;
        @ApiStatus.Internal
        @NotNull
        private TerminalEngine terminalEngineInRemDev = TerminalEngine.REWORKED;
        @NotNull
        private String myTabName;
        private boolean myCloseSessionOnLogout;
        private boolean myReportMouse;
        private boolean mySoundBell;
        private boolean myCopyOnSelection;
        private boolean myPasteOnMiddleMouseButton;
        private boolean myOverrideIdeShortcuts;
        private boolean myShellIntegration;
        private boolean myHighlightHyperlinks;
        private boolean useOptionAsMetaKey;
        @NotNull
        private TerminalUiSettingsManager.CursorShape cursorShape;
        private boolean useShellPrompt;
        @Nullable
        private String myShellPath;

        public State() {
            String string = TerminalBundle.message("local.terminal.default.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.myTabName = string;
            this.myCloseSessionOnLogout = true;
            this.myReportMouse = true;
            this.mySoundBell = true;
            this.myPasteOnMiddleMouseButton = true;
            this.myOverrideIdeShortcuts = true;
            this.myShellIntegration = true;
            this.myHighlightHyperlinks = true;
            this.cursorShape = TerminalUiSettingsManager.CursorShape.BLOCK;
        }

        @NotNull
        public final TerminalEngine getTerminalEngine() {
            return this.terminalEngine;
        }

        public final void setTerminalEngine(@NotNull TerminalEngine terminalEngine) {
            Intrinsics.checkNotNullParameter((Object)((Object)terminalEngine), (String)"<set-?>");
            this.terminalEngine = terminalEngine;
        }

        @NotNull
        public final TerminalEngine getTerminalEngineInRemDev() {
            return this.terminalEngineInRemDev;
        }

        public final void setTerminalEngineInRemDev(@NotNull TerminalEngine terminalEngine) {
            Intrinsics.checkNotNullParameter((Object)((Object)terminalEngine), (String)"<set-?>");
            this.terminalEngineInRemDev = terminalEngine;
        }

        @NotNull
        public final String getMyTabName() {
            return this.myTabName;
        }

        public final void setMyTabName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.myTabName = string;
        }

        public final boolean getMyCloseSessionOnLogout() {
            return this.myCloseSessionOnLogout;
        }

        public final void setMyCloseSessionOnLogout(boolean bl) {
            this.myCloseSessionOnLogout = bl;
        }

        public final boolean getMyReportMouse() {
            return this.myReportMouse;
        }

        public final void setMyReportMouse(boolean bl) {
            this.myReportMouse = bl;
        }

        public final boolean getMySoundBell() {
            return this.mySoundBell;
        }

        public final void setMySoundBell(boolean bl) {
            this.mySoundBell = bl;
        }

        public final boolean getMyCopyOnSelection() {
            return this.myCopyOnSelection;
        }

        public final void setMyCopyOnSelection(boolean bl) {
            this.myCopyOnSelection = bl;
        }

        public final boolean getMyPasteOnMiddleMouseButton() {
            return this.myPasteOnMiddleMouseButton;
        }

        public final void setMyPasteOnMiddleMouseButton(boolean bl) {
            this.myPasteOnMiddleMouseButton = bl;
        }

        public final boolean getMyOverrideIdeShortcuts() {
            return this.myOverrideIdeShortcuts;
        }

        public final void setMyOverrideIdeShortcuts(boolean bl) {
            this.myOverrideIdeShortcuts = bl;
        }

        public final boolean getMyShellIntegration() {
            return this.myShellIntegration;
        }

        public final void setMyShellIntegration(boolean bl) {
            this.myShellIntegration = bl;
        }

        public final boolean getMyHighlightHyperlinks() {
            return this.myHighlightHyperlinks;
        }

        public final void setMyHighlightHyperlinks(boolean bl) {
            this.myHighlightHyperlinks = bl;
        }

        public final boolean getUseOptionAsMetaKey() {
            return this.useOptionAsMetaKey;
        }

        public final void setUseOptionAsMetaKey(boolean bl) {
            this.useOptionAsMetaKey = bl;
        }

        @NotNull
        public final TerminalUiSettingsManager.CursorShape getCursorShape() {
            return this.cursorShape;
        }

        public final void setCursorShape(@NotNull TerminalUiSettingsManager.CursorShape cursorShape) {
            Intrinsics.checkNotNullParameter((Object)cursorShape, (String)"<set-?>");
            this.cursorShape = cursorShape;
        }

        public final boolean getUseShellPrompt() {
            return this.useShellPrompt;
        }

        public final void setUseShellPrompt(boolean bl) {
            this.useShellPrompt = bl;
        }

        @Deprecated(message="Use BlockTerminalOptions#promptStyle instead")
        public static /* synthetic */ void getUseShellPrompt$annotations() {
        }

        @Nullable
        public final String getMyShellPath() {
            return this.myShellPath;
        }

        public final void setMyShellPath(@Nullable String string) {
            this.myShellPath = string;
        }

        @Deprecated(message="Use TerminalLocalOptions#shellPath instead", replaceWith=@ReplaceWith(expression="TerminalLocalOptions.getInstance().shellPath", imports={}))
        public static /* synthetic */ void getMyShellPath$annotations() {
        }
    }
}

