//////////////////////////////////////////////////////////////////////////////
//
// 		  Copyright (C) 1996,1997  Matthew Doar  doar@pobox.com
// 
// Permission to use, copy, and distribute this software and its documentation 
// for any purpose with or without fee is hereby granted, provided that the 
// above copyright notice appears with all copies and that both that copyright 
// notice and this permission notice appear in supporting documentation. 
// 
// Permission to modify the software is granted, but not the right to 
// distribute the modified code. Modifications are to be distributed as 
// patches to the released version. 
// 
// This software is provided "as is" without express or implied warranty. 
//
//////////////////////////////////////////////////////////////////////////////

// tiers_dists.cc
#include <math.h>

#ifndef _TIERS_HH
#include "tiers.hh"
#endif

extern "C" 
{
  long random(void);
}

//
// Numbers of networks
//
// Note: the maximum value returned from any of the N distribution
// functions must be less than or equal to N. This is because N is
// used to allocate space for the maximum number of edges
//


////////////////////////////////////////////////////////////////////////
// Model::NMdist
//
// Return the number of MANs to be used.
//
// Currently just equal to NM
////////////////////////////////////////////////////////////////////////
const unsigned long int
Model::NMdist(const unsigned long int aNM)
{
  return aNM;
}


////////////////////////////////////////////////////////////////////////
// Model::NLdist
//
// Return the number of LANs to be used.
// 
// Currently just equal to NL
////////////////////////////////////////////////////////////////////////
const unsigned long int
Model::NLdist(const unsigned long int aNL)
{
  return aNL;
}

//
// Numbers of nodes per network
//


////////////////////////////////////////////////////////////////////////
// Model::SWdist
//
// Return the number of nodes per WAN
////////////////////////////////////////////////////////////////////////
const unsigned long int
Model::SWdist(const unsigned long int aSW)
{
  return aSW;
}



////////////////////////////////////////////////////////////////////////
// Model::SMdist
//
// Return the number of nodes per MAN
////////////////////////////////////////////////////////////////////////
const unsigned long int
Model::SMdist(const unsigned long int aSM)
{
  return aSM;
}



////////////////////////////////////////////////////////////////////////
// Model::SLdist
//
// Return the number of nodes per LAN.
////////////////////////////////////////////////////////////////////////
const unsigned long int
Model::SLdist(const unsigned long int aSL)
{
  return aSL;
}


//
// Intranetwork redundancy values
//
// Note: the maximum value returned from any of the R distribution
// functions must be less than or equal to R. This is because R is
// used to allocate space for the maximum number of extra edges


////////////////////////////////////////////////////////////////////////
// Model::RWdist
//
// Return the number of edges required from a node
// A uniform distribution between 1 and RW
////////////////////////////////////////////////////////////////////////
const unsigned long int
Model::RWdist(const unsigned long int aRW)
{
  return ((random() % aRW) + 1);
  //  return aRW; // for testing 
}


////////////////////////////////////////////////////////////////////////
// Model::RMdist
//
// Return the number of edges required from a node
// A uniform distribution between 1 and RM
////////////////////////////////////////////////////////////////////////
const unsigned long int
Model::RMdist(const unsigned long int aRM)
{
  return ((random() % aRM) + 1);
  //return aRM; // for testing 
}


////////////////////////////////////////////////////////////////////////
// Model::RLdist
//
// Return the number of edges required from a node
////////////////////////////////////////////////////////////////////////
const unsigned long int
Model::RLdist(const unsigned long int aRL)
{
  //  return ((random() % aRL) + 1);
  return (1);	// redundancy in the LAN is not supported
}

//
// Intranetwork redundancy values
//
 

////////////////////////////////////////////////////////////////////////
// Model::RMWdist
//
// Return the number of edges required from a MAN to the WAN
// A uniform distribution between 1 and RMW
////////////////////////////////////////////////////////////////////////
const unsigned long int
Model::RMWdist(const unsigned long int aRMW)
{
  return ((random() % aRMW) + 1);
  //  return aRMW; // for testing 
}


////////////////////////////////////////////////////////////////////////
// Model::RLMdist
//
// Return the number of edges required from a LAN to its MAN
// A uniform distribution between 1 and RLM
////////////////////////////////////////////////////////////////////////
const unsigned long int
Model::RLMdist(const unsigned long int aRLM)
{
  return ((random() % aRLM) + 1);
  //  return aRLM; // for testing 
}


// end of file

