// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) TypeSpec Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

#pragma once

#include "azure/keyvault/keys/dll_import_export.hpp"

#include <azure/core/datetime.hpp>
#include <azure/core/internal/extendable_enumeration.hpp>
#include <azure/core/nullable.hpp>

#include <cstdint>
#include <map>
#include <string>
#include <utility>
#include <vector>

namespace Azure { namespace Security { namespace KeyVault { namespace Keys { namespace _detail {
  namespace Models {
    /**
     * @brief JsonWebKey Key Type (kty), as defined in
     * https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
     *
     */
    class JsonWebKeyType final : public Core::_internal::ExtendableEnumeration<JsonWebKeyType> {
    public:
      /**
       * @brief Constructs a new JsonWebKeyType instance.
       *
       **/
      JsonWebKeyType() = default;

      /**
       * @brief Constructs a new JsonWebKeyType instance from a string.
       * @param jsonWebKeyType String value to construct the new instance from.
       *
       **/
      explicit JsonWebKeyType(std::string jsonWebKeyType)
          : ExtendableEnumeration(std::move(jsonWebKeyType))
      {
      }

      /// Elliptic Curve.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyType EC;

      /// Elliptic Curve with a private key which is stored in the HSM.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyType ECHsm;

      /// RSA (https://tools.ietf.org/html/rfc3447)
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyType Rsa;

      /// RSA with a private key which is stored in the HSM.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyType RsaHsm;

      /// Octet sequence (used to represent symmetric keys)
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyType Oct;

      /// Octet sequence (used to represent symmetric keys) which is stored the HSM.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyType OctHsm;
    };

    /**
     * @brief Elliptic curve name. For valid values, see JsonWebKeyCurveName.
     *
     */
    class JsonWebKeyCurveName final
        : public Core::_internal::ExtendableEnumeration<JsonWebKeyCurveName> {
    public:
      /**
       * @brief Constructs a new JsonWebKeyCurveName instance.
       *
       **/
      JsonWebKeyCurveName() = default;

      /**
       * @brief Constructs a new JsonWebKeyCurveName instance from a string.
       * @param jsonWebKeyCurveName String value to construct the new instance from.
       *
       **/
      explicit JsonWebKeyCurveName(std::string jsonWebKeyCurveName)
          : ExtendableEnumeration(std::move(jsonWebKeyCurveName))
      {
      }

      /// The NIST P-256 elliptic curve, AKA SECG curve SECP256R1.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyCurveName PTwoHundredFiftySix;

      /// The NIST P-384 elliptic curve, AKA SECG curve SECP384R1.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyCurveName PThreeHundredEightyFour;

      /// The NIST P-521 elliptic curve, AKA SECG curve SECP521R1.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyCurveName PFiveHundredTwentyOne;

      /// The SECG SECP256K1 elliptic curve.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyCurveName P256k;
    };

    /**
     * @brief Reflects the deletion recovery level currently in effect for certificates in the
     * current vault. If it contains 'Purgeable', the certificate can be permanently deleted by a
     * privileged user; otherwise, only the system can purge the certificate, at the end of the
     * retention interval.
     *
     */
    class DeletionRecoveryLevel final
        : public Core::_internal::ExtendableEnumeration<DeletionRecoveryLevel> {
    public:
      /**
       * @brief Constructs a new DeletionRecoveryLevel instance.
       *
       **/
      DeletionRecoveryLevel() = default;

      /**
       * @brief Constructs a new DeletionRecoveryLevel instance from a string.
       * @param deletionRecoveryLevel String value to construct the new instance from.
       *
       **/
      explicit DeletionRecoveryLevel(std::string deletionRecoveryLevel)
          : ExtendableEnumeration(std::move(deletionRecoveryLevel))
      {
      }

      /// Denotes a vault state in which deletion is an irreversible operation, without the
      /// possibility for recovery. This level corresponds to no protection being available against
      /// a Delete operation; the data is irretrievably lost upon accepting a Delete operation at
      /// the entity level or higher (vault, resource group, subscription etc.)
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const DeletionRecoveryLevel Purgeable;

      /// Denotes a vault state in which deletion is recoverable, and which also permits immediate
      /// and permanent deletion (i.e. purge). This level guarantees the recoverability of the
      /// deleted entity during the retention interval (90 days), unless a Purge operation is
      /// requested, or the subscription is cancelled. System wil permanently delete it after 90
      /// days, if not recovered
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const DeletionRecoveryLevel RecoverablePurgeable;

      /// Denotes a vault state in which deletion is recoverable without the possibility for
      /// immediate and permanent deletion (i.e. purge). This level guarantees the recoverability of
      /// the deleted entity during the retention interval(90 days) and while the subscription is
      /// still available. System wil permanently delete it after 90 days, if not recovered
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const DeletionRecoveryLevel Recoverable;

      /// Denotes a vault and subscription state in which deletion is recoverable within retention
      /// interval (90 days), immediate and permanent deletion (i.e. purge) is not permitted, and in
      /// which the subscription itself  cannot be permanently canceled. System wil permanently
      /// delete it after 90 days, if not recovered
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const DeletionRecoveryLevel
          RecoverableProtectedSubscription;

      /// Denotes a vault state in which deletion is recoverable, and which also permits immediate
      /// and permanent deletion (i.e. purge when 7 <= SoftDeleteRetentionInDays < 90). This level
      /// guarantees the recoverability of the deleted entity during the retention interval, unless
      /// a Purge operation is requested, or the subscription is cancelled.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const DeletionRecoveryLevel
          CustomizedRecoverablePurgeable;

      /// Denotes a vault state in which deletion is recoverable without the possibility for
      /// immediate and permanent deletion (i.e. purge when 7 <= SoftDeleteRetentionInDays <
      /// 90).This level guarantees the recoverability of the deleted entity during the retention
      /// interval and while the subscription is still available.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const DeletionRecoveryLevel CustomizedRecoverable;

      /// Denotes a vault and subscription state in which deletion is recoverable, immediate and
      /// permanent deletion (i.e. purge) is not permitted, and in which the subscription itself
      /// cannot be permanently canceled when 7 <= SoftDeleteRetentionInDays < 90. This level
      /// guarantees the recoverability of the deleted entity during the retention interval, and
      /// also reflects the fact that the subscription itself cannot be cancelled.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const DeletionRecoveryLevel
          CustomizedRecoverableProtectedSubscription;
    };

    /**
     * @brief JSON web key operations. For more information, see JsonWebKeyOperation.
     *
     */
    class JsonWebKeyOperation final
        : public Core::_internal::ExtendableEnumeration<JsonWebKeyOperation> {
    public:
      /**
       * @brief Constructs a new JsonWebKeyOperation instance.
       *
       **/
      JsonWebKeyOperation() = default;

      /**
       * @brief Constructs a new JsonWebKeyOperation instance from a string.
       * @param jsonWebKeyOperation String value to construct the new instance from.
       *
       **/
      explicit JsonWebKeyOperation(std::string jsonWebKeyOperation)
          : ExtendableEnumeration(std::move(jsonWebKeyOperation))
      {
      }

      /// Indicates that the key can be used to encrypt.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyOperation Encrypt;

      /// Indicates that the key can be used to decrypt.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyOperation Decrypt;

      /// Indicates that the key can be used to sign.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyOperation Sign;

      /// Indicates that the key can be used to verify.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyOperation Verify;

      /// Indicates that the key can be used to wrap another key.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyOperation WrapKey;

      /// Indicates that the key can be used to unwrap another key.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyOperation UnwrapKey;

      /// Indicates that the key can be imported during creation.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyOperation Import;

      /// Indicates that the private component of the key can be exported.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyOperation Export;
    };

    /**
     * @brief An algorithm used for encryption and decryption.
     *
     */
    class JsonWebKeyEncryptionAlgorithm final
        : public Core::_internal::ExtendableEnumeration<JsonWebKeyEncryptionAlgorithm> {
    public:
      /**
       * @brief Constructs a new JsonWebKeyEncryptionAlgorithm instance.
       *
       **/
      JsonWebKeyEncryptionAlgorithm() = default;

      /**
       * @brief Constructs a new JsonWebKeyEncryptionAlgorithm instance from a string.
       * @param jsonWebKeyEncryptionAlgorithm String value to construct the new instance from.
       *
       **/
      explicit JsonWebKeyEncryptionAlgorithm(std::string jsonWebKeyEncryptionAlgorithm)
          : ExtendableEnumeration(std::move(jsonWebKeyEncryptionAlgorithm))
      {
      }

      /// [Not recommended] RSAES using Optimal Asymmetric Encryption Padding (OAEP), as described
      /// in https://tools.ietf.org/html/rfc3447, with the default parameters specified by RFC 3447
      /// in Section A.2.1. Those default parameters are using a hash function of SHA-1 and a mask
      /// generation function of MGF1 with SHA-1. Microsoft recommends using RSA_OAEP_256 or
      /// stronger algorithms for enhanced security. Microsoft does *not* recommend RSA_OAEP, which
      /// is included solely for backwards compatibility. RSA_OAEP utilizes SHA1, which has known
      /// collision problems.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm RsaOaep;

      /// RSAES using Optimal Asymmetric Encryption Padding with a hash function of SHA-256 and a
      /// mask generation function of MGF1 with SHA-256.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm
          RsaOaepTwoHundredFiftySix;

      /// [Not recommended] RSAES-PKCS1-V1_5 key encryption, as described in
      /// https://tools.ietf.org/html/rfc3447. Microsoft recommends using RSA_OAEP_256 or stronger
      /// algorithms for enhanced security. Microsoft does *not* recommend RSA_1_5, which is
      /// included solely for backwards compatibility. Cryptographic standards no longer consider
      /// RSA with the PKCS#1 v1.5 padding scheme secure for encryption.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm Rsa1Five;

      /// 128-bit AES-GCM.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm A128gcm;

      /// 192-bit AES-GCM.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm A192gcm;

      /// 256-bit AES-GCM.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm A256gcm;

      /// 128-bit AES key wrap.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm A128kw;

      /// 192-bit AES key wrap.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm A192kw;

      /// 256-bit AES key wrap.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm A256kw;

      /// 128-bit AES-CBC.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm A128cbc;

      /// 192-bit AES-CBC.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm A192cbc;

      /// 256-bit AES-CBC.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm A256cbc;

      /// 128-bit AES-CBC with PKCS padding.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm A128cbcpad;

      /// 192-bit AES-CBC with PKCS padding.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm A192cbcpad;

      /// 256-bit AES-CBC with PKCS padding.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm A256cbcpad;

      /// CKM AES key wrap.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm CkmAesKeyWrap;

      /// CKM AES key wrap with padding.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeyEncryptionAlgorithm
          CkmAesKeyWrapPad;
    };

    /**
     * @brief The signing/verification algorithm identifier. For more information on possible
     * algorithm types, see JsonWebKeySignatureAlgorithm.
     *
     */
    class JsonWebKeySignatureAlgorithm final
        : public Core::_internal::ExtendableEnumeration<JsonWebKeySignatureAlgorithm> {
    public:
      /**
       * @brief Constructs a new JsonWebKeySignatureAlgorithm instance.
       *
       **/
      JsonWebKeySignatureAlgorithm() = default;

      /**
       * @brief Constructs a new JsonWebKeySignatureAlgorithm instance from a string.
       * @param jsonWebKeySignatureAlgorithm String value to construct the new instance from.
       *
       **/
      explicit JsonWebKeySignatureAlgorithm(std::string jsonWebKeySignatureAlgorithm)
          : ExtendableEnumeration(std::move(jsonWebKeySignatureAlgorithm))
      {
      }

      /// RSASSA-PSS using SHA-256 and MGF1 with SHA-256, as described in
      /// https://tools.ietf.org/html/rfc7518
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Ps256;

      /// RSASSA-PSS using SHA-384 and MGF1 with SHA-384, as described in
      /// https://tools.ietf.org/html/rfc7518
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Ps384;

      /// RSASSA-PSS using SHA-512 and MGF1 with SHA-512, as described in
      /// https://tools.ietf.org/html/rfc7518
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Ps512;

      /// RSASSA-PKCS1-v1_5 using SHA-256, as described in https://tools.ietf.org/html/rfc7518
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Rs256;

      /// RSASSA-PKCS1-v1_5 using SHA-384, as described in https://tools.ietf.org/html/rfc7518
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Rs384;

      /// RSASSA-PKCS1-v1_5 using SHA-512, as described in https://tools.ietf.org/html/rfc7518
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Rs512;

      /// HMAC using SHA-256, as described in  https://tools.ietf.org/html/rfc7518
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Hs256;

      /// HMAC using SHA-384, as described in https://tools.ietf.org/html/rfc7518
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Hs384;

      /// HMAC using SHA-512, as described in https://tools.ietf.org/html/rfc7518
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Hs512;

      /// Reserved
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Rsnull;

      /// ECDSA using P-256 and SHA-256, as described in https://tools.ietf.org/html/rfc7518.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Es256;

      /// ECDSA using P-384 and SHA-384, as described in https://tools.ietf.org/html/rfc7518
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Es384;

      /// ECDSA using P-521 and SHA-512, as described in https://tools.ietf.org/html/rfc7518
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Es512;

      /// ECDSA using P-256K and SHA-256, as described in https://tools.ietf.org/html/rfc7518
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const JsonWebKeySignatureAlgorithm Es256k;
    };

    /**
     * @brief The encryption algorithm to use to protected the exported key material
     *
     */
    class KeyEncryptionAlgorithm final
        : public Core::_internal::ExtendableEnumeration<KeyEncryptionAlgorithm> {
    public:
      /**
       * @brief Constructs a new KeyEncryptionAlgorithm instance.
       *
       **/
      KeyEncryptionAlgorithm() = default;

      /**
       * @brief Constructs a new KeyEncryptionAlgorithm instance from a string.
       * @param keyEncryptionAlgorithm String value to construct the new instance from.
       *
       **/
      explicit KeyEncryptionAlgorithm(std::string keyEncryptionAlgorithm)
          : ExtendableEnumeration(std::move(keyEncryptionAlgorithm))
      {
      }

      /// The CKM_RSA_AES_KEY_WRAP key wrap mechanism.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const KeyEncryptionAlgorithm CkmRsaAesKeyWrap;

      /// The RSA_AES_KEY_WRAP_256 key wrap mechanism.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const KeyEncryptionAlgorithm
          RsaAesKeyWrapTwoHundredFiftySix;

      /// The RSA_AES_KEY_WRAP_384 key wrap mechanism.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const KeyEncryptionAlgorithm
          RsaAesKeyWrapThreeHundredEightyFour;
    };

    /**
     * @brief The type of the action. The value should be compared case-insensitively.
     *
     */
    class KeyRotationPolicyAction final
        : public Core::_internal::ExtendableEnumeration<KeyRotationPolicyAction> {
    public:
      /**
       * @brief Constructs a new KeyRotationPolicyAction instance.
       *
       **/
      KeyRotationPolicyAction() = default;

      /**
       * @brief Constructs a new KeyRotationPolicyAction instance from a string.
       * @param keyRotationPolicyAction String value to construct the new instance from.
       *
       **/
      explicit KeyRotationPolicyAction(std::string keyRotationPolicyAction)
          : ExtendableEnumeration(std::move(keyRotationPolicyAction))
      {
      }

      /// Rotate the key based on the key policy.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const KeyRotationPolicyAction Rotate;

      /// Trigger Event Grid events. Defaults to 30 days before expiry. Key Vault only.
      AZ_SECURITY_KEYVAULT_KEYS_DLLEXPORT static const KeyRotationPolicyAction Notify;
    };

    /**
     * @brief As of http://tools.ietf.org/html/draft-ietf-jose-json-web-key-18
     *
     */
    struct JsonWebKey final
    {
      /// Key identifier.
      Nullable<std::string> Kid;

      /// JsonWebKey Key Type (kty), as defined in
      /// https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
      Nullable<JsonWebKeyType> Kty;

      /// Json web key operations. For more information on possible key operations, see
      /// JsonWebKeyOperation.
      Nullable<std::vector<std::string>> KeyOps;

      /// RSA modulus.
      Nullable<std::vector<std::uint8_t>> N;

      /// RSA public exponent.
      Nullable<std::vector<std::uint8_t>> E;

      /// RSA private exponent, or the D component of an EC private key.
      Nullable<std::vector<std::uint8_t>> D;

      /// RSA private key parameter.
      Nullable<std::vector<std::uint8_t>> Dp;

      /// RSA private key parameter.
      Nullable<std::vector<std::uint8_t>> Dq;

      /// RSA private key parameter.
      Nullable<std::vector<std::uint8_t>> Qi;

      /// RSA secret prime.
      Nullable<std::vector<std::uint8_t>> P;

      /// RSA secret prime, with p < q.
      Nullable<std::vector<std::uint8_t>> Q;

      /// Symmetric key.
      Nullable<std::vector<std::uint8_t>> K;

      /// Protected Key, used with 'Bring Your Own Key'.
      Nullable<std::vector<std::uint8_t>> T;

      /// Elliptic curve name. For valid values, see JsonWebKeyCurveName.
      Nullable<JsonWebKeyCurveName> Crv;

      /// X component of an EC public key.
      Nullable<std::vector<std::uint8_t>> X;

      /// Y component of an EC public key.
      Nullable<std::vector<std::uint8_t>> Y;
    };

    /**
     * @brief The key attestation information.
     *
     */
    struct KeyAttestation final
    {
      /// A base64url-encoded string containing certificates in PEM format, used for attestation
      /// validation.
      Nullable<std::vector<std::uint8_t>> CertificatePemFile;

      /// The attestation blob bytes encoded as base64url string corresponding to a private key.
      Nullable<std::vector<std::uint8_t>> PrivateKeyAttestation;

      /// The attestation blob bytes encoded as base64url string corresponding to a public key in
      /// case of asymmetric key.
      Nullable<std::vector<std::uint8_t>> PublicKeyAttestation;

      /// The version of the attestation.
      Nullable<std::string> Version;
    };

    /**
     * @brief The attributes of a key managed by the key vault service.
     *
     */
    struct KeyAttributes final
    {
      /// Determines whether the object is enabled.
      Nullable<bool> Enabled;

      /// Not before date in UTC.
      Nullable<DateTime> NotBefore;

      /// Expiry date in UTC.
      Nullable<DateTime> Expires;

      /// [out] Creation time in UTC.
      Nullable<DateTime> Created;

      /// [out] Last updated time in UTC.
      Nullable<DateTime> Updated;

      /// [out] softDelete data retention days. Value should be >=7 and <=90 when softDelete
      /// enabled, otherwise 0.
      Nullable<std::int32_t> RecoverableDays;

      /// [out] Reflects the deletion recovery level currently in effect for keys in the current
      /// vault. If it contains 'Purgeable' the key can be permanently deleted by a privileged user;
      /// otherwise, only the system can purge the key, at the end of the retention interval.
      Nullable<DeletionRecoveryLevel> RecoveryLevel;

      /// Indicates if the private key can be exported. Release policy must be provided when
      /// creating the first version of an exportable key.
      Nullable<bool> Exportable;

      /// [out] The underlying HSM Platform.
      Nullable<std::string> HsmPlatform;

      /// The key or key version attestation information.
      Nullable<KeyAttestation> Attestation;
    };

    /**
     * @brief The policy rules under which the key can be exported.
     *
     */
    struct KeyReleasePolicy final
    {
      /// Content type and version of key release policy
      Nullable<std::string> ContentType;

      /// Defines the mutability state of the policy. Once marked immutable, this flag cannot be
      /// reset and the policy cannot be changed under any circumstances.
      Nullable<bool> Immutable;

      /// Blob encoding the policy rules under which the key can be released. Blob must be base64
      /// URL encoded.
      Nullable<std::vector<std::uint8_t>> EncodedPolicy;
    };

    /**
     * @brief A KeyBundle consisting of a WebKey plus its attributes.
     *
     */
    struct KeyBundle final
    {
      /// The Json web key.
      Nullable<JsonWebKey> Key;

      /// The key management attributes.
      Nullable<KeyAttributes> Attributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;

      /// [out] True if the key's lifetime is managed by key vault. If this is a key backing a
      /// certificate, then managed will be true.
      Nullable<bool> Managed;

      /// The policy rules under which the key can be exported.
      Nullable<KeyReleasePolicy> ReleasePolicy;
    };

    /**
     * @brief The key create parameters.
     *
     */
    struct KeyCreateParameters final
    {
      /// The type of key to create. For valid values, see JsonWebKeyType.
      JsonWebKeyType Kty;

      /// The key size in bits. For example: 2048, 3072, or 4096 for RSA.
      Nullable<std::int32_t> KeySize;

      /// The public exponent for a RSA key.
      Nullable<std::int32_t> PublicExponent;

      /// Json web key operations. For more information on possible key operations, see
      /// JsonWebKeyOperation.
      Nullable<std::vector<JsonWebKeyOperation>> KeyOps;

      /// The attributes of a key managed by the key vault service.
      Nullable<Models::KeyAttributes> KeyAttributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;

      /// Elliptic curve name. For valid values, see JsonWebKeyCurveName.
      Nullable<JsonWebKeyCurveName> Curve;

      /// The policy rules under which the key can be exported.
      Nullable<KeyReleasePolicy> ReleasePolicy;
    };

    /**
     * @brief The key import parameters.
     *
     */
    struct KeyImportParameters final
    {
      /// Whether to import as a hardware key (HSM) or software key.
      Nullable<bool> Hsm;

      /// The Json web key
      JsonWebKey Key;

      /// The key management attributes.
      Nullable<Models::KeyAttributes> KeyAttributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;

      /// The policy rules under which the key can be exported.
      Nullable<KeyReleasePolicy> ReleasePolicy;
    };

    /**
     * @brief A DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info
     *
     */
    struct DeletedKeyBundle final
    {
      /// The Json web key.
      Nullable<JsonWebKey> Key;

      /// The key management attributes.
      Nullable<KeyAttributes> Attributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;

      /// [out] True if the key's lifetime is managed by key vault. If this is a key backing a
      /// certificate, then managed will be true.
      Nullable<bool> Managed;

      /// The policy rules under which the key can be exported.
      Nullable<KeyReleasePolicy> ReleasePolicy;

      /// The url of the recovery object, used to identify and recover the deleted key.
      Nullable<std::string> RecoveryId;

      /// [out] The time when the key is scheduled to be purged, in UTC
      Nullable<DateTime> ScheduledPurgeDate;

      /// [out] The time when the key was deleted, in UTC
      Nullable<DateTime> DeletedDate;
    };

    /**
     * @brief The key update parameters.
     *
     */
    struct KeyUpdateParameters final
    {
      /// Json web key operations. For more information on possible key operations, see
      /// JsonWebKeyOperation.
      Nullable<std::vector<JsonWebKeyOperation>> KeyOps;

      /// The attributes of a key managed by the key vault service.
      Nullable<Models::KeyAttributes> KeyAttributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;

      /// The policy rules under which the key can be exported.
      Nullable<KeyReleasePolicy> ReleasePolicy;
    };

    /**
     * @brief The key item containing key metadata.
     *
     */
    struct KeyItem final
    {
      /// Key identifier.
      Nullable<std::string> Kid;

      /// The key management attributes.
      Nullable<KeyAttributes> Attributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;

      /// [out] True if the key's lifetime is managed by key vault. If this is a key backing a
      /// certificate, then managed will be true.
      Nullable<bool> Managed;
    };

    /**
     * @brief The backup key result, containing the backup blob.
     *
     */
    struct BackupKeyResult final
    {
      /// [out] The backup blob containing the backed up key.
      Nullable<std::vector<std::uint8_t>> Value;
    };

    /**
     * @brief The key restore parameters.
     *
     */
    struct KeyRestoreParameters final
    {
      /// The backup blob associated with a key bundle.
      std::vector<std::uint8_t> KeyBundleBackup;
    };

    /**
     * @brief The key operation result.
     *
     */
    struct KeyOperationResult final
    {
      /// [out] Key identifier
      Nullable<std::string> Kid;

      /// [out] The result of the operation.
      Nullable<std::vector<std::uint8_t>> Result;

      /// [out] Cryptographically random, non-repeating initialization vector for symmetric
      /// algorithms.
      Nullable<std::vector<std::uint8_t>> Iv;

      /// [out] The tag to authenticate when performing decryption with an authenticated algorithm.
      Nullable<std::vector<std::uint8_t>> AuthenticationTag;

      /// [out] Additional data to authenticate but not encrypt/decrypt when using authenticated
      /// crypto algorithms.
      Nullable<std::vector<std::uint8_t>> AdditionalAuthenticatedData;
    };

    /**
     * @brief The key operations parameters.
     *
     */
    struct KeyOperationsParameters final
    {
      /// algorithm identifier
      JsonWebKeyEncryptionAlgorithm Algorithm;

      /// The value to operate on.
      std::vector<std::uint8_t> Value;

      /// Cryptographically random, non-repeating initialization vector for symmetric algorithms.
      Nullable<std::vector<std::uint8_t>> Iv;

      /// Additional data to authenticate but not encrypt/decrypt when using authenticated crypto
      /// algorithms.
      Nullable<std::vector<std::uint8_t>> Aad;

      /// The tag to authenticate when performing decryption with an authenticated algorithm.
      Nullable<std::vector<std::uint8_t>> Tag;
    };

    /**
     * @brief The key operations parameters.
     *
     */
    struct KeySignParameters final
    {
      /// The signing/verification algorithm identifier. For more information on possible algorithm
      /// types, see JsonWebKeySignatureAlgorithm.
      JsonWebKeySignatureAlgorithm Algorithm;

      /// The value to operate on.
      std::vector<std::uint8_t> Value;
    };

    /**
     * @brief The key verify result.
     *
     */
    struct KeyVerifyResult final
    {
      /// [out] True if the signature is verified, otherwise false.
      Nullable<bool> Value;
    };

    /**
     * @brief The key verify parameters.
     *
     */
    struct KeyVerifyParameters final
    {
      /// The signing/verification algorithm. For more information on possible algorithm types, see
      /// JsonWebKeySignatureAlgorithm.
      JsonWebKeySignatureAlgorithm Algorithm;

      /// The digest used for signing.
      std::vector<std::uint8_t> Digest;

      /// The signature to be verified.
      std::vector<std::uint8_t> Signature;
    };

    /**
     * @brief The release result, containing the released key.
     *
     */
    struct KeyReleaseResult final
    {
      /// [out] A signed object containing the released key.
      Nullable<std::string> Value;
    };

    /**
     * @brief The release key parameters.
     *
     */
    struct KeyReleaseParameters final
    {
      /// The attestation assertion for the target of the key release.
      std::string TargetAttestationToken;

      /// A client provided nonce for freshness.
      Nullable<std::string> Nonce;

      /// The encryption algorithm to use to protected the exported key material
      Nullable<KeyEncryptionAlgorithm> Enc;
    };

    /**
     * @brief The deleted key item containing the deleted key metadata and information about
     * deletion.
     *
     */
    struct DeletedKeyItem final
    {
      /// Key identifier.
      Nullable<std::string> Kid;

      /// The key management attributes.
      Nullable<KeyAttributes> Attributes;

      /// Application specific metadata in the form of key-value pairs.
      Nullable<std::map<std::string, std::string>> Tags;

      /// [out] True if the key's lifetime is managed by key vault. If this is a key backing a
      /// certificate, then managed will be true.
      Nullable<bool> Managed;

      /// The url of the recovery object, used to identify and recover the deleted key.
      Nullable<std::string> RecoveryId;

      /// [out] The time when the key is scheduled to be purged, in UTC
      Nullable<DateTime> ScheduledPurgeDate;

      /// [out] The time when the key was deleted, in UTC
      Nullable<DateTime> DeletedDate;
    };

    /**
     * @brief PurgeDeletedKey operation result.
     *
     */
    struct PurgeDeletedKeyResult final
    {
    };

    /**
     * @brief A condition to be satisfied for an action to be executed.
     *
     */
    struct LifetimeActionsTrigger final
    {
      /// Time after creation to attempt to rotate. It only applies to rotate. It will be in ISO
      /// 8601 duration format. Example: 90 days : "P90D"
      Nullable<std::string> TimeAfterCreate;

      /// Time before expiry to attempt to rotate or notify. It will be in ISO 8601 duration format.
      /// Example: 90 days : "P90D"
      Nullable<std::string> TimeBeforeExpiry;
    };

    /**
     * @brief The action that will be executed.
     *
     */
    struct LifetimeActionsType final
    {
      /// The type of the action. The value should be compared case-insensitively.
      Nullable<KeyRotationPolicyAction> Type;
    };

    /**
     * @brief Action and its trigger that will be performed by Key Vault over the lifetime of a key.
     *
     */
    struct LifetimeActions final
    {
      /// The condition that will execute the action.
      Nullable<LifetimeActionsTrigger> Trigger;

      /// The action that will be executed.
      Nullable<LifetimeActionsType> Action;
    };

    /**
     * @brief The key rotation policy attributes.
     *
     */
    struct KeyRotationPolicyAttributes final
    {
      /// The expiryTime will be applied on the new key version. It should be at least 28 days. It
      /// will be in ISO 8601 Format. Examples: 90 days: P90D, 3 months: P3M, 48 hours: PT48H, 1
      /// year and 10 days: P1Y10D
      Nullable<std::string> ExpiryTime;

      /// [out] The key rotation policy created time in UTC.
      Nullable<DateTime> Created;

      /// [out] The key rotation policy's last updated time in UTC.
      Nullable<DateTime> Updated;
    };

    /**
     * @brief Management policy for a key.
     *
     */
    struct KeyRotationPolicy final
    {
      /// [out] The key policy id.
      Nullable<std::string> Id;

      /// Actions that will be performed by Key Vault over the lifetime of a key. For preview,
      /// lifetimeActions can only have two items at maximum: one for rotate, one for notify.
      /// Notification time would be default to 30 days before expiry and it is not configurable.
      Nullable<std::vector<Models::LifetimeActions>> LifetimeActions;

      /// The key rotation policy attributes.
      Nullable<KeyRotationPolicyAttributes> Attributes;
    };

    /**
     * @brief The get random bytes response object containing the bytes.
     *
     */
    struct RandomBytes final
    {
      /// The bytes encoded as a base64url string.
      std::vector<std::uint8_t> Value;
    };

    /**
     * @brief The get random bytes request object.
     *
     */
    struct GetRandomBytesRequest final
    {
      /// The requested number of random bytes.
      std::int32_t Count = 0;
    };
}}}}}} // namespace Azure::Security::KeyVault::Keys::_detail::Models
