/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import javax.naming.spi.StateFactory;
import org.apache.harmony.jndi.internal.EnvironmentReader;
import org.apache.harmony.jndi.internal.UrlParser;
import org.apache.harmony.jndi.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingManager {
    public static final String CPE = "java.naming.spi.CannotProceedException";
    static InitialContextFactoryBuilder icfb;
    static ObjectFactoryBuilder ofb;

    NamingManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitialContextFactoryBuilder(InitialContextFactoryBuilder icfb) throws IllegalStateException, SecurityException, NamingException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        Class<NamingManager> clazz = NamingManager.class;
        synchronized (NamingManager.class) {
            if (NamingManager.icfb != null) {
                throw new IllegalStateException(Messages.getString("jndi.1E"));
            }
            NamingManager.icfb = icfb;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static boolean hasInitialContextFactoryBuilder() {
        return icfb != null;
    }

    public static synchronized void setObjectFactoryBuilder(ObjectFactoryBuilder ofb) throws IllegalStateException, SecurityException, NamingException {
        if (NamingManager.ofb != null) {
            throw new IllegalStateException(Messages.getString("jndi.1F"));
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        NamingManager.ofb = ofb;
    }

    public static Context getInitialContext(Hashtable<?, ?> h) throws NoInitialContextException, NamingException {
        if (icfb != null) {
            return icfb.createInitialContextFactory(h).getInitialContext(h);
        }
        try {
            String factoryClassName = (String)h.get("java.naming.factory.initial");
            Class<?> factoryClass = NamingManager.classForName(factoryClassName);
            InitialContextFactory factory = (InitialContextFactory)factoryClass.newInstance();
            return factory.getInitialContext(h);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            NoInitialContextException nex = new NoInitialContextException(Messages.getString("jndi.20", h));
            nex.setRootCause(e);
            throw nex;
        }
    }

    public static Object getObjectInstance(Object o, Name n, Context c, Hashtable<?, ?> h) throws NamingException, Exception {
        Object result;
        if (ofb != null) {
            ObjectFactory factory = ofb.createObjectFactory(o, h);
            return factory.getObjectInstance(o, n, c, h);
        }
        Reference ref = null;
        if (o instanceof Referenceable) {
            ref = ((Referenceable)o).getReference();
        }
        if (o instanceof Reference) {
            ref = (Reference)o;
        }
        if (ref != null) {
            if (ref.getFactoryClassName() != null) {
                return NamingManager.getObjectInstanceByFactoryInReference(ref, o, n, c, h);
            }
            result = NamingManager.getObjectInstanceByUrlRefAddr(n, c, h, ref);
            if (result != null) {
                return result;
            }
        }
        if ((result = NamingManager.getObjectInstanceByObjectFactory(o, n, c, h)) != null) {
            return result;
        }
        return o;
    }

    private static Object getObjectInstanceByObjectFactory(Object o, Name n, Context c, Hashtable<?, ?> h) throws NamingException, Exception {
        String[] fnames;
        String[] stringArray = fnames = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(h, c, "java.naming.factory.object");
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            block4: {
                String element = stringArray[n2];
                ObjectFactory factory = null;
                try {
                    factory = (ObjectFactory)NamingManager.classForName(element).newInstance();
                }
                catch (Exception exception) {
                    break block4;
                }
                Object obj = factory.getObjectInstance(o, n, c, h);
                if (obj != null) {
                    return obj;
                }
            }
            ++n2;
        }
        return null;
    }

    private static Object getObjectInstanceByUrlRefAddr(Name n, Context c, Hashtable<?, ?> h, Reference ref) throws NamingException {
        String[] pkgPrefixes = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(h, c, "java.naming.factory.url.pkgs");
        Enumeration<RefAddr> enumeration = ref.getAll();
        while (enumeration.hasMoreElements()) {
            String url;
            Object obj;
            RefAddr addr = enumeration.nextElement();
            if (!(addr instanceof StringRefAddr) || !addr.getType().equalsIgnoreCase("URL") || (obj = NamingManager.getObjectInstanceByUrlContextFactory(url = (String)((StringRefAddr)addr).getContent(), n, c, h, pkgPrefixes, UrlParser.getScheme(url))) == null) continue;
            return obj;
        }
        return null;
    }

    private static Object getObjectInstanceByUrlContextFactory(String url, Name n, Context c, Hashtable<?, ?> h, String[] pkgPrefixes, String schema) throws NamingException {
        if (schema == null || schema.length() == 0) {
            return null;
        }
        String[] stringArray = pkgPrefixes;
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            block8: {
                String element = stringArray[n2];
                ObjectFactory factory = null;
                try {
                    String clsName = String.valueOf(element) + "." + schema + "." + schema + "URLContextFactory";
                    factory = (ObjectFactory)NamingManager.classForName(clsName).newInstance();
                }
                catch (Exception exception) {
                    break block8;
                }
                try {
                    Object obj = factory.getObjectInstance(url, n, c, h);
                    if (obj != null) {
                        return obj;
                    }
                }
                catch (Exception e) {
                    if (e instanceof NamingException) {
                        throw (NamingException)e;
                    }
                    NamingException nex = new NamingException(Messages.getString("jndi.21"));
                    nex.setRootCause(e);
                    throw nex;
                }
            }
            ++n2;
        }
        return null;
    }

    private static Object getObjectInstanceByFactoryInReference(Reference ref, Object o, Name n, Context c, Hashtable<?, ?> h) throws Exception {
        ObjectFactory factory = null;
        try {
            factory = (ObjectFactory)NamingManager.classForName(ref.getFactoryClassName()).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (factory == null && ref.getFactoryClassLocation() != null) {
            factory = (ObjectFactory)NamingManager.loadFactoryFromLocation(ref.getFactoryClassName(), ref.getFactoryClassLocation());
        }
        if (factory == null) {
            return o;
        }
        return factory.getObjectInstance(ref, n, c, h);
    }

    private static Object loadFactoryFromLocation(String clsName, String location) throws Exception {
        StringTokenizer st = new StringTokenizer(location, " ");
        URL[] urls = new URL[st.countTokens()];
        int i = 0;
        while (i < urls.length) {
            urls[i] = new URL(st.nextToken());
            ++i;
        }
        URLClassLoader l = new URLClassLoader(urls);
        try {
            return l.loadClass(clsName).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Object getStateToBind(Object o, Name n, Context c, Hashtable<?, ?> h) throws NamingException {
        String[] fnames;
        String[] stringArray = fnames = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(h, c, "java.naming.factory.state");
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            block4: {
                String element = stringArray[n2];
                StateFactory factory = null;
                try {
                    factory = (StateFactory)NamingManager.classForName(element).newInstance();
                }
                catch (Exception exception) {
                    break block4;
                }
                Object state = factory.getStateToBind(o, n, c, h);
                if (state != null) {
                    return state;
                }
            }
            ++n2;
        }
        return o;
    }

    public static Context getURLContext(String schema, Hashtable<?, ?> envmt) throws NamingException {
        String[] pkgPrefixes;
        if (schema == null || schema.length() == 0 || envmt == null) {
            return null;
        }
        String[] stringArray = pkgPrefixes = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(envmt, null, "java.naming.factory.url.pkgs");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            block7: {
                ObjectFactory factory;
                String element = stringArray[n];
                try {
                    String clsName = String.valueOf(element) + "." + schema + "." + schema + "URLContextFactory";
                    factory = (ObjectFactory)NamingManager.classForName(clsName).newInstance();
                }
                catch (Exception exception) {
                    break block7;
                }
                try {
                    return (Context)factory.getObjectInstance(null, null, null, envmt);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    NamingException nex = new NamingException(Messages.getString("jndi.22", e.toString()));
                    nex.setRootCause(e);
                    throw nex;
                }
            }
            ++n;
        }
        return null;
    }

    public static Context getContinuationContext(CannotProceedException cpe) throws NamingException {
        Context ctx = null;
        if (cpe.getEnvironment() == null) {
            cpe.setEnvironment(new Hashtable());
        }
        cpe.getEnvironment().put(CPE, cpe);
        if (cpe.getResolvedObj() == null) {
            cpe.fillInStackTrace();
            throw cpe;
        }
        if (cpe.getResolvedObj() instanceof Context) {
            ctx = (Context)cpe.getResolvedObj();
        } else {
            try {
                ctx = (Context)NamingManager.getObjectInstance(cpe.getResolvedObj(), cpe.getAltName(), cpe.getAltNameCtx(), cpe.getEnvironment());
            }
            catch (Exception exception) {
                throw cpe;
            }
            if (ctx == null) {
                cpe.fillInStackTrace();
                throw cpe;
            }
        }
        return ctx;
    }

    private static Class<?> classForName(final String className) throws ClassNotFoundException {
        Class cls = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        return Class.forName(className, true, ClassLoader.getSystemClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        return null;
                    }
                }
            }
        });
        if (cls == null) {
            throw new ClassNotFoundException(Messages.getString("jndi.1C", className));
        }
        return cls;
    }
}

