/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontExporter;
import com.kreative.bitsnpicas.edit.Main;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontListPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final File fontFile;
    private final FontExporter<?> format;
    private final JList list;
    private final JLabel label;
    private final JButton openButton;

    public FontListPanel(File file, FontExporter<?> fontExporter, Font<?>[] fontArray) {
        this.fontFile = file;
        this.format = fontExporter;
        this.list = new JList(fontArray);
        this.label = new JLabel("This file contains multiple fonts. Please select one.");
        this.openButton = new JButton("Open");
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.openButton);
        JPanel jPanel2 = new JPanel(new BorderLayout(4, 4));
        jPanel2.add((Component)this.label, "First");
        jPanel2.add((Component)this.list, "Center");
        jPanel2.add((Component)jPanel, "Last");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel2, "Center");
        this.list.addMouseListener(new MyMouseListener());
        this.openButton.addActionListener(new MyActionListener());
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Font font = (Font)FontListPanel.this.list.getSelectedValue();
            if (font != null) {
                Main.openFont(FontListPanel.this.fontFile, FontListPanel.this.format, font);
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Font font;
            if (mouseEvent.getClickCount() > 1 && (font = (Font)FontListPanel.this.list.getSelectedValue()) != null) {
                Main.openFont(FontListPanel.this.fontFile, FontListPanel.this.format, font);
            }
        }
    }
}

