/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.main.BitmapInputFormat;
import com.kreative.bitsnpicas.main.BitmapInputOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ViewFont
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final BitmapFont myFont;
    private final SpinnerNumberModel scale;
    private final JComponent alphaPanel;
    private final JTextArea textArea;
    private final JComponent textPanel;

    public static void main(String[] stringArray) {
        BitmapInputOptions bitmapInputOptions = new BitmapInputOptions();
        for (String string : stringArray) {
            try {
                BitmapFont[] bitmapFontArray;
                File file = new File(string);
                BitmapInputFormat bitmapInputFormat = BitmapInputFormat.forFile(file);
                if (bitmapInputFormat == null) {
                    System.err.println("Unknown type: " + string);
                    continue;
                }
                if (bitmapInputFormat.macResFork) {
                    file = new File(new File(file, "..namedfork"), "rsrc");
                }
                if ((bitmapFontArray = (BitmapFont[])bitmapInputFormat.createImporter(bitmapInputOptions).importFont(file)) == null || bitmapFontArray.length == 0) {
                    System.err.println("No fonts found: " + string);
                    continue;
                }
                for (BitmapFont bitmapFont : bitmapFontArray) {
                    new ViewFont(bitmapFont);
                }
            }
            catch (IOException iOException) {
                System.err.println("Could not load " + string);
            }
        }
    }

    public ViewFont(BitmapFont bitmapFont) {
        this.myFont = bitmapFont;
        if (bitmapFont.getName(4) != null) {
            this.setTitle(bitmapFont.getName(4));
        } else if (bitmapFont.getName(1) != null) {
            this.setTitle(bitmapFont.getName(1));
        }
        this.scale = new SpinnerNumberModel(1, 1, 16, 1);
        this.scale.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ViewFont.this.alphaPanel.repaint();
                ViewFont.this.textPanel.repaint();
            }
        });
        this.alphaPanel = new JComponent(){
            private static final long serialVersionUID = 1L;

            protected void paintComponent(Graphics graphics) {
                Insets insets = this.getInsets();
                int n = insets.left;
                int n2 = insets.top;
                int n3 = this.getWidth() - insets.left - insets.right;
                int n4 = this.getHeight() - insets.top - insets.bottom;
                int n5 = ViewFont.this.scale.getNumber().intValue();
                graphics.setColor(Color.white);
                graphics.fillRect(n, n2, n3, n4);
                graphics.setColor(Color.black);
                ViewFont.this.myFont.drawAlphabet(graphics, n, n2 + ViewFont.this.myFont.getLineAscent() * n5, n5, n3);
            }
        };
        this.textArea = new JTextArea("The quick brown fox jumped over the lazy dogs with a razorback-jumping frog that could level six piqued gymnasts who speak Latin: Lorem ipsum dolor sit amet...");
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ViewFont.this.textPanel.repaint();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ViewFont.this.textPanel.repaint();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ViewFont.this.textPanel.repaint();
            }
        });
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textPanel = new JComponent(){
            private static final long serialVersionUID = 1L;

            protected void paintComponent(Graphics graphics) {
                Insets insets = this.getInsets();
                int n = insets.left;
                int n2 = insets.top;
                int n3 = this.getWidth() - insets.left - insets.right;
                int n4 = this.getHeight() - insets.top - insets.bottom;
                int n5 = ViewFont.this.scale.getNumber().intValue();
                graphics.setColor(Color.white);
                graphics.fillRect(n, n2, n3, n4);
                graphics.setColor(Color.black);
                ViewFont.this.myFont.draw(graphics, ViewFont.this.textArea.getText(), n, n2 + ViewFont.this.myFont.getLineAscent() * n5, n5, n3);
            }
        };
        JPanel jPanel = new JPanel(new BorderLayout(4, 4));
        jPanel.add((Component)new JLabel("Scale:"), "Before");
        jPanel.add((Component)new JSpinner(this.scale), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "After");
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1, 10, 10));
        jPanel3.add(this.alphaPanel);
        jPanel3.add(new JScrollPane(this.textArea, 22, 31));
        jPanel3.add(this.textPanel);
        JPanel jPanel4 = new JPanel(new BorderLayout(10, 10));
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)jPanel2, "Last");
        jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setContentPane(jPanel4);
        this.setSize(512, 456);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void fontChanged() {
        this.alphaPanel.repaint();
        this.textPanel.repaint();
    }
}

