/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.mover;

import com.kreative.bitsnpicas.mover.MoverFile;
import com.kreative.bitsnpicas.mover.MoverInfoPanel;
import com.kreative.bitsnpicas.mover.MoverTable;
import com.kreative.bitsnpicas.mover.MoverTableModel;
import com.kreative.bitsnpicas.mover.SaveManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class MoverPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final MoverInfoPanel infoPanel;
    private final MoverTableModel tableModel;
    private final MoverTable table;
    private final JScrollPane tablePane;

    public MoverPanel(JFrame jFrame, File file, MoverFile moverFile, final SaveManager saveManager) {
        this.infoPanel = new MoverInfoPanel(file);
        this.tableModel = new MoverTableModel(moverFile);
        this.table = new MoverTable(this.tableModel, this.infoPanel);
        this.tablePane = new JScrollPane(this.table, 22, 32);
        saveManager.setInfoPanel(this.infoPanel);
        this.table.createDropTarget(this.tablePane);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.infoPanel.setBorder(BorderFactory.createEmptyBorder(12, 16, 12, 16));
        jPanel.add((Component)this.infoPanel, "First");
        jPanel.add(this.tablePane);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                saveManager.setChanged();
            }
        });
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                MoverPanel.this.table.requestFocusInWindow();
            }
        });
    }

    public MoverTableModel getTableModel() {
        return this.tableModel;
    }

    public MoverTable getTable() {
        return this.table;
    }
}

