/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.data;

import java.io.File;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicodeUtils {
    public static File getTableDirectory(String string) {
        File file;
        File file2;
        if (System.getProperty("os.name").toUpperCase().contains("MAC OS")) {
            File file3;
            file2 = new File(System.getProperty("user.home"));
            File file4 = new File(file2, "Library");
            if (!file4.exists()) {
                file4.mkdir();
            }
            if (!(file3 = new File(file4, "Preferences")).exists()) {
                file3.mkdir();
            }
            file = new File(file3, "com.kreative.unicode");
        } else if (System.getProperty("os.name").toUpperCase().contains("WINDOWS")) {
            File file5;
            file2 = new File(System.getProperty("user.home"));
            File file6 = new File(file2, "Application Data");
            if (!file6.exists()) {
                file6.mkdir();
            }
            if (!(file5 = new File(file6, "Kreative")).exists()) {
                file5.mkdir();
            }
            file = new File(file5, "Unicode");
        } else {
            file2 = new File(System.getProperty("user.home"));
            file = new File(file2, ".com.kreative.unicode");
        }
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file2 = new File(file, string)).exists()) {
            file2.mkdir();
        }
        return file2;
    }

    public static String stripExtension(String string) {
        int n = string.lastIndexOf(46);
        return n > 0 ? string.substring(0, n) : string;
    }

    public static int naturalCompare(String string, String string2) {
        List<String> list = UnicodeUtils.naturalTokenize(string.trim());
        List<String> list2 = UnicodeUtils.naturalTokenize(string2.trim());
        for (int i = 0; i < list.size() && i < list2.size(); ++i) {
            try {
                double d = Double.parseDouble(list.get(i));
                double d2 = Double.parseDouble(list2.get(i));
                int n = Double.compare(d, d2);
                if (n == 0) continue;
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                int n = list.get(i).compareToIgnoreCase(list2.get(i));
                if (n == 0) continue;
                return n;
            }
        }
        return list.size() - list2.size();
    }

    private static List<String> naturalTokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            int n2;
            int n3 = Character.isDigit(c) ? 1 : (n2 = Character.isLetter(c) ? 2 : 3);
            if (n2 != n) {
                if (stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
                n = n2;
            }
            stringBuffer.append(c);
            c = stringCharacterIterator.next();
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }
}

