# livecd-stage1 example specfile
# used to build a livecd-stage1

# The subarch can be any of the supported catalyst subarches (like athlon-xp).
# Refer to "man catalyst" or <https://wiki.gentoo.org/wiki/Catalyst>
# for supported subarches
# example:
# subarch: athlon-xp
subarch:

# The version stamp is an identifier for the build.  It can be anything you wish
# it to be, but it is usually a date.
# example:
# version_stamp: 2006.1
version_stamp:

# The target specifies what target we want catalyst to do.  For building a CD,
# we start with livecd-stage1 as our target.
# example:
# target: livecd-stage1
target:

# The rel_type defines what kind of build we are doing.  This is merely another
# identifier, but it useful for allowing multiple concurrent builds.  Usually,
# default will suffice.
# example:
# rel_type: default
rel_type:

# This is the system profile to be used by catalyst to build this target.  It is
# specified as a relative path from /var/db/repos/gentoo/profiles.
# example:
# profile: default-linux/x86/2006.1
profile:

# This specifies which snapshot to use for building this target.
# example:
# snapshot: 2006.1
snapshot:

# This specifies where the seed stage comes from for this target,  The path is
# relative to $clst_sharedir/builds.  The rel_type is also used as a path prefix
# for the seed.
# example:
# default/stage3-x86-2006.1
source_subpath:

# This is an optional directory containing portage configuration files.  It
# follows the same syntax as /etc/portage and should be consistent across all
# targets to minimize problems.
# example:
# portage_confdir: /etc/portage
portage_confdir:

# This option specifies the location of the ebuild repositories that you would
# like to have used when building this target. It takes a space-separated list
# of directory names.
# example:
# repos: /usr/local/portage
repos:

# This option specifies the names of ebuild repositories that you would like to
# leave configured in the resulting build.  It takes a space-separated list of
# names.  This only affects the configuration; the contents are never kept.
# example:
# keep_repos: kde qt
keep_repos:

# This allows the optional directory containing the output packages for
# catalyst.  Mainly used as a way for different spec files to access the same
# cache directory.  Default behavior is for this location to be autogenerated
# by catalyst based on the spec file.
# example:
# pkgcache_path: /tmp/packages
pkgcache_path:

# The livecd-stage1 target is where you will build packages for your CD.  These
# packages can be built with customized USE settings.  The settings here are
# additive to the default USE configured by the profile.  For building release
# media, the first thing we do is disable all default USE flags with -* and then
# begin to set our own.
# example:
# livecd/use: -* ipv6 socks5 livecd fbcon ncurses readline ssl
livecd/use:

# This is the set of packages that we will merge into the CD's filesystem.  They
# will be built with the USE flags configured above.  These packages must not
# depend on a configured kernel.  If the package requires a configured kernel,
# then it will be defined elsewhere.
# example:
# livecd/packages: livecd-tools dhcpcd acpid apmd gentoo-sources coldplug fxload irssi gpm syslog-ng parted links raidtools dosfstools nfs-utils jfsutils xfsprogs e2fsprogs reiserfsprogs ntfsprogs pwgen rp-pppoe screen mirrorselect penggy iputils hwdata-knoppix hwsetup lvm2 evms vim pptpclient mdadm ethtool wireless-tools prism54-firmware wpa_supplicant
livecd/packages:
