/*****************************************************************************
 * Copyright (c) 2014-2025 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include "drawing/ImageIndexType.h"
#include "drawing/ScrollingText.h"
#include "rct1/Limits.h"

enum : ImageIndex
{
    // Used for on-demand drawing of dynamic memory
    SPR_TEMP = 0x7FFFE,

    SPR_DEFAULT_PALETTE = 1532,

    SPR_SCROLLING_TEXT_LEGACY_START = 1542,
    SPR_SCROLLING_TEXT_LEGACY_END = SPR_SCROLLING_TEXT_LEGACY_START + OpenRCT2::kMaxScrollingTextLegacyEntries,
    SPR_SCROLLING_TEXT_DEFAULT = 1574,

    SPR_EDGE_ROCK_BASE = 1579,
    SPR_EDGE_WOOD_RED_BASE = 1747,
    SPR_EDGE_WOOD_BLACK_BASE = 1663,
    SPR_EDGE_ICE_BASE = 1831,

    SPR_TERRAIN_STAFF = 2618,
    SPR_TERRAIN_STAFF_SLOPED = 2619,

    SPR_TERRAIN_SELECTION_SQUARE_SIMPLE = 2624, // Used for showing peep spawn
    SPR_TERRAIN_SELECTION_SQUARE = 2625,        // Used to show land owned by park
    SPR_TERRAIN_SELECTION_DOTTED = 2644,        // Used to show construction rights owned by park

    SPR_PALETTE_1_START = 3100,
    SPR_PALETTE_1_END = 3110,

    PEEP_SPAWN_ARROW_0 = 3111,
    PEEP_SPAWN_ARROW_1 = 3112,
    PEEP_SPAWN_ARROW_2 = 3113,
    PEEP_SPAWN_ARROW_3 = 3114,

    SPR_BLANK_TILE = 3123,

    // This is the start of every character there are
    // 224 characters per font (first 32 are control codes hence why it doesn't go to 255)
    // 4 fonts
    // = 896 sprites
    SPR_CHAR_START = 3861,
    SPR_CHAR_END = 4757,

    SPR_TEXT_PALETTE = 4914,
    SPR_PALETTE_2_START = 4915,
    SPR_PALETTE_2_END = 5047,

    SPR_RESIZE = 5058,
    SPR_PALETTE_BTN = 5059,
    SPR_PALETTE_BTN_PRESSED = 5060,
    SPR_SHOP_ITEM_BALLOON = 5061,
    SPR_SHOP_ITEM_TOY = 5062,
    SPR_SHOP_ITEM_MAP = 5063,
    SPR_SHOP_ITEM_PHOTO = 5064,
    SPR_SHOP_ITEM_UMBRELLA = 5065,
    SPR_SHOP_ITEM_DRINK = 5066,
    SPR_SHOP_ITEM_BURGER = 5067,
    SPR_SHOP_ITEM_CHIPS = 5068,
    SPR_SHOP_ITEM_ICE_CREAM = 5069,
    SPR_SHOP_ITEM_CANDYFLOSS = 5070,
    SPR_SHOP_ITEM_EMPTY_CAN = 5071,
    SPR_SHOP_ITEM_RUBBISH = 5072,
    SPR_SHOP_ITEM_EMPTY_BURGER_BOX = 5073,
    SPR_SHOP_ITEM_PIZZA = 5074,
    SPR_SHOP_ITEM_VOUCHER = 5075,
    SPR_SHOP_ITEM_POPCORN = 5076,
    SPR_SHOP_ITEM_HOT_DOG = 5077,
    SPR_SHOP_ITEM_TENTACLE = 5078,
    SPR_SHOP_ITEM_HAT = 5079,
    SPR_SHOP_ITEM_TOFFEE_APPLE = 5080,
    SPR_SHOP_ITEM_TSHIRT = 5081,
    SPR_SHOP_ITEM_DOUGHNUT = 5082,
    SPR_SHOP_ITEM_COFFEE = 5083,
    SPR_SHOP_ITEM_EMPTY_CUP = 5084,
    SPR_SHOP_ITEM_CHICKEN = 5085,
    SPR_SHOP_ITEM_LEMONADE = 5086,
    SPR_SHOP_ITEM_EMPTY_BOX = 5087,
    SPR_SHOP_ITEM_EMPTY_BOTTLE = 5088,
    SPR_SHOP_ITEM_PHOTO2 = 5089,
    SPR_SHOP_ITEM_PHOTO3 = 5090,
    SPR_SHOP_ITEM_PHOTO4 = 5091,
    SPR_SHOP_ITEM_PRETZEL = 5092,
    SPR_SHOP_ITEM_CHOCOLATE = 5093,
    SPR_SHOP_ITEM_ICED_TEA = 5094,
    SPR_SHOP_ITEM_FUNNEL_CAKE = 5095,
    SPR_SHOP_ITEM_SUNGLASSES = 5096,
    SPR_SHOP_ITEM_BEEF_NOODLES = 5097,
    SPR_SHOP_ITEM_FRIED_RICE_NOODLES = 5098,
    SPR_SHOP_ITEM_WONTON_SOUP = 5099,
    SPR_SHOP_ITEM_MEATBALL_SOUP = 5100,
    SPR_SHOP_ITEM_FRUIT_JUICE = 5101,
    SPR_SHOP_ITEM_SOYBEAN_MILK = 5102,
    SPR_SHOP_ITEM_SUJEONGGWA = 5103,
    SPR_SHOP_ITEM_SUB_SANDWICH = 5104,
    SPR_SHOP_ITEM_COOKIE = 5105,
    SPR_SHOP_ITEM_EMPTY_BOWL_RED = 5106,
    SPR_SHOP_ITEM_EMPTY_DRINK_CARTON = 5107,
    SPR_SHOP_ITEM_EMPTY_JUICE_CUP = 5108,
    SPR_SHOP_ITEM_ROAST_SAUSAGE = 5109,
    SPR_SHOP_ITEM_EMPTY_BOWL_BLUE = 5110,
    SPR_STAFF_ORDERS_SWEEPING = 5111,
    SPR_STAFF_ORDERS_WATER_FLOWERS = 5112,
    SPR_STAFF_ORDERS_EMPTY_BINS = 5113,
    SPR_STAFF_ORDERS_MOWING = 5114,
    SPR_STAFF_ORDERS_INSPECT_RIDES = 5115,
    SPR_STAFF_ORDERS_FIX_RIDES = 5116,
    SPR_STAFF_PATROL_PATH = 5117,
    SPR_STAFF_COSTUME_PANDA = 5118,
    SPR_STAFF_COSTUME_TIGER = 5119,
    SPR_STAFF_COSTUME_ELEPHANT = 5120,
    SPR_STAFF_COSTUME_ROMAN = 5121,
    SPR_STAFF_COSTUME_GORILLA = 5122,
    SPR_STAFF_COSTUME_SNOWMAN = 5123,
    SPR_STAFF_COSTUME_KNIGHT = 5124,
    SPR_STAFF_COSTUME_ASTRONAUT = 5125,
    SPR_STAFF_COSTUME_BANDIT = 5126,
    SPR_STAFF_COSTUME_SHERIFF = 5127,
    SPR_STAFF_COSTUME_PIRATE = 5128,

    SPR_RIDE_CONSTRUCTION_STRAIGHT = 5137,
    SPR_RIDE_CONSTRUCTION_LEFT_CURVE = 5138,
    SPR_RIDE_CONSTRUCTION_RIGHT_CURVE = 5139,
    SPR_RIDE_CONSTRUCTION_LEFT_CURVE_SMALL = 5140,
    SPR_RIDE_CONSTRUCTION_RIGHT_CURVE_SMALL = 5141,
    SPR_RIDE_CONSTRUCTION_LEFT_CURVE_LARGE = 5142,
    SPR_RIDE_CONSTRUCTION_RIGHT_CURVE_LARGE = 5143,
    SPR_RIDE_CONSTRUCTION_SLOPE_DOWN_STEEP = 5144,
    SPR_RIDE_CONSTRUCTION_SLOPE_DOWN = 5145,
    SPR_RIDE_CONSTRUCTION_SLOPE_LEVEL = 5146,
    SPR_RIDE_CONSTRUCTION_SLOPE_UP = 5147,
    SPR_RIDE_CONSTRUCTION_SLOPE_UP_STEEP = 5148,
    SPR_RIDE_CONSTRUCTION_VERTICAL_RISE = 5149,
    SPR_RIDE_CONSTRUCTION_VERTICAL_DROP = 5150,
    SPR_RIDE_CONSTRUCTION_HELIX_DOWN = 5151,
    SPR_RIDE_CONSTRUCTION_HELIX_UP = 5152,
    SPR_RIDE_CONSTRUCTION_LEFT_BANK = 5153,
    SPR_RIDE_CONSTRUCTION_NO_BANK = 5154,
    SPR_RIDE_CONSTRUCTION_RIGHT_BANK = 5155,
    SPR_RIDE_CONSTRUCTION_U_SHAPED_TRACK = 5156,
    SPR_RIDE_CONSTRUCTION_O_SHAPED_TRACK = 5157,
    SPR_RIDE_CONSTRUCTION_RC_TRACK = 5158,
    SPR_RIDE_CONSTRUCTION_WATER_CHANNEL = 5159,
    SPR_PREVIOUS = 5160,
    SPR_NEXT = 5161,
    SPR_DEMOLISH_CURRENT_SECTION = 5162,
    SPR_CHAIN_LIFT = 5163,
    SPR_CONSTRUCTION = 5164,
    SPR_DEMOLISH = 5165,
    SPR_HEARING_VIEWPORT = 5166,
    SPR_LOCATE = 5167,
    SPR_RENAME = 5168,
    SPR_ROTATE_ARROW = 5169,
    SPR_MIRROR_ARROW = 5170,
    SPR_SCENERY = 5171,
    SPR_SCENERY_CLUSTER = 5172,
    SPR_PAINTBRUSH = 5173,
    SPR_PICKUP_BTN = 5174,
    SPR_PATROL_BTN = 5175,
    SPR_BUY_LAND_RIGHTS = 5176,
    SPR_BUY_CONSTRUCTION_RIGHTS = 5177,
    SPR_NO_ENTRY = 5178,
    SPR_CLOSED = 5179,
    SPR_OPEN = 5180,
    SPR_TESTING = 5181,
    SPR_TOGGLE_OPEN_CLOSE = 5182,
    SPR_FLOPPY = 5183,
    SPR_SHOW_GUESTS_THOUGHTS_ABOUT_THIS_RIDE_ATTRACTION = 5184,
    SPR_SHOW_GUESTS_QUEUING_FOR_THIS_RIDE_ATTRACTION = 5185,
    SPR_SHOW_GUESTS_ON_THIS_RIDE_ATTRACTION = 5186,
    SPR_RIDE = 5187,
    SPR_TRACK_PEEP = 5188,
    SPR_NEW_RIDE = 5189,
    SPR_FINANCE = 5190,
    SPR_NEW_SCENERY = 5191,
    SPR_MAP = 5192,
    SPR_GUESTS = 5193,
    SPR_AWARD = 5194,
    SPR_GRAPH = 5195,
    SPR_MECHANIC = 5196,
    SPR_PARK_ENTRANCE = 5197,
    SPR_TAB = 5198, // 0x144e
    SPR_TAB_ACTIVE = 5199,
    SPR_TAB_PARK_ENTRANCE = 5200,
    SPR_TAB_GEARS_0 = 5201,
    SPR_TAB_GEARS_1 = SPR_TAB_GEARS_0 + 1,
    SPR_TAB_GEARS_2 = SPR_TAB_GEARS_0 + 2,
    SPR_TAB_GEARS_3 = SPR_TAB_GEARS_0 + 3,
    SPR_TAB_WRENCH_0 = 5205,
    SPR_TAB_WRENCH_1 = SPR_TAB_WRENCH_0 + 1,
    SPR_TAB_WRENCH_2 = SPR_TAB_WRENCH_0 + 2,
    SPR_TAB_WRENCH_3 = SPR_TAB_WRENCH_0 + 3,
    SPR_TAB_WRENCH_4 = SPR_TAB_WRENCH_0 + 4,
    SPR_TAB_WRENCH_5 = SPR_TAB_WRENCH_0 + 5,
    SPR_TAB_WRENCH_6 = SPR_TAB_WRENCH_0 + 6,
    SPR_TAB_WRENCH_7 = SPR_TAB_WRENCH_0 + 7,
    SPR_TAB_WRENCH_8 = SPR_TAB_WRENCH_0 + 8,
    SPR_TAB_WRENCH_9 = SPR_TAB_WRENCH_0 + 9,
    SPR_TAB_WRENCH_10 = SPR_TAB_WRENCH_0 + 10,
    SPR_TAB_WRENCH_11 = SPR_TAB_WRENCH_0 + 11,
    SPR_TAB_WRENCH_12 = SPR_TAB_WRENCH_0 + 12,
    SPR_TAB_WRENCH_13 = SPR_TAB_WRENCH_0 + 13,
    SPR_TAB_WRENCH_14 = SPR_TAB_WRENCH_0 + 14,
    SPR_TAB_WRENCH_15 = SPR_TAB_WRENCH_0 + 15,
    SPR_TAB_PAINT_0 = 5221,
    SPR_TAB_PAINT_1 = SPR_TAB_PAINT_0 + 1,
    SPR_TAB_PAINT_2 = SPR_TAB_PAINT_0 + 2,
    SPR_TAB_PAINT_3 = SPR_TAB_PAINT_0 + 3,
    SPR_TAB_PAINT_4 = SPR_TAB_PAINT_0 + 4,
    SPR_TAB_PAINT_5 = SPR_TAB_PAINT_0 + 5,
    SPR_TAB_PAINT_6 = SPR_TAB_PAINT_0 + 6,
    SPR_TAB_PAINT_7 = SPR_TAB_PAINT_0 + 7,
    SPR_TAB_TIMER_0 = 5229,
    SPR_TAB_TIMER_1 = SPR_TAB_TIMER_0 + 1,
    SPR_TAB_TIMER_2 = SPR_TAB_TIMER_0 + 2,
    SPR_TAB_TIMER_3 = SPR_TAB_TIMER_0 + 3,
    SPR_TAB_TIMER_4 = SPR_TAB_TIMER_0 + 4,
    SPR_TAB_TIMER_5 = SPR_TAB_TIMER_0 + 5,
    SPR_TAB_TIMER_6 = SPR_TAB_TIMER_0 + 6,
    SPR_TAB_TIMER_7 = SPR_TAB_TIMER_0 + 7,
    SPR_TAB_GRAPH_A_0 = 5237,
    SPR_TAB_GRAPH_A_1 = SPR_TAB_GRAPH_A_0 + 1,
    SPR_TAB_GRAPH_A_2 = SPR_TAB_GRAPH_A_0 + 2,
    SPR_TAB_GRAPH_A_3 = SPR_TAB_GRAPH_A_0 + 3,
    SPR_TAB_GRAPH_A_4 = SPR_TAB_GRAPH_A_0 + 4,
    SPR_TAB_GRAPH_A_5 = SPR_TAB_GRAPH_A_0 + 5,
    SPR_TAB_GRAPH_A_6 = SPR_TAB_GRAPH_A_0 + 6,
    SPR_TAB_GRAPH_A_7 = SPR_TAB_GRAPH_A_0 + 7,
    SPR_TAB_GRAPH_0 = 5245,
    SPR_TAB_GRAPH_1 = SPR_TAB_GRAPH_0 + 1,
    SPR_TAB_GRAPH_2 = SPR_TAB_GRAPH_0 + 2,
    SPR_TAB_GRAPH_3 = SPR_TAB_GRAPH_0 + 3,
    SPR_TAB_GRAPH_4 = SPR_TAB_GRAPH_0 + 4,
    SPR_TAB_GRAPH_5 = SPR_TAB_GRAPH_0 + 5,
    SPR_TAB_GRAPH_6 = SPR_TAB_GRAPH_0 + 6,
    SPR_TAB_GRAPH_7 = SPR_TAB_GRAPH_0 + 7,
    SPR_TAB_ADMISSION_0 = 5253,
    SPR_TAB_ADMISSION_1 = SPR_TAB_ADMISSION_0 + 1,
    SPR_TAB_ADMISSION_2 = SPR_TAB_ADMISSION_0 + 2,
    SPR_TAB_ADMISSION_3 = SPR_TAB_ADMISSION_0 + 3,
    SPR_TAB_ADMISSION_4 = SPR_TAB_ADMISSION_0 + 4,
    SPR_TAB_ADMISSION_5 = SPR_TAB_ADMISSION_0 + 5,
    SPR_TAB_ADMISSION_6 = SPR_TAB_ADMISSION_0 + 6,
    SPR_TAB_ADMISSION_7 = SPR_TAB_ADMISSION_0 + 7,
    SPR_TAB_FINANCES_SUMMARY_0 = 5261,
    SPR_TAB_FINANCES_SUMMARY_1 = SPR_TAB_FINANCES_SUMMARY_0 + 1,
    SPR_TAB_FINANCES_SUMMARY_2 = SPR_TAB_FINANCES_SUMMARY_0 + 2,
    SPR_TAB_FINANCES_SUMMARY_3 = SPR_TAB_FINANCES_SUMMARY_0 + 3,
    SPR_TAB_FINANCES_SUMMARY_4 = SPR_TAB_FINANCES_SUMMARY_0 + 4,
    SPR_TAB_FINANCES_SUMMARY_5 = SPR_TAB_FINANCES_SUMMARY_0 + 5,
    SPR_TAB_FINANCES_SUMMARY_6 = SPR_TAB_FINANCES_SUMMARY_0 + 6,
    SPR_TAB_FINANCES_SUMMARY_7 = SPR_TAB_FINANCES_SUMMARY_0 + 7,
    SPR_TAB_THOUGHTS_0 = 5269,
    SPR_TAB_THOUGHTS_1 = SPR_TAB_THOUGHTS_0 + 1,
    SPR_TAB_THOUGHTS_2 = SPR_TAB_THOUGHTS_0 + 2,
    SPR_TAB_THOUGHTS_3 = SPR_TAB_THOUGHTS_0 + 3,
    SPR_TAB_THOUGHTS_4 = SPR_TAB_THOUGHTS_0 + 4,
    SPR_TAB_THOUGHTS_5 = SPR_TAB_THOUGHTS_0 + 5,
    SPR_TAB_THOUGHTS_6 = SPR_TAB_THOUGHTS_0 + 6,
    SPR_TAB_THOUGHTS_7 = SPR_TAB_THOUGHTS_0 + 7,
    SPR_TAB_STATS_0 = 5277,
    SPR_TAB_STATS_1 = SPR_TAB_STATS_0 + 1,
    SPR_TAB_STATS_2 = SPR_TAB_STATS_0 + 2,
    SPR_TAB_STATS_3 = SPR_TAB_STATS_0 + 3,
    SPR_TAB_STATS_4 = SPR_TAB_STATS_0 + 4,
    SPR_TAB_STATS_5 = SPR_TAB_STATS_0 + 5,
    SPR_TAB_STATS_6 = SPR_TAB_STATS_0 + 6,
    SPR_PEEP_LARGE_FACE_VERY_VERY_UNHAPPY = 5284,
    SPR_PEEP_LARGE_FACE_VERY_UNHAPPY = 5285,
    SPR_PEEP_LARGE_FACE_UNHAPPY = 5286,
    SPR_PEEP_LARGE_FACE_NORMAL = 5287,
    SPR_PEEP_LARGE_FACE_HAPPY = 5288,
    SPR_PEEP_LARGE_FACE_VERY_HAPPY = 5289,
    SPR_PEEP_LARGE_FACE_VERY_VERY_HAPPY = 5290,
    SPR_PEEP_LARGE_FACE_TIRED = 5291,
    SPR_PEEP_LARGE_FACE_VERY_TIRED = 5292,
    SPR_PEEP_LARGE_FACE_SICK = 5293,
    SPR_PEEP_LARGE_FACE_VERY_SICK_0 = 5294,
    SPR_PEEP_LARGE_FACE_VERY_SICK_1 = SPR_PEEP_LARGE_FACE_VERY_SICK_0 + 1,
    SPR_PEEP_LARGE_FACE_VERY_SICK_2 = SPR_PEEP_LARGE_FACE_VERY_SICK_0 + 2,
    SPR_PEEP_LARGE_FACE_VERY_SICK_3 = SPR_PEEP_LARGE_FACE_VERY_SICK_0 + 3,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 = 5298,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_1 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 1,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_2 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 2,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_3 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 3,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_4 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 4,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_5 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 5,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_6 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 6,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_7 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 7,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_8 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 8,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_9 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 9,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_10 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 10,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_11 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 11,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_12 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 12,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_13 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 13,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_14 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 14,
    SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_15 = SPR_PEEP_LARGE_FACE_VERY_VERY_SICK_0 + 15,
    SPR_PEEP_LARGE_FACE_ANGRY_0 = 5314,
    SPR_PEEP_LARGE_FACE_ANGRY_1 = SPR_PEEP_LARGE_FACE_ANGRY_0 + 1,
    SPR_PEEP_LARGE_FACE_ANGRY_2 = SPR_PEEP_LARGE_FACE_ANGRY_0 + 2,
    SPR_PEEP_LARGE_FACE_ANGRY_3 = SPR_PEEP_LARGE_FACE_ANGRY_0 + 3,
    // 5318 seems to be part of SPR_TAB_STAFF_OPTIONS
    SPR_TAB_STAFF_OPTIONS_0 = 5319,
    SPR_TAB_STAFF_OPTIONS_1 = SPR_TAB_STAFF_OPTIONS_0 + 1,
    SPR_TAB_STAFF_OPTIONS_2 = SPR_TAB_STAFF_OPTIONS_0 + 2,
    SPR_TAB_STAFF_OPTIONS_3 = SPR_TAB_STAFF_OPTIONS_0 + 3,
    SPR_TAB_STAFF_OPTIONS_4 = SPR_TAB_STAFF_OPTIONS_0 + 4,
    SPR_TAB_STAFF_OPTIONS_5 = SPR_TAB_STAFF_OPTIONS_0 + 5,
    SPR_TAB_STAFF_OPTIONS_6 = SPR_TAB_STAFF_OPTIONS_0 + 6,
    SPR_TAB_GUEST_INVENTORY = 5326,
    SPR_TAB_FINANCES_RESEARCH_0 = 5327,

    SPR_TAB_MUSIC_0 = 5335,

    SPR_TAB_SHOPS_AND_STALLS_0 = 5351,
    SPR_TAB_SHOPS_AND_STALLS_1 = SPR_TAB_SHOPS_AND_STALLS_0 + 1,
    SPR_TAB_SHOPS_AND_STALLS_2 = SPR_TAB_SHOPS_AND_STALLS_0 + 2,
    SPR_TAB_SHOPS_AND_STALLS_3 = SPR_TAB_SHOPS_AND_STALLS_0 + 3,
    SPR_TAB_SHOPS_AND_STALLS_4 = SPR_TAB_SHOPS_AND_STALLS_0 + 4,
    SPR_TAB_SHOPS_AND_STALLS_5 = SPR_TAB_SHOPS_AND_STALLS_0 + 5,
    SPR_TAB_SHOPS_AND_STALLS_6 = SPR_TAB_SHOPS_AND_STALLS_0 + 6,
    SPR_TAB_SHOPS_AND_STALLS_7 = SPR_TAB_SHOPS_AND_STALLS_0 + 7,
    SPR_TAB_SHOPS_AND_STALLS_8 = SPR_TAB_SHOPS_AND_STALLS_0 + 8,
    SPR_TAB_SHOPS_AND_STALLS_9 = SPR_TAB_SHOPS_AND_STALLS_0 + 9,
    SPR_TAB_SHOPS_AND_STALLS_10 = SPR_TAB_SHOPS_AND_STALLS_0 + 10,
    SPR_TAB_SHOPS_AND_STALLS_11 = SPR_TAB_SHOPS_AND_STALLS_0 + 11,
    SPR_TAB_SHOPS_AND_STALLS_12 = SPR_TAB_SHOPS_AND_STALLS_0 + 12,
    SPR_TAB_SHOPS_AND_STALLS_13 = SPR_TAB_SHOPS_AND_STALLS_0 + 13,
    SPR_TAB_SHOPS_AND_STALLS_14 = SPR_TAB_SHOPS_AND_STALLS_0 + 14,
    SPR_TAB_SHOPS_AND_STALLS_15 = SPR_TAB_SHOPS_AND_STALLS_0 + 15,

    SPR_TAB_KIOSKS_AND_FACILITIES_0 = 5367,
    SPR_TAB_KIOSKS_AND_FACILITIES_1 = SPR_TAB_KIOSKS_AND_FACILITIES_0 + 1,
    SPR_TAB_KIOSKS_AND_FACILITIES_2 = SPR_TAB_KIOSKS_AND_FACILITIES_0 + 2,
    SPR_TAB_KIOSKS_AND_FACILITIES_3 = SPR_TAB_KIOSKS_AND_FACILITIES_0 + 3,
    SPR_TAB_KIOSKS_AND_FACILITIES_4 = SPR_TAB_KIOSKS_AND_FACILITIES_0 + 4,
    SPR_TAB_KIOSKS_AND_FACILITIES_5 = SPR_TAB_KIOSKS_AND_FACILITIES_0 + 5,
    SPR_TAB_KIOSKS_AND_FACILITIES_6 = SPR_TAB_KIOSKS_AND_FACILITIES_0 + 6,
    SPR_TAB_KIOSKS_AND_FACILITIES_7 = SPR_TAB_KIOSKS_AND_FACILITIES_0 + 7,

    SPR_TAB_FINANCES_FINANCIAL_GRAPH_0 = 5375,

    SPR_TAB_FINANCES_PROFIT_GRAPH_0 = 5391,

    SPR_TAB_FINANCES_VALUE_GRAPH_0 = 5407,

    SPR_TAB_FINANCES_MARKETING_0 = 5423,

    SPR_TAB_RIDE_0 = 5442,
    SPR_TAB_RIDE_1 = SPR_TAB_RIDE_0 + 1,
    SPR_TAB_RIDE_2 = SPR_TAB_RIDE_0 + 2,
    SPR_TAB_RIDE_3 = SPR_TAB_RIDE_0 + 3,
    SPR_TAB_RIDE_4 = SPR_TAB_RIDE_0 + 4,
    SPR_TAB_RIDE_5 = SPR_TAB_RIDE_0 + 5,
    SPR_TAB_RIDE_6 = SPR_TAB_RIDE_0 + 6,
    SPR_TAB_RIDE_7 = SPR_TAB_RIDE_0 + 7,
    SPR_TAB_RIDE_8 = SPR_TAB_RIDE_0 + 8,
    SPR_TAB_RIDE_9 = SPR_TAB_RIDE_0 + 9,
    SPR_TAB_RIDE_10 = SPR_TAB_RIDE_0 + 10,
    SPR_TAB_RIDE_11 = SPR_TAB_RIDE_0 + 11,
    SPR_TAB_RIDE_12 = SPR_TAB_RIDE_0 + 12,
    SPR_TAB_RIDE_13 = SPR_TAB_RIDE_0 + 13,
    SPR_TAB_RIDE_14 = SPR_TAB_RIDE_0 + 14,
    SPR_TAB_RIDE_15 = SPR_TAB_RIDE_0 + 15,
    SPR_TAB_RIDE_16 = SPR_TAB_RIDE_0 + 16, // Same as SPR_TAB_RIDE_0
    SPR_TAB_SCENERY_TREES = 5459,
    SPR_TAB_SCENERY_URBAN = 5460,
    SPR_TAB_SCENERY_WALLS = 5461,
    SPR_TAB_SCENERY_SIGNAGE = 5462,
    SPR_TAB_SCENERY_PATHS = 5463,
    SPR_TAB_SCENERY_PATH_ITEMS = 5464,
    SPR_TAB_SCENERY_STATUES = 5465,
    SPR_TAB_PARK = 5466,
    SPR_TAB_WATER = 5467,
    SPR_TAB_STATS = 5468,
    SPR_AWARD_MOST_UNTIDY = 5469,
    SPR_AWARD_MOST_TIDY = SPR_AWARD_MOST_UNTIDY + 1,
    SPR_AWARD_BEST_ROLLERCOASTERS = SPR_AWARD_MOST_UNTIDY + 2,
    SPR_AWARD_BEST_VALUE = SPR_AWARD_MOST_UNTIDY + 3,
    SPR_AWARD_MOST_BEAUTIFUL = SPR_AWARD_MOST_UNTIDY + 4,
    SPR_AWARD_WORST_VALUE = SPR_AWARD_MOST_UNTIDY + 5,
    SPR_AWARD_SAFEST = SPR_AWARD_MOST_UNTIDY + 6,
    SPR_AWARD_BEST_STAFF = SPR_AWARD_MOST_UNTIDY + 7,
    SPR_AWARD_BEST_FOOD = SPR_AWARD_MOST_UNTIDY + 8,
    SPR_AWARD_WORST_FOOD = SPR_AWARD_MOST_UNTIDY + 9,
    SPR_AWARD_BEST_TOILETS = SPR_AWARD_MOST_UNTIDY + 10,
    SPR_AWARD_MOST_DISAPPOINTING = SPR_AWARD_MOST_UNTIDY + 11,
    SPR_AWARD_BEST_WATER_RIDES = SPR_AWARD_MOST_UNTIDY + 12,
    SPR_AWARD_BEST_CUSTOM_DESIGNED_RIDES = SPR_AWARD_MOST_UNTIDY + 13,
    SPR_AWARD_MOST_DAZZLING_RIDE_COLOURS = SPR_AWARD_MOST_UNTIDY + 14,
    SPR_AWARD_MOST_CONFUSING_LAYOUT = SPR_AWARD_MOST_UNTIDY + 15,
    SPR_AWARD_BEST_GENTLE_RIDES = SPR_AWARD_MOST_UNTIDY + 16,
    SPR_PEEP_SMALL_FACE_VERY_VERY_UNHAPPY = 5486,
    SPR_PEEP_SMALL_FACE_VERY_UNHAPPY = 5487,
    SPR_PEEP_SMALL_FACE_UNHAPPY = 5488,
    SPR_PEEP_SMALL_FACE_NORMAL = 5489,
    SPR_PEEP_SMALL_FACE_HAPPY = 5490,
    SPR_PEEP_SMALL_FACE_VERY_HAPPY = 5491,
    SPR_PEEP_SMALL_FACE_VERY_VERY_HAPPY = 5492,
    SPR_PEEP_SMALL_FACE_TIRED = 5493,
    SPR_PEEP_SMALL_FACE_VERY_TIRED = 5494,
    SPR_PEEP_SMALL_FACE_SICK = 5495,
    SPR_PEEP_SMALL_FACE_VERY_SICK = 5496,
    SPR_PEEP_SMALL_FACE_VERY_VERY_SICK = 5497,
    SPR_PEEP_SMALL_FACE_ANGRY = 5498,
    SPR_LAND_TOOL_DECREASE = 5499,
    SPR_LAND_TOOL_DECREASE_PRESSED = 5500,
    SPR_LAND_TOOL_INCREASE = 5501,
    SPR_LAND_TOOL_INCREASE_PRESSED = 5502,
    SPR_LAND_TOOL_SIZE_0 = 5503,
    SPR_LAND_TOOL_SIZE_1 = SPR_LAND_TOOL_SIZE_0 + 1,
    SPR_LAND_TOOL_SIZE_2 = SPR_LAND_TOOL_SIZE_0 + 2,
    SPR_LAND_TOOL_SIZE_3 = SPR_LAND_TOOL_SIZE_0 + 3,
    SPR_LAND_TOOL_SIZE_4 = SPR_LAND_TOOL_SIZE_0 + 4,
    SPR_LAND_TOOL_SIZE_5 = SPR_LAND_TOOL_SIZE_0 + 5,
    SPR_LAND_TOOL_SIZE_6 = SPR_LAND_TOOL_SIZE_0 + 6,
    SPR_LAND_TOOL_SIZE_7 = SPR_LAND_TOOL_SIZE_0 + 7,
    SPR_TAB_OBJECTIVE_0 = 5511,
    SPR_TAB_OBJECTIVE_1 = SPR_TAB_OBJECTIVE_0 + 1,
    SPR_TAB_OBJECTIVE_2 = SPR_TAB_OBJECTIVE_0 + 2,
    SPR_TAB_OBJECTIVE_3 = SPR_TAB_OBJECTIVE_0 + 3,
    SPR_TAB_OBJECTIVE_4 = SPR_TAB_OBJECTIVE_0 + 4,
    SPR_TAB_OBJECTIVE_5 = SPR_TAB_OBJECTIVE_0 + 5,
    SPR_TAB_OBJECTIVE_6 = SPR_TAB_OBJECTIVE_0 + 6,
    SPR_TAB_OBJECTIVE_7 = SPR_TAB_OBJECTIVE_0 + 7,
    SPR_TAB_OBJECTIVE_8 = SPR_TAB_OBJECTIVE_0 + 8,
    SPR_TAB_OBJECTIVE_9 = SPR_TAB_OBJECTIVE_0 + 9,
    SPR_TAB_OBJECTIVE_10 = SPR_TAB_OBJECTIVE_0 + 10,
    SPR_TAB_OBJECTIVE_11 = SPR_TAB_OBJECTIVE_0 + 11,
    SPR_TAB_OBJECTIVE_12 = SPR_TAB_OBJECTIVE_0 + 12,
    SPR_TAB_OBJECTIVE_13 = SPR_TAB_OBJECTIVE_0 + 13,
    SPR_TAB_OBJECTIVE_14 = SPR_TAB_OBJECTIVE_0 + 14,
    SPR_TAB_OBJECTIVE_15 = SPR_TAB_OBJECTIVE_0 + 15,
    SPR_TAB_AWARDS = 5527,
    SPR_TAB_QUESTION = 5528,

    SPR_TAB_RIDES_SHOP_0 = 5530,

    SPR_TAB_RIDES_TRANSPORT_0 = 5537,

    SPR_TAB_RIDES_GENTLE_0 = 5542,

    SPR_TAB_RIDES_ROLLER_COASTERS_0 = 5546,

    SPR_TAB_RIDES_WATER_0 = 5551,

    SPR_TAB_RIDES_THRILL_0 = 5557,

    SPR_TAB_LARGE = 5564,
    SPR_TAB_LARGE_SELECTED = 5565,
    SPR_TAB_EXTRA_LARGE = 5566,
    SPR_TAB_EXTRA_LARGE_SELECTED = 5567,
    SPR_TAB_GUESTS_0 = 5568,
    SPR_TAB_GUESTS_1 = SPR_TAB_GUESTS_0 + 1,
    SPR_TAB_GUESTS_2 = SPR_TAB_GUESTS_0 + 2,
    SPR_TAB_GUESTS_3 = SPR_TAB_GUESTS_0 + 3,
    SPR_TAB_GUESTS_4 = SPR_TAB_GUESTS_0 + 4,
    SPR_TAB_GUESTS_5 = SPR_TAB_GUESTS_0 + 5,
    SPR_TAB_GUESTS_6 = SPR_TAB_GUESTS_0 + 6,
    SPR_TAB_GUESTS_7 = SPR_TAB_GUESTS_0 + 7,
    SPR_MAZE_CONSTRUCTION_BUILD = 5576,
    SPR_MAZE_CONSTRUCTION_MOVE = 5577,
    SPR_MAZE_CONSTRUCTION_FILL_IN = 5578,
    SPR_FLOOR_TEXTURE_GRASS = 5579,
    SPR_FLOOR_TEXTURE_SAND = SPR_FLOOR_TEXTURE_GRASS + 1,
    SPR_FLOOR_TEXTURE_DIRT = SPR_FLOOR_TEXTURE_GRASS + 2,
    SPR_FLOOR_TEXTURE_ROCK = SPR_FLOOR_TEXTURE_GRASS + 3,
    SPR_FLOOR_TEXTURE_MARTIAN = SPR_FLOOR_TEXTURE_GRASS + 4,
    SPR_FLOOR_TEXTURE_CHECKERBOARD = SPR_FLOOR_TEXTURE_GRASS + 5,
    SPR_FLOOR_TEXTURE_GRASS_CLUMPS = SPR_FLOOR_TEXTURE_GRASS + 6,
    SPR_FLOOR_TEXTURE_ICE = SPR_FLOOR_TEXTURE_GRASS + 7,
    SPR_FLOOR_TEXTURE_GRID_RED = SPR_FLOOR_TEXTURE_GRASS + 8,
    SPR_FLOOR_TEXTURE_GRID_YELLOW = SPR_FLOOR_TEXTURE_GRASS + 9,
    SPR_FLOOR_TEXTURE_GRID_BLUE = SPR_FLOOR_TEXTURE_GRASS + 10,
    SPR_FLOOR_TEXTURE_GRID_GREEN = SPR_FLOOR_TEXTURE_GRASS + 11,
    SPR_FLOOR_TEXTURE_SAND_DARK = SPR_FLOOR_TEXTURE_GRASS + 12,
    SPR_FLOOR_TEXTURE_SAND_LIGHT = SPR_FLOOR_TEXTURE_GRASS + 13,
    SPR_WALL_TEXTURE_ROCK = 5593,
    SPR_WALL_TEXTURE_WOOD_RED = SPR_WALL_TEXTURE_ROCK + 1,
    SPR_WALL_TEXTURE_WOOD_BLACK = SPR_WALL_TEXTURE_ROCK + 2,
    SPR_WALL_TEXTURE_ICE = SPR_WALL_TEXTURE_ROCK + 3,
    SPR_TOOLBAR_PAUSE = 5597,

    SPR_TOOLBAR_FILE = 5599,

    SPR_TOOLBAR_ZOOM_OUT = 5601,

    SPR_TOOLBAR_ZOOM_OUT_DISABLED = 5603,
    SPR_TOOLBAR_ZOOM_IN = 5604,

    SPR_TOOLBAR_ZOOM_IN_DISABLED = 5606,
    SPR_TOOLBAR_ROTATE = 5607,

    SPR_TOOLBAR_LAND = 5609,

    SPR_TOOLBAR_MAP = 5611,

    SPR_TOOLBAR_GUESTS = 5613,

    SPR_TOOLBAR_SCENERY = 5615,

    SPR_TOOLBAR_WATER = 5617,

    SPR_TOOLBAR_RIDES = 5619,

    SPR_TOOLBAR_VIEW = 5621,

    SPR_TOOLBAR_FOOTPATH = 5623,

    SPR_TAB_TOOLBAR = 5625,

    SPR_TOOLBAR_STAFF = 5627,

    SPR_TOOLBAR_PARK = 5629,

    SPR_TOOLBAR_CONSTRUCT_RIDE = 5631,

    SPR_TOOLBAR_CLEAR_SCENERY = 5633,

    SPR_CONSTRUCTION_DIRECTION_NE = 5635,
    SPR_CONSTRUCTION_DIRECTION_SE = 5636,
    SPR_CONSTRUCTION_DIRECTION_SW = 5637,
    SPR_CONSTRUCTION_DIRECTION_NW = 5638,
    SPR_CONSTRUCTION_FOOTPATH_LAND = 5639,
    SPR_CONSTRUCTION_FOOTPATH_BRIDGE = 5640,

    SPR_HEIGHT_MARKER_BASE = 5769,

    SPR_PEEP_PICKUP_COUNT = 12,
    SPR_PEEP_PICKUP_GUEST_START = 6813,
    SPR_PEEP_PICKUP_HANDYMAN_START = 11289,
    SPR_PEEP_PICKUP_MECHANIC_START = 11469,
    SPR_PEEP_PICKUP_GUARD_START = 11909,
    SPR_PEEP_PICKUP_PANDA_START = 12001,
    SPR_PEEP_PICKUP_TIGER_START = 12157,
    SPR_PEEP_PICKUP_ELEPHANT_START = 12353,
    SPR_PEEP_PICKUP_GORILLA_START = 12665,
    SPR_PEEP_PICKUP_SNOWMAN_START = 12881,
    SPR_PEEP_PICKUP_KNIGHT_START = 12981,
    SPR_PEEP_PICKUP_BANDIT_START = 13197,
    SPR_PEEP_PICKUP_PIRATE_START = 13469,
    SPR_PEEP_PICKUP_SHERIFF_START = 13701,
    SPR_PEEP_PICKUP_ASTRONAUT_START = 13845,
    SPR_PEEP_PICKUP_ROMAN_START = 13925,

    SPR_RIDE_DESIGN_PREVIEW_SPIRAL_ROLLER_COASTER_TRACK = 14222,
    SPR_RIDE_DESIGN_PREVIEW_SPIRAL_ROLLER_COASTER_SUPPORTS = 14223,
    SPR_RIDE_DESIGN_PREVIEW_STAND_UP_ROLLER_COASTER_TRACK = 14224,
    SPR_RIDE_DESIGN_PREVIEW_STAND_UP_ROLLER_COASTER_SUPPORTS = 14225,
    SPR_RIDE_DESIGN_PREVIEW_SUSPENDED_SWINGING_COASTER_TRACK = 14226,
    SPR_RIDE_DESIGN_PREVIEW_SUSPENDED_SWINGING_COASTER_SUPPORTS = 14227,
    SPR_RIDE_DESIGN_PREVIEW_INVERTED_ROLLER_COASTER_TRACK = 14228,
    SPR_RIDE_DESIGN_PREVIEW_INVERTED_ROLLER_COASTER_SUPPORTS = 14229,
    SPR_RIDE_DESIGN_PREVIEW_JUNIOR_ROLLER_COASTER_TRACK = 14230,
    SPR_RIDE_DESIGN_PREVIEW_JUNIOR_ROLLER_COASTER_SUPPORTS = 14231,
    SPR_RIDE_DESIGN_PREVIEW_MINIATURE_RAILWAY_TRACK = 14232,
    SPR_RIDE_DESIGN_PREVIEW_MINIATURE_RAILWAY_SUPPORTS = 14233,
    SPR_RIDE_DESIGN_PREVIEW_MONORAIL_TRACK = 14234,
    SPR_RIDE_DESIGN_PREVIEW_MONORAIL_SUPPORTS = 14235,
    SPR_RIDE_DESIGN_PREVIEW_MINI_SUSPENDED_COASTER_TRACK = 14236,
    SPR_RIDE_DESIGN_PREVIEW_MINI_SUSPENDED_COASTER_SUPPORTS = 14237,
    SPR_RIDE_DESIGN_PREVIEW_BOAT_HIRE_TRACK = 14238,
    SPR_RIDE_DESIGN_PREVIEW_BOAT_HIRE_SUPPORTS = 14239,
    SPR_RIDE_DESIGN_PREVIEW_WOODEN_WILD_MOUSE_TRACK = 14240,
    SPR_RIDE_DESIGN_PREVIEW_WOODEN_WILD_MOUSE_SUPPORTS = 14241,
    SPR_RIDE_DESIGN_PREVIEW_STEEPLECHASE_TRACK = 14242,
    SPR_RIDE_DESIGN_PREVIEW_STEEPLECHASE_SUPPORTS = 14243,
    SPR_RIDE_DESIGN_PREVIEW_CAR_RIDE_TRACK = 14244,
    SPR_RIDE_DESIGN_PREVIEW_CAR_RIDE_SUPPORTS = 14245,
    SPR_RIDE_DESIGN_PREVIEW_LAUNCHED_FREEFALL_TRACK = 14246,
    SPR_RIDE_DESIGN_PREVIEW_LAUNCHED_FREEFALL_SUPPORTS = 14247,
    SPR_RIDE_DESIGN_PREVIEW_BOBSLEIGH_COASTER_TRACK = 14248,
    SPR_RIDE_DESIGN_PREVIEW_BOBSLEIGH_COASTER_SUPPORTS = 14249,
    SPR_RIDE_DESIGN_PREVIEW_OBSERVATION_TOWER_TRACK = 14250,
    SPR_RIDE_DESIGN_PREVIEW_OBSERVATION_TOWER_SUPPORTS = 14251,
    SPR_RIDE_DESIGN_PREVIEW_LOOPING_ROLLER_COASTER_TRACK = 14252,
    SPR_RIDE_DESIGN_PREVIEW_LOOPING_ROLLER_COASTER_SUPPORTS = 14253,
    SPR_RIDE_DESIGN_PREVIEW_DINGHY_SLIDE_TRACK = 14254,
    SPR_RIDE_DESIGN_PREVIEW_DINGHY_SLIDE_SUPPORTS = 14255,
    SPR_RIDE_DESIGN_PREVIEW_MINE_TRAIN_COASTER_TRACK = 14256,
    SPR_RIDE_DESIGN_PREVIEW_MINE_TRAIN_COASTER_SUPPORTS = 14257,
    SPR_RIDE_DESIGN_PREVIEW_CHAIRLIFT_TRACK = 14258,
    SPR_RIDE_DESIGN_PREVIEW_CHAIRLIFT_SUPPORTS = 14259,
    SPR_RIDE_DESIGN_PREVIEW_CORKSCREW_ROLLER_COASTER_TRACK = 14260,
    SPR_RIDE_DESIGN_PREVIEW_CORKSCREW_ROLLER_COASTER_SUPPORTS = 14261,

    SPR_RIDE_DESIGN_PREVIEW_SPIRAL_SLIDE_TRACK = 14264,

    SPR_RIDE_DESIGN_PREVIEW_GO_KARTS_TRACK = 14266,
    SPR_RIDE_DESIGN_PREVIEW_GO_KARTS_SUPPORTS = 14267,
    SPR_RIDE_DESIGN_PREVIEW_LOG_FLUME_TRACK = 14268,
    SPR_RIDE_DESIGN_PREVIEW_LOG_FLUME_SUPPORTS = 14269,
    SPR_RIDE_DESIGN_PREVIEW_RIVER_RAPIDS_TRACK = 14270,
    SPR_RIDE_DESIGN_PREVIEW_RIVER_RAPIDS_SUPPORTS = 14271,
    SPR_RIDE_DESIGN_PREVIEW_DODGEMS_TRACK = 14272,
    SPR_RIDE_DESIGN_PREVIEW_DODGEMS_SUPPORTS = 14273,
    SPR_RIDE_DESIGN_PREVIEW_SWINGING_SHIP_TRACK = 14274,
    SPR_RIDE_DESIGN_PREVIEW_SWINGING_SHIP_SUPPORTS = 14275,
    SPR_RIDE_DESIGN_PREVIEW_SWINGING_INVERTER_SHIP_TRACK = 14276,
    SPR_RIDE_DESIGN_PREVIEW_SWINGING_INVERTER_SHIP_SUPPORTS = 14277,

    SPR_RIDE_DESIGN_PREVIEW_FERRIS_WHEEL_TRACK = 14296,

    SPR_RIDE_DESIGN_PREVIEW_TOP_SPIN_TRACK = 14302,

    SPR_RIDE_DESIGN_PREVIEW_REVERSE_FREEFALL_COASTER_TRACK = 14306,
    SPR_RIDE_DESIGN_PREVIEW_REVERSE_FREEFALL_COASTER_SUPPORTS = 14307,
    SPR_RIDE_DESIGN_PREVIEW_LIFT_TRACK = 14308,

    SPR_RIDE_DESIGN_PREVIEW_VERTICAL_DROP_ROLLER_COASTER_TRACK = 14310,
    SPR_RIDE_DESIGN_PREVIEW_VERTICAL_DROP_ROLLER_COASTER_SUPPORTS = 14311,

    SPR_RIDE_DESIGN_PREVIEW_GHOST_TRAIN_TRACK = 14322,
    SPR_RIDE_DESIGN_PREVIEW_GHOST_TRAIN_SUPPORTS = 14323,
    SPR_RIDE_DESIGN_PREVIEW_TWISTER_ROLLER_COASTER_TRACK = 14324,
    SPR_RIDE_DESIGN_PREVIEW_TWISTER_ROLLER_COASTER_SUPPORTS = 14325,
    SPR_RIDE_DESIGN_PREVIEW_WOODEN_ROLLER_COASTER_TRACK = 14326,
    SPR_RIDE_DESIGN_PREVIEW_WOODEN_ROLLER_COASTER_SUPPORTS = 14327,
    SPR_RIDE_DESIGN_PREVIEW_SIDE_FRICTION_ROLLER_COASTER_TRACK = 14328,
    SPR_RIDE_DESIGN_PREVIEW_SIDE_FRICTION_ROLLER_COASTER_SUPPORTS = 14329,
    SPR_RIDE_DESIGN_PREVIEW_WILD_MOUSE_TRACK = 14330,
    SPR_RIDE_DESIGN_PREVIEW_WILD_MOUSE_SUPPORTS = 14331,
    SPR_RIDE_DESIGN_PREVIEW_MULTI_DIMENSION_ROLLER_COASTER_TRACK = 14332,
    SPR_RIDE_DESIGN_PREVIEW_MULTI_DIMENSION_ROLLER_COASTER_SUPPORTS = 14333,

    SPR_RIDE_DESIGN_PREVIEW_FLYING_ROLLER_COASTER_TRACK = 14336,
    SPR_RIDE_DESIGN_PREVIEW_FLYING_ROLLER_COASTER_SUPPORTS = 14337,

    SPR_RIDE_DESIGN_PREVIEW_VIRGINIA_REEL_TRACK = 14340,
    SPR_RIDE_DESIGN_PREVIEW_VIRGINIA_REEL_SUPPORTS = 14341,
    SPR_RIDE_DESIGN_PREVIEW_SPLASH_BOATS_TRACK = 14342,
    SPR_RIDE_DESIGN_PREVIEW_SPLASH_BOATS_SUPPORTS = 14343,
    SPR_RIDE_DESIGN_PREVIEW_MINI_HELICOPTERS_TRACK = 14344,
    SPR_RIDE_DESIGN_PREVIEW_MINI_HELICOPTERS_SUPPORTS = 14345,
    SPR_RIDE_DESIGN_PREVIEW_LAY_DOWN_ROLLER_COASTER_TRACK = 14346,
    SPR_RIDE_DESIGN_PREVIEW_LAY_DOWN_ROLLER_COASTER_SUPPORTS = 14347,
    SPR_RIDE_DESIGN_PREVIEW_SUSPENDED_MONORAIL_TRACK = 14348,
    SPR_RIDE_DESIGN_PREVIEW_SUSPENDED_MONORAIL_SUPPORTS = 14349,

    SPR_RIDE_DESIGN_PREVIEW_REVERSER_ROLLER_COASTER_TRACK = 14352,
    SPR_RIDE_DESIGN_PREVIEW_REVERSER_ROLLER_COASTER_SUPPORTS = 14353,
    SPR_RIDE_DESIGN_PREVIEW_HEARTLINE_TWISTER_COASTER_TRACK = 14354,
    SPR_RIDE_DESIGN_PREVIEW_HEARTLINE_TWISTER_COASTER_SUPPORTS = 14355,
    SPR_RIDE_DESIGN_PREVIEW_MINI_GOLF_TRACK = 14356,
    SPR_RIDE_DESIGN_PREVIEW_MINI_GOLF_SUPPORTS = 14357,
    SPR_RIDE_DESIGN_PREVIEW_GIGA_RC = 14358,
    SPR_RIDE_DESIGN_PREVIEW_GIGA_RC_SUPPORTS = 14359,
    SPR_RIDE_DESIGN_PREVIEW_ROTO_DROP_TRACK = 14360,
    SPR_RIDE_DESIGN_PREVIEW_ROTO_DROP_SUPPORTS = 14361,
    SPR_RIDE_DESIGN_PREVIEW_FLYING_SAUCERS_TRACK = 14362,

    SPR_RIDE_DESIGN_PREVIEW_MONORAIL_CYCLES_TRACK = 14366,
    SPR_RIDE_DESIGN_PREVIEW_MONORAIL_CYCLES_SUPPORTS = 14367,
    SPR_RIDE_DESIGN_PREVIEW_COMPACT_INVERTED_COASTER_TRACK = 14368,
    SPR_RIDE_DESIGN_PREVIEW_COMPACT_INVERTED_COASTER_SUPPORTS = 14369,
    SPR_RIDE_DESIGN_PREVIEW_WATER_COASTER_TRACK = 14370,
    SPR_RIDE_DESIGN_PREVIEW_WATER_COASTER_SUPPORTS = 14371,
    SPR_RIDE_DESIGN_PREVIEW_AIR_POWERED_VERTICAL_COASTER_TRACK = 14372,
    SPR_RIDE_DESIGN_PREVIEW_AIR_POWERED_VERTICAL_COASTER_SUPPORTS = 14373,
    SPR_RIDE_DESIGN_PREVIEW_INVERTED_HAIRPIN_COASTER_TRACK = 14374,
    SPR_RIDE_DESIGN_PREVIEW_INVERTED_HAIRPIN_COASTER_SUPPORTS = 14375,
    SPR_RIDE_DESIGN_PREVIEW_MAGIC_CARPET_TRACK = 14376,
    SPR_RIDE_DESIGN_PREVIEW_MAGIC_CARPET_SUPPORTS = 14377,
    SPR_RIDE_DESIGN_PREVIEW_SUBMARINE_RIDE_TRACK = 14378,
    SPR_RIDE_DESIGN_PREVIEW_SUBMARINE_RIDE_SUPPORTS = 14379,
    SPR_RIDE_DESIGN_PREVIEW_RIVER_RAFTS_TRACK = 14380,
    SPR_RIDE_DESIGN_PREVIEW_RIVER_RAFTS_SUPPORTS = 14381,

    SPR_RIDE_DESIGN_PREVIEW_INVERTED_IMPULSE_COASTER_TRACK = 14394,
    SPR_RIDE_DESIGN_PREVIEW_INVERTED_IMPULSE_COASTER_SUPPORTS = 14395,
    SPR_RIDE_DESIGN_PREVIEW_MINI_ROLLER_COASTER_TRACK = 14396,
    SPR_RIDE_DESIGN_PREVIEW_MINI_ROLLER_COASTER_SUPPORTS = 14397,
    SPR_RIDE_DESIGN_PREVIEW_MINE_RIDE_TRACK = 14398,
    SPR_RIDE_DESIGN_PREVIEW_MINE_RIDE_SUPPORTS = 14399,

    SPR_RIDE_DESIGN_PREVIEW_LIM_LAUNCHED_ROLLER_COASTER_TRACK = 14402,
    SPR_RIDE_DESIGN_PREVIEW_LIM_LAUNCHED_ROLLER_COASTER_SUPPORTS = 14403,

    SPR_RIDE_DESIGN_PREVIEW_MAZE_BRICK_WALLS = 21990,
    SPR_RIDE_DESIGN_PREVIEW_MAZE_HEDGES = 21991,
    SPR_RIDE_DESIGN_PREVIEW_MAZE_ICE_BLOCKS = 21992,
    SPR_RIDE_DESIGN_PREVIEW_MAZE_WOODEN_FENCES = 21993,

    SPR_LAND_OWNERSHIP_AVAILABLE = 22955,
    SPR_LAND_CONSTRUCTION_RIGHTS_AVAILABLE = 22956,

    SPR_WATER_PARTICLES_DENSE_0 = 22965,
    SPR_WATER_PARTICLES_DENSE_1 = SPR_WATER_PARTICLES_DENSE_0 + 1,
    SPR_WATER_PARTICLES_DENSE_2 = SPR_WATER_PARTICLES_DENSE_0 + 2,
    SPR_WATER_PARTICLES_DENSE_3 = SPR_WATER_PARTICLES_DENSE_0 + 3,
    SPR_WATER_PARTICLES_DENSE_4 = SPR_WATER_PARTICLES_DENSE_0 + 4,
    SPR_WATER_PARTICLES_DENSE_5 = SPR_WATER_PARTICLES_DENSE_0 + 5,
    SPR_WATER_PARTICLES_DENSE_6 = SPR_WATER_PARTICLES_DENSE_0 + 6,
    SPR_WATER_PARTICLES_DENSE_7 = SPR_WATER_PARTICLES_DENSE_0 + 7,

    SPR_LITTER_SICK = 23101,
    SPR_LITTER_SICK_ALT = 23103,
    SPR_LITTER_EMPTY_CAN = 23105,
    SPR_LITTER_RUBBISH = 23107,
    SPR_LITTER_EMPTY_BURGER_BOX = 23109,
    SPR_LITTER_EMPTY_CUP = 23111,
    SPR_LITTER_EMPTY_BOX = 23113,
    SPR_LITTER_EMPTY_BOTTLE = 23115,
    SPR_LITTER_EMPTY_BOWL_RED = 23117,
    SPR_LITTER_EMPTY_DRINK_CART = 23121,
    SPR_LITTER_EMPTY_JUICE_CUP = 23125,
    SPR_LITTER_EMPTY_BOWL_BLUE = 23129,

    SPR_DUCK = 23133,

    SPR_NEXT_WEATHER = 23189,
    SPR_WEATHER_SUN = 23190,
    SPR_WEATHER_SUN_CLOUD = 23191,
    SPR_WEATHER_CLOUD = 23192,
    SPR_WEATHER_LIGHT_RAIN = 23193,
    SPR_WEATHER_HEAVY_RAIN = 23194,
    SPR_WEATHER_STORM = 23195,
    SPR_WEATHER_SNOW = 23196,
    SPR_RATING_LOW = 23197,
    SPR_RATING_HIGH = 23198,
    SPR_MENU_CHECKMARK = 23199,
    SPR_FADE_1 = 23200,
    SPR_FADE_2 = 23201,
    SPR_FADE_3 = 23202,
    SPR_FADE_4 = 23203,
    SPR_FADE_5 = 23204,
    SPR_FADE_6 = 23205,
    SPR_FADE_7 = 23206,
    SPR_MENU_NEW_GAME = 23207,
    SPR_MENU_LOAD_GAME = 23208,
    SPR_MENU_TUTORIAL = 23209,
    SPR_MENU_EXIT = 23210,
    SPR_MENU_TOOLBOX = 23211,
    SPR_MENU_LOGO = 23212,
    SPR_CREDITS_LOGO_SMALL = 23213,
    SPR_CREDITS_CHRIS_SAWYER_SMALL = 23214,
    SPR_INTRO_CHRIS_SAWYER_00 = 23215,
    SPR_INTRO_CHRIS_SAWYER_10 = SPR_INTRO_CHRIS_SAWYER_00 + 1,
    SPR_INTRO_LOGO_00 = 23218,
    SPR_INTRO_LOGO_10 = SPR_INTRO_LOGO_00 + 1,
    SPR_INTRO_LOGO_20 = SPR_INTRO_LOGO_00 + 2,
    SPR_INTRO_LOGO_01 = SPR_INTRO_LOGO_00 + 3,
    SPR_INTRO_LOGO_11 = SPR_INTRO_LOGO_00 + 4,
    SPR_INTRO_LOGO_21 = SPR_INTRO_LOGO_00 + 5,

    SPR_INTRO_INFOGRAMES_00 = 23226,
    SPR_INTRO_INFOGRAMES_10 = SPR_INTRO_INFOGRAMES_00 + 1,
    SPR_INTRO_INFOGRAMES_01 = SPR_INTRO_INFOGRAMES_00 + 2,
    SPR_INTRO_INFOGRAMES_11 = SPR_INTRO_INFOGRAMES_00 + 3,
    SPR_CREDITS_INFOGRAMES = 23230,

    SPR_NEW_RIDE_MASK = 29013,

    SPR_SPLASH_EFFECT_1_NE_0 = 29014,
    SPR_SPLASH_EFFECT_1_NE_1 = SPR_SPLASH_EFFECT_1_NE_0 + 1,
    SPR_SPLASH_EFFECT_1_NE_2 = SPR_SPLASH_EFFECT_1_NE_0 + 2,
    SPR_SPLASH_EFFECT_1_NE_3 = SPR_SPLASH_EFFECT_1_NE_0 + 3,
    SPR_SPLASH_EFFECT_1_NE_4 = SPR_SPLASH_EFFECT_1_NE_0 + 4,
    SPR_SPLASH_EFFECT_1_NE_5 = SPR_SPLASH_EFFECT_1_NE_0 + 5,
    SPR_SPLASH_EFFECT_1_NE_6 = SPR_SPLASH_EFFECT_1_NE_0 + 6,
    SPR_SPLASH_EFFECT_1_NE_7 = SPR_SPLASH_EFFECT_1_NE_0 + 7,

    SPR_SPLASH_EFFECT_2_NW_0 = 29022,
    SPR_SPLASH_EFFECT_2_NW_1 = SPR_SPLASH_EFFECT_2_NW_0 + 1,
    SPR_SPLASH_EFFECT_2_NW_2 = SPR_SPLASH_EFFECT_2_NW_0 + 2,
    SPR_SPLASH_EFFECT_2_NW_3 = SPR_SPLASH_EFFECT_2_NW_0 + 3,
    SPR_SPLASH_EFFECT_2_NW_4 = SPR_SPLASH_EFFECT_2_NW_0 + 4,
    SPR_SPLASH_EFFECT_2_NW_5 = SPR_SPLASH_EFFECT_2_NW_0 + 5,
    SPR_SPLASH_EFFECT_2_NW_6 = SPR_SPLASH_EFFECT_2_NW_0 + 6,
    SPR_SPLASH_EFFECT_2_NW_7 = SPR_SPLASH_EFFECT_2_NW_0 + 7,

    SPR_SPLASH_EFFECT_2_NE_0 = 29030,
    SPR_SPLASH_EFFECT_2_NE_1 = SPR_SPLASH_EFFECT_2_NE_0 + 1,
    SPR_SPLASH_EFFECT_2_NE_2 = SPR_SPLASH_EFFECT_2_NE_0 + 2,
    SPR_SPLASH_EFFECT_2_NE_3 = SPR_SPLASH_EFFECT_2_NE_0 + 3,
    SPR_SPLASH_EFFECT_2_NE_4 = SPR_SPLASH_EFFECT_2_NE_0 + 4,
    SPR_SPLASH_EFFECT_2_NE_5 = SPR_SPLASH_EFFECT_2_NE_0 + 5,
    SPR_SPLASH_EFFECT_2_NE_6 = SPR_SPLASH_EFFECT_2_NE_0 + 6,
    SPR_SPLASH_EFFECT_2_NE_7 = SPR_SPLASH_EFFECT_2_NE_0 + 7,

    SPR_SPLASH_EFFECT_1_NW_0 = 29038,
    SPR_SPLASH_EFFECT_1_NW_1 = SPR_SPLASH_EFFECT_1_NW_0 + 1,
    SPR_SPLASH_EFFECT_1_NW_2 = SPR_SPLASH_EFFECT_1_NW_0 + 2,
    SPR_SPLASH_EFFECT_1_NW_3 = SPR_SPLASH_EFFECT_1_NW_0 + 3,
    SPR_SPLASH_EFFECT_1_NW_4 = SPR_SPLASH_EFFECT_1_NW_0 + 4,
    SPR_SPLASH_EFFECT_1_NW_5 = SPR_SPLASH_EFFECT_1_NW_0 + 5,
    SPR_SPLASH_EFFECT_1_NW_6 = SPR_SPLASH_EFFECT_1_NW_0 + 6,
    SPR_SPLASH_EFFECT_1_NW_7 = SPR_SPLASH_EFFECT_1_NW_0 + 7,

    SPR_SPLASH_EFFECT_3_NE_0 = 29046,
    SPR_SPLASH_EFFECT_3_NE_1 = SPR_SPLASH_EFFECT_3_NE_0 + 1,
    SPR_SPLASH_EFFECT_3_NE_2 = SPR_SPLASH_EFFECT_3_NE_0 + 2,
    SPR_SPLASH_EFFECT_3_NE_3 = SPR_SPLASH_EFFECT_3_NE_0 + 3,
    SPR_SPLASH_EFFECT_3_NE_4 = SPR_SPLASH_EFFECT_3_NE_0 + 4,
    SPR_SPLASH_EFFECT_3_NE_5 = SPR_SPLASH_EFFECT_3_NE_0 + 5,
    SPR_SPLASH_EFFECT_3_NE_6 = SPR_SPLASH_EFFECT_3_NE_0 + 6,
    SPR_SPLASH_EFFECT_3_NE_7 = SPR_SPLASH_EFFECT_3_NE_0 + 7,

    SPR_SPLASH_EFFECT_4_NW_0 = 29054,
    SPR_SPLASH_EFFECT_4_NW_1 = SPR_SPLASH_EFFECT_4_NW_0 + 1,
    SPR_SPLASH_EFFECT_4_NW_2 = SPR_SPLASH_EFFECT_4_NW_0 + 2,
    SPR_SPLASH_EFFECT_4_NW_3 = SPR_SPLASH_EFFECT_4_NW_0 + 3,
    SPR_SPLASH_EFFECT_4_NW_4 = SPR_SPLASH_EFFECT_4_NW_0 + 4,
    SPR_SPLASH_EFFECT_4_NW_5 = SPR_SPLASH_EFFECT_4_NW_0 + 5,
    SPR_SPLASH_EFFECT_4_NW_6 = SPR_SPLASH_EFFECT_4_NW_0 + 6,
    SPR_SPLASH_EFFECT_4_NW_7 = SPR_SPLASH_EFFECT_4_NW_0 + 7,

    SPR_SPLASH_EFFECT_4_NE_0 = 29062,
    SPR_SPLASH_EFFECT_4_NE_1 = SPR_SPLASH_EFFECT_4_NE_0 + 1,
    SPR_SPLASH_EFFECT_4_NE_2 = SPR_SPLASH_EFFECT_4_NE_0 + 2,
    SPR_SPLASH_EFFECT_4_NE_3 = SPR_SPLASH_EFFECT_4_NE_0 + 3,
    SPR_SPLASH_EFFECT_4_NE_4 = SPR_SPLASH_EFFECT_4_NE_0 + 4,
    SPR_SPLASH_EFFECT_4_NE_5 = SPR_SPLASH_EFFECT_4_NE_0 + 5,
    SPR_SPLASH_EFFECT_4_NE_6 = SPR_SPLASH_EFFECT_4_NE_0 + 6,
    SPR_SPLASH_EFFECT_4_NE_7 = SPR_SPLASH_EFFECT_4_NE_0 + 7,

    SPR_SPLASH_EFFECT_3_NW_0 = 29070,
    SPR_SPLASH_EFFECT_3_NW_1 = SPR_SPLASH_EFFECT_3_NW_0 + 1,
    SPR_SPLASH_EFFECT_3_NW_2 = SPR_SPLASH_EFFECT_3_NW_0 + 2,
    SPR_SPLASH_EFFECT_3_NW_3 = SPR_SPLASH_EFFECT_3_NW_0 + 3,
    SPR_SPLASH_EFFECT_3_NW_4 = SPR_SPLASH_EFFECT_3_NW_0 + 4,
    SPR_SPLASH_EFFECT_3_NW_5 = SPR_SPLASH_EFFECT_3_NW_0 + 5,
    SPR_SPLASH_EFFECT_3_NW_6 = SPR_SPLASH_EFFECT_3_NW_0 + 6,
    SPR_SPLASH_EFFECT_3_NW_7 = SPR_SPLASH_EFFECT_3_NW_0 + 7,

    SPR_SPLASH_EFFECT_5_NE_0 = 29078,
    SPR_SPLASH_EFFECT_5_NE_1 = SPR_SPLASH_EFFECT_5_NE_0 + 1,
    SPR_SPLASH_EFFECT_5_NE_3 = SPR_SPLASH_EFFECT_5_NE_0 + 2,
    SPR_SPLASH_EFFECT_5_NE_2 = SPR_SPLASH_EFFECT_5_NE_0 + 3,
    SPR_SPLASH_EFFECT_5_NE_4 = SPR_SPLASH_EFFECT_5_NE_0 + 4,
    SPR_SPLASH_EFFECT_5_NE_5 = SPR_SPLASH_EFFECT_5_NE_0 + 5,
    SPR_SPLASH_EFFECT_5_NE_6 = SPR_SPLASH_EFFECT_5_NE_0 + 6,
    SPR_SPLASH_EFFECT_5_NE_7 = SPR_SPLASH_EFFECT_5_NE_0 + 7,

    SPR_SPLASH_EFFECT_5_SE_0 = 29086,
    SPR_SPLASH_EFFECT_5_SE_1 = SPR_SPLASH_EFFECT_5_SE_0 + 1,
    SPR_SPLASH_EFFECT_5_SE_2 = SPR_SPLASH_EFFECT_5_SE_0 + 2,
    SPR_SPLASH_EFFECT_5_SE_3 = SPR_SPLASH_EFFECT_5_SE_0 + 3,
    SPR_SPLASH_EFFECT_5_SE_4 = SPR_SPLASH_EFFECT_5_SE_0 + 4,
    SPR_SPLASH_EFFECT_5_SE_5 = SPR_SPLASH_EFFECT_5_SE_0 + 5,
    SPR_SPLASH_EFFECT_5_SE_6 = SPR_SPLASH_EFFECT_5_SE_0 + 6,
    SPR_SPLASH_EFFECT_5_SE_7 = SPR_SPLASH_EFFECT_5_SE_0 + 7,

    SPR_SPLASH_EFFECT_5_SW_0 = 29094,
    SPR_SPLASH_EFFECT_5_SW_1 = SPR_SPLASH_EFFECT_5_SW_0 + 1,
    SPR_SPLASH_EFFECT_5_SW_2 = SPR_SPLASH_EFFECT_5_SW_0 + 2,
    SPR_SPLASH_EFFECT_5_SW_3 = SPR_SPLASH_EFFECT_5_SW_0 + 3,
    SPR_SPLASH_EFFECT_5_SW_4 = SPR_SPLASH_EFFECT_5_SW_0 + 4,
    SPR_SPLASH_EFFECT_5_SW_5 = SPR_SPLASH_EFFECT_5_SW_0 + 5,
    SPR_SPLASH_EFFECT_5_SW_6 = SPR_SPLASH_EFFECT_5_SW_0 + 6,
    SPR_SPLASH_EFFECT_5_SW_7 = SPR_SPLASH_EFFECT_5_SW_0 + 7,

    SPR_SPLASH_EFFECT_5_NW_0 = 29102,
    SPR_SPLASH_EFFECT_5_NW_1 = SPR_SPLASH_EFFECT_5_NW_0 + 1,
    SPR_SPLASH_EFFECT_5_NW_2 = SPR_SPLASH_EFFECT_5_NW_0 + 2,
    SPR_SPLASH_EFFECT_5_NW_3 = SPR_SPLASH_EFFECT_5_NW_0 + 3,
    SPR_SPLASH_EFFECT_5_NW_4 = SPR_SPLASH_EFFECT_5_NW_0 + 4,
    SPR_SPLASH_EFFECT_5_NW_5 = SPR_SPLASH_EFFECT_5_NW_0 + 5,
    SPR_SPLASH_EFFECT_5_NW_6 = SPR_SPLASH_EFFECT_5_NW_0 + 6,
    SPR_SPLASH_EFFECT_5_NW_7 = SPR_SPLASH_EFFECT_5_NW_0 + 7,

    SPR_G1_END = 29294,
    SPR_RCTC_G1_END = 29357, // The number of elements in RCTC's g1.dat file

    // Start of OpenRCT2 additions (g2.dat)

    SPR_G2_BEGIN = 29357,
    SPR_G2_EMPTY = SPR_G2_BEGIN,
    SPR_G2_PLACEHOLDER,

    // G2 UI Elements
    // When adding UI elements to G2, insert them before fonts and give them a name in src/openrct2/scripting/IconNames.hpp

    SPR_G2_LOGO,
    SPR_G2_TITLE,
    SPR_G2_FASTFORWARD,
    SPR_G2_SPEED_ARROW,
    SPR_G2_HYPER_ARROW,
    SPR_G2_TAB_LAND,
    SPR_G2_ZOOM_IN,
    SPR_G2_ZOOM_IN_DISABLED,
    SPR_G2_ZOOM_OUT,
    SPR_G2_ZOOM_OUT_DISABLED,
    SPR_G2_TAB_TREE,
    SPR_G2_TAB_PENCIL,
    SPR_G2_BUTTON_LARGE_SCENERY,
    SPR_G2_BUTTON_TREES,
    SPR_G2_BUTTON_FOOTPATH,
    SPR_G2_RCT1_CLOSE_BUTTON_0,
    SPR_G2_RCT1_CLOSE_BUTTON_1,
    SPR_G2_RCT1_CLOSE_BUTTON_2,
    SPR_G2_RCT1_CLOSE_BUTTON_3,
    SPR_G2_RCT1_TEST_BUTTON_0,
    SPR_G2_RCT1_TEST_BUTTON_1,
    SPR_G2_RCT1_TEST_BUTTON_2,
    SPR_G2_RCT1_TEST_BUTTON_3,
    SPR_G2_RCT1_OPEN_BUTTON_0,
    SPR_G2_RCT1_OPEN_BUTTON_1,
    SPR_G2_RCT1_OPEN_BUTTON_2,
    SPR_G2_RCT1_OPEN_BUTTON_3,
    SPR_G2_TITLE_RESTART,
    SPR_G2_TITLE_STOP,
    SPR_G2_TITLE_PLAY,
    SPR_G2_TITLE_SKIP,
    SPR_G2_SANDBOX,
    SPR_G2_TAB_NEWS,
    SPR_G2_LOCKED,
    SPR_G2_MENU_MULTIPLAYER,
    SPR_G2_SORT,
    SPR_G2_COPY,
    SPR_G2_PASTE,
    SPR_G2_TOOLBAR_MUTE,
    SPR_G2_TOOLBAR_MUTE_PRESSED,
    SPR_G2_TOOLBAR_UNMUTE,
    SPR_G2_TOOLBAR_UNMUTE_PRESSED,
    SPR_G2_SEARCH,
    SPR_G2_EYEDROPPER,
    SPR_G2_CHAT,
    SPR_G2_MAP_NORTH,
    SPR_G2_MAP_NORTH_PRESSED,
    SPR_G2_MAP_WEST,
    SPR_G2_MAP_WEST_PRESSED,
    SPR_G2_MAP_SOUTH,
    SPR_G2_MAP_SOUTH_PRESSED,
    SPR_G2_MAP_EAST,
    SPR_G2_MAP_EAST_PRESSED,
    SPR_G2_TOOLBAR_MULTIPLAYER,
    SPR_G2_TOOLBAR_MULTIPLAYER_PRESSED,
    SPR_G2_MULTIPLAYER_SYNC,
    SPR_G2_MULTIPLAYER_DESYNC,
    SPR_G2_SIMULATE,
    SPR_G2_RCT1_SIMULATE_BUTTON_0,
    SPR_G2_RCT1_SIMULATE_BUTTON_1,
    SPR_G2_RCT1_SIMULATE_BUTTON_2,
    SPR_G2_RCT1_SIMULATE_BUTTON_3,
    SPR_G2_INFINITY,
    SPR_G2_LAND_TOOL_SIZE_6,
    SPR_G2_MOUNTAIN_TOOL_EVEN,
    SPR_G2_MOUNTAIN_TOOL_ODD,
    SPR_G2_SCENERY_SCATTER_LOW,
    SPR_G2_SCENERY_SCATTER_MEDIUM,
    SPR_G2_SCENERY_SCATTER_HIGH,
    SPR_G2_VIEW,
    SPR_G2_PATH_RAILINGS_TAB,
    SPR_G2_LEGACY_PATH_TAB,
    SPR_G2_PATH_SURFACE_TAB,
    SPR_G2_RIDE_STATION_TAB,
    SPR_G2_TERRAIN_EDGE_TAB,
    SPR_G2_BUTTON_HIDE_VEGETATION,
    SPR_G2_BUTTON_HIDE_SCENERY,
    SPR_G2_BUTTON_HIDE_VEHICLES,
    SPR_G2_BUTTON_HIDE_SUPPORTS,
    SPR_G2_BUTTON_HIDE_PARTIAL,
    SPR_G2_BUTTON_HIDE_FULL,
    SPR_G2_LINK_CHAIN,
    SPR_G2_SIDEWAYS_TAB,
    SPR_G2_SIDEWAYS_TAB_ACTIVE,
    SPR_G2_ARROW_UP,
    SPR_G2_ARROW_DOWN,
    SPR_G2_RELOAD,
    SPR_G2_MAP_GEN_TERRAIN_TAB,
    SPR_G2_MAP_GEN_BTN,
    SPR_G2_PEEP_SPAWN,
    SPR_G2_ICON_PALETTE_INVISIBLE,
    SPR_G2_ICON_PALETTE_INVISIBLE_PRESSED,
    SPR_G2_FOLDER,
    SPR_G2_FOLDER_NEW,
    SPR_G2_FOLDER_PARENT,
    SPR_G2_FOLDER_DEFAULT,
    SPR_G2_SYSTEM_BROWSER,
    SPR_G2_PEEP_ANIMATIONS,
    SPR_G2_WEATHER_SNOW,
    SPR_G2_WEATHER_HEAVY_SNOW,
    SPR_G2_WEATHER_BLIZZARD,

    // G2 Loading progress

    SPR_G2_LOADER_HYBRID_SUPPORTS,
    SPR_G2_LOADER_HYBRID_TRACK,
    SPR_G2_LOADER_HYBRID_VEHICLE,
    SPR_G2_LOADER_STEEL_SUPPORTS,
    SPR_G2_LOADER_STEEL_TRACK,
    SPR_G2_LOADER_STEEL_VEHICLE,
    SPR_G2_LOADER_WOODEN_SUPPORTS,
    SPR_G2_LOADER_WOODEN_TRACK,
    SPR_G2_LOADER_WOODEN_VEHICLE,

    // G2 Palette maps

    SPR_G2_PALETTE_BEGIN,
    SPR_G2_PAL_REMAP_DARK_OLIVE_DARK = SPR_G2_PALETTE_BEGIN,
    SPR_G2_PAL_REMAP_DARK_OLIVE_LIGHT,
    SPR_G2_PAL_REMAP_SATURATED_BROWN_LIGHT,
    SPR_G2_PAL_REMAP_BORDEAUX_RED_DARK,
    SPR_G2_PAL_REMAP_BORDEAUX_RED_LIGHT,
    SPR_G2_PAL_REMAP_GRASS_GREEN_DARK,
    SPR_G2_PAL_REMAP_GRASS_GREEN_LIGHT,
    SPR_G2_PAL_REMAP_OLIVE_DARK,
    SPR_G2_PAL_REMAP_OLIVE_LIGHT,
    SPR_G2_PAL_REMAP_SATURATED_GREEN_LIGHT,
    SPR_G2_PAL_REMAP_TAN_DARK,
    SPR_G2_PAL_REMAP_TAN_LIGHT,
    SPR_G2_PAL_REMAP_DULL_PURPLE_LIGHT,
    SPR_G2_PAL_REMAP_DULL_GREEN_DARK,
    SPR_G2_PAL_REMAP_DULL_GREEN_LIGHT,
    SPR_G2_PAL_REMAP_SATURATED_PURPLE_DARK,
    SPR_G2_PAL_REMAP_SATURATED_PURPLE_LIGHT,
    SPR_G2_PAL_REMAP_ORANGE_LIGHT,
    SPR_G2_PAL_REMAP_AQUA_DARK,
    SPR_G2_PAL_REMAP_MAGENTA_LIGHT,
    SPR_G2_PAL_REMAP_DULL_BROWN_DARK,
    SPR_G2_PAL_REMAP_DULL_BROWN_LIGHT,
    SPR_G2_PAL_REMAP_INVISIBLE,
    SPR_G2_PAL_REMAP_VOID,
    SPR_G2_PAL_GLASS_DARK_OLIVE_DARK,
    SPR_G2_PAL_GLASS_DARK_OLIVE_LIGHT,
    SPR_G2_PAL_GLASS_SATURATED_BROWN_LIGHT,
    SPR_G2_PAL_GLASS_BORDEAUX_RED_DARK,
    SPR_G2_PAL_GLASS_BORDEAUX_RED_LIGHT,
    SPR_G2_PAL_GLASS_GRASS_GREEN_DARK,
    SPR_G2_PAL_GLASS_GRASS_GREEN_LIGHT,
    SPR_G2_PAL_GLASS_OLIVE_DARK,
    SPR_G2_PAL_GLASS_OLIVE_LIGHT,
    SPR_G2_PAL_GLASS_SATURATED_GREEN_LIGHT,
    SPR_G2_PAL_GLASS_TAN_DARK,
    SPR_G2_PAL_GLASS_TAN_LIGHT,
    SPR_G2_PAL_GLASS_DULL_PURPLE_LIGHT,
    SPR_G2_PAL_GLASS_DULL_GREEN_DARK,
    SPR_G2_PAL_GLASS_DULL_GREEN_LIGHT,
    SPR_G2_PAL_GLASS_SATURATED_PURPLE_DARK,
    SPR_G2_PAL_GLASS_SATURATED_PURPLE_LIGHT,
    SPR_G2_PAL_GLASS_ORANGE_LIGHT,
    SPR_G2_PAL_GLASS_AQUA_DARK,
    SPR_G2_PAL_GLASS_MAGENTA_LIGHT,
    SPR_G2_PAL_GLASS_DULL_BROWN_DARK,
    SPR_G2_PAL_GLASS_DULL_BROWN_LIGHT,
    SPR_G2_PAL_GLASS_INVISIBLE,
    SPR_G2_PAL_GLASS_VOID,
    SPR_G2_PALETTE_END = SPR_G2_PAL_GLASS_VOID,

    // G2 Misc

    SPR_G2_SURFACE_GLASSY_RECOLOURABLE,
    SPR_G2_SELECTION_EDGE_NW,
    SPR_G2_SELECTION_EDGE_NE,
    SPR_G2_SELECTION_EDGE_SW,
    SPR_G2_SELECTION_EDGE_SE,

    // G2 Characters

    SPR_G2_CHAR_BEGIN,
    SPR_G2_AE_UPPER = SPR_G2_CHAR_BEGIN + 0,
    SPR_G2_AE_LOWER,
    SPR_G2_O_STROKE_UPPER,
    SPR_G2_O_STROKE_LOWER,

    SPR_G2_CYRILLIC_UKRAINIAN_IE_UPPER,
    SPR_G2_CYRILLIC_BE_UPPER,
    SPR_G2_CYRILLIC_GHE_UPPER,
    SPR_G2_CYRILLIC_DE_UPPER,
    SPR_G2_CYRILLIC_ZHE_UPPER,
    SPR_G2_CYRILLIC_ZE_UPPER,
    SPR_G2_CYRILLIC_I_UPPER,
    SPR_G2_CYRILLIC_SHORT_I_UPPER,
    SPR_G2_CYRILLIC_EL_UPPER,
    SPR_G2_CYRILLIC_PE_UPPER,
    SPR_G2_CYRILLIC_U_UPPER,
    SPR_G2_CYRILLIC_EF_UPPER,
    SPR_G2_CYRILLIC_TSE_UPPER,
    SPR_G2_CYRILLIC_CHE_UPPER,
    SPR_G2_CYRILLIC_SHA_UPPER,
    SPR_G2_CYRILLIC_SHCHA_UPPER,
    SPR_G2_CYRILLIC_HARD_SIGN_UPPER,
    SPR_G2_CYRILLIC_YERU_UPPER,
    SPR_G2_CYRILLIC_SOFT_SIGN_UPPER,
    SPR_G2_CYRILLIC_E_UPPER,
    SPR_G2_CYRILLIC_YU_UPPER,
    SPR_G2_CYRILLIC_YA_UPPER,

    SPR_G2_CYRILLIC_BE_LOWER,
    SPR_G2_CYRILLIC_VE_LOWER,
    SPR_G2_CYRILLIC_GHE_LOWER,
    SPR_G2_CYRILLIC_DE_LOWER,
    SPR_G2_CYRILLIC_ZHE_LOWER,
    SPR_G2_CYRILLIC_ZE_LOWER,
    SPR_G2_CYRILLIC_I_LOWER,
    SPR_G2_CYRILLIC_SHORT_I_LOWER,
    SPR_G2_CYRILLIC_KA_LOWER,
    SPR_G2_CYRILLIC_EL_LOWER,
    SPR_G2_CYRILLIC_EM_LOWER,
    SPR_G2_CYRILLIC_EN_LOWER,
    SPR_G2_CYRILLIC_PE_LOWER,
    SPR_G2_CYRILLIC_TE_LOWER,
    SPR_G2_CYRILLIC_EF_LOWER,
    SPR_G2_CYRILLIC_TSE_LOWER,
    SPR_G2_CYRILLIC_CHE_LOWER,
    SPR_G2_CYRILLIC_SHA_LOWER,
    SPR_G2_CYRILLIC_SHCHA_LOWER,
    SPR_G2_CYRILLIC_YERU_LOWER,
    SPR_G2_CYRILLIC_SOFT_SIGN_LOWER,
    SPR_G2_CYRILLIC_E_LOWER,
    SPR_G2_CYRILLIC_YU_LOWER,
    SPR_G2_CYRILLIC_YA_LOWER,
    SPR_G2_CYRILLIC_UKRAINIAN_IE_LOWER,
    SPR_G2_CYRILLIC_GHE_UPTURN_UPPER,
    SPR_G2_CYRILLIC_GHE_UPTURN_LOWER,

    SPR_G2_GERMAN_OPENQUOTES,

    SPR_G2_GUILDER_SIGN,

    SPR_G2_G_BREVE_UPPER,
    SPR_G2_I_WITH_DOT_UPPER,
    SPR_G2_S_CEDILLA_UPPER,
    SPR_G2_G_BREVE_LOWER,
    SPR_G2_I_WITHOUT_DOT_LOWER,
    SPR_G2_S_CEDILLA_LOWER,

    SPR_G2_INTERPUNCT,

    SPR_G2_A_BREVE_UPPER,
    SPR_G2_T_COMMA_UPPER,
    SPR_G2_T_COMMA_LOWER,

    SPR_G2_ELLIPSIS,

    SPR_G2_C_CARON_UPPER,
    SPR_G2_C_CARON_LOWER,

    SPR_G2_Y_ACUTE_UPPER,
    SPR_G2_Y_ACUTE_LOWER,

    SPR_G2_O_DOUBLE_ACUTE_UPPER,
    SPR_G2_O_DOUBLE_ACUTE_LOWER,

    SPR_G2_OE_UPPER,
    SPR_G2_OE_LOWER,

    SPR_G2_U_DOUBLE_ACUTE_UPPER,
    SPR_G2_U_DOUBLE_ACUTE_LOWER,

    SPR_G2_D_CARON_UPPER,
    SPR_G2_D_CARON_LOWER,
    SPR_G2_E_CARON_UPPER,
    SPR_G2_E_CARON_LOWER,
    SPR_G2_N_CARON_UPPER,
    SPR_G2_N_CARON_LOWER,
    SPR_G2_R_CARON_UPPER,
    SPR_G2_R_CARON_LOWER,
    SPR_G2_S_CARON_UPPER,
    SPR_G2_S_CARON_LOWER,
    SPR_G2_T_CARON_UPPER,
    SPR_G2_T_CARON_LOWER,
    SPR_G2_U_RING_UPPER,
    SPR_G2_U_RING_LOWER,
    SPR_G2_W_CIRCUMFLEX_UPPER,
    SPR_G2_W_CIRCUMFLEX_LOWER,
    SPR_G2_Y_CIRCUMFLEX_UPPER,
    SPR_G2_Y_CIRCUMFLEX_LOWER,
    SPR_G2_Z_CARON_UPPER,
    SPR_G2_Z_CARON_LOWER,

    SPR_G2_ROUBLE_SIGN,

    SPR_G2_J,
    SPR_G2_L,

    SPR_G2_C_CIRCUMFLEX_UPPER,
    SPR_G2_C_CIRCUMFLEX_LOWER,
    SPR_G2_G_CIRCUMFLEX_UPPER,
    SPR_G2_G_CIRCUMFLEX_LOWER,
    SPR_G2_H_CIRCUMFLEX_UPPER,
    SPR_G2_H_CIRCUMFLEX_LOWER,
    SPR_G2_J_CIRCUMFLEX_UPPER,
    SPR_G2_J_CIRCUMFLEX_LOWER,
    SPR_G2_S_CIRCUMFLEX_UPPER,
    SPR_G2_S_CIRCUMFLEX_LOWER,
    SPR_G2_U_BREVE_UPPER,
    SPR_G2_U_BREVE_LOWER,

    SPR_G2_LEFT_BRACE,
    SPR_G2_VERTICAL_BAR,
    SPR_G2_RIGHT_BRACE,
    SPR_G2_TILDE,

    SPR_G2_EYE,

    SPR_G2_GLYPH_COUNT = (SPR_G2_EYE - SPR_G2_CHAR_BEGIN) + 1,
    SPR_G2_CHAR_END = SPR_G2_CHAR_BEGIN + SPR_G2_GLYPH_COUNT * 3,

    // G2 Track additions

    SPR_G2_JUNIOR_RC_BEGIN = SPR_G2_CHAR_END,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_SW_NE = SPR_G2_JUNIOR_RC_BEGIN,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_NW_SE,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_NE_SW,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_SE_NW,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_NW_SE_PART_0_2,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_NE_SW_PART_0_2,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_SW_NE,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_NW_SE,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_NE_SW,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_SE_NW,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_NW_SE_PART_0_2,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_NE_SW_PART_0_2,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_SW_NE,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_NW_SE,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_NE_SW,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_SE_NW,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_NW_SE_PART_0_2,
    SPR_JUNIOR_RC_FLAT_TO_60_DEG_UP_CHAIN_NE_SW_PART_0_2,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_SW_NE,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_NW_SE,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_NE_SW,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_SE_NW,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_NW_SE_PART_0_2,
    SPR_JUNIOR_RC_60_DEG_UP_TO_FLAT_CHAIN_NE_SW_PART_0_2,
    SPR_JUNIOR_RC_BOOSTER_NW_SE,
    SPR_JUNIOR_RC_BOOSTER_NE_SW,
    SPR_G2_JUNIOR_DIAG_BRAKES,
    SPR_G2_JUNIOR_RC_END = SPR_G2_JUNIOR_DIAG_BRAKES + 6,

    SPR_G2_LATTICE_TRIANGLE_TRACK_BEGIN = SPR_G2_JUNIOR_RC_END,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BOOSTER_NE_SW = SPR_G2_LATTICE_TRIANGLE_TRACK_BEGIN,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BOOSTER_NW_SE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BOOSTER_ALT_NE_SW,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BOOSTER_ALT_NW_SE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BOOSTER_ALT_SW_NE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BOOSTER_ALT_SE_NW,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BLOCK_BRAKE_ALT_CLOSED_NE_SW,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BLOCK_BRAKE_ALT_CLOSED_NW_SE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BLOCK_BRAKE_ALT_CLOSED_SW_NE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BLOCK_BRAKE_ALT_CLOSED_SE_NW,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BLOCK_BRAKE_ALT_OPEN_NE_SW,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BLOCK_BRAKE_ALT_OPEN_NW_SE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BLOCK_BRAKE_ALT_OPEN_SW_NE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BLOCK_BRAKE_ALT_OPEN_SE_NW,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BRAKE_ALT_CLOSED_NE_SW,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BRAKE_ALT_CLOSED_NW_SE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BRAKE_ALT_CLOSED_SW_NE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BRAKE_ALT_CLOSED_SE_NW,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BRAKE_ALT_OPEN_NE_SW,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BRAKE_ALT_OPEN_NW_SE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BRAKE_ALT_OPEN_SW_NE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BRAKE_ALT_OPEN_SE_NW,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BRAKES,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BLOCK_BRAKE_CLOSED_ALT_1 = SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BRAKES + 6,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BLOCK_BRAKE_CLOSED_ALT_2,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BLOCK_BRAKE_CLOSED_ALT_3,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BLOCK_BRAKE_CLOSED_ALT_4,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BLOCK_BRAKE_OPEN_ALT_1,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BLOCK_BRAKE_OPEN_ALT_2,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BLOCK_BRAKE_OPEN_ALT_3,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BLOCK_BRAKE_OPEN_ALT_4,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BOOSTER_1,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BOOSTER_2,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BOOSTER_ALT_1,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BOOSTER_ALT_2,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BOOSTER_ALT_3,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BOOSTER_ALT_4,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BRAKE_CLOSED_ALT_1,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BRAKE_CLOSED_ALT_2,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BRAKE_CLOSED_ALT_3,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BRAKE_CLOSED_ALT_4,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BRAKE_OPEN_ALT_1,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BRAKE_OPEN_ALT_2,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BRAKE_OPEN_ALT_3,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIAG_BRAKE_OPEN_ALT_4,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DRIVE_TYRE_NE_SW,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DRIVE_TYRE_NW_SE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DRIVE_TYRE_SW_NE,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DRIVE_TYRE_SE_NW,
    SPR_G2_LATTICE_TRIANGLE_TRACK_POWERED_LIFT_1,
    SPR_G2_LATTICE_TRIANGLE_TRACK_POWERED_LIFT_2,
    SPR_G2_LATTICE_TRIANGLE_TRACK_POWERED_LIFT_3,
    SPR_G2_LATTICE_TRIANGLE_TRACK_POWERED_LIFT_4,
    SPR_G2_LATTICE_TRIANGLE_TRACK_POWERED_LIFT_ALT_1,
    SPR_G2_LATTICE_TRIANGLE_TRACK_POWERED_LIFT_ALT_2,
    SPR_G2_LATTICE_TRIANGLE_TRACK_POWERED_LIFT_ALT_3,
    SPR_G2_LATTICE_TRIANGLE_TRACK_POWERED_LIFT_ALT_4,
    SPR_G2_LATTICE_TRIANGLE_TRACK_VERTICAL,
    SPR_G2_LATTICE_TRIANGLE_TRACK_VERTICAL_TWIST = SPR_G2_LATTICE_TRIANGLE_TRACK_VERTICAL + 12,
    SPR_G2_LATTICE_TRIANGLE_TRACK_BARREL_ROLL = SPR_G2_LATTICE_TRIANGLE_TRACK_VERTICAL_TWIST + 12,
    SPR_G2_LATTICE_TRIANGLE_TRACK_HALF_LOOP = SPR_G2_LATTICE_TRIANGLE_TRACK_BARREL_ROLL + 48,
    SPR_G2_LATTICE_TRIANGLE_TRACK_VERTICAL_LOOP = SPR_G2_LATTICE_TRIANGLE_TRACK_HALF_LOOP + 16,
    SPR_G2_LATTICE_TRIANGLE_TRACK_QUARTER_LOOP = SPR_G2_LATTICE_TRIANGLE_TRACK_VERTICAL_LOOP + 32,
    SPR_G2_LATTICE_TRIANGLE_TRACK_CORKSCREW = SPR_G2_LATTICE_TRIANGLE_TRACK_QUARTER_LOOP + 12,
    SPR_G2_LATTICE_TRIANGLE_TRACK_LARGE_CORKSCREW = SPR_G2_LATTICE_TRIANGLE_TRACK_CORKSCREW + 24,
    SPR_G2_LATTICE_TRIANGLE_TRACK_TURN_BANK_TRANSITION = SPR_G2_LATTICE_TRIANGLE_TRACK_LARGE_CORKSCREW + 40,
    SPR_G2_LATTICE_TRIANGLE_TRACK_MEDIUM_HALF_LOOP = SPR_G2_LATTICE_TRIANGLE_TRACK_TURN_BANK_TRANSITION + 18,
    SPR_G2_LATTICE_TRIANGLE_TRACK_LARGE_HALF_LOOP = SPR_G2_LATTICE_TRIANGLE_TRACK_MEDIUM_HALF_LOOP + 40,
    SPR_G2_LATTICE_TRIANGLE_TRACK_ZERO_G_ROLL = SPR_G2_LATTICE_TRIANGLE_TRACK_LARGE_HALF_LOOP + 56,
    SPR_G2_LATTICE_TRIANGLE_TRACK_LARGE_ZERO_G_ROLL = SPR_G2_LATTICE_TRIANGLE_TRACK_ZERO_G_ROLL + 32,
    SPR_G2_LATTICE_TRIANGLE_TRACK_SMALL_FLAT_TO_STEEP = SPR_G2_LATTICE_TRIANGLE_TRACK_LARGE_ZERO_G_ROLL + 40,
    SPR_G2_LATTICE_TRIANGLE_TRACK_GENTLE_LARGE_CURVE = SPR_G2_LATTICE_TRIANGLE_TRACK_SMALL_FLAT_TO_STEEP + 20,
    SPR_G2_LATTICE_TRIANGLE_TRACK_GENTLE_LARGE_CURVE_BANKED = SPR_G2_LATTICE_TRIANGLE_TRACK_GENTLE_LARGE_CURVE + 64,
    SPR_G2_LATTICE_TRIANGLE_TRACK_FLAT_TO_STEEP_DIAGONAL = SPR_G2_LATTICE_TRIANGLE_TRACK_GENTLE_LARGE_CURVE_BANKED + 128,
    SPR_G2_LATTICE_TRIANGLE_TRACK_DIVE_LOOP = SPR_G2_LATTICE_TRIANGLE_TRACK_FLAT_TO_STEEP_DIAGONAL + 24,
    SPR_G2_LATTICE_TRIANGLE_TRACK_END = SPR_G2_LATTICE_TRIANGLE_TRACK_DIVE_LOOP + 32,

    SPR_G2_MINI_RC_BEGIN = SPR_G2_LATTICE_TRIANGLE_TRACK_END,
    SPR_G2_MINI_RC_BOOSTER_NE_SW = SPR_G2_MINI_RC_BEGIN,
    SPR_G2_MINI_RC_BOOSTER_NW_SE,
    SPR_G2_MINI_RC_END,

    SPR_G2_BM_RC_BEGIN = SPR_G2_MINI_RC_END,
    SPR_G2_BM_DIAG_BRAKES = SPR_G2_BM_RC_BEGIN,
    SPR_G2_BM_BOOSTER_NE_SW = SPR_G2_BM_DIAG_BRAKES + 6,
    SPR_G2_BM_BOOSTER_NW_SE,
    SPR_G2_BM_TRACK_GENTLE_LARGE_CURVE,
    SPR_G2_BM_TRACK_GENTLE_LARGE_CURVE_BANKED = SPR_G2_BM_TRACK_GENTLE_LARGE_CURVE + 64,
    SPR_G2_BM_TRACK_LARGE_CORKSCREW = SPR_G2_BM_TRACK_GENTLE_LARGE_CURVE_BANKED + 128,
    SPR_G2_BM_TRACK_MEDIUM_HALF_LOOP = SPR_G2_BM_TRACK_LARGE_CORKSCREW + 40,
    SPR_G2_BM_TRACK_ZERO_G_ROLL = SPR_G2_BM_TRACK_MEDIUM_HALF_LOOP + 44,
    SPR_G2_BM_TRACK_LARGE_ZERO_G_ROLL = SPR_G2_BM_TRACK_ZERO_G_ROLL + 32,
    SPR_G2_BM_TRACK_FLAT_TO_STEEP_DIAGONAL = SPR_G2_BM_TRACK_LARGE_ZERO_G_ROLL + 40,
    SPR_G2_BM_TRACK_DIVE_LOOP = SPR_G2_BM_TRACK_FLAT_TO_STEEP_DIAGONAL + 24,
    SPR_G2_BM_RC_END = SPR_G2_BM_TRACK_DIVE_LOOP + 32,

    SPR_G2_MINIATURE_RAILWAY_BEGIN = SPR_G2_BM_RC_END,
    SPR_G2_MINIATURE_RAILWAY_QUARTER_TURN_3_TILES_SW_SE_PART_3 = SPR_G2_MINIATURE_RAILWAY_BEGIN,
    SPR_G2_MINIATURE_RAILWAY_GRAVEL_SW_NE,
    SPR_G2_MINIATURE_RAILWAY_GRAVEL_NW_SE,
    SPR_G2_MINIATURE_RAILWAY_GROOVED_SW_NE,
    SPR_G2_MINIATURE_RAILWAY_GROOVED_NW_SE,
    SPR_G2_MINIATURE_RAILWAY_INSET_SW_NE,
    SPR_G2_MINIATURE_RAILWAY_INSET_NW_SE,
    SPR_G2_MINIATURE_RAILWAY_INSET_END_NE,
    SPR_G2_MINIATURE_RAILWAY_INSET_END_SE,
    SPR_G2_MINIATURE_RAILWAY_INSET_END_NW,
    SPR_G2_MINIATURE_RAILWAY_INSET_END_SW,
    SPR_G2_MINIATURE_RAILWAY_INSET_END_SW_NE,
    SPR_G2_MINIATURE_RAILWAY_INSET_END_NW_SE,
    SPR_G2_MINIATURE_RAILWAY_END,

    SPR_G2_WOODEN_RC_BEGIN = SPR_G2_MINIATURE_RAILWAY_END,
    SPR_G2_WOODEN_RC_BOOSTER_SW_NE = SPR_G2_WOODEN_RC_BEGIN,
    SPR_G2_WOODEN_RC_BOOSTER_NW_SE,

    SPR_G2_WOODEN_RC_DIAG_BRAKES,

    SPR_G2_WOODEN_RC_STATION_BLOCK_BRAKE_OPEN_SW_NE = SPR_G2_WOODEN_RC_DIAG_BRAKES + 6,
    SPR_G2_WOODEN_RC_STATION_BLOCK_BRAKE_OPEN_NW_SE,
    SPR_G2_WOODEN_RC_STATION_BLOCK_BRAKE_CLOSED_SW_NE,
    SPR_G2_WOODEN_RC_STATION_BLOCK_BRAKE_CLOSED_NW_SE,

    SPR_RIDE_DESIGN_PREVIEW_CLASSIC_WOODEN_ROLLER_COASTER_TRACK,
    SPR_RIDE_DESIGN_PREVIEW_CLASSIC_WOODEN_ROLLER_COASTER_SUPPORTS,

    SPR_G2_WOODEN_RC_25_60_SWNE_CHAINED,
    SPR_G2_WOODEN_RC_25_60_SENW_CHAINED,
    SPR_G2_WOODEN_RC_25_60_SWNE_CHAINED_BACK,
    SPR_G2_WOODEN_RC_25_60_SENW_CHAINED_BACK,
    SPR_G2_WOODEN_RC_60_SWNE_CHAINED,
    SPR_G2_WOODEN_RC_60_SENW_CHAINED,
    SPR_G2_WOODEN_RC_60_SWNE_CHAINED_BACK,
    SPR_G2_WOODEN_RC_60_SENW_CHAINED_BACK,
    SPR_G2_WOODEN_RC_60_25_SWNE_CHAINED,
    SPR_G2_WOODEN_RC_60_25_SENW_CHAINED,
    SPR_G2_WOODEN_RC_60_25_SWNE_CHAINED_BACK,
    SPR_G2_WOODEN_RC_60_25_SENW_CHAINED_BACK,
    SPR_G2_WOODEN_RC_FLAT_TO_STEEP,
    SPR_G2_WOODEN_RC_FLAT_TO_STEEP_RAILS = SPR_G2_WOODEN_RC_FLAT_TO_STEEP + 32,
    SPR_G2_WOODEN_RC_FLAT_TO_STEEP_FRONT = SPR_G2_WOODEN_RC_FLAT_TO_STEEP_RAILS + 32,
    SPR_G2_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS = SPR_G2_WOODEN_RC_FLAT_TO_STEEP_FRONT + 16,
    SPR_G2_WOODEN_RC_MEDIUM_HALF_LOOP = SPR_G2_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 16,
    SPR_G2_WOODEN_RC_LARGE_HALF_LOOP = SPR_G2_WOODEN_RC_MEDIUM_HALF_LOOP + 48,
    SPR_G2_WOODEN_RC_END = SPR_G2_WOODEN_RC_LARGE_HALF_LOOP + 64,

    SPR_G2_BM_INVERT_RC_BEGIN = SPR_G2_WOODEN_RC_END,
    SPR_G2_BM_INVERT_BOOSTER_1 = SPR_G2_BM_INVERT_RC_BEGIN,
    SPR_G2_BM_INVERT_BOOSTER_2,
    SPR_G2_BM_INVERT_DIAG_BRAKES,
    SPR_G2_BM_INVERT_RC_END = SPR_G2_BM_INVERT_DIAG_BRAKES + 2,

    SPR_G2_LOOPING_RC_BEGIN = SPR_G2_BM_INVERT_RC_END,
    SPR_G2_LOOPING_DIAG_BRAKES = SPR_G2_LOOPING_RC_BEGIN,
    SPR_G2_LOOPING_RC_END = SPR_G2_LOOPING_DIAG_BRAKES + 4,

    SPR_G2_MINETRAIN_RC_BEGIN = SPR_G2_LOOPING_RC_END,
    SPR_G2_MINETRAIN_DIAG_BRAKES = SPR_G2_MINETRAIN_RC_BEGIN,
    SPR_G2_MINETRAIN_RC_FLAT_TO_STEEP = SPR_G2_MINETRAIN_DIAG_BRAKES + 6,
    SPR_G2_MINETRAIN_RC_END = SPR_G2_MINETRAIN_RC_FLAT_TO_STEEP + 32,

    SPR_G2_STANDUP_RC_BEGIN = SPR_G2_MINETRAIN_RC_END,
    SPR_G2_STANDUP_DIAG_BRAKES = SPR_G2_STANDUP_RC_BEGIN,
    SPR_G2_STANDUP_TRACK_25455 = SPR_G2_STANDUP_DIAG_BRAKES + 6,
    SPR_G2_STANDUP_TRACK_25457,
    SPR_G2_STANDUP_TRACK_25459,
    SPR_G2_STANDUP_TRACK_25461,
    SPR_G2_STANDUP_TRACK_25462,
    SPR_G2_STANDUP_TRACK_25463,
    SPR_G2_STANDUP_TRACK_25464,
    SPR_G2_STANDUP_TRACK_25466,
    SPR_G2_STANDUP_TRACK_25468,
    SPR_G2_STANDUP_TRACK_25470,
    SPR_G2_STANDUP_TRACK_25471,
    SPR_G2_STANDUP_TRACK_25472,
    SPR_G2_STANDUP_TRACK_25473,
    SPR_G2_STANDUP_TRACK_25521,
    SPR_G2_STANDUP_TRACK_25523,
    SPR_G2_STANDUP_TRACK_25526,
    SPR_G2_STANDUP_TRACK_25528,
    SPR_G2_STANDUP_TRACK_25530,
    SPR_G2_STANDUP_TRACK_25659,
    SPR_G2_STANDUP_TRACK_25661,
    SPR_G2_STANDUP_TRACK_25664,
    SPR_G2_STANDUP_TRACK_25665,
    SPR_G2_STANDUP_TRACK_25666,
    SPR_G2_STANDUP_TRACK_25668,
    SPR_G2_STANDUP_TRACK_25672,
    SPR_G2_STANDUP_TRACK_25673,
    SPR_G2_STANDUP_TRACK_25676,
    SPR_G2_STANDUP_TRACK_25677,
    SPR_G2_STANDUP_TRACK_25680,
    SPR_G2_STANDUP_TRACK_25684,
    SPR_G2_STANDUP_TRACK_25685,
    SPR_G2_STANDUP_TRACK_25686,
    SPR_G2_STANDUP_TRACK_25687,
    SPR_G2_STANDUP_TRACK_25689,
    SPR_G2_STANDUP_TRACK_25781,
    SPR_G2_STANDUP_TRACK_25783,
    SPR_G2_STANDUP_TRACK_25785,
    SPR_G2_STANDUP_TRACK_25787,
    SPR_G2_STANDUP_TRACK_25788,
    SPR_G2_STANDUP_TRACK_25792,
    SPR_G2_STANDUP_TRACK_25794,
    SPR_G2_STANDUP_TRACK_25796,
    SPR_G2_STANDUP_TRACK_25797,
    SPR_G2_STANDUP_TRACK_25798,
    SPR_G2_STANDUP_TRACK_25799,
    SPR_G2_STANDUP_TRACK_25803,
    SPR_G2_STANDUP_TRACK_25805,
    SPR_G2_STANDUP_TRACK_25807,
    SPR_G2_STANDUP_TRACK_25809,
    SPR_G2_STANDUP_TRACK_25810,
    SPR_G2_STANDUP_TRACK_25811,
    SPR_G2_STANDUP_TRACK_25812,
    SPR_G2_STANDUP_TRACK_25814,
    SPR_G2_STANDUP_TRACK_25816,
    SPR_G2_STANDUP_TRACK_25820,
    SPR_G2_STANDUP_TRACK_25821,
    SPR_G2_STANDUP_TRACK_25825,
    SPR_G2_STANDUP_TRACK_25827,
    SPR_G2_STANDUP_TRACK_25834,
    SPR_G2_STANDUP_TRACK_25835,
    SPR_G2_STANDUP_TRACK_25843,
    SPR_G2_STANDUP_TRACK_25844,
    SPR_G2_STANDUP_TRACK_SMALL_FLAT_TO_STEEP,
    SPR_G2_STANDUP_TRACK_FLAT_TO_STEEP = SPR_G2_STANDUP_TRACK_SMALL_FLAT_TO_STEEP + 20,
    SPR_G2_STANDUP_TRACK_VERTICAL = SPR_G2_STANDUP_TRACK_FLAT_TO_STEEP + 36,
    SPR_G2_STANDUP_TRACK_STEEP_SMALL_CURVE = SPR_G2_STANDUP_TRACK_VERTICAL + 12,
    SPR_G2_STANDUP_TRACK_VERTICAL_TWIST = SPR_G2_STANDUP_TRACK_STEEP_SMALL_CURVE + 16,
    SPR_G2_STANDUP_TRACK_SLOPE_BANK_TRANSITION = SPR_G2_STANDUP_TRACK_VERTICAL_TWIST + 12,
    SPR_G2_STANDUP_TRACK_GENTLE_SMALL_CURVE_BANKED = SPR_G2_STANDUP_TRACK_SLOPE_BANK_TRANSITION + 64,
    SPR_G2_STANDUP_TRACK_GENTLE_MEDIUM_CURVE_BANKED = SPR_G2_STANDUP_TRACK_GENTLE_SMALL_CURVE_BANKED + 20,
    SPR_G2_STANDUP_TRACK_GENTLE_LARGE_CURVE = SPR_G2_STANDUP_TRACK_GENTLE_MEDIUM_CURVE_BANKED + 40,
    SPR_G2_STANDUP_TRACK_GENTLE_LARGE_CURVE_BANKED = SPR_G2_STANDUP_TRACK_GENTLE_LARGE_CURVE + 64,
    SPR_G2_STANDUP_TRACK_TURN_BANK_TRANSITION = SPR_G2_STANDUP_TRACK_GENTLE_LARGE_CURVE_BANKED + 128,
    SPR_G2_STANDUP_TRACK_LARGE_CORKSCREW = SPR_G2_STANDUP_TRACK_TURN_BANK_TRANSITION + 28,
    SPR_G2_STANDUP_TRACK_QUARTER_LOOP = SPR_G2_STANDUP_TRACK_LARGE_CORKSCREW + 44,
    SPR_G2_STANDUP_TRACK_MEDIUM_HALF_LOOP = SPR_G2_STANDUP_TRACK_QUARTER_LOOP + 14,
    SPR_G2_STANDUP_TRACK_LARGE_HALF_LOOP = SPR_G2_STANDUP_TRACK_MEDIUM_HALF_LOOP + 50,
    SPR_G2_STANDUP_TRACK_BARREL_ROLL = SPR_G2_STANDUP_TRACK_LARGE_HALF_LOOP + 70,
    SPR_G2_STANDUP_TRACK_ZERO_G_ROLL = SPR_G2_STANDUP_TRACK_BARREL_ROLL + 36,
    SPR_G2_STANDUP_TRACK_LARGE_ZERO_G_ROLL = SPR_G2_STANDUP_TRACK_ZERO_G_ROLL + 36,
    SPR_G2_STANDUP_RC_END = SPR_G2_STANDUP_TRACK_LARGE_ZERO_G_ROLL + 42,

    SPR_G2_STEEPLECHASE_RC_BEGIN = SPR_G2_STANDUP_RC_END,
    SPR_G2_STEEPLECHASE_DIAG_BRAKES = SPR_G2_STEEPLECHASE_RC_BEGIN,
    SPR_G2_STEEPLECHASE_RC_END = SPR_G2_STEEPLECHASE_DIAG_BRAKES + 2,

    SPR_G2_MULTIDIM_RC_BEGIN = SPR_G2_STEEPLECHASE_RC_END,
    SPR_G2_MULTIDIM_UPRIGHT_DIAG_BRAKES = SPR_G2_MULTIDIM_RC_BEGIN,
    SPR_G2_MULTIDIM_INVERTED_DIAG_BRAKES = SPR_G2_MULTIDIM_UPRIGHT_DIAG_BRAKES + 6,
    SPR_G2_MULTIDIM_RC_END = SPR_G2_MULTIDIM_INVERTED_DIAG_BRAKES + 5,

    SPR_G2_SLC_RC_BEGIN = SPR_G2_MULTIDIM_RC_END,
    SPR_G2_SLC_DIAG_BRAKES = SPR_G2_SLC_RC_BEGIN,
    SPR_G2_SLC_RC_END = SPR_G2_SLC_DIAG_BRAKES + 3,

    SPR_G2_CORKSCREW_RC_BEGIN = SPR_G2_SLC_RC_END,
    SPR_G2_CORKSCREW_DIAG_BRAKES = SPR_G2_CORKSCREW_RC_BEGIN,
    SPR_G2_CORKSCREW_TRACK_SMALL_FLAT_TO_STEEP = SPR_G2_CORKSCREW_DIAG_BRAKES + 6,
    SPR_G2_CORKSCREW_TRACK_VERTICAL = SPR_G2_CORKSCREW_TRACK_SMALL_FLAT_TO_STEEP + 20,
    SPR_G2_CORKSCREW_TRACK_VERTICAL_TWIST = SPR_G2_CORKSCREW_TRACK_VERTICAL + 8,
    SPR_G2_CORKSCREW_TRACK_SLOPE_BANK_TRANSITION = SPR_G2_CORKSCREW_TRACK_VERTICAL_TWIST + 12,
    SPR_G2_CORKSCREW_TRACK_GENTLE_SMALL_CURVE_BANKED = SPR_G2_CORKSCREW_TRACK_SLOPE_BANK_TRANSITION + 64,
    SPR_G2_CORKSCREW_TRACK_GENTLE_MEDIUM_CURVE_BANKED = SPR_G2_CORKSCREW_TRACK_GENTLE_SMALL_CURVE_BANKED + 18,
    SPR_G2_CORKSCREW_TRACK_GENTLE_LARGE_CURVE = SPR_G2_CORKSCREW_TRACK_GENTLE_MEDIUM_CURVE_BANKED + 40,
    SPR_G2_CORKSCREW_TRACK_GENTLE_LARGE_CURVE_BANKED = SPR_G2_CORKSCREW_TRACK_GENTLE_LARGE_CURVE + 64,
    SPR_G2_CORKSCREW_TRACK_TURN_BANK_TRANSITION = SPR_G2_CORKSCREW_TRACK_GENTLE_LARGE_CURVE_BANKED + 128,
    SPR_G2_CORKSCREW_TRACK_LARGE_CORKSCREW = SPR_G2_CORKSCREW_TRACK_TURN_BANK_TRANSITION + 22,
    SPR_G2_CORKSCREW_TRACK_QUARTER_LOOP = SPR_G2_CORKSCREW_TRACK_LARGE_CORKSCREW + 42,
    SPR_G2_CORKSCREW_TRACK_MEDIUM_HALF_LOOP = SPR_G2_CORKSCREW_TRACK_QUARTER_LOOP + 14,
    SPR_G2_CORKSCREW_TRACK_LARGE_HALF_LOOP = SPR_G2_CORKSCREW_TRACK_MEDIUM_HALF_LOOP + 48,
    SPR_G2_CORKSCREW_TRACK_BARREL_ROLL = SPR_G2_CORKSCREW_TRACK_LARGE_HALF_LOOP + 64,
    SPR_G2_CORKSCREW_TRACK_ZERO_G_ROLL = SPR_G2_CORKSCREW_TRACK_BARREL_ROLL + 48,
    SPR_G2_CORKSCREW_TRACK_LARGE_ZERO_G_ROLL = SPR_G2_CORKSCREW_TRACK_ZERO_G_ROLL + 40,
    SPR_G2_CORKSCREW_TRACK_FLAT_TO_STEEP_DIAGONAL = SPR_G2_CORKSCREW_TRACK_LARGE_ZERO_G_ROLL + 58,
    SPR_G2_CORKSCREW_TRACK_DIVE_LOOP = SPR_G2_CORKSCREW_TRACK_FLAT_TO_STEEP_DIAGONAL + 24,
    SPR_G2_CORKSCREW_RC_END = SPR_G2_CORKSCREW_TRACK_DIVE_LOOP + 32,

    SPR_G2_LIM_LAUNCHED_TRACK_BEGIN = SPR_G2_CORKSCREW_RC_END,
    SPR_G2_LIM_LAUNCHED_TRACK_BARREL_ROLL = SPR_G2_LIM_LAUNCHED_TRACK_BEGIN + 0,
    SPR_G2_LIM_LAUNCHED_TRACK_HALF_LOOP = SPR_G2_LIM_LAUNCHED_TRACK_BARREL_ROLL + 48,
    SPR_G2_LIM_LAUNCHED_TRACK_FLAT_TO_STEEP = SPR_G2_LIM_LAUNCHED_TRACK_HALF_LOOP + 16,
    SPR_G2_LIM_LAUNCHED_TRACK_LARGE_CORKSCREW = SPR_G2_LIM_LAUNCHED_TRACK_FLAT_TO_STEEP + 32,
    SPR_G2_LIM_LAUNCHED_TRACK_TURN_BANK_TRANSITION = SPR_G2_LIM_LAUNCHED_TRACK_LARGE_CORKSCREW + 40,
    SPR_G2_LIM_LAUNCHED_TRACK_MEDIUM_HALF_LOOP = SPR_G2_LIM_LAUNCHED_TRACK_TURN_BANK_TRANSITION + 18,
    SPR_G2_LIM_LAUNCHED_TRACK_LARGE_HALF_LOOP = SPR_G2_LIM_LAUNCHED_TRACK_MEDIUM_HALF_LOOP + 40,
    SPR_G2_LIM_LAUNCHED_TRACK_ZERO_G_ROLL = SPR_G2_LIM_LAUNCHED_TRACK_LARGE_HALF_LOOP + 56,
    SPR_G2_LIM_LAUNCHED_TRACK_LARGE_ZERO_G_ROLL = SPR_G2_LIM_LAUNCHED_TRACK_ZERO_G_ROLL + 32,
    SPR_G2_LIM_LAUNCHED_TRACK_SMALL_FLAT_TO_STEEP = SPR_G2_LIM_LAUNCHED_TRACK_LARGE_ZERO_G_ROLL + 40,
    SPR_G2_LIM_LAUNCHED_TRACK_END = SPR_G2_LIM_LAUNCHED_TRACK_SMALL_FLAT_TO_STEEP + 20,

    SPR_G2_FLUME_25_60_NE_SW = SPR_G2_LIM_LAUNCHED_TRACK_END,
    SPR_G2_FLUME_25_60_NW_SE,
    SPR_G2_FLUME_25_60_NE_SW_BACK_WATER,
    SPR_G2_FLUME_25_60_NE_SW_BACK,
    SPR_G2_FLUME_25_60_NW_SE_BACK_WATER,
    SPR_G2_FLUME_25_60_NW_SE_BACK,
    SPR_G2_FLUME_60_NE_SW,
    SPR_G2_FLUME_60_NW_SE,
    SPR_G2_FLUME_60_NE_SW_BACK,
    SPR_G2_FLUME_60_NW_SE_BACK,
    SPR_G2_FLUME_60_25_NE_SW,
    SPR_G2_FLUME_60_25_NW_SE,
    SPR_G2_FLUME_60_25_NE_SW_BACK_WATER,
    SPR_G2_FLUME_60_25_NE_SW_BACK,
    SPR_G2_FLUME_60_25_NW_SE_BACK_WATER,
    SPR_G2_FLUME_60_25_NW_SE_BACK,

    SPR_G2_BOAT_HIRE_BEGIN,
    SPR_G2_BOAT_HIRE_TRACK_SMALL_CURVE = SPR_G2_BOAT_HIRE_BEGIN,
    SPR_G2_BOAT_HIRE_TRACK_MEDIUM_CURVE = SPR_G2_BOAT_HIRE_TRACK_SMALL_CURVE + 24,
    SPR_G2_BOAT_HIRE_TRACK_LARGE_CURVE = SPR_G2_BOAT_HIRE_TRACK_MEDIUM_CURVE + 40,
    SPR_G2_BOAT_HIRE_TRACK_FLAT_DIAGONAL = SPR_G2_BOAT_HIRE_TRACK_LARGE_CURVE + 68,
    SPR_G2_BOAT_HIRE_TRACK_S_BEND = SPR_G2_BOAT_HIRE_TRACK_FLAT_DIAGONAL + 3,
    SPR_G2_BOAT_HIRE_END = SPR_G2_BOAT_HIRE_TRACK_S_BEND + 32,

    SPR_G2_MINE_RIDE_BEGIN = SPR_G2_BOAT_HIRE_END,
    SPR_G2_MINE_RIDE_TRACK_19471 = SPR_G2_MINE_RIDE_BEGIN,
    SPR_G2_MINE_RIDE_END = SPR_G2_MINE_RIDE_TRACK_19471 + 1,

    // G2 Supports

    SPR_G2_SUPPORT_WOODEN_TRUSS = SPR_G2_MINE_RIDE_END,
    SPR_G2_SUPPORT_WOODEN_MINE = SPR_G2_SUPPORT_WOODEN_TRUSS + 32,
    SPR_G2_SUPPORT_END = SPR_G2_SUPPORT_WOODEN_MINE + 32,

    // G2 New track types

    SPR_RIDE_DESIGN_PREVIEW_HYBRID_COASTER_TRACK = SPR_G2_SUPPORT_END,
    SPR_RIDE_DESIGN_PREVIEW_HYBRID_COASTER_SUPPORTS = SPR_RIDE_DESIGN_PREVIEW_HYBRID_COASTER_TRACK + 1,
    SPR_G2_HYBRID_BEGIN = SPR_RIDE_DESIGN_PREVIEW_HYBRID_COASTER_TRACK + 2,
    SPR_G2_HYBRID_TRACK_FLAT = SPR_G2_HYBRID_BEGIN,
    SPR_G2_HYBRID_TRACK_BRAKE = SPR_G2_HYBRID_TRACK_FLAT + 2,
    SPR_G2_HYBRID_TRACK_BLOCK_BRAKE = SPR_G2_HYBRID_TRACK_BRAKE + 2,
    SPR_G2_HYBRID_TRACK_BOOSTER = SPR_G2_HYBRID_TRACK_BLOCK_BRAKE + 2,
    SPR_G2_HYBRID_TRACK_GENTLE = SPR_G2_HYBRID_TRACK_BOOSTER + 2,
    SPR_G2_HYBRID_TRACK_STEEP = SPR_G2_HYBRID_TRACK_GENTLE + 12,
    SPR_G2_HYBRID_TRACK_VERTICAL = SPR_G2_HYBRID_TRACK_STEEP + 16,
    SPR_G2_HYBRID_TRACK_SMALL_CURVE = SPR_G2_HYBRID_TRACK_VERTICAL + 12,
    SPR_G2_HYBRID_TRACK_MEDIUM_CURVE = SPR_G2_HYBRID_TRACK_SMALL_CURVE + 12,
    SPR_G2_HYBRID_TRACK_LARGE_CURVE = SPR_G2_HYBRID_TRACK_MEDIUM_CURVE + 20,
    SPR_G2_HYBRID_TRACK_FLAT_DIAGONAL = SPR_G2_HYBRID_TRACK_LARGE_CURVE + 32,
    SPR_G2_HYBRID_TRACK_BRAKE_DIAGONAL = SPR_G2_HYBRID_TRACK_FLAT_DIAGONAL + 2,
    SPR_G2_HYBRID_TRACK_BLOCK_BRAKE_DIAGONAL = SPR_G2_HYBRID_TRACK_BRAKE_DIAGONAL + 2,
    SPR_G2_HYBRID_TRACK_GENTLE_DIAGONAL = SPR_G2_HYBRID_TRACK_BLOCK_BRAKE_DIAGONAL + 2,
    SPR_G2_HYBRID_TRACK_STEEP_DIAGONAL = SPR_G2_HYBRID_TRACK_GENTLE_DIAGONAL + 12,
    SPR_G2_HYBRID_TRACK_BANK_TRANSITION = SPR_G2_HYBRID_TRACK_STEEP_DIAGONAL + 12,
    SPR_G2_HYBRID_TRACK_BANK_TRANSITION_DIAGONAL = SPR_G2_HYBRID_TRACK_BANK_TRANSITION + 42,
    SPR_G2_HYBRID_TRACK_SMALL_CURVE_BANKED = SPR_G2_HYBRID_TRACK_BANK_TRANSITION_DIAGONAL + 35,
    SPR_G2_HYBRID_TRACK_MEDIUM_CURVE_BANKED = SPR_G2_HYBRID_TRACK_SMALL_CURVE_BANKED + 16,
    SPR_G2_HYBRID_TRACK_LARGE_CURVE_BANKED = SPR_G2_HYBRID_TRACK_MEDIUM_CURVE_BANKED + 25,
    SPR_G2_HYBRID_TRACK_GENTLE_SMALL_CURVE = SPR_G2_HYBRID_TRACK_LARGE_CURVE_BANKED + 40,
    SPR_G2_HYBRID_TRACK_GENTLE_MEDIUM_CURVE = SPR_G2_HYBRID_TRACK_GENTLE_SMALL_CURVE + 16,
    SPR_G2_HYBRID_TRACK_STEEP_SMALL_CURVE = SPR_G2_HYBRID_TRACK_GENTLE_MEDIUM_CURVE + 40,
    SPR_G2_HYBRID_TRACK_VERTICAL_TWIST = SPR_G2_HYBRID_TRACK_STEEP_SMALL_CURVE + 16,
    SPR_G2_HYBRID_TRACK_SLOPE_BANK_TRANSITION = SPR_G2_HYBRID_TRACK_VERTICAL_TWIST + 12,
    SPR_G2_HYBRID_TRACK_GENTLE_SMALL_CURVE_BANKED = SPR_G2_HYBRID_TRACK_SLOPE_BANK_TRANSITION + 72,
    SPR_G2_HYBRID_TRACK_GENTLE_MEDIUM_CURVE_BANKED = SPR_G2_HYBRID_TRACK_GENTLE_SMALL_CURVE_BANKED + 22,
    SPR_G2_HYBRID_TRACK_S_BEND = SPR_G2_HYBRID_TRACK_GENTLE_MEDIUM_CURVE_BANKED + 52,
    SPR_G2_HYBRID_TRACK_SMALL_HELIX = SPR_G2_HYBRID_TRACK_S_BEND + 16,
    SPR_G2_HYBRID_TRACK_LARGE_HELIX = SPR_G2_HYBRID_TRACK_SMALL_HELIX + 32,
    SPR_G2_HYBRID_TRACK_BARREL_ROLL = SPR_G2_HYBRID_TRACK_LARGE_HELIX + 50,
    SPR_G2_HYBRID_TRACK_FLAT_TO_STEEP = SPR_G2_HYBRID_TRACK_BARREL_ROLL + 48,
    SPR_G2_HYBRID_TRACK_QUARTER_LOOP = SPR_G2_HYBRID_TRACK_FLAT_TO_STEEP + 32,
    SPR_G2_HYBRID_TRACK_TURN_BANK_TRANSITION = SPR_G2_HYBRID_TRACK_QUARTER_LOOP + 24,
    SPR_G2_HYBRID_TRACK_POWERED_LIFT = SPR_G2_HYBRID_TRACK_TURN_BANK_TRANSITION + 18,
    SPR_G2_HYBRID_TRACK_ZERO_G_ROLL = SPR_G2_HYBRID_TRACK_POWERED_LIFT + 4,
    SPR_G2_HYBRID_TRACK_LARGE_ZERO_G_ROLL = SPR_G2_HYBRID_TRACK_ZERO_G_ROLL + 40,
    SPR_G2_HYBRID_TRACK_GENTLE_LARGE_CURVE = SPR_G2_HYBRID_TRACK_LARGE_ZERO_G_ROLL + 58,
    SPR_G2_HYBRID_TRACK_GENTLE_LARGE_CURVE_BANKED = SPR_G2_HYBRID_TRACK_GENTLE_LARGE_CURVE + 64,
    SPR_G2_HYBRID_LIFT_BEGIN = SPR_G2_HYBRID_TRACK_GENTLE_LARGE_CURVE_BANKED + 142,
    SPR_G2_HYBRID_LIFT_TRACK_FLAT = SPR_G2_HYBRID_LIFT_BEGIN,
    SPR_G2_HYBRID_LIFT_TRACK_GENTLE = SPR_G2_HYBRID_LIFT_TRACK_FLAT + 4,
    SPR_G2_HYBRID_LIFT_TRACK_STEEP = SPR_G2_HYBRID_LIFT_TRACK_GENTLE + 12,
    SPR_G2_HYBRID_LIFT_TRACK_FLAT_DIAGONAL = SPR_G2_HYBRID_LIFT_TRACK_STEEP + 16,
    SPR_G2_HYBRID_LIFT_TRACK_GENTLE_DIAGONAL = SPR_G2_HYBRID_LIFT_TRACK_FLAT_DIAGONAL + 4,
    SPR_G2_HYBRID_LIFT_TRACK_STEEP_DIAGONAL = SPR_G2_HYBRID_LIFT_TRACK_GENTLE_DIAGONAL + 12,
    SPR_G2_HYBRID_END = SPR_G2_HYBRID_LIFT_TRACK_STEEP_DIAGONAL + 12,

    SPR_RIDE_DESIGN_PREVIEW_SINGLE_RAIL_ROLLER_COASTER_TRACK = SPR_G2_HYBRID_END,
    SPR_RIDE_DESIGN_PREVIEW_SINGLE_RAIL_ROLLER_COASTER_SUPPORTS = SPR_RIDE_DESIGN_PREVIEW_SINGLE_RAIL_ROLLER_COASTER_TRACK + 1,
    SPR_G2_SINGLE_RAIL_BEGIN = SPR_RIDE_DESIGN_PREVIEW_SINGLE_RAIL_ROLLER_COASTER_TRACK + 2,
    SPR_G2_SINGLE_RAIL_TRACK_FLAT = SPR_G2_SINGLE_RAIL_BEGIN,
    SPR_G2_SINGLE_RAIL_TRACK_BRAKE = SPR_G2_SINGLE_RAIL_TRACK_FLAT + 2,
    SPR_G2_SINGLE_RAIL_TRACK_BLOCK_BRAKE = SPR_G2_SINGLE_RAIL_TRACK_BRAKE + 2,
    SPR_G2_SINGLE_RAIL_TRACK_GENTLE = SPR_G2_SINGLE_RAIL_TRACK_BLOCK_BRAKE + 2,
    SPR_G2_SINGLE_RAIL_TRACK_STEEP = SPR_G2_SINGLE_RAIL_TRACK_GENTLE + 12,
    SPR_G2_SINGLE_RAIL_TRACK_VERTICAL = SPR_G2_SINGLE_RAIL_TRACK_STEEP + 16,
    SPR_G2_SINGLE_RAIL_TRACK_SMALL_CURVE = SPR_G2_SINGLE_RAIL_TRACK_VERTICAL + 12,
    SPR_G2_SINGLE_RAIL_TRACK_MEDIUM_CURVE = SPR_G2_SINGLE_RAIL_TRACK_SMALL_CURVE + 12,
    SPR_G2_SINGLE_RAIL_TRACK_LARGE_CURVE = SPR_G2_SINGLE_RAIL_TRACK_MEDIUM_CURVE + 20,
    SPR_G2_SINGLE_RAIL_TRACK_FLAT_DIAGONAL = SPR_G2_SINGLE_RAIL_TRACK_LARGE_CURVE + 32,
    SPR_G2_SINGLE_RAIL_TRACK_BRAKE_DIAGONAL = SPR_G2_SINGLE_RAIL_TRACK_FLAT_DIAGONAL + 2,
    SPR_G2_SINGLE_RAIL_TRACK_BLOCK_BRAKE_DIAGONAL = SPR_G2_SINGLE_RAIL_TRACK_BRAKE_DIAGONAL + 2,
    SPR_G2_SINGLE_RAIL_TRACK_GENTLE_DIAGONAL = SPR_G2_SINGLE_RAIL_TRACK_BLOCK_BRAKE_DIAGONAL + 2,
    SPR_G2_SINGLE_RAIL_TRACK_STEEP_DIAGONAL = SPR_G2_SINGLE_RAIL_TRACK_GENTLE_DIAGONAL + 12,
    SPR_G2_SINGLE_RAIL_TRACK_BANK_TRANSITION = SPR_G2_SINGLE_RAIL_TRACK_STEEP_DIAGONAL + 12,
    SPR_G2_SINGLE_RAIL_TRACK_BANK_TRANSITION_DIAGONAL = SPR_G2_SINGLE_RAIL_TRACK_BANK_TRANSITION + 40,
    SPR_G2_SINGLE_RAIL_TRACK_SMALL_CURVE_BANKED = SPR_G2_SINGLE_RAIL_TRACK_BANK_TRANSITION_DIAGONAL + 34,
    SPR_G2_SINGLE_RAIL_TRACK_MEDIUM_CURVE_BANKED = SPR_G2_SINGLE_RAIL_TRACK_SMALL_CURVE_BANKED + 14,
    SPR_G2_SINGLE_RAIL_TRACK_LARGE_CURVE_BANKED = SPR_G2_SINGLE_RAIL_TRACK_MEDIUM_CURVE_BANKED + 22,
    SPR_G2_SINGLE_RAIL_TRACK_GENTLE_SMALL_CURVE = SPR_G2_SINGLE_RAIL_TRACK_LARGE_CURVE_BANKED + 32,
    SPR_G2_SINGLE_RAIL_TRACK_GENTLE_MEDIUM_CURVE = SPR_G2_SINGLE_RAIL_TRACK_GENTLE_SMALL_CURVE + 16,
    SPR_G2_SINGLE_RAIL_TRACK_STEEP_SMALL_CURVE = SPR_G2_SINGLE_RAIL_TRACK_GENTLE_MEDIUM_CURVE + 40,
    SPR_G2_SINGLE_RAIL_TRACK_VERTICAL_TWIST = SPR_G2_SINGLE_RAIL_TRACK_STEEP_SMALL_CURVE + 16,
    SPR_G2_SINGLE_RAIL_TRACK_SLOPE_BANK_TRANSITION = SPR_G2_SINGLE_RAIL_TRACK_VERTICAL_TWIST + 12,
    SPR_G2_SINGLE_RAIL_TRACK_GENTLE_SMALL_CURVE_BANKED = SPR_G2_SINGLE_RAIL_TRACK_SLOPE_BANK_TRANSITION + 64,
    SPR_G2_SINGLE_RAIL_TRACK_GENTLE_MEDIUM_CURVE_BANKED = SPR_G2_SINGLE_RAIL_TRACK_GENTLE_SMALL_CURVE_BANKED + 16,
    SPR_G2_SINGLE_RAIL_TRACK_S_BEND = SPR_G2_SINGLE_RAIL_TRACK_GENTLE_MEDIUM_CURVE_BANKED + 40,
    SPR_G2_SINGLE_RAIL_TRACK_SMALL_HELIX = SPR_G2_SINGLE_RAIL_TRACK_S_BEND + 16,
    SPR_G2_SINGLE_RAIL_TRACK_LARGE_HELIX = SPR_G2_SINGLE_RAIL_TRACK_SMALL_HELIX + 28,
    SPR_G2_SINGLE_RAIL_TRACK_BARREL_ROLL = SPR_G2_SINGLE_RAIL_TRACK_LARGE_HELIX + 44,
    SPR_G2_SINGLE_RAIL_TRACK_HALF_LOOP = SPR_G2_SINGLE_RAIL_TRACK_BARREL_ROLL + 48,
    SPR_G2_SINGLE_RAIL_TRACK_FLAT_TO_STEEP = SPR_G2_SINGLE_RAIL_TRACK_HALF_LOOP + 16,
    SPR_G2_SINGLE_RAIL_TRACK_QUARTER_LOOP = SPR_G2_SINGLE_RAIL_TRACK_FLAT_TO_STEEP + 32,
    SPR_G2_SINGLE_RAIL_TRACK_CORKSCREW = SPR_G2_SINGLE_RAIL_TRACK_QUARTER_LOOP + 12,
    SPR_G2_SINGLE_RAIL_TRACK_LARGE_CORKSCREW = SPR_G2_SINGLE_RAIL_TRACK_CORKSCREW + 24,
    SPR_G2_SINGLE_RAIL_TRACK_TURN_BANK_TRANSITION = SPR_G2_SINGLE_RAIL_TRACK_LARGE_CORKSCREW + 40,
    SPR_G2_SINGLE_RAIL_TRACK_MEDIUM_HALF_LOOP = SPR_G2_SINGLE_RAIL_TRACK_TURN_BANK_TRANSITION + 18,
    SPR_G2_SINGLE_RAIL_TRACK_LARGE_HALF_LOOP = SPR_G2_SINGLE_RAIL_TRACK_MEDIUM_HALF_LOOP + 40,
    SPR_G2_SINGLE_RAIL_TRACK_ZERO_G_ROLL = SPR_G2_SINGLE_RAIL_TRACK_LARGE_HALF_LOOP + 56,
    SPR_G2_SINGLE_RAIL_TRACK_LARGE_ZERO_G_ROLL = SPR_G2_SINGLE_RAIL_TRACK_ZERO_G_ROLL + 32,
    SPR_G2_SINGLE_RAIL_TRACK_SMALL_FLAT_TO_STEEP = SPR_G2_SINGLE_RAIL_TRACK_LARGE_ZERO_G_ROLL + 40,
    SPR_G2_SINGLE_RAIL_TRACK_GENTLE_LARGE_CURVE = SPR_G2_SINGLE_RAIL_TRACK_SMALL_FLAT_TO_STEEP + 20,
    SPR_G2_SINGLE_RAIL_TRACK_GENTLE_LARGE_CURVE_BANKED = SPR_G2_SINGLE_RAIL_TRACK_GENTLE_LARGE_CURVE + 64,
    SPR_G2_SINGLE_RAIL_TRACK_FLAT_TO_STEEP_DIAGONAL = SPR_G2_SINGLE_RAIL_TRACK_GENTLE_LARGE_CURVE_BANKED + 128,
    SPR_G2_SINGLE_RAIL_TRACK_DIVE_LOOP = SPR_G2_SINGLE_RAIL_TRACK_FLAT_TO_STEEP_DIAGONAL + 24,
    SPR_G2_SINGLE_RAIL_LIFT_BEGIN = SPR_G2_SINGLE_RAIL_TRACK_DIVE_LOOP + 32,
    SPR_G2_SINGLE_RAIL_LIFT_TRACK_FLAT = SPR_G2_SINGLE_RAIL_LIFT_BEGIN,
    SPR_G2_SINGLE_RAIL_LIFT_TRACK_GENTLE = SPR_G2_SINGLE_RAIL_LIFT_TRACK_FLAT + 4,
    SPR_G2_SINGLE_RAIL_LIFT_TRACK_STEEP = SPR_G2_SINGLE_RAIL_LIFT_TRACK_GENTLE + 12,
    SPR_G2_SINGLE_RAIL_LIFT_TRACK_FLAT_DIAGONAL = SPR_G2_SINGLE_RAIL_LIFT_TRACK_STEEP + 16,
    SPR_G2_SINGLE_RAIL_LIFT_TRACK_GENTLE_DIAGONAL = SPR_G2_SINGLE_RAIL_LIFT_TRACK_FLAT_DIAGONAL + 4,
    SPR_G2_SINGLE_RAIL_LIFT_TRACK_STEEP_DIAGONAL = SPR_G2_SINGLE_RAIL_LIFT_TRACK_GENTLE_DIAGONAL + 12,
    SPR_G2_SINGLE_RAIL_LIFT_TRACK_SMALL_FLAT_TO_STEEP = SPR_G2_SINGLE_RAIL_LIFT_TRACK_STEEP_DIAGONAL + 12,
    SPR_G2_SINGLE_RAIL_END = SPR_G2_SINGLE_RAIL_LIFT_TRACK_SMALL_FLAT_TO_STEEP + 20,

    SPR_RIDE_DESIGN_PREVIEW_ALPINE_COASTER_TRACK = SPR_G2_SINGLE_RAIL_END,
    SPR_RIDE_DESIGN_PREVIEW_ALPINE_COASTER_SUPPORTS = SPR_RIDE_DESIGN_PREVIEW_ALPINE_COASTER_TRACK + 1,
    SPR_G2_ALPINE_BEGIN = SPR_RIDE_DESIGN_PREVIEW_ALPINE_COASTER_TRACK + 2,
    SPR_G2_ALPINE_TRACK_FLAT = SPR_G2_ALPINE_BEGIN,
    SPR_G2_ALPINE_TRACK_GENTLE = SPR_G2_ALPINE_TRACK_FLAT + 2,
    SPR_G2_ALPINE_TRACK_SMALL_CURVE = SPR_G2_ALPINE_TRACK_GENTLE + 12,
    SPR_G2_ALPINE_TRACK_MEDIUM_CURVE = SPR_G2_ALPINE_TRACK_SMALL_CURVE + 12,
    SPR_G2_ALPINE_TRACK_LARGE_CURVE = SPR_G2_ALPINE_TRACK_MEDIUM_CURVE + 20,
    SPR_G2_ALPINE_TRACK_FLAT_DIAGONAL = SPR_G2_ALPINE_TRACK_LARGE_CURVE + 32,
    SPR_G2_ALPINE_TRACK_GENTLE_DIAGONAL = SPR_G2_ALPINE_TRACK_FLAT_DIAGONAL + 4,
    SPR_G2_ALPINE_TRACK_BANK_TRANSITION = SPR_G2_ALPINE_TRACK_GENTLE_DIAGONAL + 12,
    SPR_G2_ALPINE_TRACK_BANK_TRANSITION_DIAGONAL = SPR_G2_ALPINE_TRACK_BANK_TRANSITION + 40,
    SPR_G2_ALPINE_TRACK_SMALL_CURVE_BANKED = SPR_G2_ALPINE_TRACK_BANK_TRANSITION_DIAGONAL + 34,
    SPR_G2_ALPINE_TRACK_MEDIUM_CURVE_BANKED = SPR_G2_ALPINE_TRACK_SMALL_CURVE_BANKED + 14,
    SPR_G2_ALPINE_TRACK_LARGE_CURVE_BANKED = SPR_G2_ALPINE_TRACK_MEDIUM_CURVE_BANKED + 22,
    SPR_G2_ALPINE_TRACK_GENTLE_SMALL_CURVE = SPR_G2_ALPINE_TRACK_LARGE_CURVE_BANKED + 32,
    SPR_G2_ALPINE_TRACK_GENTLE_MEDIUM_CURVE = SPR_G2_ALPINE_TRACK_GENTLE_SMALL_CURVE + 16,
    SPR_G2_ALPINE_TRACK_S_BEND = SPR_G2_ALPINE_TRACK_GENTLE_MEDIUM_CURVE + 40,
    SPR_G2_ALPINE_TRACK_SMALL_HELIX = SPR_G2_ALPINE_TRACK_S_BEND + 16,
    SPR_G2_ALPINE_TRACK_LARGE_HELIX = SPR_G2_ALPINE_TRACK_SMALL_HELIX + 28,
    SPR_G2_ALPINE_TRACK_TURN_BANK_TRANSITION = SPR_G2_ALPINE_TRACK_LARGE_HELIX + 44,
    SPR_G2_ALPINE_LIFT_BEGIN = SPR_G2_ALPINE_TRACK_TURN_BANK_TRANSITION + 18,
    SPR_G2_ALPINE_LIFT_TRACK_FLAT = SPR_G2_ALPINE_LIFT_BEGIN,
    SPR_G2_ALPINE_LIFT_TRACK_GENTLE = SPR_G2_ALPINE_LIFT_TRACK_FLAT + 4,
    SPR_G2_ALPINE_LIFT_TRACK_FLAT_DIAGONAL = SPR_G2_ALPINE_LIFT_TRACK_GENTLE + 12,
    SPR_G2_ALPINE_LIFT_TRACK_GENTLE_DIAGONAL = SPR_G2_ALPINE_LIFT_TRACK_FLAT_DIAGONAL + 4,
    SPR_G2_ALPINE_END = SPR_G2_ALPINE_LIFT_TRACK_GENTLE_DIAGONAL + 12,

    SPR_G2_ICON_MEDIUM_CURVE_LEFT = SPR_G2_ALPINE_END,
    SPR_G2_ICON_MEDIUM_CURVE_RIGHT,

    SPR_G2_HYBRID_GENTLE_BRAKE,
    SPR_G2_SINGLE_RAIL_GENTLE_BRAKE = SPR_G2_HYBRID_GENTLE_BRAKE + 4,
    SPR_G2_CORKSCREW_BOOSTER_NE_SW_1 = SPR_G2_SINGLE_RAIL_GENTLE_BRAKE + 4,
    SPR_G2_CORKSCREW_BOOSTER_NW_SE_1,
    SPR_G2_CORKSCREW_BOOSTER_NE_SW_2,
    SPR_G2_CORKSCREW_BOOSTER_NW_SE_2,
    SPR_G2_OPAQUE_WATER_OVERLAY,
    SPR_G2_HYBRID_GENTLE_DIAG_BRAKE = SPR_G2_OPAQUE_WATER_OVERLAY + 5,
    SPR_G2_SINGLE_RAIL_GENTLE_DIAG_BRAKE = SPR_G2_HYBRID_GENTLE_DIAG_BRAKE + 4,
    SPR_G2_ICON_ROTATE_ANTI_CLOCKWISE = SPR_G2_SINGLE_RAIL_GENTLE_DIAG_BRAKE + 4,

    SPR_G2_END,

    SPR_CSG_BEGIN = SPR_G2_END,
    SPR_CSG_END = SPR_CSG_BEGIN + OpenRCT2::RCT1::Limits::kNumLLCsgEntries,

    G2_SPRITE_COUNT = SPR_G2_END - SPR_G2_BEGIN,

    SPR_SCROLLING_TEXT_START = SPR_CSG_END,
    SPR_SCROLLING_TEXT_END = SPR_SCROLLING_TEXT_START + OpenRCT2::kMaxScrollingTextEntries,

    SPR_IMAGE_LIST_LENGTH = 1000000,
    SPR_IMAGE_LIST_BEGIN = SPR_SCROLLING_TEXT_END,
    SPR_IMAGE_LIST_END = SPR_IMAGE_LIST_BEGIN + SPR_IMAGE_LIST_LENGTH,
};
