/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.jar.Manifest;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;

@Command(common=true, usage="usage_DisplayTheVersionOfJgit")
class Version
extends TextBuiltin {
    Version() {
    }

    protected void run() throws Exception {
        String version = this.getImplementationVersion();
        if (version == null) {
            version = this.getBundleVersion();
        }
        if (version == null) {
            throw Version.die(CLIText.get().cannotReadPackageInformation);
        }
        this.outw.println(MessageFormat.format(CLIText.get().jgitVersion, version));
    }

    protected final boolean requiresRepository() {
        return false;
    }

    private String getImplementationVersion() {
        Package pkg = this.getClass().getPackage();
        return pkg == null ? null : pkg.getImplementationVersion();
    }

    private String getBundleVersion() {
        URL url;
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl instanceof URLClassLoader && (url = ((URLClassLoader)cl).findResource("META-INF/MANIFEST.MF")) != null) {
            return Version.getBundleVersion(url);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBundleVersion(URL url) {
        String string;
        InputStream is = url.openStream();
        try {
            Manifest manifest = new Manifest(is);
            string = manifest.getMainAttributes().getValue("Bundle-Version");
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        is.close();
        return string;
    }
}

