/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.console.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import scala.tools.jline.console.completer.Completer;
import scala.tools.jline.internal.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentCompleter
implements Completer {
    private final ArgumentDelimiter delimiter;
    private final List<Completer> completers = new ArrayList<Completer>();
    private boolean strict = true;

    public ArgumentCompleter(ArgumentDelimiter argumentDelimiter, Collection<Completer> collection) {
        assert (argumentDelimiter != null);
        this.delimiter = argumentDelimiter;
        assert (collection != null);
        this.completers.addAll(collection);
    }

    public ArgumentCompleter(ArgumentDelimiter argumentDelimiter, Completer ... completerArray) {
        this(argumentDelimiter, Arrays.asList(completerArray));
    }

    public ArgumentCompleter(Completer ... completerArray) {
        this((ArgumentDelimiter)new WhitespaceArgumentDelimiter(), completerArray);
    }

    public ArgumentCompleter(List<Completer> list) {
        this((ArgumentDelimiter)new WhitespaceArgumentDelimiter(), list);
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public ArgumentDelimiter getDelimiter() {
        return this.delimiter;
    }

    public List<Completer> getCompleters() {
        return this.completers;
    }

    @Override
    public int complete(String string, int n, List<CharSequence> list) {
        CharSequence charSequence;
        int n2;
        assert (list != null);
        ArgumentDelimiter argumentDelimiter = this.getDelimiter();
        ArgumentList argumentList = argumentDelimiter.delimit(string, n);
        int n3 = argumentList.getArgumentPosition();
        int n4 = argumentList.getCursorArgumentIndex();
        if (n4 < 0) {
            return -1;
        }
        List<Completer> list2 = this.getCompleters();
        Completer completer = n4 >= list2.size() ? list2.get(list2.size() - 1) : list2.get(n4);
        for (n2 = 0; this.isStrict() && n2 < n4; ++n2) {
            Completer completer2 = list2.get(n2 >= list2.size() ? list2.size() - 1 : n2);
            String[] stringArray = argumentList.getArguments();
            charSequence = stringArray == null || n2 >= stringArray.length ? "" : stringArray[n2];
            LinkedList<CharSequence> linkedList = new LinkedList<CharSequence>();
            if (completer2.complete((String)charSequence, ((String)charSequence).length(), linkedList) == -1) {
                return -1;
            }
            if (linkedList.size() != 0) continue;
            return -1;
        }
        n2 = completer.complete(argumentList.getCursorArgument(), n3, list);
        if (n2 == -1) {
            return -1;
        }
        int n5 = n2 + argumentList.getBufferPosition() - n3;
        if (n != string.length() && argumentDelimiter.isDelimiter(string, n)) {
            for (int i = 0; i < list.size(); ++i) {
                charSequence = list.get(i);
                while (charSequence.length() > 0 && argumentDelimiter.isDelimiter(charSequence, charSequence.length() - 1)) {
                    charSequence = charSequence.subSequence(0, charSequence.length() - 1);
                }
                list.set(i, charSequence);
            }
        }
        Log.trace("Completing ", string, " (pos=", n, ") with: ", list, ": offset=", n5);
        return n5;
    }

    public static class ArgumentList {
        private String[] arguments;
        private int cursorArgumentIndex;
        private int argumentPosition;
        private int bufferPosition;

        public ArgumentList(String[] stringArray, int n, int n2, int n3) {
            assert (stringArray != null);
            this.arguments = stringArray;
            this.cursorArgumentIndex = n;
            this.argumentPosition = n2;
            this.bufferPosition = n3;
        }

        public void setCursorArgumentIndex(int n) {
            this.cursorArgumentIndex = n;
        }

        public int getCursorArgumentIndex() {
            return this.cursorArgumentIndex;
        }

        public String getCursorArgument() {
            if (this.cursorArgumentIndex < 0 || this.cursorArgumentIndex >= this.arguments.length) {
                return null;
            }
            return this.arguments[this.cursorArgumentIndex];
        }

        public void setArgumentPosition(int n) {
            this.argumentPosition = n;
        }

        public int getArgumentPosition() {
            return this.argumentPosition;
        }

        public void setArguments(String[] stringArray) {
            this.arguments = stringArray;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public void setBufferPosition(int n) {
            this.bufferPosition = n;
        }

        public int getBufferPosition() {
            return this.bufferPosition;
        }
    }

    public static class WhitespaceArgumentDelimiter
    extends AbstractArgumentDelimiter {
        public boolean isDelimiterChar(CharSequence charSequence, int n) {
            return Character.isWhitespace(charSequence.charAt(n));
        }
    }

    public static abstract class AbstractArgumentDelimiter
    implements ArgumentDelimiter {
        private char[] quoteChars = new char[]{'\'', '\"'};
        private char[] escapeChars = new char[]{'\\'};

        public void setQuoteChars(char[] cArray) {
            this.quoteChars = cArray;
        }

        public char[] getQuoteChars() {
            return this.quoteChars;
        }

        public void setEscapeChars(char[] cArray) {
            this.escapeChars = cArray;
        }

        public char[] getEscapeChars() {
            return this.escapeChars;
        }

        public ArgumentList delimit(CharSequence charSequence, int n) {
            LinkedList<String> linkedList = new LinkedList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = -1;
            int n3 = -1;
            for (int i = 0; charSequence != null && i <= charSequence.length(); ++i) {
                if (i == n) {
                    n3 = linkedList.size();
                    n2 = stringBuilder.length();
                }
                if (i == charSequence.length() || this.isDelimiter(charSequence, i)) {
                    if (stringBuilder.length() <= 0) continue;
                    linkedList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                stringBuilder.append(charSequence.charAt(i));
            }
            return new ArgumentList(linkedList.toArray(new String[linkedList.size()]), n3, n2, n);
        }

        public boolean isDelimiter(CharSequence charSequence, int n) {
            return !this.isQuoted(charSequence, n) && !this.isEscaped(charSequence, n) && this.isDelimiterChar(charSequence, n);
        }

        public boolean isQuoted(CharSequence charSequence, int n) {
            return false;
        }

        public boolean isEscaped(CharSequence charSequence, int n) {
            if (n <= 0) {
                return false;
            }
            for (int i = 0; this.escapeChars != null && i < this.escapeChars.length; ++i) {
                if (charSequence.charAt(n) != this.escapeChars[i]) continue;
                return !this.isEscaped(charSequence, n - 1);
            }
            return false;
        }

        public abstract boolean isDelimiterChar(CharSequence var1, int var2);
    }

    public static interface ArgumentDelimiter {
        public ArgumentList delimit(CharSequence var1, int var2);

        public boolean isDelimiter(CharSequence var1, int var2);
    }
}

