/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.pantsbuild.jarjar.DepFindVisitor;
import org.pantsbuild.jarjar.DepHandler;
import org.pantsbuild.jarjar.util.ClassHeaderReader;
import org.pantsbuild.jarjar.util.ClassPathEntry;
import org.pantsbuild.jarjar.util.ClassPathIterator;
import org.pantsbuild.jarjar.util.RuntimeIOException;

public class DepFind {
    private File curDir = new File(System.getProperty("user.dir"));

    public void setCurrentDirectory(File curDir) {
        this.curDir = curDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String from, String to, DepHandler handler) throws IOException {
        try {
            InputStream in;
            ClassPathEntry entry;
            ClassHeaderReader header = new ClassHeaderReader();
            HashMap<String, String> classes = new HashMap<String, String>();
            ClassPathIterator cp = new ClassPathIterator(this.curDir, to, null);
            try {
                while (cp.hasNext()) {
                    entry = cp.next();
                    in = entry.openStream();
                    try {
                        header.read(in);
                        classes.put(header.getClassName(), entry.getSource());
                    }
                    catch (Exception e) {
                        System.err.println("Error reading " + entry.getName() + ": " + e.getMessage());
                    }
                    finally {
                        in.close();
                    }
                }
            }
            finally {
                cp.close();
            }
            handler.handleStart();
            cp = new ClassPathIterator(this.curDir, from, null);
            try {
                while (cp.hasNext()) {
                    entry = cp.next();
                    in = entry.openStream();
                    try {
                        new ClassReader(in).accept((ClassVisitor)new DepFindVisitor(classes, entry.getSource(), handler), 2);
                    }
                    catch (Exception e) {
                        System.err.println("Error reading " + entry.getName() + ": " + e.getMessage());
                    }
                    finally {
                        in.close();
                    }
                }
            }
            finally {
                cp.close();
            }
            handler.handleEnd();
        }
        catch (RuntimeIOException e) {
            throw (IOException)e.getCause();
        }
    }
}

