/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.pantsbuild.jarjar.EmptyClassVisitor;
import org.pantsbuild.jarjar.Keep;
import org.pantsbuild.jarjar.PackageRemapper;
import org.pantsbuild.jarjar.PatternElement;
import org.pantsbuild.jarjar.Wildcard;
import org.pantsbuild.jarjar.util.EntryStruct;
import org.pantsbuild.jarjar.util.JarProcessor;

class KeepProcessor
extends Remapper
implements JarProcessor {
    private final ClassVisitor cv = new RemappingClassAdapter((ClassVisitor)new EmptyClassVisitor(), (Remapper)this);
    private final List<Wildcard> wildcards;
    private final List<String> roots = new ArrayList<String>();
    private final Map<String, Set<String>> depend = new HashMap<String, Set<String>>();
    private Set<String> curSet;
    private byte[] buf = new byte[8192];

    public KeepProcessor(List<Keep> patterns) {
        this.wildcards = PatternElement.createWildcards(patterns);
    }

    public boolean isEnabled() {
        return !this.wildcards.isEmpty();
    }

    public Set<String> getExcludes() {
        HashSet<String> closure = new HashSet<String>();
        this.closureHelper(closure, this.roots);
        HashSet<String> removable = new HashSet<String>(this.depend.keySet());
        removable.removeAll(closure);
        return removable;
    }

    private void closureHelper(Set<String> closure, Collection<String> process) {
        if (process == null) {
            return;
        }
        for (String name : process) {
            if (!closure.add(name)) continue;
            this.closureHelper(closure, (Collection<String>)this.depend.get(name));
        }
    }

    @Override
    public boolean process(EntryStruct struct) throws IOException {
        try {
            if (struct.name.endsWith(".class")) {
                String name = struct.name.substring(0, struct.name.length() - 6);
                for (Wildcard wildcard : this.wildcards) {
                    if (!wildcard.matches(name)) continue;
                    this.roots.add(name);
                }
                this.curSet = new HashSet<String>();
                this.depend.put(name, this.curSet);
                new ClassReader((InputStream)new ByteArrayInputStream(struct.data)).accept(this.cv, 8);
                this.curSet.remove(name);
            }
        }
        catch (Exception e) {
            System.err.println("Error reading " + struct.name + ": " + e.getMessage());
        }
        return true;
    }

    public String map(String key) {
        if (key.startsWith("java/") || key.startsWith("javax/")) {
            return null;
        }
        this.curSet.add(key);
        return null;
    }

    public Object mapValue(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            if (PackageRemapper.isArrayForName(s)) {
                this.mapDesc(s.replace('.', '/'));
            } else if (KeepProcessor.isForName(s)) {
                this.map(s.replace('.', '/'));
            }
            return value;
        }
        return super.mapValue(value);
    }

    private static boolean isForName(String value) {
        if (value.equals("")) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }
}

