/*
 * Decompiled with CFR 0.152.
 */
package scalariform.formatter;

import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scalariform.formatter.ScalaFormatter;
import scalariform.formatter.preferences.MultilineScaladocCommentsStartOnFirstLine$;
import scalariform.formatter.preferences.PlaceScaladocAsterisksBeneathSecondAsterisk$;
import scalariform.lexer.HiddenToken;

public abstract class CommentFormatter$class {
    private static Tuple2 getLines(ScalaFormatter $this, String comment) {
        String prefix = (String)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/** ", "/**", "/* ", "/*"})).find((Function1)new Serializable($this, comment){
            public static final long serialVersionUID = 0L;
            private final String comment$1;

            public final boolean apply(String x$1) {
                return this.comment$1.startsWith(x$1);
            }
            {
                this.comment$1 = comment$1;
            }
        }).get();
        Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(comment)).splitAt(prefix.length());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String start = (String)tuple2._1();
            String rest = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)start, (Object)rest);
            String start2 = (String)tuple23._1();
            String rest2 = (String)tuple23._2();
            Tuple2 tuple24 = new StringOps(Predef$.MODULE$.augmentString(rest2)).splitAt(rest2.length() - "*/".length());
            if (tuple24 != null) {
                .colon.colon x2;
                String contents = (String)tuple24._1();
                String p2 = (String)tuple24._2();
                String string = contents;
                String contents2 = string;
                List list = Predef$.MODULE$.refArrayOps((Object[])contents2.split("\\r?\\n([ \\t]*(\\*(?!/))?)?", Integer.MAX_VALUE)).toList();
                if (list instanceof .colon.colon && (x2 = (.colon.colon)list) != null) {
                    Tuple2 tuple25;
                    String firstLine = (String)x2.hd$1();
                    List otherLines = x2.tl$1();
                    Tuple2 tuple26 = tuple25 = new Tuple2((Object)firstLine, (Object)otherLines);
                    String firstLine2 = (String)tuple26._1();
                    List otherLines2 = (List)tuple26._2();
                    int afterStarSpaces = BoxesRunTime.unboxToBoolean((Object)$this.formattingPreferences().apply(MultilineScaladocCommentsStartOnFirstLine$.MODULE$)) ? 2 : 1;
                    String string2 = CommentFormatter$class.scalariform$formatter$CommentFormatter$$dropInitialSpaces($this, firstLine2, 1);
                    List adjustedLines = ((List)otherLines2.map((Function1)new Serializable($this, afterStarSpaces){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ScalaFormatter $outer;
                        private final int afterStarSpaces$1;

                        public final String apply(String x$3) {
                            return CommentFormatter$class.scalariform$formatter$CommentFormatter$$dropInitialSpaces(this.$outer, x$3, this.afterStarSpaces$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.afterStarSpaces$1 = afterStarSpaces$1;
                        }
                    }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)string2);
                    return new Tuple2((Object)start2, (Object)adjustedLines);
                }
                throw new MatchError((Object)list);
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public static String scalariform$formatter$CommentFormatter$$dropInitialSpaces(ScalaFormatter $this, String s, int maxSpacesToDrop) {
        while (maxSpacesToDrop > 0 && s.startsWith(" ")) {
            --maxSpacesToDrop;
            s = (String)new StringOps(Predef$.MODULE$.augmentString(s)).drop(1);
        }
        return s;
    }

    public static String scalariform$formatter$CommentFormatter$$removeTrailingWhitespace(ScalaFormatter $this, String s) {
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).reverse())).dropWhile((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$5) {
                return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(x$5));
            }
        }))).reverse();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List pruneEmptyInitial(ScalaFormatter $this, List lines) {
        List list = lines;
        if (!(list instanceof .colon.colon)) return lines;
        .colon.colon x2 = (.colon.colon)list;
        if (x2 == null) return lines;
        String first = (String)x2.hd$1();
        List rest = x2.tl$1();
        String string = first.trim();
        String string2 = "";
        if (string != null) {
            if (!string.equals(string2)) return lines;
            return rest;
        }
        if (string2 == null) return rest;
        return lines;
    }

    private static List pruneEmptyFinal(ScalaFormatter $this, List lines) {
        return CommentFormatter$class.pruneEmptyInitial($this, lines.reverse()).reverse();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String formatComment(ScalaFormatter $this, HiddenToken comment, int indentLevel) {
        String string;
        if (new StringOps(Predef$.MODULE$.augmentString(comment.rawText())).contains((Object)BoxesRunTime.boxToCharacter((char)'\n'))) {
            Tuple2 tuple2;
            StringBuilder sb = new StringBuilder();
            Tuple2 tuple22 = CommentFormatter$class.getLines($this, comment.rawText());
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            String start = (String)tuple22._1();
            List rawLines = (List)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)start, (Object)rawLines);
            String start2 = (String)tuple23._1();
            List rawLines2 = (List)tuple23._2();
            List lines = CommentFormatter$class.pruneEmptyFinal($this, CommentFormatter$class.pruneEmptyInitial($this, rawLines2));
            boolean alignBeneathSecondAsterisk = BoxesRunTime.unboxToBoolean((Object)$this.formattingPreferences().apply(PlaceScaladocAsterisksBeneathSecondAsterisk$.MODULE$));
            boolean startOnFirstLine = BoxesRunTime.unboxToBoolean((Object)$this.formattingPreferences().apply(MultilineScaladocCommentsStartOnFirstLine$.MODULE$));
            String beforeStarSpaces = alignBeneathSecondAsterisk ? "  " : " ";
            String afterStarSpaces = startOnFirstLine && !alignBeneathSecondAsterisk ? "  " : " ";
            sb.append(start2.trim());
            BooleanRef firstLine = new BooleanRef(true);
            lines.foreach((Function1)new Serializable($this, sb, startOnFirstLine, beforeStarSpaces, afterStarSpaces, firstLine, indentLevel){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ScalaFormatter $outer;
                private final StringBuilder sb$1;
                private final boolean startOnFirstLine$1;
                private final String beforeStarSpaces$1;
                private final String afterStarSpaces$2;
                private final BooleanRef firstLine$1;
                private final int indentLevel$1;

                public final void apply(String line) {
                    Object object;
                    String trimmedLine = CommentFormatter$class.scalariform$formatter$CommentFormatter$$removeTrailingWhitespace(this.$outer, line);
                    if (this.firstLine$1.elem && this.startOnFirstLine$1) {
                        object = new StringOps(Predef$.MODULE$.augmentString(trimmedLine)).nonEmpty() ? this.sb$1.append(" ").append(trimmedLine) : BoxedUnit.UNIT;
                    } else {
                        ScalaFormatter.StringBuilderExtra qual$1 = this.$outer.stringBuilder2stringBuilderExtra(this.sb$1.append(this.$outer.newlineSequence()));
                        int x$7 = this.indentLevel$1;
                        Option<Object> x$8 = qual$1.indent$default$2();
                        qual$1.indent(x$7, x$8).append(this.beforeStarSpaces$1).append("*");
                        object = new StringOps(Predef$.MODULE$.augmentString(trimmedLine)).nonEmpty() ? this.sb$1.append(this.afterStarSpaces$2).append(trimmedLine) : BoxedUnit.UNIT;
                    }
                    this.firstLine$1.elem = false;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.sb$1 = sb$1;
                    this.startOnFirstLine$1 = startOnFirstLine$1;
                    this.beforeStarSpaces$1 = beforeStarSpaces$1;
                    this.afterStarSpaces$2 = afterStarSpaces$2;
                    this.firstLine$1 = firstLine$1;
                    this.indentLevel$1 = indentLevel$1;
                }
            });
            ScalaFormatter.StringBuilderExtra qual$2 = $this.stringBuilder2stringBuilderExtra(sb.append($this.newlineSequence()));
            int x$9 = indentLevel;
            Option<Object> x$10 = qual$2.indent$default$2();
            qual$2.indent(x$9, x$10).append(beforeStarSpaces).append("*/");
            string = sb.toString();
            return string;
        } else {
            string = comment.rawText();
        }
        return string;
    }

    public static void $init$(ScalaFormatter $this) {
    }
}

